/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.texplate.util;

import java.time.LocalDate;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0006\u0010\u0011\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/islandoftex/texplate/util/MessageUtils;", "", "<init>", "()V", "WIDTH", "", "VERSION", "", "line", "", "message", "status", "result", "", "error", "throwable", "", "drawLogo", "texplate"})
public final class MessageUtils {
    @NotNull
    public static final MessageUtils INSTANCE = new MessageUtils();
    private static final int WIDTH = 60;
    @NotNull
    private static final String VERSION;

    private MessageUtils() {
    }

    @JvmStatic
    public static final void line(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        System.out.print((Object)(StringsKt.padEnd(message + ' ', 51, '.') + ' '));
    }

    @JvmStatic
    public static final void status(boolean result) {
        System.out.println((Object)(result ? "[ DONE ]" : "[FAILED]"));
    }

    @JvmStatic
    public static final void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter(throwable, "throwable");
        System.out.println((Object)('\n' + StringsKt.padEnd("HOUSTON, WE'VE GOT A PROBLEM ", 60, '-') + '\n' + throwable.getMessage() + '\n' + StringsKt.padStart("", 60, '-') + '\n'));
    }

    public final void drawLogo() {
        String string = " ______         __   __          ___             __             \n/\\__  _\\       /\\ \\ /\\ \\        /\\_ \\           /\\ \\__          \n\\/_/\\ \\/    __ \\ `\\`\\/'/'  _____\\//\\ \\      __  \\ \\ ,_\\    __   \n   \\ \\ \\  /'__`\\`\\/ > <   /\\ '__`\\\\ \\ \\   /'__`\\ \\ \\ \\/  /'__`\\ \n    \\ \\ \\/\\  __/   \\/'/\\`\\\\ \\ \\L\\ \\\\_\\ \\_/\\ \\L\\.\\_\\ \\ \\_/\\  __/ \n     \\ \\_\\ \\____\\  /\\_\\\\ \\_\\ \\ ,__//\\____\\ \\__/.\\_\\\\ \\__\\ \\____\\\n      \\/_/\\/____/  \\/_/ \\/_/\\ \\ \\/ \\/____/\\/__/\\/_/ \\/__/\\/____/\n                             \\ \\_\\                              \n                              \\/_/                              \n";
        System.out.println((Object)string);
        string = "TeXplate " + VERSION + ", a document structure creation tool\nCopyright (c) " + LocalDate.now().getYear() + ", Island of TeX\nAll rights reserved.\n";
        System.out.println((Object)string);
    }

    static {
        String string = MessageUtils.class.getPackage().getImplementationVersion();
        if (string == null) {
            string = "DEVELOPMENT BUILD";
        }
        VERSION = string;
    }
}

