/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.trackers;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.trackers.KotlinModuleOutOfCodeBlockModificationTracker;
import org.jetbrains.kotlin.idea.caches.trackers.PureKotlinCodeBlockModificationListener;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0015\u001a\u00020\u0012R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener;", "Lcom/intellij/psi/impl/PsiTreeChangePreprocessor;", "Lcom/intellij/openapi/Disposable$Default;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modificationTrackerImpl", "Lcom/intellij/psi/util/PsiModificationTracker;", "kotlinModificationCount", "", "kotlinOutOfCodeBlockTrackerImpl", "Lcom/intellij/openapi/util/SimpleModificationTracker;", "kotlinOutOfCodeBlockTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getKotlinOutOfCodeBlockTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "treeChanged", "", "event", "Lcom/intellij/psi/impl/PsiTreeChangeEventImpl;", "incModificationCount", "Companion", "kotlin.base.fe10.analysis"})
public final class KotlinCodeBlockModificationListener
implements PsiTreeChangePreprocessor,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiModificationTracker modificationTrackerImpl;
    private volatile long kotlinModificationCount;
    @NotNull
    private final SimpleModificationTracker kotlinOutOfCodeBlockTrackerImpl;
    @NotNull
    private final ModificationTracker kotlinOutOfCodeBlockTracker;

    public KotlinCodeBlockModificationListener(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        PsiModificationTracker psiModificationTracker = PsiModificationTracker.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiModificationTracker, (String)"getInstance(...)");
        this.modificationTrackerImpl = psiModificationTracker;
        this.kotlinOutOfCodeBlockTrackerImpl = new SimpleModificationTracker();
        this.kotlinOutOfCodeBlockTracker = (ModificationTracker)this.kotlinOutOfCodeBlockTrackerImpl;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        KotlinModuleOutOfCodeBlockModificationTracker.Updater perModuleOutOfCodeBlockTrackerUpdater = KotlinModuleOutOfCodeBlockModificationTracker.Companion.getUpdaterInstance$kotlin_base_fe10_analysis(project);
        PureKotlinCodeBlockModificationListener.Companion.getInstance(project);
        PsiManagerEx.getInstanceEx((Project)project).addTreeChangePreprocessor((PsiTreeChangePreprocessor)this, (Disposable)this);
        Topic topic = PsiModificationTracker.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> KotlinCodeBlockModificationListener._init_$lambda$0(this, perModuleOutOfCodeBlockTrackerUpdater));
        messageBusConnection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.incModificationCount();
            }

            public void pluginLoaded(IdeaPluginDescriptor pluginDescriptor) {
                Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
                this.incModificationCount();
            }
        });
    }

    @NotNull
    public final ModificationTracker getKotlinOutOfCodeBlockTracker() {
        return this.kotlinOutOfCodeBlockTracker;
    }

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        boolean outOfCodeBlock;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!PsiModificationTrackerImpl.canAffectPsi((PsiTreeChangeEventImpl)event)) {
            return;
        }
        PsiTreeChangeEventImpl.PsiEventType psiEventType = event.getCode();
        switch (psiEventType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[psiEventType.ordinal()]) {
            case 1: {
                boolean bl;
                if (event.getPropertyName() == "propUnloadedPsi" || event.getPropertyName() == "roots" || event.getPropertyName() == "fileName") {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 2: {
                boolean bl;
                if (event.getOldParent() instanceof PsiDirectory || event.getNewParent() instanceof PsiDirectory) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                boolean bl = outOfCodeBlock = event.getParent() instanceof PsiDirectory;
            }
        }
        if (outOfCodeBlock) {
            this.incModificationCount();
        }
    }

    public final void incModificationCount() {
        this.kotlinOutOfCodeBlockTrackerImpl.incModificationCount();
    }

    private static final void _init_$lambda$0(KotlinCodeBlockModificationListener this$0, KotlinModuleOutOfCodeBlockModificationTracker.Updater $perModuleOutOfCodeBlockTrackerUpdater) {
        long kotlinTrackerInternalIDECount = this$0.modificationTrackerImpl.forLanguage((Language)KotlinLanguage.INSTANCE).getModificationCount();
        if (this$0.kotlinModificationCount == kotlinTrackerInternalIDECount) {
            this$0.incModificationCount();
        } else {
            this$0.kotlinModificationCount = kotlinTrackerInternalIDECount;
        }
        KotlinModuleOutOfCodeBlockModificationTracker.Updater.onPsiModificationTrackerUpdate$kotlin_base_fe10_analysis$default($perModuleOutOfCodeBlockTrackerUpdater, 0, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.base.fe10.analysis"})
    @SourceDebugExtension(value={"SMAP\nKotlinCodeBlockModificationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinCodeBlockModificationListener.kt\norg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,104:1\n30#2,2:105\n*S KotlinDebug\n*F\n+ 1 KotlinCodeBlockModificationListener.kt\norg/jetbrains/kotlin/idea/caches/trackers/KotlinCodeBlockModificationListener$Companion\n*L\n65#1:105,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinCodeBlockModificationListener getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<KotlinCodeBlockModificationListener> serviceClass$iv = KotlinCodeBlockModificationListener.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KotlinCodeBlockModificationListener)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PsiTreeChangeEventImpl.PsiEventType.values().length];
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

