/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.statistics.v2.flow;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.AggregatedFusMetric;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.FusFlowSendingStep;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolEventsKt;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolFusFlowCollector;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolFusMetric;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.KotlinBuildToolsMetricsKt;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.RawFusValue;
import org.jetbrains.kotlin.idea.gradle.statistics.v2.flow.RawMetricsForBuild;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J(\u0010\u0013\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0018\u00010\u00142\u0006\u0010\u0012\u001a\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000bH\u0002J\u0016\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014*\u00020\u0018H\u0002J\u0014\u0010\u001b\u001a\u00020\u0018*\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u0018H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/KotlinBuildToolFusFlowProcessor;", "", "<init>", "()V", "FILE_NAME_BUILD_ID_PREFIX_SEPARATOR", "", "fusFileExtensionsGlob", "BUILD_FINISHED_FUS_FILE_EXTENSION", "process", "", "statisticsFolder", "Ljava/nio/file/Path;", "process$intellij_kotlin_gradle_gradle", "filterFilesToRead", "", "", "staticFolder", "removeAllFusReportsForBuild", "buildId", "aggregateMetricsForBuildId", "", "Lorg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/AggregatedFusMetric;", "files", "readFile", "Lorg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/RawMetricsForBuild;", "path", "aggregateMetrics", "add", "rawMetricsForBuild", "intellij.kotlin.gradle.gradle"})
@SourceDebugExtension(value={"SMAP\nKotlinBuildToolFusFlowProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinBuildToolFusFlowProcessor.kt\norg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/KotlinBuildToolFusFlowProcessor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,149:1\n216#2:150\n217#2:153\n136#2,9:187\n216#2:196\n217#2:198\n145#2:199\n216#2:200\n217#2:208\n1869#3,2:151\n1193#3,2:154\n1267#3,2:156\n774#3:158\n865#3,2:159\n1270#3:161\n774#3:162\n865#3,2:163\n1869#3,2:165\n1617#3,9:167\n1869#3:176\n1870#3:178\n1626#3:179\n2851#3,7:180\n774#3:209\n865#3,2:210\n1#4:177\n1#4:197\n382#5,7:201\n382#5,7:212\n*S KotlinDebug\n*F\n+ 1 KotlinBuildToolFusFlowProcessor.kt\norg/jetbrains/kotlin/idea/gradle/statistics/v2/flow/KotlinBuildToolFusFlowProcessor\n*L\n39#1:150\n39#1:153\n124#1:187,9\n124#1:196\n124#1:198\n124#1:199\n134#1:200\n134#1:208\n42#1:151,2\n57#1:154,2\n57#1:156,2\n61#1:158\n61#1:159,2\n57#1:161\n76#1:162\n76#1:163,2\n76#1:165,2\n82#1:167,9\n82#1:176\n82#1:178\n82#1:179\n90#1:180,7\n111#1:209\n111#1:210,2\n82#1:177\n124#1:197\n135#1:201,7\n114#1:212,7\n*E\n"})
public final class KotlinBuildToolFusFlowProcessor {
    @NotNull
    public static final KotlinBuildToolFusFlowProcessor INSTANCE = new KotlinBuildToolFusFlowProcessor();
    @NotNull
    private static final String FILE_NAME_BUILD_ID_PREFIX_SEPARATOR = ".";
    @NotNull
    private static final String fusFileExtensionsGlob;
    @NotNull
    private static final String BUILD_FINISHED_FUS_FILE_EXTENSION = "finish-profile";

    private KotlinBuildToolFusFlowProcessor() {
    }

    public final void process$intellij_kotlin_gradle_gradle(@NotNull Path statisticsFolder) {
        Intrinsics.checkNotNullParameter((Object)statisticsFolder, (String)"statisticsFolder");
        try {
            Map<String, List<Path>> pathsByBuildId;
            Map<String, List<Path>> $this$forEach$iv = pathsByBuildId = this.filterFilesToRead(statisticsFolder);
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, List<Path>>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                List<Path> paths;
                Map.Entry<String, List<Path>> element$iv;
                Map.Entry<String, List<Path>> entry = element$iv = iterator2.next();
                boolean bl = false;
                String buildId = entry.getKey();
                if (INSTANCE.aggregateMetricsForBuildId(buildId, paths = entry.getValue()) == null) continue;
                Iterable $this$forEach$iv2 = KotlinBuildToolEventsKt.getKotlinBuildToolsFusEvenList();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Set<AggregatedFusMetric<?>> aggregatedFusMetric;
                    FusFlowSendingStep it = (FusFlowSendingStep)element$iv2;
                    boolean bl2 = false;
                    KotlinBuildToolFusFlowCollector.INSTANCE.send(it, buildId, aggregatedFusMetric);
                }
                INSTANCE.removeAllFusReportsForBuild(statisticsFolder, buildId);
            }
        }
        catch (Exception e) {
            Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("Failed to process " + statisticsFolder + " directory: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<Path>> filterFilesToRead(@NotNull Path staticFolder) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)staticFolder, (String)"staticFolder");
        List buildFinishFiles = PathsKt.listDirectoryEntries((Path)staticFolder, (String)"*.finish-profile");
        Iterable $this$associate$iv = buildFinishFiles;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Path it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Map map2 = destination$iv$iv;
            Path buildFinishFile = (Path)element$iv$iv;
            boolean bl = false;
            String buildId = StringsKt.substringBefore$default((String)((Object)buildFinishFile.getFileName()).toString(), (String)".finish-profile", null, (int)2, null);
            Iterable iterable2 = PathsKt.listDirectoryEntries((Path)staticFolder, (String)fusFileExtensionsGlob);
            boolean $i$f$filter = false;
            void var17_17 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv2;
                boolean bl2 = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                it = (Path)element$iv$iv2;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)buildId, (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List fusFiles = (List)destination$iv$iv2;
            Pair pair = TuplesKt.to((Object)buildId, (Object)CollectionsKt.plus((Collection)fusFiles, (Iterable)CollectionsKt.listOf((Object)buildFinishFile)));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void removeAllFusReportsForBuild(Path staticFolder, String buildId) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = PathsKt.listDirectoryEntries$default((Path)staticFolder, null, (int)1, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)PathsKt.getName((Path)it), (String)buildId, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            Files.deleteIfExists(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Set<AggregatedFusMetric<?>> aggregateMetricsForBuildId(@NotNull String buildId, @NotNull List<? extends Path> files) {
        Object v1;
        void $this$reduceOrNull$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)buildId, (String)"buildId");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$mapNotNull$iv = files;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            RawMetricsForBuild rawMetricsForBuild;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            RawMetricsForBuild rawMetricsForBuild2 = INSTANCE.readFile(it);
            if (!Intrinsics.areEqual((Object)rawMetricsForBuild2.getBuildId(), (Object)buildId)) {
                Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("File " + it.getFileName() + " contains data for buildId `" + rawMetricsForBuild2.getBuildId() + "`, but build `" + buildId + "` was expected. Skipping file.");
                rawMetricsForBuild = null;
            } else {
                rawMetricsForBuild = rawMetricsForBuild2;
            }
            if (rawMetricsForBuild == null) continue;
            RawMetricsForBuild it$iv$iv = rawMetricsForBuild;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$reduceOrNull = false;
        Iterator iterator$iv = $this$reduceOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void rawMetricsForBuild2;
                RawMetricsForBuild $i$f$mapNotNullTo2 = (RawMetricsForBuild)iterator$iv.next();
                RawMetricsForBuild rawMetricsForBuild1 = (RawMetricsForBuild)accumulator$iv;
                boolean bl = false;
                accumulator$iv = INSTANCE.add(rawMetricsForBuild1, (RawMetricsForBuild)rawMetricsForBuild2);
            }
            v1 = accumulator$iv;
        }
        RawMetricsForBuild rawMetricsForBuild = v1;
        return rawMetricsForBuild != null ? this.aggregateMetrics(rawMetricsForBuild) : null;
    }

    private final RawMetricsForBuild readFile(Path path2) {
        Ref.ObjectRef buildId = new Ref.ObjectRef();
        buildId.element = StringsKt.substringBefore$default((String)PathsKt.getName((Path)path2), (String)FILE_NAME_BUILD_ID_PREFIX_SEPARATOR, null, (int)2, null);
        HashMap rawMetrics = new HashMap();
        File file = path2.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FilesKt.forEachLine$default((File)file, null, arg_0 -> KotlinBuildToolFusFlowProcessor.readFile$lambda$0(buildId, path2, rawMetrics, arg_0), (int)1, null);
        return new RawMetricsForBuild((String)buildId.element, rawMetrics);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AggregatedFusMetric<?>> aggregateMetrics(RawMetricsForBuild $this$aggregateMetrics) {
        void $this$mapNotNullTo$iv$iv;
        Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> $this$mapNotNull$iv = $this$aggregateMetrics.getRawMetrics();
        boolean $i$f$mapNotNull = false;
        Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> map2 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            AggregatedFusMetric it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry it = element$iv$iv;
            boolean bl2 = false;
            if (((KotlinBuildToolFusMetric)it.getKey()).process((List)it.getValue()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final RawMetricsForBuild add(RawMetricsForBuild $this$add, RawMetricsForBuild rawMetricsForBuild) {
        if (!Intrinsics.areEqual((Object)rawMetricsForBuild.getBuildId(), (Object)$this$add.getBuildId())) {
            Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("Try to aggregate metrics for different builds: " + $this$add.getBuildId() + " and " + rawMetricsForBuild.getBuildId());
            return $this$add;
        }
        Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> $this$forEach$iv = rawMetricsForBuild.getRawMetrics();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<KotlinBuildToolFusMetric<?>, List<RawFusValue>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            void $this$getOrPut$iv;
            Map.Entry<KotlinBuildToolFusMetric<?>, List<RawFusValue>> element$iv;
            Map.Entry<KotlinBuildToolFusMetric<?>, List<RawFusValue>> entry = element$iv = iterator2.next();
            boolean bl = false;
            KotlinBuildToolFusMetric<?> metric = entry.getKey();
            List<RawFusValue> rawValues = entry.getValue();
            Map<KotlinBuildToolFusMetric<?>, List<RawFusValue>> map2 = $this$add.getRawMetrics();
            KotlinBuildToolFusMetric<?> key$iv = metric;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).addAll((Collection)rawValues);
        }
        return $this$add;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit readFile$lambda$0(Ref.ObjectRef $buildId, Path $path, HashMap $rawMetrics, String lines) {
        block7: {
            void $this$filterTo$iv$iv;
            block6: {
                void it;
                String string;
                Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
                if (StringsKt.startsWith$default((String)lines, (String)"BUILD FINISHED", (boolean)false, (int)2, null)) {
                    return Unit.INSTANCE;
                }
                if (!StringsKt.startsWith$default((String)lines, (String)"Build:", (boolean)false, (int)2, null)) break block6;
                String string2 = string = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)lines, (String)"Build:", null, (int)2, null))).toString();
                Ref.ObjectRef objectRef = $buildId;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)$buildId.element, (Object)it)) {
                    Logger.getInstance(KotlinBuildToolFusFlowProcessor.class).warn("Kotlin build FUS file with name " + PathsKt.getName((Path)$path) + " contains data for build " + (String)it);
                }
                objectRef.element = string;
                break block7;
            }
            String[] it = new String[]{"="};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)lines, (String[])it, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it2 = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !StringsKt.isBlank((CharSequence)it2);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List metric = (List)destination$iv$iv;
            if (metric.size() != 2) break block7;
            Object object = KotlinBuildToolsMetricsKt.getKotlinFusMetricsMap().get(metric.get(0));
            if (object != null && (object = object.getMetric()) != null) {
                Object object2;
                void $this$getOrPut$iv;
                Object metricKey = object;
                boolean bl = false;
                Map map2 = $rawMetrics;
                Object key$iv = metricKey;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl3 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object2 = answer$iv;
                } else {
                    object2 = value$iv;
                }
                ((List)object2).add(RawFusValue.box-impl(RawFusValue.constructor-impl((String)metric.get(1))));
            }
        }
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new String[]{"plugin-profile", "kotlin-profile"};
        fusFileExtensionsGlob = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)",", (CharSequence)"*.{", (CharSequence)"}", (int)0, null, null, (int)56, null);
    }
}

