/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.inline;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlinePropertyDialog;
import org.jetbrains.kotlin.idea.refactoring.inline.AbstractKotlinInlinePropertyProcessor;
import org.jetbrains.kotlin.idea.refactoring.inline.KotlinInlineActionHandler;
import org.jetbrains.kotlin.idea.refactoring.inline.codeInliner.InlineUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002JN\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H&R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyHandler;", "Lorg/jetbrains/kotlin/idea/refactoring/inline/KotlinInlineActionHandler;", "withPrompt", "", "<init>", "(Z)V", "getWithPrompt", "()Z", "helpId", "", "getHelpId", "()Ljava/lang/String;", "refactoringName", "getRefactoringName", "canInlineKotlinElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlineKotlinElement", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "performRefactoring", "declaration", "Lorg/jetbrains/kotlin/psi/KtProperty;", "assignmentToDelete", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "createInlinePropertyDialog", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyDialog;", "reference", "Lcom/intellij/psi/PsiReference;", "createProcessor", "Lorg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyProcessor;", "inlineThisOnly", "deleteAfter", "isWhenSubjectVariable", "statementToDelete", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nAbstractKotlinInlinePropertyHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractKotlinInlinePropertyHandler.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ApplicationUtils.kt\norg/jetbrains/kotlin/idea/util/application/ApplicationUtilsKt\n*L\n1#1,116:1\n1#2:117\n73#3:118\n*S KotlinDebug\n*F\n+ 1 AbstractKotlinInlinePropertyHandler.kt\norg/jetbrains/kotlin/idea/refactoring/inline/AbstractKotlinInlinePropertyHandler\n*L\n72#1:118\n*E\n"})
public abstract class AbstractKotlinInlinePropertyHandler
extends KotlinInlineActionHandler {
    private final boolean withPrompt;

    public AbstractKotlinInlinePropertyHandler(boolean withPrompt) {
        this.withPrompt = withPrompt;
    }

    public /* synthetic */ AbstractKotlinInlinePropertyHandler(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    protected final boolean getWithPrompt() {
        return this.withPrompt;
    }

    @Override
    @NotNull
    public String getHelpId() {
        return "refactoring.inlineVariable";
    }

    @Override
    @NotNull
    public String getRefactoringName() {
        return KotlinBundle.message((String)"title.inline.property", (Object[])new Object[0]);
    }

    @Override
    public boolean canInlineKotlinElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof KtProperty && ((KtProperty)element).getName() != null;
    }

    @Override
    public void inlineKotlinElement(@NotNull Project project, @Nullable Editor editor, @NotNull KtElement element) {
        KtPropertyAccessor setter;
        Object object;
        KtPropertyAccessor it;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtProperty declaration = (KtProperty)element;
        if (!this.checkSources(project, editor, element)) {
            return;
        }
        if (!((KtProperty)element).hasBody()) {
            String message2;
            if (KotlinCommonRefactoringUtilKt.isAbstract((KtDeclaration)element)) {
                var6_5 = new Object[]{this.getRefactoringName()};
                v0 = KotlinBundle.message((String)"refactoring.cannot.be.applied.to.abstract.declaration", (Object[])var6_5);
            } else if (KtPsiUtilKt.isExpectDeclaration((KtDeclaration)((KtDeclaration)element))) {
                var6_5 = new Object[]{this.getRefactoringName()};
                v0 = KotlinBundle.message((String)"refactoring.cannot.be.applied.to.expect.declaration", (Object[])var6_5);
            } else {
                v0 = message2 = null;
            }
            if (message2 != null) {
                this.showErrorHint(project, editor, message2);
                return;
            }
        }
        KtPropertyAccessor ktPropertyAccessor = declaration.getGetter();
        if (ktPropertyAccessor != null) {
            KtPropertyAccessor ktPropertyAccessor2;
            it = ktPropertyAccessor2 = ktPropertyAccessor;
            boolean bl = false;
            object = it.hasBody() ? ktPropertyAccessor2 : null;
        } else {
            object = null;
        }
        KtPropertyAccessor getter = object;
        KtPropertyAccessor ktPropertyAccessor3 = declaration.getSetter();
        if (ktPropertyAccessor3 != null) {
            KtPropertyAccessor it2 = it = ktPropertyAccessor3;
            boolean bl = false;
            v4 = it2.hasBody() ? it : null;
        } else {
            v4 = setter = null;
        }
        if ((getter != null || setter != null) && declaration.getInitializer() != null) {
            this.showErrorHint(project, editor, KotlinBundle.message((String)"cannot.inline.property.with.accessor.s.and.backing.field", (Object[])new Object[0]));
            return;
        }
        KtBinaryExpression assignmentToDelete = null;
        if (getter == null && setter == null) {
            AbstractKotlinInlinePropertyProcessor.Initializer initializer2 = AbstractKotlinInlinePropertyProcessor.Companion.extractInitialization(declaration).getInitializerOrShowErrorHint(project, editor);
            if (initializer2 == null) {
                return;
            }
            AbstractKotlinInlinePropertyProcessor.Initializer initializer3 = initializer2;
            assignmentToDelete = initializer3.getAssignment();
        }
        this.performRefactoring(declaration, assignmentToDelete, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void performRefactoring(KtProperty declaration, KtBinaryExpression assignmentToDelete, Editor editor) {
        Editor editor2 = editor;
        PsiReference reference = editor2 != null ? InlineUtilsKt.findSimpleNameReference(editor2) : null;
        AbstractKotlinInlinePropertyDialog dialog2 = this.createInlinePropertyDialog(declaration, reference, assignmentToDelete, editor);
        if (this.withPrompt) {
            boolean $i$f$isUnitTestMode = false;
            if (!ApplicationManager.getApplication().isUnitTestMode() && dialog2.shouldBeShown()) {
                dialog2.show();
                return;
            }
        }
        try {
            dialog2.doAction();
            return;
        }
        finally {
            dialog2.close(0, true, ExitActionType.OK);
        }
    }

    private final AbstractKotlinInlinePropertyDialog createInlinePropertyDialog(KtProperty declaration, PsiReference reference, KtBinaryExpression assignmentToDelete, Editor editor) {
        boolean bl = this.withPrompt;
        return new AbstractKotlinInlinePropertyDialog(declaration, reference, editor, this, assignmentToDelete, bl){
            final /* synthetic */ KtProperty $declaration;
            final /* synthetic */ PsiReference $reference;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ AbstractKotlinInlinePropertyHandler this$0;
            final /* synthetic */ KtBinaryExpression $assignmentToDelete;
            {
                this.$declaration = $declaration;
                this.$reference = $reference;
                this.$editor = $editor;
                this.this$0 = $receiver;
                this.$assignmentToDelete = $assignmentToDelete;
                super($declaration, $reference, $super_call_param$1, $editor);
            }

            public AbstractKotlinInlinePropertyProcessor createProcessor() {
                boolean bl = this.isInlineThisOnly();
                boolean bl2 = !this.isInlineThisOnly() && !this.isKeepTheDeclaration();
                PsiElement psiElement = this.$declaration.getParent();
                KtWhenExpression ktWhenExpression = psiElement instanceof KtWhenExpression ? (KtWhenExpression)psiElement : null;
                boolean bl3 = Intrinsics.areEqual((Object)(ktWhenExpression != null ? ktWhenExpression.getSubjectVariable() : null), (Object)this.$declaration);
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                return this.this$0.createProcessor(this.$declaration, this.$reference, bl, bl2, bl3, this.$editor, this.$assignmentToDelete, project);
            }
        };
    }

    @NotNull
    public abstract AbstractKotlinInlinePropertyProcessor createProcessor(@NotNull KtProperty var1, @Nullable PsiReference var2, boolean var3, boolean var4, boolean var5, @Nullable Editor var6, @Nullable KtBinaryExpression var7, @NotNull Project var8);

    public AbstractKotlinInlinePropertyHandler() {
        this(false, 1, null);
    }
}

