/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractProcedureMsSymbol;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractThunkMsSymbol
extends AbstractProcedureMsSymbol {
    protected long parentPointer;
    protected long endPointer;
    protected long nextPointer;
    protected long offset;
    protected int segment;
    protected int length;
    protected Ordinal ordinal;
    protected String name;
    protected int variant;
    protected String variantString;

    public AbstractThunkMsSymbol(AbstractPdb pdb, PdbByteReader reader, int offsetSize, StringParseType strType) throws PdbException {
        super(pdb, reader);
        this.parentPointer = reader.parseUnsignedIntVal();
        this.endPointer = reader.parseUnsignedIntVal();
        this.nextPointer = reader.parseUnsignedIntVal();
        this.offset = reader.parseVarSizedOffset(offsetSize);
        this.segment = pdb.parseSegment(reader);
        this.length = reader.parseUnsignedShortVal();
        this.ordinal = Ordinal.fromValue(reader.parseUnsignedByteVal());
        this.name = reader.parseString(pdb, strType);
        switch (this.ordinal.ordinal()) {
            case 1: {
                this.variant = reader.parseUnsignedShortVal();
                this.variantString = reader.parseString(pdb, strType);
                break;
            }
            case 2: {
                this.variant = reader.parseUnsignedShortVal();
                break;
            }
            default: {
                this.variant = 0;
            }
        }
        reader.align4();
    }

    @Override
    public long getParentPointer() {
        return this.parentPointer;
    }

    @Override
    public long getEndPointer() {
        return this.endPointer;
    }

    @Override
    public long getNextPointer() {
        return this.nextPointer;
    }

    @Override
    public long getProcedureLength() {
        return this.length;
    }

    @Override
    public long getDebugStartOffset() {
        return 0L;
    }

    @Override
    public long getDebugEndOffset() {
        return this.length;
    }

    @Override
    public RecordNumber getTypeRecordNumber() {
        return RecordNumber.NO_TYPE;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public int getSegment() {
        return this.segment;
    }

    public int getLength() {
        return this.length;
    }

    public Ordinal getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getVariant() {
        return this.variant;
    }

    public String getVariantString() {
        if (this.ordinal == Ordinal.ADJUSTOR) {
            return this.variantString;
        }
        return "";
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], Length: %08X, %s\n", this.getSymbolTypeName(), this.segment, this.offset, this.length, this.name));
        builder.append(String.format("   Parent: %08X, End: %08X, Next: %08X\n", this.parentPointer, this.endPointer, this.nextPointer));
        switch (this.ordinal.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                builder.append(String.format("   " + String.valueOf((Object)this.ordinal) + ", Delta: %d, Target: %s\n", this.variant, this.variantString));
                break;
            }
            case 2: {
                builder.append(String.format("   " + String.valueOf((Object)this.ordinal) + ", Table Entry: %d\n", this.variant));
                break;
            }
            default: {
                builder.append("   " + String.valueOf((Object)this.ordinal) + "\n");
            }
        }
    }

    public static enum Ordinal {
        NOTYPE("", 0),
        ADJUSTOR("Type: Adjustor", 1),
        VCALL("Type: VCall", 2),
        PCODE("Type: 03", 3),
        LOAD("Type: 04", 4),
        TRAMPOLINE_INCREMENTAL("Type: 05", 5),
        TRANMPOLINE_BRANCHISLAND("Type: 06", 6);

        private static final Map<Integer, Ordinal> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static Ordinal fromValue(int val) {
            return BY_VALUE.getOrDefault(val, NOTYPE);
        }

        private Ordinal(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, Ordinal>();
            for (Ordinal val : Ordinal.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

