/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StringIdMsType;

public class UserDefinedTypeSourceAndLineMsType
extends AbstractMsType {
    public static final int PDB_ID = 5638;
    private RecordNumber udtRecordNumber;
    private RecordNumber sourceFileNameStringIdRecordNumber;
    private int lineNumber;

    public UserDefinedTypeSourceAndLineMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.udtRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.sourceFileNameStringIdRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.ITEM, 32);
        this.lineNumber = reader.parseInt();
        reader.skipPadding();
    }

    @Override
    public int getPdbId() {
        return 5638;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public RecordNumber getSourceFileNameStringIdRecordNumber() {
        return this.sourceFileNameStringIdRecordNumber;
    }

    public String getSourceFileName() {
        StringIdMsType stringIdType = this.pdb.getTypeRecord(this.getSourceFileNameStringIdRecordNumber(), StringIdMsType.class);
        if (stringIdType == null) {
            return null;
        }
        return stringIdType.getString();
    }

    public RecordNumber getUdtRecordNumber() {
        return this.udtRecordNumber;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(UserDefinedTypeSourceAndLineMsType.class.getSimpleName());
        builder.append(", line: ");
        builder.append(this.lineNumber);
        builder.append(", SourceFileNameStringIdIndex: ");
        builder.append(this.getSourceFileName());
        builder.append(", type: ");
        builder.append(this.pdb.getTypeRecord(this.udtRecordNumber));
    }
}

