/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompiler.taint;

import com.contrastsecurity.sarif.LogicalLocation;
import com.contrastsecurity.sarif.Run;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompiler.taint.TaintState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.pcode.VarnodeAST;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import sarif.SarifUtils;

public record TaintQueryResult(String name, String fqname, Address iaddr, Address faddr, List<String> labels, boolean functionLevelResult) {
    public TaintQueryResult(Map<String, Object> result) {
        this((String)result.get("name"), (String)result.get("location"), (Address)result.get("Address"), (Address)result.get("entry"), new ArrayList<String>(), (Address)result.get("Address") == null);
        String value = (String)result.get("value");
        this.addLabel(value);
    }

    public TaintQueryResult(Map<String, Object> result, Run run, LogicalLocation ll) {
        this(SarifUtils.extractDisplayName((LogicalLocation)ll), ll.getDecoratedName(), (Address)result.get("Address"), (Address)result.get("entry"), new ArrayList<String>(), (Address)result.get("Address") == null);
        String value = (String)result.get("value");
        this.addLabel(value);
    }

    public String getLabel() {
        return this.labels.get(0);
    }

    public String getQualifiedName() {
        return this.fqname;
    }

    public Address getInsnAddr() {
        return this.iaddr;
    }

    public void addLabel(String label) {
        this.labels.add(label);
    }

    public boolean hasLabel(String label) {
        return this.labels.contains(label);
    }

    public String matches(ClangToken token) {
        boolean functionLevelToken;
        String text = token.getText();
        String hvName = TaintState.varName(token, true);
        if (hvName == null) {
            return null;
        }
        Varnode vn = token.getVarnode();
        ClangFunction clangFunction = token.getClangFunction();
        Function function = clangFunction.getHighFunction().getFunction();
        boolean bl = functionLevelToken = function.isThunk() || vn == null;
        if (functionLevelToken) {
            if (this.faddr.equals((Object)function.getEntryPoint()) && this.name.endsWith(hvName)) {
                return hvName;
            }
        } else if (this.functionLevelResult) {
            if (this.faddr.equals((Object)function.getEntryPoint()) && (this.name.endsWith(hvName) || this.name.endsWith(text))) {
                return hvName;
            }
        } else {
            HighVariable hv;
            Address vaddr = token.getMinAddress();
            if (vaddr == null && (hv = token.getHighVariable()) instanceof HighParam) {
                vaddr = hv.getRepresentative().getPCAddress();
            }
            if (this.iaddr.equals((Object)vaddr)) {
                VarnodeAST ast = (VarnodeAST)vn;
                if (this.fqname.endsWith(":" + ast.getUniqueId())) {
                    return hvName;
                }
                if (this.fqname.contains(":" + hvName)) {
                    return hvName;
                }
                if (this.fqname.contains(":" + String.valueOf(ast.getAddress()))) {
                    return hvName;
                }
            }
        }
        return null;
    }

    public boolean matchesFunction(String fname, Address entry_address) {
        return this.name.startsWith(fname) && this.iaddr.equals((Object)entry_address);
    }
}

