/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.TraceObjectValueStorage;
import ghidra.trace.model.Lifespan;
import java.util.NavigableMap;
import java.util.Objects;

public class DBTraceObjectValueBehind
implements TraceObjectValueStorage {
    private final DBTraceObjectManager manager;
    private final DBTraceObject parent;
    private final String entryKey;
    private Lifespan lifespan;
    private final Object value;
    private boolean deleted = false;
    private final DBTraceObjectValue wrapper;

    public DBTraceObjectValueBehind(DBTraceObjectManager manager, DBTraceObject parent, String entryKey, Lifespan lifespan, Object value) {
        this.manager = manager;
        this.parent = Objects.requireNonNull(parent, "Root cannot be delayed");
        this.entryKey = entryKey;
        this.lifespan = lifespan;
        this.value = value;
        this.wrapper = new DBTraceObjectValue(manager, this);
    }

    public String toString() {
        return "<%s parent=%s entryKey=%s lifespan=%s value=%s>".formatted(this.getClass().getSimpleName(), this.parent, this.entryKey, this.lifespan, this.value);
    }

    @Override
    public String getEntryKey() {
        return this.entryKey;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public DBTraceObjectManager getManager() {
        return this.manager;
    }

    @Override
    public DBTraceObject getChildOrNull() {
        Object object = this.value;
        if (object instanceof DBTraceObject) {
            DBTraceObject child = (DBTraceObject)object;
            return child;
        }
        return null;
    }

    @Override
    public void doSetLifespan(Lifespan lifespan) {
        NavigableMap<Long, DBTraceObjectValueBehind> values = this.manager.valueWbCache.doRemoveNoCleanup(this);
        this.lifespan = lifespan;
        this.manager.valueWbCache.doAddDirect(values, this);
    }

    @Override
    public void doDelete() {
        this.deleted = true;
        this.manager.doDeleteCachedValue(this);
    }

    @Override
    public DBTraceObject getParent() {
        return this.parent;
    }

    @Override
    public DBTraceObjectValue getWrapper() {
        return this.wrapper;
    }
}

