/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CreateThunkFunctionCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.block.FollowFlow;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CreateFunctionCmd
extends BackgroundCommand<Program> {
    private AddressSetView origEntries;
    private AddressSetView origBody;
    private Program program;
    private String name;
    private Function newFunc;
    private SourceType source;
    private boolean findEntryPoint = false;
    private boolean recreateFunction = false;
    private List<Address> referringThunkAddresses;

    public CreateFunctionCmd(String name, AddressSetView entries, AddressSetView body, SourceType source, boolean findEntryPoint, boolean recreateFunction) {
        super("Create Function", true, true, false);
        this.origEntries = entries;
        this.origBody = body;
        this.name = name;
        this.source = source;
        this.findEntryPoint = findEntryPoint;
        this.recreateFunction = recreateFunction;
    }

    public CreateFunctionCmd(String name, Address entry, AddressSetView body, SourceType source, boolean findEntryPoint, boolean recreateFunction) {
        this(name, (AddressSetView)new AddressSet(entry, entry), body, source, findEntryPoint, recreateFunction);
    }

    public CreateFunctionCmd(AddressSetView entries, boolean findEntryPoint) {
        this(null, entries, null, SourceType.DEFAULT, findEntryPoint, false);
    }

    public CreateFunctionCmd(AddressSetView entries) {
        this(null, entries, null, SourceType.DEFAULT, false, false);
    }

    public CreateFunctionCmd(AddressSetView entries, SourceType source) {
        this(null, entries, null, source, false, false);
    }

    public CreateFunctionCmd(String name, Address entry, AddressSetView body, SourceType source) {
        this(name, entry, body, source, false, false);
    }

    CreateFunctionCmd(Address entry, List<Address> referringThunkAddresses) {
        this(entry);
        this.referringThunkAddresses = referringThunkAddresses;
    }

    public CreateFunctionCmd(Address entry) {
        this(null, entry, null, SourceType.DEFAULT);
    }

    public CreateFunctionCmd(Address entry, boolean findEntryPoint) {
        this(null, entry, null, SourceType.DEFAULT, findEntryPoint, false);
    }

    public boolean applyTo(Program p, TaskMonitor monitor) {
        this.program = p;
        Namespace globalNameSpace = this.program.getGlobalNamespace();
        int functionsCreated = 0;
        int count = 0;
        monitor.initialize(this.origEntries.getNumAddresses());
        AddressIterator iter = this.origEntries.getAddresses(true);
        while (iter.hasNext() && !monitor.isCancelled()) {
            monitor.setProgress((long)(++count));
            SourceType tmpSource = this.source;
            Address origEntry = iter.next();
            String funcName = this.name;
            try {
                if (origEntry.isExternalAddress()) {
                    Function extFunc;
                    Symbol oldSym = this.program.getSymbolTable().getPrimarySymbol(origEntry);
                    if (oldSym == null) continue;
                    Object symObj = oldSym.getObject();
                    if (symObj instanceof Function) {
                        extFunc = (Function)symObj;
                    } else if (symObj instanceof ExternalLocation) {
                        extFunc = ((ExternalLocation)symObj).createFunction();
                    } else {
                        Msg.error((Object)((Object)this), (Object)("Unexpected external symbol object: " + String.valueOf(symObj.getClass())));
                        continue;
                    }
                    if (funcName == null) continue;
                    monitor.setMessage("Function " + funcName);
                    extFunc.setName(funcName, this.source);
                    continue;
                }
                Namespace nameSpace = globalNameSpace;
                if (funcName == null) {
                    Symbol oldSym = this.program.getSymbolTable().getPrimarySymbol(origEntry);
                    if (oldSym != null && oldSym.getSource() != SourceType.DEFAULT) {
                        funcName = oldSym.getName();
                        tmpSource = oldSym.getSource();
                        Namespace oldParentNamespace = oldSym.getParentNamespace();
                        if (oldParentNamespace.getSymbol().getSymbolType() != SymbolType.FUNCTION) {
                            nameSpace = oldParentNamespace;
                        }
                    } else {
                        funcName = SymbolUtilities.getDefaultFunctionName((Address)origEntry);
                        tmpSource = SourceType.DEFAULT;
                    }
                }
                monitor.setMessage("Function " + funcName);
                boolean didCreate = false;
                try {
                    didCreate = this.createFunction(monitor, funcName, nameSpace, origEntry, this.origBody, tmpSource);
                }
                catch (OverlappingFunctionException e) {
                    didCreate = this.createFunction(monitor, funcName, nameSpace, origEntry, this.origBody, tmpSource);
                }
                if (didCreate) {
                    ++functionsCreated;
                    continue;
                }
                this.setStatusMsg("Unable to create function at " + String.valueOf(origEntry));
            }
            catch (CancelledException nameSpace) {
            }
            catch (Exception e) {
                String errMsg = e.getMessage();
                if (errMsg == null) {
                    errMsg = e.toString();
                }
                this.setStatusMsg(errMsg);
            }
        }
        return (long)functionsCreated == this.origEntries.getNumAddresses();
    }

    public Function getFunction() {
        return this.newFunc;
    }

    private boolean createFunction(TaskMonitor monitor, String funcName, Namespace nameSpace, Address entry, AddressSetView body, SourceType nameSource) throws InvalidInputException, OverlappingFunctionException, CancelledException {
        Function existingFunction;
        FunctionManager functionMgr = this.program.getFunctionManager();
        if (this.findEntryPoint) {
            Function functionContaining = functionMgr.getFunctionContaining(entry);
            if (functionContaining != null) {
                if (!this.recreateFunction) {
                    entry = functionContaining.getEntryPoint();
                    long bodySize = functionContaining.getBody().getNumAddresses();
                    if (bodySize != 1L) {
                        return true;
                    }
                }
                if (!functionContaining.getEntryPoint().equals((Object)entry)) {
                    entry = this.findFunctionEntry(entry);
                }
            }
            if (entry == null) {
                return false;
            }
            if (this.origBody != null && !this.origBody.isEmpty()) {
                Function func = this.program.getFunctionManager().getFunctionContaining(entry);
                if (func == null) {
                    return false;
                }
                try {
                    func.setBody(this.origBody);
                    return true;
                }
                catch (OverlappingFunctionException overlappingFunctionException) {
                    // empty catch block
                }
            }
            if (CreateFunctionCmd.fixupFunctionBody(this.program, this.program.getListing().getInstructionAt(entry), monitor)) {
                return true;
            }
        }
        if ((existingFunction = functionMgr.getFunctionAt(entry)) != null) {
            return this.handleExistingFunction(monitor, entry, existingFunction);
        }
        body = body == null ? CreateFunctionCmd.getFunctionBody(this.program, entry, false, monitor) : body;
        HashMap<Function, AddressSetView> bodyChangeMap = new HashMap<Function, AddressSetView>();
        body = CreateFunctionCmd.subtractBodyFromExisting(this.program, entry, body, bodyChangeMap, monitor);
        return this.createFunction(nameSpace, funcName, entry, body, nameSource, bodyChangeMap, monitor);
    }

    private boolean createFunction(Namespace nameSpace, String funcName, Address entry, AddressSetView body, SourceType nameSource, Map<Function, AddressSetView> bodyChangeMap, TaskMonitor monitor) throws OverlappingFunctionException, InvalidInputException {
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitAt(entry);
        if (cu == null) {
            return false;
        }
        if (this.resolveThunk(entry, body, monitor)) {
            return true;
        }
        if (this.referringThunkAddresses != null) {
            for (Address addr : this.referringThunkAddresses) {
                if (!body.contains(addr)) continue;
                Msg.error((Object)((Object)this), (Object)("Failed to create function at " + String.valueOf(entry) + " since its body contains referring thunk at " + String.valueOf(addr)));
                return false;
            }
        }
        this.newFunc = listing.createFunction(funcName, nameSpace, entry, body, nameSource);
        return true;
    }

    private static AddressSetView subtractBodyFromExisting(Program program, Address entry, AddressSetView newFuncBody, Map<Function, AddressSetView> bodyChangeMap, TaskMonitor monitor) throws CancelledException, OverlappingFunctionException {
        Iterator iter = program.getFunctionManager().getFunctionsOverlapping(newFuncBody);
        while (iter.hasNext()) {
            AddressSetView overlapFuncBody;
            monitor.checkCancelled();
            Function overlapFunc = (Function)iter.next();
            Address overlapEntryPoint = overlapFunc.getEntryPoint();
            if (overlapEntryPoint.equals((Object)entry) || (overlapFuncBody = overlapFunc.getBody()).getNumAddresses() == 1L && (overlapFuncBody = CreateFunctionCmd.getFunctionBody(program, overlapEntryPoint, false, monitor)).contains(entry)) continue;
            Address overlapEndAddr = overlapEntryPoint.compareTo((Object)entry) < 0 ? newFuncBody.getMaxAddress() : overlapEntryPoint.previous();
            AddressSet overlapAddrsShouldBeInNewFunction = new AddressSet(entry, overlapEndAddr);
            AddressSet newOverlapFuncBody = overlapFuncBody.subtract((AddressSetView)overlapAddrsShouldBeInNewFunction);
            try {
                if (!overlapFuncBody.equals((Object)newOverlapFuncBody)) {
                    overlapFunc.setBody((AddressSetView)newOverlapFuncBody);
                    bodyChangeMap.put(overlapFunc, overlapFuncBody);
                }
                overlapFuncBody = newOverlapFuncBody;
            }
            catch (OverlappingFunctionException overlappingFunctionException) {
                // empty catch block
            }
            newFuncBody = newFuncBody.subtract(overlapFuncBody);
        }
        return newFuncBody;
    }

    private boolean handleExistingFunction(TaskMonitor monitor, Address entry, Function existingFunction) throws OverlappingFunctionException, CancelledException {
        long bodySize = existingFunction.getBody().getNumAddresses();
        if (bodySize > 1L) {
            if (!this.recreateFunction) {
                return true;
            }
            if (this.resolveThunk(entry, null, monitor)) {
                return true;
            }
        }
        return CreateFunctionCmd.fixupFunctionBody(this.program, existingFunction, monitor) || this.recreateFunction;
    }

    private boolean resolveThunk(Address entry, AddressSetView body, TaskMonitor monitor) throws OverlappingFunctionException {
        Address thunkedAddr = CreateThunkFunctionCmd.getThunkedExternalFunctionAddress(this.program, entry);
        if (thunkedAddr == null) {
            thunkedAddr = CreateThunkFunctionCmd.getThunkedAddr(this.program, entry);
        }
        if (thunkedAddr == null || thunkedAddr.equals((Object)entry)) {
            return false;
        }
        if (this.referringThunkAddresses != null && this.referringThunkAddresses.contains(entry)) {
            throw new OverlappingFunctionException("Invalid referenced function: circular thunk reference at " + String.valueOf(entry));
        }
        CreateThunkFunctionCmd cmd = new CreateThunkFunctionCmd(entry, body, thunkedAddr, this.referringThunkAddresses);
        if (cmd.applyTo(this.program, monitor)) {
            this.newFunc = cmd.getThunkFunction();
            return true;
        }
        return false;
    }

    private static void restoreOriginalBodies(Map<Function, AddressSetView> bodyChangeMap) {
        Set<Map.Entry<Function, AddressSetView>> entries = bodyChangeMap.entrySet();
        for (Map.Entry<Function, AddressSetView> entry : entries) {
            try {
                entry.getKey().setBody(entry.getValue());
            }
            catch (OverlappingFunctionException e) {
                e.printStackTrace();
            }
        }
    }

    private Address findFunctionEntry(Address bodyAddr) {
        AddressSpace space = bodyAddr.getAddressSpace();
        AddressSet subSet = new AddressSet();
        Instruction followInstr = this.program.getListing().getInstructionContaining(bodyAddr);
        while (followInstr != null && !subSet.contains(followInstr.getMinAddress()) && followInstr.getMinAddress().getAddressSpace() == space) {
            subSet.addRange(followInstr.getMinAddress(), followInstr.getMaxAddress());
            Function func = this.program.getFunctionManager().getFunctionContaining(followInstr.getMinAddress());
            if (func != null) {
                return func.getEntryPoint();
            }
            Address fallFrom = followInstr.getFallFrom();
            if (fallFrom == null) {
                ReferenceIterator iter = followInstr.getReferenceIteratorTo();
                if (!iter.hasNext()) break;
                Reference ref = iter.next();
                if (ref.getReferenceType().isCall()) {
                    return followInstr.getMinAddress();
                }
                fallFrom = ref.getFromAddress();
            }
            followInstr = this.program.getListing().getInstructionContaining(fallFrom);
        }
        return null;
    }

    public static AddressSetView getFunctionBody(TaskMonitor monitor, Program program, Address entry) {
        return CreateFunctionCmd.getFunctionBody(program, entry, true, monitor);
    }

    public static AddressSetView getFunctionBody(Program program, Address entry) {
        return CreateFunctionCmd.getFunctionBody(program, entry, true, null);
    }

    public static AddressSetView getFunctionBody(Program program, Address entry, TaskMonitor monitor) {
        return CreateFunctionCmd.getFunctionBody(program, entry, false, monitor);
    }

    public static AddressSetView getFunctionBody(Program program, Address entry, boolean includeOtherFunctions, TaskMonitor monitor) {
        Instruction instr = program.getListing().getInstructionAt(entry);
        if (instr == null) {
            return new AddressSet(entry, entry);
        }
        FlowType[] dontFollow = new FlowType[]{RefType.COMPUTED_CALL, RefType.CONDITIONAL_CALL, RefType.UNCONDITIONAL_CALL, RefType.INDIRECTION};
        FollowFlow flow = new FollowFlow(program, entry, dontFollow, includeOtherFunctions, false, true);
        return flow.getFlowAddressSet(monitor);
    }

    public static boolean fixupFunctionBody(Program program, Instruction start_inst, TaskMonitor monitor) throws CancelledException {
        if (start_inst == null) {
            return true;
        }
        Function func = program.getFunctionManager().getFunctionContaining(start_inst.getMinAddress());
        return CreateFunctionCmd.fixupFunctionBody(program, func, monitor);
    }

    public static boolean fixupFunctionBody(Program program, Function func, TaskMonitor monitor) throws CancelledException {
        if (func == null || func.isExternal()) {
            return false;
        }
        Address entry = func.getEntryPoint();
        AddressSetView newBody = CreateFunctionCmd.getFunctionBody(program, entry, false, monitor);
        if (func.getSignatureSource() == SourceType.DEFAULT && !func.isThunk() && CreateFunctionCmd.resolveThunk(program, entry, newBody, monitor)) {
            return true;
        }
        if (newBody == null || newBody.isEmpty()) {
            return false;
        }
        if (func.getBody().equals((Object)newBody)) {
            return false;
        }
        try {
            func.setBody(newBody);
        }
        catch (OverlappingFunctionException e) {
            HashMap<Function, AddressSetView> bodyChangeMap = new HashMap<Function, AddressSetView>();
            try {
                newBody = CreateFunctionCmd.subtractBodyFromExisting(program, entry, newBody, bodyChangeMap, monitor);
                func.setBody(newBody);
            }
            catch (OverlappingFunctionException | CancelledException e1) {
                CreateFunctionCmd.restoreOriginalBodies(bodyChangeMap);
                return false;
            }
        }
        return true;
    }

    private static boolean resolveThunk(Program program, Address entry, AddressSetView body, TaskMonitor monitor) {
        Address thunkedAddr = CreateThunkFunctionCmd.getThunkedAddr(program, entry);
        if (thunkedAddr == null || thunkedAddr.equals((Object)entry)) {
            return false;
        }
        CreateThunkFunctionCmd cmd = new CreateThunkFunctionCmd(entry, body, thunkedAddr);
        return cmd.applyTo(program, monitor);
    }
}

