/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.MenuData;
import ghidra.app.plugin.core.datamgr.actions.AbstractFindReferencesToFieldAction;
import ghidra.app.plugin.core.datamgr.editor.EnumEditorProvider;
import ghidra.app.services.FieldMatcher;
import ghidra.framework.plugintool.Plugin;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;

public class FindReferencesToEnumFieldAction
extends AbstractFindReferencesToFieldAction {
    public FindReferencesToEnumFieldAction(Plugin plugin) {
        super(plugin);
    }

    @Override
    protected AbstractFindReferencesToFieldAction.DataTypeAndFields getSelectedType(ActionContext context) {
        ComponentProvider provider = context.getComponentProvider();
        if (!(provider instanceof EnumEditorProvider)) {
            return null;
        }
        EnumEditorProvider enumProvider = (EnumEditorProvider)provider;
        String fieldName = enumProvider.getSelectedFieldName();
        if (fieldName == null) {
            return null;
        }
        this.updateMenuName(fieldName);
        Enum dt = enumProvider.getEnum();
        return new AbstractFindReferencesToFieldAction.DataTypeAndFields((DataType)dt, new String[]{fieldName});
    }

    @Override
    protected FieldMatcher createFieldMatcher(AbstractFindReferencesToFieldAction.DataTypeAndFields typeAndFields) {
        DataType dt = typeAndFields.dataType();
        String field = typeAndFields.fieldNames()[0];
        return new FieldMatcher(dt, field);
    }

    private void updateMenuName(String name) {
        String menuName = "Find Uses of " + name;
        MenuData data = this.getPopupMenuData().cloneData();
        data.setMenuPath(new String[]{menuName});
        this.setPopupMenuData(data);
    }
}

