/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import ghidra.app.plugin.core.overview.entropy.KnotRecord;
import ghidra.util.ColorUtils;
import ghidra.util.datastruct.WeakDataStructureFactory;
import ghidra.util.datastruct.WeakSet;
import java.awt.Color;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OverviewPalette {
    private Color uninitializedColor;
    private Color[] colors;
    private ArrayList<KnotRecord> knots;
    private WeakSet<ChangeListener> listeners = WeakDataStructureFactory.createSingleThreadAccessWeakSet();

    public OverviewPalette(int sz, Color uninit) {
        this.uninitializedColor = uninit;
        this.colors = new Color[sz];
        this.knots = new ArrayList();
    }

    void addPaletteListener(ChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    private void firePaletteChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(changeEvent);
        }
    }

    public int getSize() {
        if (this.colors == null) {
            return 0;
        }
        return this.colors.length;
    }

    public Color getColor(int i) {
        if (i < 0) {
            return this.uninitializedColor;
        }
        return this.colors[i];
    }

    public void setBase(Color lo, Color hi) {
        double step = 1.0 / (double)(this.colors.length - 1);
        double t = 1.0E-5;
        for (int i = 0; i < this.colors.length; ++i) {
            int red = (int)((double)lo.getRed() * (1.0 - t) + (double)hi.getRed() * t);
            int green = (int)((double)lo.getGreen() * (1.0 - t) + (double)hi.getGreen() * t);
            int blue = (int)((double)lo.getBlue() * (1.0 - t) + (double)hi.getGreen() * t);
            t += step;
            this.colors[i] = ColorUtils.getColor((int)red, (int)green, (int)blue);
        }
        this.knots.clear();
        this.firePaletteChanged();
    }

    public ArrayList<KnotRecord> getKnots() {
        return this.knots;
    }

    public void addKnot(String name, Color knot, int start, int point) {
        int bound = 2 * (point - start) + 1 + start;
        if (bound > this.colors.length) {
            bound = this.colors.length;
        }
        KnotRecord newrec = new KnotRecord(name, knot, start, bound, point);
        this.knots.add(newrec);
        this.mergeKnot(newrec);
        this.firePaletteChanged();
    }

    private void mergeKnot(KnotRecord k) {
        double radianstep = Math.toRadians(180.0) / (double)(k.point - k.start);
        double cur = 0.0;
        for (int start = k.start; start < k.end; ++start) {
            Color oldcolor = this.colors[start];
            Color knot = k.color;
            double t = (-Math.cos(cur) + 1.0) / 2.0;
            double tmp = (double)(knot.getRed() - oldcolor.getRed()) * t + (double)oldcolor.getRed();
            int red = (int)Math.floor(tmp);
            tmp = (double)(knot.getGreen() - oldcolor.getGreen()) * t + (double)oldcolor.getGreen();
            int green = (int)Math.floor(tmp);
            tmp = (double)(knot.getBlue() - oldcolor.getBlue()) * t + (double)oldcolor.getBlue();
            int blue = (int)Math.floor(tmp);
            this.colors[start] = ColorUtils.getColor((int)red, (int)green, (int)blue);
            cur += radianstep;
        }
    }
}

