/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.rtti.GoFuncDataTable;
import ghidra.app.util.bin.format.golang.rtti.GoFuncFlag;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoPcDataTable;
import ghidra.app.util.bin.format.golang.rtti.GoPcValueEvaluator;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoSourceFileInfo;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.GoTypeManager;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.framework.store.LockException;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName={"runtime._func"})
public class GoFuncData
implements StructureMarkup<GoFuncData> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoFuncData> context;
    @FieldMapping(presentWhen="1.18+", fieldName={"entryoff", "entryOff"})
    @EOLComment(value="getDescription")
    @MarkupReference(value="getFuncAddress")
    private long entryoff;
    @FieldMapping(presentWhen="-1.17")
    @EOLComment(value="getDescription")
    @MarkupReference(value="getFuncAddress")
    private long entry;
    @FieldMapping(fieldName={"nameoff", "nameOff"})
    @MarkupReference(value="getNameAddress")
    private long nameoff;
    @FieldMapping
    @MarkupReference(value="getDeferreturnAddress")
    private long deferreturn;
    @FieldMapping
    private long pcfile;
    @FieldMapping
    private long pcln;
    @FieldMapping
    private int npcdata;
    @FieldMapping(presentWhen="1.16+")
    private long cuOffset = -1L;
    @FieldMapping
    private byte funcID;
    @FieldMapping(presentWhen="1.17+")
    @EOLComment(value="flags")
    private byte flag;
    @FieldMapping
    private int nfuncdata;
    private Address funcAddress;

    public void setEntryoff(long entryoff) {
        this.entryoff = entryoff;
        GoModuledata moduledata = this.getModuledata();
        this.funcAddress = moduledata != null ? moduledata.getText().add(entryoff) : null;
        this.entry = this.funcAddress != null ? this.funcAddress.getOffset() : -1L;
    }

    public void setEntry(long entry) {
        this.entry = entry;
        this.funcAddress = this.context.getDataTypeMapper().getCodeAddress(entry);
    }

    public Address getFuncAddress() {
        return this.funcAddress;
    }

    public AddressRange getBody() {
        try {
            long max = new GoPcValueEvaluator(this, this.pcfile).getMaxPC() - 1L;
            if (max > this.entry) {
                return new AddressRangeImpl(this.funcAddress, this.funcAddress.getNewAddress(max));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new AddressRangeImpl(this.funcAddress, this.funcAddress);
    }

    public Function getFunction() {
        Address addr = this.getFuncAddress();
        return this.programContext.getProgram().getFunctionManager().getFunctionAt(addr);
    }

    public Address getDeferreturnAddress() {
        return this.deferreturn != 0L ? this.getFuncAddress().add(this.deferreturn) : null;
    }

    private long getPcDataStartOffset(int tableIndex) {
        return this.context.getStructureLength() + 4 * tableIndex;
    }

    private long getPcDataStart(int tableIndex) throws IOException {
        return this.context.getFieldReader(this.getPcDataStartOffset(tableIndex)).readNextUnsignedInt();
    }

    private long getFuncDataPtr(int tableIndex) throws IOException {
        return this.getPcDataStart(this.npcdata + tableIndex);
    }

    public int getPcDataValue(GoPcDataTable tableIndex, long targetPC) throws IOException {
        if (tableIndex == null || tableIndex.ordinal() >= this.npcdata) {
            return -1;
        }
        long pcstart = this.getPcDataStart(tableIndex.ordinal());
        return new GoPcValueEvaluator(this, pcstart).eval(targetPC);
    }

    public List<Integer> getPcDataValues(GoPcDataTable tableIndex) throws IOException {
        if (tableIndex == null || tableIndex.ordinal() >= this.npcdata) {
            return List.of();
        }
        long pcstart = this.getPcDataStart(tableIndex.ordinal());
        return new GoPcValueEvaluator(this, pcstart).evalAll(Long.MAX_VALUE);
    }

    public long getFuncDataValue(GoFuncDataTable tableIndex) throws IOException {
        if (tableIndex == null || tableIndex.ordinal() < 0 || tableIndex.ordinal() >= this.nfuncdata) {
            return -1L;
        }
        long gofuncoffset = this.getModuledata().getGofunc();
        if (gofuncoffset == 0L) {
            return -1L;
        }
        long off = this.getFuncDataPtr(tableIndex.ordinal());
        return off == -1L ? null : Long.valueOf(gofuncoffset + off);
    }

    public String recoverFunctionSignature() throws IOException {
        RecoveredSignature sig = RecoveredSignature.read(this, this.programContext);
        return sig.toString();
    }

    public Address getNameAddress() {
        GoModuledata moduledata = this.getModuledata();
        if (moduledata != null) {
            GoSlice slice = moduledata.getFuncnametab();
            if (slice == null) {
                slice = moduledata.getPclntable();
            }
            return slice.getArrayAddress().add(this.nameoff);
        }
        return null;
    }

    public String getName() {
        GoModuledata moduledata = this.getModuledata();
        if (moduledata != null) {
            try {
                GoSlice slice = moduledata.getFuncnametab();
                if (slice == null) {
                    slice = moduledata.getPclntable();
                }
                return slice.getElementReader(1, (int)this.nameoff).readNextUtf8String();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "unknown_func_%x_%s".formatted(this.context.getStructureStart(), this.funcAddress != null ? this.funcAddress : "missing_addr");
    }

    public GoSymbolName getSymbolName() {
        return GoSymbolName.parse(this.getName());
    }

    public String getDescription() {
        return this.getName() + "@" + String.valueOf(this.getFuncAddress());
    }

    public boolean isInline() {
        return this.entryoff == -1L || this.entryoff == 0xFFFFFFFFL;
    }

    public Set<GoFuncFlag> getFlags() {
        return GoFuncFlag.parseFlags(this.flag);
    }

    public boolean isAsmFunction() {
        return GoFuncFlag.ASM.isSet(this.flag);
    }

    public GoSourceFileInfo getSourceFileInfo() throws IOException {
        GoModuledata moduledata = this.getModuledata();
        if (moduledata == null) {
            return null;
        }
        int fileno = new GoPcValueEvaluator(this, this.pcfile).eval(this.entry);
        int lineNum = new GoPcValueEvaluator(this, this.pcln).eval(this.entry);
        if (fileno < 0) {
            return null;
        }
        String fileName = this.getSourceFilename(fileno);
        return fileName != null ? new GoSourceFileInfo(fileName, lineNum) : null;
    }

    public void markupSourceFileInfo() {
        GoModuledata moduledata = this.getModuledata();
        if (moduledata == null) {
            return;
        }
        Program program = this.programContext.getProgram();
        SourceFileManager sfman = program.getSourceFileManager();
        try {
            int fileNum;
            int lineNum;
            GoPcValueEvaluator fileEval = new GoPcValueEvaluator(this, this.pcfile);
            GoPcValueEvaluator lineEval = new GoPcValueEvaluator(this, this.pcln);
            long startpc = this.entry;
            long prevFilenum = -1L;
            while ((lineNum = lineEval.evalNext()) > 0 && (fileNum = fileEval.eval(startpc)) >= 0) {
                fileEval.reset();
                if ((long)fileNum != prevFilenum) {
                    prevFilenum = fileNum;
                    String fileName = this.getSourceFilename(fileNum);
                    if (!"<autogenerated>".equals(fileName)) {
                        fileName = FSUtilities.normalizeNativePath(fileName);
                        Address startAddr = this.programContext.getCodeAddress(startpc);
                        long len = lineEval.getPC() - startpc;
                        SourceFile sourceFile = new SourceFile(fileName);
                        try {
                            sfman.addSourceFile(sourceFile);
                            sfman.addSourceMapEntry(sourceFile, lineNum, startAddr, len);
                        }
                        catch (AddressOverflowException | IllegalArgumentException e) {
                            Msg.error((Object)this, (Object)("Failed to add source file mapping: " + e.getMessage()));
                        }
                    }
                }
                startpc = lineEval.getPC();
            }
        }
        catch (LockException | IOException e) {
            Msg.error((Object)this, (Object)"Failed to set source file info", (Throwable)e);
        }
    }

    private String getSourceFilename(int fileno) throws IOException {
        GoSlice nameSlice;
        long fileoff;
        GoModuledata moduledata = this.getModuledata();
        GoSlice cutab = moduledata.getCutab();
        GoSlice filetab = moduledata.getFiletab();
        if (cutab == null) {
            fileoff = filetab.readUIntElement(4, fileno);
            nameSlice = moduledata.getPclntable();
        } else {
            fileoff = cutab.readUIntElement(4, (int)this.cuOffset + fileno);
            nameSlice = filetab;
        }
        String fileName = fileoff >= 0L ? nameSlice.getElementReader(1, (int)fileoff).readNextUtf8String() : null;
        return fileName;
    }

    public GoModuledata getModuledata() {
        return this.programContext.findContainingModuleByFuncData(this.context.getStructureStart());
    }

    @Override
    public StructureContext<GoFuncData> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getSymbolName().asString();
    }

    @Override
    public String getStructureNamespace() throws IOException {
        return this.getSymbolName().packagePath();
    }

    @Override
    public String getStructureLabel() throws IOException {
        return "%s___funcdata".formatted(this.getStructureName());
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException, CancelledException {
        Address deferreturnAddr;
        Address addr;
        GoTypeManager goTypes = this.programContext.getGoTypes();
        if (this.npcdata > 0) {
            ArrayDataType pcdataArrayDT = new ArrayDataType(goTypes.getDataType("uint32"), this.npcdata, -1, this.programContext.getDTM());
            addr = this.context.getStructureAddress().add(this.getPcDataStartOffset(0));
            session.markupAddress(addr, (DataType)pcdataArrayDT);
            session.labelAddress(addr, this.getStructureLabel() + "___pcdata", this.getStructureNamespace());
        }
        if (this.nfuncdata > 0) {
            ArrayDataType funcdataArrayDT = new ArrayDataType(goTypes.getDataType("uint32"), this.nfuncdata, -1, this.programContext.getDTM());
            addr = this.context.getStructureAddress().add(this.getPcDataStartOffset(this.npcdata));
            session.markupAddress(addr, (DataType)funcdataArrayDT);
            session.labelAddress(addr, this.getStructureLabel() + "___array", this.getStructureNamespace());
        }
        if ((deferreturnAddr = this.getDeferreturnAddress()) != null) {
            GoSymbolName funcName = this.getSymbolName();
            session.labelAddress(deferreturnAddr, funcName.asString() + "_deferreturn", funcName.packagePath());
        }
    }

    public String toString() {
        return "GoFuncData [getFuncAddress()=%s, getSymbolName()=%s, getStructureContext()=%s]".formatted(this.getFuncAddress(), this.getSymbolName(), this.getStructureContext());
    }

    record RecoveredSignature(String name, List<RecoveredArg> args, boolean partial, boolean error) {
        private static final int ARGINFO_ENDSEQ = 255;
        private static final int ARGINFO_STARTAGG = 254;
        private static final int ARGINFO_ENDAGG = 253;
        private static final int ARGINFO_DOTDOTDOT = 252;
        private static final int ARGINFO_OFFSET_TOOLARGE = 251;

        public static RecoveredSignature read(GoFuncData funcData, GoRttiMapper goBinary) throws IOException {
            RecoveredArg args = RecoveredSignature.readArgs(funcData, goBinary);
            return new RecoveredSignature(funcData.getName(), args.subArgs, args.hasPartialFlag(), args.partial);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static RecoveredArg readArgs(GoFuncData funcData, GoRttiMapper goBinary) throws IOException {
            ArrayList<RecoveredArg> current;
            long argInfoOffset = funcData.getFuncDataValue(GoFuncDataTable.FUNCDATA_ArgInfo);
            if (argInfoOffset == -1L) {
                return new RecoveredArg(List.of(), 0, false);
            }
            BinaryReader argInfoReader = goBinary.getReader(argInfoOffset);
            ArrayDeque<ArrayList<RecoveredArg>> resultStack = new ArrayDeque<ArrayList<RecoveredArg>>();
            List<RecoveredArg> parent = null;
            ArrayList<RecoveredArg> results = current = new ArrayList<RecoveredArg>();
            try {
                block9: while (true) {
                    int b = argInfoReader.readNextUnsignedByte();
                    switch (b) {
                        case 255: {
                            return new RecoveredArg(results, 0, false);
                        }
                        case 254: {
                            parent = current;
                            current = new ArrayList();
                            resultStack.addLast(current);
                            continue block9;
                        }
                        case 253: {
                            if (parent == null) {
                                throw new IOException("no parent");
                            }
                            parent.add(new RecoveredArg(current, 0, false));
                            current = parent;
                            parent = (List)resultStack.pollLast();
                            continue block9;
                        }
                        case 252: {
                            current.add(new RecoveredArg(null, -1, true));
                            continue block9;
                        }
                        case 251: {
                            current.add(new RecoveredArg(null, -2, true));
                            continue block9;
                        }
                    }
                    int sz = argInfoReader.readNextUnsignedByte();
                    current.add(new RecoveredArg(null, sz, false));
                }
            }
            catch (IOException e) {
                return new RecoveredArg(results, 0, true);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.partial) {
                sb.append("[partial] ");
            }
            if (this.error) {
                sb.append("[error] ");
            }
            sb.append("func ").append(this.name).append("(");
            for (int i = 0; i < this.args.size(); ++i) {
                RecoveredArg arg = this.args.get(i);
                if (i != 0) {
                    sb.append(", ");
                }
                arg.concatString(sb);
            }
            sb.append(") ???");
            return sb.toString();
        }
    }

    record RecoveredArg(List<RecoveredArg> subArgs, int argSize, boolean partial) {
        boolean hasPartialFlag() {
            if (this.partial) {
                return true;
            }
            if (this.subArgs != null) {
                for (RecoveredArg subArg : this.subArgs) {
                    if (!subArg.hasPartialFlag()) continue;
                    return true;
                }
            }
            return false;
        }

        void concatString(StringBuilder sb) {
            if (this.subArgs != null) {
                boolean first = true;
                sb.append("struct? {");
                for (RecoveredArg subArg : this.subArgs) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    subArg.concatString(sb);
                }
                sb.append("}");
            } else {
                sb.append(switch (this.argSize) {
                    case -1 -> "...";
                    case -2 -> "???";
                    default -> Integer.toString(this.argSize);
                });
            }
        }
    }
}

