/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macos.rm;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.app.util.bin.format.macos.rm.ReferenceListEntry;
import ghidra.app.util.bin.format.macos.rm.ResourceHeader;
import ghidra.app.util.bin.format.macos.rm.ResourceMap;
import ghidra.app.util.bin.format.macos.rm.ResourceTypeFactory;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResourceType
implements StructConverter {
    private int type;
    private byte[] _typeBytes;
    private short numberOfResources;
    private short offsetToReferenceList;
    private List<ReferenceListEntry> _referenceList = new ArrayList<ReferenceListEntry>();
    private Object _resourceObject;

    ResourceType(BinaryReader reader, ResourceHeader header, ResourceMap map, long resourceTypeListStartIndex) throws IOException {
        this.type = reader.peekNextInt();
        this._typeBytes = reader.readNextByteArray(4);
        this.numberOfResources = reader.readNextShort();
        this.offsetToReferenceList = reader.readNextShort();
        this.parseReferenceList(reader, map);
        this._resourceObject = ResourceTypeFactory.getResourceObject(reader, header, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseReferenceList(BinaryReader reader, ResourceMap map) throws IOException {
        long referenceListStartIndex = map.getMapStartIndex() + (long)map.getResourceTypeListOffset() + (long)this.offsetToReferenceList;
        long oldIndex = reader.getPointerIndex();
        reader.setPointerIndex(referenceListStartIndex);
        try {
            for (int i = 0; i < this.numberOfResources + 1; ++i) {
                this._referenceList.add(new ReferenceListEntry(reader, map));
            }
        }
        finally {
            reader.setPointerIndex(oldIndex);
        }
    }

    public Object getResourceObject() {
        return this._resourceObject;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeAsString() {
        if (this.isAscii()) {
            return new String(this._typeBytes);
        }
        return "0x" + Integer.toHexString(this.type);
    }

    public short getNumberOfResources() {
        return this.numberOfResources;
    }

    public short getOffsetToReferenceList() {
        return this.offsetToReferenceList;
    }

    public List<ReferenceListEntry> getReferenceList() {
        return this._referenceList;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = StructConverterUtil.parseName(ResourceType.class);
        StructureDataType struct = new StructureDataType(name, 0);
        if (this.isAscii()) {
            struct.add((DataType)new StringDataType(), 4, "type", null);
        } else {
            struct.add(DWORD, "type", null);
        }
        struct.add(WORD, "numberOfResources", null);
        struct.add(WORD, "offsetToReferenceList", null);
        return struct;
    }

    private boolean isAscii() {
        for (byte b : this._typeBytes) {
            if (b >= 32 && b <= 126) continue;
            return false;
        }
        return true;
    }
}

