/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.objc2;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_Constants;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_InstanceVariableList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_MethodList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_PropertyList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_ProtocolList;
import ghidra.app.util.bin.format.objc2.ObjectiveC2_State;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC1_Utilities;
import ghidra.app.util.bin.format.objectiveC.ObjectiveC_MethodType;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ObjectiveC2_ClassRW
implements StructConverter {
    public static final String NAME = "class_rw_t";
    private ObjectiveC2_State _state;
    private long _index;
    private long flags;
    private long instanceStart;
    private long instanceSize;
    private long reserved;
    private String name;
    private ObjectiveC2_MethodList baseMethods;
    private ObjectiveC2_ProtocolList baseProtocols;
    private ObjectiveC2_InstanceVariableList ivars;
    private long weakIvarLayout;
    private ObjectiveC2_PropertyList baseProperties;

    public ObjectiveC2_ClassRW() {
    }

    public ObjectiveC2_ClassRW(ObjectiveC2_State state, BinaryReader reader) throws IOException {
        this._state = state;
        this._index = reader.getPointerIndex();
        if (state.is32bit) {
            this.flags = reader.readNextUnsignedInt();
            this.instanceStart = reader.readNextUnsignedInt();
            this.instanceSize = reader.readNextUnsignedInt();
            this.reserved = reader.readNextUnsignedInt();
        } else {
            this.flags = reader.readNextLong();
            this.instanceStart = reader.readNextLong();
            this.instanceSize = reader.readNextLong();
        }
        this.readName(reader);
        this.readBaseMethods(reader);
        this.readBaseProtocols(reader);
        this.readInstanceVariables(reader);
        this.weakIvarLayout = ObjectiveC1_Utilities.readNextIndex(reader, state.is32bit);
        this.readBaseProperties(reader);
    }

    public long getIndex() {
        return this._index;
    }

    public String getName() {
        return this.name;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getInstanceStart() {
        return this.instanceStart;
    }

    public long getInstanceSize() {
        return this.instanceSize;
    }

    public long getReserved() {
        return this.reserved;
    }

    public long getWeakIvarLayout() {
        return this.weakIvarLayout;
    }

    public ObjectiveC2_MethodList getBaseMethods() {
        return this.baseMethods;
    }

    public ObjectiveC2_ProtocolList getBaseProtocols() {
        return this.baseProtocols;
    }

    public ObjectiveC2_InstanceVariableList getInstanceVariables() {
        return this.ivars;
    }

    public ObjectiveC2_PropertyList getBaseProperties() {
        return this.baseProperties;
    }

    private void readName(BinaryReader reader) throws IOException {
        long nameIndex = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (nameIndex != 0L) {
            this.name = reader.readAsciiString(nameIndex);
        }
    }

    private void readBaseProperties(BinaryReader reader) throws IOException {
        long propertiesIndex = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (propertiesIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(propertiesIndex);
            this.baseProperties = new ObjectiveC2_PropertyList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readInstanceVariables(BinaryReader reader) throws IOException {
        long instanceVariablesIndex = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (instanceVariablesIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(instanceVariablesIndex);
            this.ivars = new ObjectiveC2_InstanceVariableList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readBaseProtocols(BinaryReader reader) throws IOException {
        long protocolsIndex = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (protocolsIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(protocolsIndex);
            this.baseProtocols = new ObjectiveC2_ProtocolList(this._state, reader);
            reader.setPointerIndex(originalIndex);
        }
    }

    private void readBaseMethods(BinaryReader reader) throws IOException {
        long methodsIndex = ObjectiveC1_Utilities.readNextIndex(reader, this._state.is32bit);
        if (methodsIndex != 0L) {
            long originalIndex = reader.getPointerIndex();
            reader.setPointerIndex(methodsIndex);
            this.baseMethods = new ObjectiveC2_MethodList(this._state, reader, ObjectiveC_MethodType.INSTANCE);
            reader.setPointerIndex(originalIndex);
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        if (this._state.is32bit) {
            struct.add(DWORD, "flags", null);
            struct.add(DWORD, "instanceStart", null);
            struct.add(DWORD, "instanceSize", null);
            struct.add(DWORD, "reserved", null);
        } else {
            struct.add(QWORD, "flags", null);
            struct.add(QWORD, "instanceStart", null);
            struct.add(QWORD, "instanceSize", null);
        }
        struct.add((DataType)new PointerDataType(ASCII), this._state.pointerSize, "name", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_MethodList.toGenericDataType()), this._state.pointerSize, "baseMethods", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_ProtocolList.toGenericDataType(this._state)), this._state.pointerSize, "baseProtocols", null);
        struct.add((DataType)new PointerDataType(ObjectiveC2_InstanceVariableList.toGenericDataType()), this._state.pointerSize, "ivars", null);
        if (this._state.is32bit) {
            struct.add(DWORD, "weakIvarLayout", null);
        } else {
            struct.add(QWORD, "weakIvarLayout", null);
        }
        struct.add((DataType)new PointerDataType(ObjectiveC2_PropertyList.toGenericDataType()), this._state.pointerSize, "baseProperties", null);
        struct.setCategoryPath(ObjectiveC2_Constants.CATEGORY_PATH);
        return struct;
    }

    public void applyTo() throws Exception {
        Namespace namespace;
        Address address = ObjectiveC1_Utilities.toAddress(this._state.program, this.getIndex());
        try {
            ObjectiveC1_Utilities.applyData(this._state.program, this.toDataType(), address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            namespace = ObjectiveC1_Utilities.createNamespace(this._state.program, "objc", NAME);
            ObjectiveC1_Utilities.createSymbol(this._state.program, namespace, this.getName(), address);
        }
        catch (Exception namespace2) {
            // empty catch block
        }
        namespace = ObjectiveC1_Utilities.getClassNamespace(this._state.program, null, this.getName());
        if (this.baseMethods != null) {
            this.baseMethods.applyTo(namespace);
        }
        if (this.baseProtocols != null) {
            this.baseProtocols.applyTo(namespace);
        }
        if (this.ivars != null) {
            this.ivars.applyTo(namespace);
        }
        if (this.baseProperties != null) {
            this.baseProperties.applyTo(namespace);
        }
    }
}

