/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.listingpanel;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.MultiRowLayout;
import docking.widgets.fieldpanel.support.RowLayout;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import ghidra.app.util.viewer.field.DummyFieldFactory;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.format.FormatModelListener;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModelListener;
import ghidra.app.util.viewer.proxy.AddressProxy;
import ghidra.app.util.viewer.proxy.ClosedVariableProxy;
import ghidra.app.util.viewer.proxy.CodeUnitProxy;
import ghidra.app.util.viewer.proxy.DataProxy;
import ghidra.app.util.viewer.proxy.FunctionProxy;
import ghidra.app.util.viewer.proxy.VariableProxy;
import ghidra.app.util.viewer.util.ProgramOpenCloseManager;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Reference;
import ghidra.util.datastruct.LRUMap;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProgramBigListingModel
implements ListingModel,
FormatModelListener,
DomainObjectListener,
ChangeListener,
OptionsChangeListener {
    protected final Program program;
    private ProgramOpenCloseManager openCloseMgr = new ProgramOpenCloseManager();
    private FormatManager formatMgr;
    private ToolOptions fieldOptions;
    private boolean showExternalFunctionPointerFormat;
    private boolean showNonExternalFunctionPointerFormat;
    private final Listing listing;
    private DummyFieldFactory dummyFactory;
    private List<ListingModelListener> listeners = new ArrayList<ListingModelListener>();
    private LayoutCache layoutCache = new LayoutCache(this);

    public ProgramBigListingModel(Program program, FormatManager formatMgr) {
        this.program = program;
        this.listing = program.getListing();
        this.formatMgr = formatMgr;
        this.dummyFactory = new DummyFieldFactory(formatMgr);
        formatMgr.addFormatModelListener(this);
        program.addListener((DomainObjectListener)this);
        this.openCloseMgr.addChangeListener(this);
        this.fieldOptions = formatMgr.getFieldOptions();
        this.fieldOptions.addOptionsChangeListener((OptionsChangeListener)this);
        this.initOptions();
    }

    private void initOptions() {
        this.showExternalFunctionPointerFormat = this.fieldOptions.getBoolean("Function Pointers.Display External Function Pointer Header", true);
        this.showNonExternalFunctionPointerFormat = this.fieldOptions.getBoolean("Function Pointers.Display Non-External Function Pointer Header", false);
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals("Function Pointers.Display External Function Pointer Header")) {
            this.showExternalFunctionPointerFormat = (Boolean)newValue;
            this.formatModelChanged(null);
        } else if (optionName.equals("Function Pointers.Display Non-External Function Pointer Header")) {
            this.showNonExternalFunctionPointerFormat = (Boolean)newValue;
            this.formatModelChanged(null);
        }
        this.layoutCache.clear();
    }

    @Override
    public AddressSetView getAddressSet() {
        return this.program.getMemory();
    }

    @Override
    public void dispose() {
        this.program.removeListener((DomainObjectListener)this);
        this.fieldOptions.removeOptionsChangeListener((OptionsChangeListener)this);
        this.formatMgr.removeFormatModleListener(this);
        this.listeners.clear();
    }

    @Override
    public void setFormatManager(FormatManager formatManager) {
        this.formatMgr = formatManager;
        this.formatMgr.addFormatModelListener(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.notifyDataChanged(true);
    }

    @Override
    public Layout getLayout(Address addr, boolean isGapAddress) {
        Layout layout = this.layoutCache.get(addr, isGapAddress);
        if (layout == null) {
            layout = this.doGetLayout(addr, isGapAddress);
            this.layoutCache.put(addr, layout, isGapAddress);
        }
        return layout;
    }

    private Layout doGetLayout(Address addr, boolean isGapAddress) {
        ListingField f;
        FieldFormatModel format;
        ArrayList<RowLayout> list = new ArrayList<RowLayout>();
        CodeUnit cu = this.listing.getCodeUnitAt(addr);
        ArrayList<Data> dataList = null;
        Function function = null;
        Data data = null;
        int indexSize = 1;
        if (cu != null) {
            indexSize = cu.getLength();
            function = this.listing.getFunctionAt(addr);
        } else if (addr.isExternalAddress()) {
            function = this.listing.getFunctionAt(addr);
        }
        if (cu instanceof Data) {
            data = (Data)cu;
            if (function == null && data.isPointer()) {
                function = this.getPointerReferencedFunction(data);
            }
        } else if (cu == null) {
            data = this.listing.getDataContaining(addr);
        }
        if (data != null && data.getNumComponents() > 0) {
            dataList = new ArrayList<Data>();
            this.addOpenData(dataList, data, addr);
            this.addUnionPostOpenData(dataList, data, addr);
        }
        if (isGapAddress) {
            format = this.formatMgr.getDividerModel();
            format.addLayouts(list, 0, new AddressProxy(this, addr));
        }
        if (cu != null) {
            format = this.formatMgr.getPlateFormat();
            format.addLayouts(list, 0, new CodeUnitProxy(this, this.program, cu));
        }
        if (function != null) {
            format = this.formatMgr.getFunctionFormat();
            format.addLayouts(list, 0, new FunctionProxy(this, this.program, addr, function));
            format = this.formatMgr.getFunctionVarFormat();
            boolean variablesOpen = this.openCloseMgr.isFunctionVariablesOpen(function.getEntryPoint());
            if (variablesOpen) {
                this.addReturn(addr, list, format, function);
                this.addParameters(addr, list, format, function);
                this.addLocals(addr, list, format, function);
            } else {
                format.addLayouts(list, 0, new ClosedVariableProxy(this, this.program, addr, function));
            }
        }
        if (cu != null) {
            format = this.formatMgr.getCodeUnitFormat();
            format.addLayouts(list, 0, new CodeUnitProxy(this, this.program, cu));
        }
        if (dataList != null) {
            for (Data d : dataList) {
                format = this.formatMgr.getOpenDataFormat(d);
                if (format != null) {
                    format.addLayouts(list, 0, new DataProxy(this, this.program, d));
                }
                indexSize = d.getLength();
            }
            dataList = null;
        }
        if (list.size() > 0) {
            return new MultiRowLayout(list.toArray(new RowLayout[list.size()]), indexSize);
        }
        if (cu != null && (f = this.dummyFactory.getField(new CodeUnitProxy(this, this.program, cu), 0)) != null) {
            return new MultiRowLayout((RowLayout)new SingleRowLayout((Field)f), indexSize);
        }
        return null;
    }

    private void addReturn(Address addr, List<RowLayout> list, FieldFormatModel format, Function function) {
        format.addLayouts(list, 0, new VariableProxy(this, this.program, addr, function, (Variable)function.getReturn(), true));
    }

    private void addLocals(Address addr, List<RowLayout> list, FieldFormatModel format, Function function) {
        Variable[] vars;
        for (Variable var : vars = function.getLocalVariables()) {
            format.addLayouts(list, 0, new VariableProxy(this, this.program, addr, function, var, false));
        }
    }

    private void addParameters(Address addr, List<RowLayout> list, FieldFormatModel format, Function function) {
        Parameter[] params;
        for (Parameter param : params = function.getParameters()) {
            format.addLayouts(list, 0, new VariableProxy(this, this.program, addr, function, (Variable)param, false));
        }
    }

    private Function getPointerReferencedFunction(Data data) {
        Reference ref = data.getPrimaryReference(0);
        if (ref == null) {
            return null;
        }
        if (ref.isExternalReference() && !this.showExternalFunctionPointerFormat) {
            return null;
        }
        if (!ref.isExternalReference() && !this.showNonExternalFunctionPointerFormat) {
            return null;
        }
        return this.listing.getFunctionAt(ref.getToAddress());
    }

    @Override
    public int getMaxWidth() {
        return this.formatMgr.getMaxWidth();
    }

    @Override
    public Address getAddressAfter(Address address) {
        Address openAddr;
        Data data;
        CodeUnit cu = this.listing.getCodeUnitContaining(address);
        if (cu instanceof Data && (data = (Data)cu).getNumComponents() > 0 && this.openCloseMgr.isDataOpen(data.getMinAddress()) && (openAddr = this.findOpenDataAfter(address, data)) != null) {
            return openAddr;
        }
        cu = this.listing.getCodeUnitAfter(address);
        return cu == null ? null : cu.getMinAddress();
    }

    private Address findOpenDataAfter(Address address, Data parent) {
        Address openAddr;
        Data data;
        DataType dt = parent.getBaseDataType();
        if (dt instanceof Union) {
            int index = this.openCloseMgr.getOpenDataIndex(parent);
            if (index < 0) {
                return null;
            }
            data = parent.getComponent(index);
        } else if (dt instanceof Structure) {
            offset = (int)address.subtract(parent.getMinAddress());
            data = parent.getComponentContaining(offset);
            if (data == null) {
                ++offset;
                int length = dt.getLength();
                while (offset < length) {
                    data = parent.getComponentAt(offset);
                    if (data != null) {
                        return data.getMinAddress();
                    }
                    ++offset;
                }
            }
        } else {
            offset = (int)address.subtract(parent.getMinAddress());
            data = parent.getComponentContaining(offset);
        }
        if (data == null) {
            return null;
        }
        if (data.getNumComponents() > 0 && this.openCloseMgr.isDataOpen(data) && (openAddr = this.findOpenDataAfter(address, data)) != null) {
            return openAddr;
        }
        int index = data.getComponentIndex();
        if (dt instanceof Union) {
            Address maxAddr;
            if (index < parent.getNumComponents() && (maxAddr = parent.getComponent(index).getMaxAddress()).compareTo((Object)address) > 0) {
                return maxAddr;
            }
            Address maxAddr2 = parent.getMaxAddress();
            if (maxAddr2.compareTo((Object)address) > 0) {
                return maxAddr2;
            }
        } else {
            while (index < parent.getNumComponents() - 1) {
                Data component;
                if (address.compareTo((Object)(component = parent.getComponent(++index)).getMinAddress()) >= 0) continue;
                return component.getAddress();
            }
        }
        return null;
    }

    @Override
    public Address getAddressBefore(Address addr) {
        Address prevAddr;
        CodeUnit cu = this.listing.getCodeUnitContaining(addr);
        if (cu == null || addr.equals((Object)cu.getMinAddress())) {
            cu = this.listing.getCodeUnitBefore(addr);
            if (this.isOpenData(cu)) {
                return cu.getMaxAddress();
            }
            return cu == null ? null : cu.getMinAddress();
        }
        if (this.isOpenData(cu) && (prevAddr = this.findOpenDataBefore(addr, (Data)cu)) != null) {
            return prevAddr;
        }
        return cu.getMinAddress();
    }

    public boolean isOpenData(CodeUnit cu) {
        Data data;
        return cu instanceof Data && (data = (Data)cu).getNumComponents() > 0 && this.openCloseMgr.isDataOpen(data.getMinAddress());
    }

    private Address findOpenDataBefore(Address addr, Data parent) {
        Address openAddr;
        Data data;
        if (parent.getAddress().equals((Object)addr)) {
            return null;
        }
        if (parent.getBaseDataType() instanceof Union) {
            int index = this.openCloseMgr.getOpenDataIndex(parent);
            if (index < 0) {
                return null;
            }
            data = parent.getComponent(index);
        } else {
            int offset = (int)addr.subtract(parent.getMinAddress());
            List componentsContaining = parent.getComponentsContaining(offset - 1);
            Data data2 = data = componentsContaining.isEmpty() ? null : (Data)componentsContaining.get(componentsContaining.size() - 1);
        }
        if (data == null) {
            return addr.previous();
        }
        if (data.getNumComponents() > 0 && this.openCloseMgr.isDataOpen(data) && (openAddr = this.findOpenDataBefore(addr, data)) != null) {
            return openAddr;
        }
        if (!data.getAddress().equals((Object)addr)) {
            return data.getAddress();
        }
        int index = data.getComponentIndex();
        if (index > 0) {
            return parent.getComponent(index - 1).getAddress();
        }
        return null;
    }

    private void addOpenData(List<Data> list, Data data, Address addr) {
        block5: {
            Address dataAddr;
            block6: {
                dataAddr = data.getMinAddress();
                if (!this.openCloseMgr.isDataOpen(data)) break block5;
                DataType dt = data.getBaseDataType();
                if (!(dt instanceof Union)) break block6;
                int openIndex = this.openCloseMgr.getOpenDataIndex(data);
                int numComps = ((Union)dt).getNumComponents();
                if (openIndex < 0) {
                    openIndex = numComps;
                }
                for (int i = 0; i <= openIndex && i < numComps; ++i) {
                    Data tmpData = data.getComponent(i);
                    if (tmpData.getMinAddress().equals((Object)addr)) {
                        list.add(tmpData);
                    }
                    if (tmpData.getNumComponents() <= 0) continue;
                    this.addOpenData(list, tmpData, addr);
                }
                break block5;
            }
            List dataList = data.getComponentsContaining((int)addr.subtract(dataAddr));
            if (dataList == null) break block5;
            for (Data subData : dataList) {
                if (subData.getMinAddress().equals((Object)addr)) {
                    list.add(subData);
                }
                if (subData.getNumComponents() <= 0) continue;
                this.addOpenData(list, subData, addr);
            }
        }
    }

    private void addUnionPostOpenData(List<Data> list, Data data, Address addr) {
        DataType dt = data.getBaseDataType();
        if (dt instanceof Union) {
            Address dataAddr = data.getMinAddress();
            if (this.openCloseMgr.isDataOpen(data)) {
                int openIndex;
                int i = openIndex = this.openCloseMgr.getOpenDataIndex(data);
                int numComps = ((Union)dt).getNumComponents();
                if (i < 0) {
                    i = numComps;
                }
                while (i < numComps) {
                    Data tmpData = data.getComponent(i);
                    if (tmpData.getNumComponents() > 0) {
                        this.addUnionPostOpenData(list, tmpData, addr);
                    }
                    if (i > openIndex && data.getMaxAddress().equals((Object)addr)) {
                        list.add(tmpData);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public boolean isOpen(Data data) {
        return this.openCloseMgr.isDataOpen(data);
    }

    @Override
    public void toggleOpen(Data data) {
        this.openCloseMgr.toggleDataOpen(data);
    }

    @Override
    public void setFunctionVariablesOpen(Address functionAddress, boolean open) {
        this.openCloseMgr.setFunctionVariablesOpen(functionAddress, open);
    }

    @Override
    public void setAllFunctionVariablesOpen(boolean open) {
        this.openCloseMgr.setAllFunctionVariablesOpen(open);
    }

    @Override
    public boolean areFunctionVariablesOpen(Address FunctionAddress) {
        return this.openCloseMgr.isFunctionVariablesOpen(FunctionAddress);
    }

    @Override
    public void openAllData(Data data, TaskMonitor monitor) {
        this.openCloseMgr.openDataRecursively(data, monitor);
    }

    @Override
    public void closeAllData(Data data, TaskMonitor monitor) {
        this.openCloseMgr.closeDataRecursively(data, monitor);
    }

    @Override
    public void openAllData(AddressSetView addresses, TaskMonitor monitor) {
        this.openCloseMgr.openAllData(this.program, addresses, monitor);
    }

    @Override
    public void closeAllData(AddressSetView addresses, TaskMonitor monitor) {
        this.openCloseMgr.closeAllData(this.program, addresses, monitor);
    }

    @Override
    public void closeData(Data data) {
        this.openCloseMgr.closeData(data);
    }

    @Override
    public boolean openData(Data data) {
        this.openCloseMgr.openData(data);
        return true;
    }

    protected void notifyDataChanged(boolean updateImmediately) {
        this.layoutCache.clear();
        for (ListingModelListener listener : this.listeners) {
            listener.dataChanged(updateImmediately);
        }
    }

    private void notifyModelSizeChanged() {
        this.layoutCache.clear();
        for (ListingModelListener listener : this.listeners) {
            listener.modelSizeChanged();
        }
    }

    @Override
    public void formatModelChanged(FieldFormatModel model) {
        this.notifyModelSizeChanged();
    }

    @Override
    public void addListener(ListingModelListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ListingModelListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public boolean isClosed() {
        return this.program.isClosed();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.program.isClosed()) {
            return;
        }
        boolean updateImmediately = ev.numRecords() <= 5;
        this.notifyDataChanged(updateImmediately);
    }

    @Override
    public AddressSet adjustAddressSetToCodeUnitBoundaries(AddressSet addressSet) {
        if (this.program == null) {
            return addressSet;
        }
        List list = addressSet.toList();
        for (AddressRange range : list) {
            Address maxCuAddr;
            Address minCuAddr;
            Address minAddr = range.getMinAddress();
            Address maxAddr = range.getMaxAddress();
            CodeUnit cu = this.program.getListing().getCodeUnitContaining(minAddr);
            if (cu != null && !(minCuAddr = cu.getMinAddress()).equals((Object)minAddr)) {
                addressSet.addRange(minCuAddr, minAddr);
            }
            if ((cu = this.program.getListing().getCodeUnitContaining(maxAddr)) == null || (maxCuAddr = cu.getMaxAddress()).equals((Object)maxAddr)) continue;
            addressSet.addRange(maxAddr, maxCuAddr);
        }
        return addressSet;
    }

    @Override
    public ListingModel copy() {
        ProgramBigListingModel model = new ProgramBigListingModel(this.program, this.formatMgr);
        model.openCloseMgr = this.openCloseMgr;
        return model;
    }

    private class LayoutCache {
        private LRUMap<Address, Layout> cache = new LRUMap(10);
        private LRUMap<Address, Layout> gapCache = new LRUMap(10);

        private LayoutCache(ProgramBigListingModel programBigListingModel) {
        }

        void clear() {
            this.cache.clear();
            this.gapCache.clear();
        }

        Layout get(Address addr, boolean isGapAddress) {
            if (isGapAddress) {
                return (Layout)this.gapCache.get((Object)addr);
            }
            return (Layout)this.cache.get((Object)addr);
        }

        void put(Address addr, Layout layout, boolean isGapAddress) {
            if (isGapAddress) {
                this.gapCache.put((Object)addr, (Object)layout);
            } else {
                this.cache.put((Object)addr, (Object)layout);
            }
        }
    }
}

