/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.swift.nodes;

import ghidra.app.util.demangler.Demangled;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.swift.SwiftDemangler;
import ghidra.app.util.demangler.swift.nodes.SwiftNode;

public class SwiftClassNode
extends SwiftNode {
    @Override
    public Demangled demangle(SwiftDemangler demangler) throws DemangledException {
        String name = null;
        Demangled namespace = null;
        Demangled privateDeclNamespace = null;
        block5: for (SwiftNode child : this.getChildren()) {
            switch (child.getKind()) {
                case Identifier: {
                    name = child.getText();
                    continue block5;
                }
                case PrivateDeclName: {
                    Demangled temp = child.demangle(demangler);
                    name = temp.getName();
                    privateDeclNamespace = temp.getNamespace();
                    continue block5;
                }
                case Class: 
                case Enum: 
                case Module: 
                case Structure: {
                    namespace = child.demangle(demangler);
                    continue block5;
                }
            }
            this.skip(child);
        }
        if (name == null) {
            return this.getUnknown();
        }
        DemangledDataType type = new DemangledDataType(this.properties.mangled(), this.properties.originalDemangled(), name);
        type.setNamespace(SwiftNode.join(namespace, privateDeclNamespace));
        type.setClass();
        type.incrementPointerLevels();
        return type;
    }
}

