/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.Caching;
import generic.theme.GColor;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.FGPrimaryViewer;
import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.jung.renderer.FGVertexRenderer;
import ghidra.app.plugin.core.functiongraph.graph.jung.transformer.FGVertexPickableBackgroundPaintTransformer;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupHistoryInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupVertexSerializer;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphOptions;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.LayoutProvider;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.renderer.VisualGraphEdgeLabelRenderer;
import ghidra.graph.viewer.vertex.AbstractVisualVertexRenderer;
import ghidra.program.util.ProgramLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.UndefinedFunction;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;

public class FGComponent
extends GraphComponent<FGVertex, FGEdge, FunctionGraph> {
    private static final Color PICKED_COLOR = new GColor("color.bg.plugin.functiongraph.vertex.picked");
    private static final Color START_COLOR = new GColor("color.bg.plugin.functiongraph.vertex.entry");
    private static final Color END_COLOR = new GColor("color.bg.plugin.functiongraph.vertex.exit");
    private static final Color UNDEFINED_FUNCTION_COLOR = new GColor("color.bg.undefined");
    private static final int REALLY_BIG_FG_VERTEX_COUNT = 75;
    private final FGView functionGraphView;
    private FGData functionGraphData;
    private FunctionGraph functionGraph;

    public FGComponent(FGView functionGraphView, FGData data, LayoutProvider<FGVertex, FGEdge, FunctionGraph> layoutProvider) {
        this.setGraphOptions(functionGraphView.getController().getFunctionGraphOptions());
        this.setGraph((VisualGraph)data.getFunctionGraph());
        this.functionGraphView = functionGraphView;
        this.functionGraphData = data;
        this.functionGraph = data.getFunctionGraph();
        this.build();
        String message = data.getMessage();
        if (message != null) {
            this.setStatusMessage(message);
        }
    }

    protected FGVertex getInitialVertex() {
        FGVertex focused = (FGVertex)super.getInitialVertex();
        if (focused == null) {
            return this.functionGraph.getRootVertex();
        }
        return focused;
    }

    protected void zoomInCompletely(FGVertex v) {
        super.zoomInCompletely((VisualVertex)v);
        FGVertex vertex = (FGVertex)((FunctionGraph)this.graph).getFocusedVertex();
        if (vertex == null) {
            return;
        }
        Rectangle cursorBounds = vertex.getCursorBounds();
        if (cursorBounds != null) {
            this.ensureCursorVisible(vertex);
            return;
        }
        SystemUtilities.runSwingLater(() -> this.ensureCursorVisible(vertex));
    }

    public void restoreSettings() {
        this.restoreGroupedVertices();
        this.restoreVertexLocations();
    }

    private void restoreGroupedVertices() {
        Element regroupVertexXML;
        FGController controller = this.functionGraphView.getController();
        Element groupedVertexXML = this.functionGraph.getSavedGroupedVertexSettings();
        if (groupedVertexXML != null) {
            GroupVertexSerializer.recreateGroupedVertices(controller, groupedVertexXML);
        }
        if ((regroupVertexXML = this.functionGraph.getSavedGroupHistory()) != null) {
            Collection<GroupHistoryInfo> history = GroupVertexSerializer.recreateGroupHistory(controller, regroupVertexXML);
            this.functionGraph.setGroupHistory(history);
        }
    }

    private FGLayout getFunctionGraphLayout() {
        VisualGraphLayout graphLayout = this.primaryViewer.getVisualGraphLayout();
        FGLayout layout = (FGLayout)graphLayout;
        return layout;
    }

    private void restoreVertexLocations() {
        Map<FGVertex, Point> vertexLocations = this.functionGraph.getSavedVertexLocations();
        Set<Map.Entry<FGVertex, Point>> entrySet = vertexLocations.entrySet();
        FGLayout layout = this.getFunctionGraphLayout();
        for (Map.Entry<FGVertex, Point> entry : entrySet) {
            layout.setLocation(entry.getKey(), entry.getValue(), LayoutListener.ChangeType.RESTORE);
        }
        if (layout instanceof Caching) {
            ((Caching)layout).clear();
        }
        VisualGraphViewUpdater viewUpdater = this.getViewUpdater();
        if (this.isSatelliteShowing()) {
            viewUpdater.fitGraphToViewerNow((VisualizationServer)this.satelliteViewer);
        }
        HashSet edges = new HashSet();
        Set<FGVertex> vertices = vertexLocations.keySet();
        for (FGVertex vertex : vertices) {
            edges.addAll(((FunctionGraph)this.graph).getIncidentEdges(vertex));
        }
        viewUpdater.updateEdgeShapes(edges);
        this.repaint();
    }

    public void clearLayoutPositionCache() {
        this.functionGraph.clearSavedVertexLocations();
    }

    public void clearAllUserLayoutSettings() {
        this.functionGraph.clearAllUserLayoutSettings();
    }

    protected void refreshCurrentLayout() {
        super.refreshCurrentLayout();
        this.functionGraphView.broadcastLayoutRefreshNeeded();
    }

    protected FGPrimaryViewer createPrimaryGraphViewer(VisualGraphLayout<FGVertex, FGEdge> layout, Dimension viewerSize) {
        return new FGPrimaryViewer(this, layout, viewerSize);
    }

    protected void decoratePrimaryViewer(GraphViewer<FGVertex, FGEdge> viewer, VisualGraphLayout<FGVertex, FGEdge> layout) {
        super.decoratePrimaryViewer(viewer, layout);
        Renderer renderer = viewer.getRenderer();
        RenderContext renderContext = viewer.getRenderContext();
        PickedState pickedVertexState = viewer.getPickedVertexState();
        FGVertexRenderer vertexRenderer = new FGVertexRenderer();
        vertexRenderer.setVertexFillPaintTransformer(new FGVertexPickableBackgroundPaintTransformer((PickedInfo<FGVertex>)pickedVertexState, PICKED_COLOR, START_COLOR, END_COLOR));
        renderer.setVertexRenderer((Renderer.Vertex)vertexRenderer);
        Function edgeLabelTransformer = e -> e.getLabel();
        renderContext.setEdgeLabelTransformer(edgeLabelTransformer);
        VisualGraphEdgeLabelRenderer edgeLabelRenderer = new VisualGraphEdgeLabelRenderer((Color)new GColor("color.fg.plugin.functiongraph.label.picked"));
        edgeLabelRenderer.setNonPickedForegroundColor((Color)new GColor("color.fg.plugin.functiongraph.label.non.picked"));
        edgeLabelRenderer.setRotateEdgeLabels(false);
        renderContext.setEdgeLabelRenderer((EdgeLabelRenderer)edgeLabelRenderer);
        viewer.setGraphOptions(this.vgOptions);
        Color bgColor = this.vgOptions.getGraphBackgroundColor();
        if (this.vgOptions.isDefaultBackgroundColor(bgColor)) {
            ghidra.program.model.listing.Function function = this.functionGraphData.getFunction();
            if (function instanceof UndefinedFunction) {
                viewer.setBackground(UNDEFINED_FUNCTION_COLOR);
            } else {
                viewer.setBackground((Color)new GColor("color.bg.plugin.functiongraph"));
            }
        }
    }

    protected void decorateSatelliteViewer(SatelliteGraphViewer<FGVertex, FGEdge> viewer, VisualGraphLayout<FGVertex, FGEdge> layout) {
        super.decorateSatelliteViewer(viewer, layout);
        Renderer renderer = viewer.getRenderer();
        AbstractVisualVertexRenderer vertexRenderer = (AbstractVisualVertexRenderer)renderer.getVertexRenderer();
        PickedState pickedVertexState = viewer.getPickedVertexState();
        RenderContext renderContext = viewer.getRenderContext();
        renderContext.setVertexFillPaintTransformer((Function)new FGVertexPickableBackgroundPaintTransformer((PickedInfo<FGVertex>)pickedVertexState, PICKED_COLOR, START_COLOR, END_COLOR));
        vertexRenderer.setVertexFillPaintTransformer((Function)new FGVertexPickableBackgroundPaintTransformer((PickedInfo<FGVertex>)pickedVertexState, PICKED_COLOR, START_COLOR, END_COLOR));
        viewer.setGraphOptions(this.vgOptions);
    }

    protected boolean isReallyBigData() {
        return ((FunctionGraph)this.graph).getVertices().size() > 75;
    }

    public void dispose() {
        this.functionGraph = null;
        this.functionGraphData = null;
        super.dispose();
    }

    public FunctionGraphOptions getFunctionGraphOptions() {
        return (FunctionGraphOptions)this.vgOptions;
    }

    public void ensureCursorVisible(FGVertex vertex) {
        VisualGraphViewUpdater viewUpdater = this.getViewUpdater();
        Rectangle cursorBounds = vertex.getCursorBounds();
        if (cursorBounds != null) {
            viewUpdater.ensureVertexAreaVisible((VisualVertex)vertex, cursorBounds, null);
            return;
        }
        RenderContext renderContext = this.primaryViewer.getRenderContext();
        Function transformer = renderContext.getVertexShapeTransformer();
        Shape shape = (Shape)transformer.apply((Object)vertex);
        Rectangle bounds = shape.getBounds();
        viewUpdater.ensureVertexAreaVisible((VisualVertex)vertex, bounds, null);
    }

    public void setVertexFocused(FGVertex v, ProgramLocation location) {
        boolean wasFocused = v.isFocused();
        this.gPickedState.pickToSync((Object)v);
        v.setProgramLocation(location);
        if (!wasFocused) {
            this.gPickedState.pickToActivate((Object)v);
        }
    }
}

