/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.eiglsperger;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertionOrderSplayTree<T> {
    private static final Logger log = LoggerFactory.getLogger(InsertionOrderSplayTree.class);
    protected Node<T> root;

    static <T> int nodeSize(Node<T> node) {
        return node == null ? 0 : node.size;
    }

    public static <T> InsertionOrderSplayTree<T> create() {
        return new InsertionOrderSplayTree<T>();
    }

    public static <T> InsertionOrderSplayTree<T> create(Node<T> root) {
        InsertionOrderSplayTree<T> tree = new InsertionOrderSplayTree<T>(root);
        tree.validate();
        return tree;
    }

    protected InsertionOrderSplayTree() {
    }

    protected InsertionOrderSplayTree(Node<T> root) {
        this.root = root;
    }

    void leftRotate(Node<T> x) {
        Node y = x.right;
        if (y != null) {
            x.right = y.left;
            if (y.left != null) {
                y.left.parent = x;
            }
            y.parent = x.parent;
        }
        if (x.parent == null) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        if (y != null) {
            y.left = x;
        }
        x.size = InsertionOrderSplayTree.nodeSize(x.left) + InsertionOrderSplayTree.nodeSize(x.right) + 1;
        x.parent = y;
    }

    void rightRotate(Node<T> x) {
        Node y = x.left;
        if (y != null) {
            x.left = y.right;
            if (y.right != null) {
                y.right.parent = x;
            }
            y.parent = x.parent;
        }
        if (null == x.parent) {
            this.root = y;
        } else if (x == x.parent.left) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        if (y != null) {
            y.right = x;
        }
        x.size = InsertionOrderSplayTree.nodeSize(x.left) + InsertionOrderSplayTree.nodeSize(x.right) + 1;
        x.parent = y;
    }

    public void splay(T element) {
        Node<T> node = this.find(element);
        if (node != null) {
            this.splay(node);
        }
    }

    public void splay(Node<T> x) {
        if (x == null) {
            return;
        }
        int leftSize = 0;
        int rightSize = 0;
        while (x.parent != null) {
            if (null == x.parent.parent) {
                if (x.parent.left == x) {
                    this.rightRotate(x.parent);
                    continue;
                }
                this.leftRotate(x.parent);
                continue;
            }
            if (x.parent.left == x && x.parent.parent.left == x.parent) {
                this.rightRotate(x.parent.parent);
                this.rightRotate(x.parent);
                continue;
            }
            if (x.parent.right == x && x.parent.parent.right == x.parent) {
                this.leftRotate(x.parent.parent);
                this.leftRotate(x.parent);
                continue;
            }
            if (x.parent.left == x && x.parent.parent.right == x.parent) {
                this.rightRotate(x.parent);
                this.leftRotate(x.parent);
                continue;
            }
            this.leftRotate(x.parent);
            this.rightRotate(x.parent);
        }
        this.root.size = (leftSize += InsertionOrderSplayTree.nodeSize(this.root.left)) + (rightSize += InsertionOrderSplayTree.nodeSize(this.root.right)) + 1;
        this.validate();
    }

    static <T> Node<T> p(Node<T> node) {
        return node != null ? node.parent : node;
    }

    static <T> int size(Node<T> node) {
        return node != null ? node.size() : 0;
    }

    static <T> Node<T> l(Node<T> node) {
        return node != null ? node.left : node;
    }

    static <T> Node<T> r(Node<T> node) {
        return node != null ? node.right : node;
    }

    public int pos(Node<T> node) {
        if (node == this.root) {
            return InsertionOrderSplayTree.size(InsertionOrderSplayTree.l(node));
        }
        if (InsertionOrderSplayTree.r(InsertionOrderSplayTree.p(node)) == node) {
            return this.pos(InsertionOrderSplayTree.p(node)) + InsertionOrderSplayTree.size(InsertionOrderSplayTree.l(node)) + 1;
        }
        if (InsertionOrderSplayTree.l(InsertionOrderSplayTree.p(node)) == node) {
            return this.pos(InsertionOrderSplayTree.p(node)) - InsertionOrderSplayTree.size(InsertionOrderSplayTree.r(node)) - 1;
        }
        return -1;
    }

    void replace(Node<T> u, Node<T> v) {
        if (null == u.parent) {
            this.root = v;
        } else if (u == u.parent.left) {
            u.parent.left = v;
        } else {
            u.parent.right = v;
        }
        if (v != null) {
            v.parent = u.parent;
        }
    }

    Node<T> subtree_minimum(Node<T> u) {
        while (u.left != null) {
            u = u.left;
        }
        return u;
    }

    Node<T> subtree_maximum(Node<T> u) {
        while (u.right != null) {
            u = u.right;
        }
        return u;
    }

    public Node<T> max() {
        if (this.root != null) {
            return this.subtree_maximum(this.root);
        }
        return null;
    }

    public Node<T> min() {
        if (this.root != null) {
            return this.subtree_minimum(this.root);
        }
        return null;
    }

    public void append(T key) {
        Node<T> z = new Node<T>(key);
        z.size = 1;
        if (this.root == null) {
            this.root = z;
            return;
        }
        Node<T> max = this.max();
        this.splay(max);
        max.right = z;
        max.size += z.size;
        z.parent = max;
    }

    public static <T> InsertionOrderSplayTree<T> join(Pair<InsertionOrderSplayTree<T>> trees) {
        ((InsertionOrderSplayTree)trees.first).join((InsertionOrderSplayTree)trees.second);
        return (InsertionOrderSplayTree)trees.first;
    }

    public void join(InsertionOrderSplayTree<T> joiner) {
        Node<T> largest = this.max();
        this.splay(largest);
        if (this.root != null) {
            this.root.right = joiner.root;
            if (joiner.root != null) {
                this.root.size += joiner.root.size;
                joiner.root.parent = this.root;
            }
        } else {
            this.root = joiner.root;
        }
    }

    public Node<T> find(int k) {
        return this.find(this.root, (T)k);
    }

    Node<T> find(Node<T> node, int k) {
        if (node == null) {
            return null;
        }
        int pos = this.pos(node);
        if (pos == k) {
            return node;
        }
        if (pos < k) {
            return this.find(node.right, (T)k);
        }
        return this.find(node.left, (T)k);
    }

    public static <T> Pair<InsertionOrderSplayTree<T>> split(InsertionOrderSplayTree<T> tree, T key) {
        InsertionOrderSplayTree<T> right = tree.split(key);
        return Pair.of(tree, right);
    }

    public InsertionOrderSplayTree<T> split(T key) {
        Node<T> node = this.find(key);
        if (node != null) {
            this.splay(node);
            node.size -= InsertionOrderSplayTree.size(node.right);
            if (node.right != null) {
                node.right.parent = null;
            }
            if (node.left != null) {
                node.left.parent = null;
            }
            this.root = node.left;
            InsertionOrderSplayTree splitter = InsertionOrderSplayTree.create(node.right);
            splitter.validate();
            this.validate();
            return splitter;
        }
        return this;
    }

    public static <T> Pair<InsertionOrderSplayTree<T>> split(InsertionOrderSplayTree<T> tree, int position) {
        InsertionOrderSplayTree<T> right = tree.split(position);
        return Pair.of(tree, right);
    }

    public InsertionOrderSplayTree<T> split(int position) {
        Node<int> found = this.find((T)position);
        if (found != null) {
            this.splay(found);
            if (found.right != null) {
                found.right.parent = null;
                found.size -= found.right.size;
            }
            InsertionOrderSplayTree splitter = InsertionOrderSplayTree.create(found.right);
            found.right = null;
            splitter.validate();
            this.validate();
            if (this.find((T)found) == null) {
                throw new RuntimeException("Node " + found + " at position " + position + " was not still in tree");
            }
            return splitter;
        }
        return InsertionOrderSplayTree.create();
    }

    public Node<T> find(Node<T> node) {
        return this.find(this.root, (T)node);
    }

    private Node<T> find(Node<T> from, Node<T> node) {
        if (from == null) {
            return null;
        }
        if (from == node) {
            return from;
        }
        Node<Node<Object>> found = this.find(from.left, (T)node);
        if (found != null) {
            return found;
        }
        found = this.find(from.right, (T)node);
        if (found != null) {
            return found;
        }
        return null;
    }

    public Node<T> find(T key) {
        return this.find(this.root, key);
    }

    private Node<T> find(Node<T> from, T node) {
        if (from == null) {
            return null;
        }
        if (from != null && from.key.equals(node)) {
            return from;
        }
        Node found = this.find(from.left, node);
        if (found != null) {
            return found;
        }
        found = this.find(from.right, node);
        if (found != null) {
            return found;
        }
        return null;
    }

    public void erase(T key) {
        Node<T> z = this.find(key);
        if (null == z) {
            return;
        }
        this.splay(z);
        if (null == z.left) {
            this.replace(z, z.right);
        } else if (null == z.right) {
            this.replace(z, z.left);
        } else {
            Node y = this.subtree_minimum(z.right);
            if (y.parent != z) {
                this.replace(y, y.right);
                y.right = z.right;
                y.right.parent = y;
            }
            this.replace(z, y);
            y.left = z.left;
            y.left.parent = y;
        }
    }

    public int size() {
        return this.root != null ? this.root.size : 0;
    }

    public int height() {
        return InsertionOrderSplayTree.height(this.root);
    }

    public static <T> int height(Node<T> node) {
        return node != null ? 1 + Math.max(InsertionOrderSplayTree.height(node.left), InsertionOrderSplayTree.height(node.right)) : 0;
    }

    public boolean contains(Node<T> element) {
        return this.contains(this.root, (T)element);
    }

    private boolean contains(Node<T> from, Node<T> segment) {
        if (from == null) {
            return false;
        }
        if (from == segment) {
            return true;
        }
        return this.contains(from.left, (T)segment) || this.contains(from.right, (T)segment);
    }

    public boolean contains(T value) {
        return this.contains(this.root, value);
    }

    private boolean contains(Node<T> from, T value) {
        if (from == null) {
            return false;
        }
        if (from.key == value) {
            return true;
        }
        return this.contains(from.left, value) || this.contains(from.right, value);
    }

    public String printTree() {
        return this.printTree(this.root, 0);
    }

    public String printTree(Node<T> node, int d) {
        StringBuilder builder = new StringBuilder();
        if (node == null) {
            return "";
        }
        builder.append(this.printTree(node.right, d + 1));
        for (int i = 0; i < d; ++i) {
            builder.append("  ");
        }
        builder.append(node.key + "(" + node.size + ")\n");
        builder.append(this.printTree(node.left, d + 1));
        return builder.toString();
    }

    public String printTree(String note) {
        return note + "\n" + this.printTree(this.root, 0);
    }

    public void validate() {
        if (log.isTraceEnabled() && this.root != null) {
            if (this.root.parent != null) {
                throw new RuntimeException("root parent is not null");
            }
            this.root.validate();
            this.validateChild(this.root.left);
            this.validateChild(this.root.right);
        }
    }

    private void validateChild(Node<T> node) {
        if (node != null) {
            node.validate();
            if (node.parent == null) {
                throw new RuntimeException("child " + node.key + " has null parent");
            }
            if (node.size != node.count()) {
                throw new RuntimeException("size of " + node.key + " does not match count");
            }
            this.validateChild(node.left);
            this.validateChild(node.right);
        }
    }

    protected List<Node<T>> nodes() {
        ArrayList<Node<T>> list = new ArrayList<Node<T>>();
        Iterator<T> iterator = new Iterator<T>(this.root);
        while (iterator.hasNext()) {
            list.add((Node<T>)iterator.next());
        }
        return list;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Iterator<T> iterator = new Iterator<T>(this.root);
        while (iterator.hasNext()) {
            Object node = iterator.next();
            buf.append(node.toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    public static class Node<T> {
        T key;
        Node<T> parent;
        Node<T> left;
        Node<T> right;
        int size = 1;

        public Node(T key) {
            this.key = key;
        }

        public int size() {
            return this.size;
        }

        int count() {
            int leftCount = this.left != null ? this.left.count() : 0;
            int rightCount = this.right != null ? this.right.count() : 0;
            int count = 1 + leftCount + rightCount;
            return count;
        }

        public void validate() {
            if (this == this.left) {
                throw new RuntimeException("this == left");
            }
            if (this.left != null && this.left == this.right) {
                throw new RuntimeException("children match");
            }
            if (this == this.parent) {
                throw new RuntimeException("node is its own parent");
            }
        }
    }

    public static class Iterator<V>
    implements java.util.Iterator<Node<V>> {
        private Node<V> next;
        Set<Node<V>> elements = new LinkedHashSet<Node<V>>();

        public Iterator(Node<V> root) {
            this.next = root;
            if (this.next == null) {
                return;
            }
            while (this.next.left != null) {
                if (this.elements.contains(this.next.left)) {
                    throw new RuntimeException("duplicate elements");
                }
                this.elements.add(this.next.left);
                this.next = this.next.left;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Node<V> r = this.next;
            if (this.next.right != null) {
                this.next = this.next.right;
                while (this.next.left != null) {
                    this.next = this.next.left;
                }
                return r;
            }
            while (true) {
                if (this.next.parent == null) {
                    this.next = null;
                    return r;
                }
                if (this.next.parent.left == this.next) {
                    this.next = this.next.parent;
                    return r;
                }
                this.next = this.next.parent;
            }
        }
    }
}

