/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.coff.relocation;

import ghidra.app.util.bin.format.RelocationException;
import ghidra.app.util.bin.format.coff.CoffFileHeader;
import ghidra.app.util.bin.format.coff.CoffRelocation;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationContext;
import ghidra.app.util.bin.format.coff.relocation.CoffRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.RelocationResult;

public class PowerPC_CoffRelocationHandler
implements CoffRelocationHandler {
    public static final short IMAGE_REL_PPC_ABSOLUTE = 0;
    public static final short IMAGE_REL_PPC_ADDR64 = 1;
    public static final short IMAGE_REL_PPC_ADDR32 = 2;
    public static final short IMAGE_REL_PPC_ADDR24 = 3;
    public static final short IMAGE_REL_PPC_ADDR16 = 4;
    public static final short IMAGE_REL_PPC_ADDR14 = 5;
    public static final short IMAGE_REL_PPC_REL24 = 6;
    public static final short IMAGE_REL_PPC_REL14 = 7;
    public static final short IMAGE_REL_PPC_ADDR32NB = 10;
    public static final short IMAGE_REL_PPC_SECREL = 11;
    public static final short IMAGE_REL_PPC_SECTION = 12;
    public static final short IMAGE_REL_PPC_SECREL16 = 15;
    public static final short IMAGE_REL_PPC_REFHI = 16;
    public static final short IMAGE_REL_PPC_REFLO = 17;
    public static final short IMAGE_REL_PPC_PAIR = 18;
    public static final short IMAGE_REL_PPC_SECRELLO = 19;
    public static final short IMAGE_REL_PPC_GPREL = 21;
    public static final short IMAGE_REL_PPC_TOKEN = 22;

    public boolean canRelocate(CoffFileHeader fileHeader) {
        return fileHeader.getMachine() == 496;
    }

    public RelocationResult relocate(Address address, CoffRelocation relocation, CoffRelocationContext relocationContext) throws MemoryAccessException, RelocationException {
        switch (relocation.getType()) {
            case 0: 
            case 11: 
            case 12: 
            case 22: {
                return RelocationResult.SKIPPED;
            }
        }
        return RelocationResult.UNSUPPORTED;
    }
}

