/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldFunctionDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class OldFunctionDBAdapterV1
extends OldFunctionDBAdapter {
    static final String FUNCTIONS_TABLE_NAME = "Functions";
    static final int SCHEMA_VERSION = 1;
    static final int V1_RETURN_DATA_TYPE_ID_COL = 0;
    static final int V1_STACK_DEPTH_COL = 1;
    static final int V1_STACK_PARAM_OFFSET_COL = 2;
    static final int V1_STACK_RETURN_OFFSET_COL = 3;
    static final int V1_STACK_LOCAL_SIZE_COL = 4;
    static final int V1_REPEATABLE_COMMENT_COL = 5;
    static final Schema V1_FUNCTIONS_SCHEMA = new Schema(1, "Entry Point", new Field[]{LongField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE, StringField.INSTANCE}, new String[]{"Return DataType ID", "StackDepth", "StackParamOffset", "StackReturnOffset", "StackLocalSize", "RepeatableComment"});
    protected Table table;

    OldFunctionDBAdapterV1(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        super(addrMap);
        this.table = dbHandle.getTable(FUNCTIONS_TABLE_NAME);
        if (this.table == null) {
            throw new VersionException("Missing Table: Functions");
        }
        if (this.table.getSchema().getVersion() != 1) {
            int version = this.table.getSchema().getVersion();
            if (version < 1) {
                throw new VersionException(true);
            }
            throw new VersionException(2, false);
        }
    }

    @Override
    public DBRecord getFunctionRecord(long functionKey) throws IOException {
        return this.table.getRecord(functionKey);
    }

    @Override
    public RecordIterator iterateFunctionRecords() throws IOException {
        return this.table.iterator();
    }

    public DBRecord translateRecord(DBRecord oldRecord) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(FUNCTIONS_TABLE_NAME);
    }
}

