/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.widgets.textfield.HintTextField;
import gui.event.MouseBinding;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Objects;
import java.util.function.Consumer;

public class MouseEntryTextField
extends HintTextField {
    private static final String HINT = "Press a mouse button";
    private String disabledHint = "Press a mouse button";
    private MouseBinding mouseBinding;
    private Consumer<MouseBinding> listener;

    public MouseEntryTextField(int columns, Consumer<MouseBinding> listener) {
        super(HINT);
        MouseListener[] oldListeners1;
        this.setColumns(columns);
        this.setName("Mouse Entry Text Field");
        this.getAccessibleContext().setAccessibleName(this.getName());
        this.listener = Objects.requireNonNull(listener);
        for (MouseListener l : oldListeners1 = this.getMouseListeners()) {
            this.removeMouseListener(l);
        }
        this.addMouseListener(new MyMouseListener());
        this.addKeyListener(new MyKeyListener());
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setHint(enabled ? HINT : this.disabledHint);
        super.setEnabled(enabled);
    }

    public void setDisabledHint(String disabledHint) {
        this.disabledHint = Objects.requireNonNull(disabledHint);
    }

    public MouseBinding getMouseBinding() {
        return this.mouseBinding;
    }

    public void setMouseBinding(MouseBinding mb) {
        this.processMouseBinding(mb, false);
    }

    public void clearField() {
        this.processMouseBinding(null, false);
    }

    public void clearMouseBinding() {
        this.processMouseBinding(null, true);
    }

    private void processMouseBinding(MouseBinding mb, boolean notify) {
        this.mouseBinding = mb;
        if (this.mouseBinding == null) {
            this.setText("");
        } else {
            this.setText(this.mouseBinding.getDisplayText());
        }
        if (notify) {
            this.listener.accept(mb);
        }
    }

    private class MyMouseListener
    extends MouseAdapter {
        private MyMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!MouseEntryTextField.this.isEnabled()) {
                return;
            }
            MouseEntryTextField.this.requestFocusInWindow(FocusEvent.Cause.MOUSE_EVENT);
            int modifiersEx = e.getModifiersEx();
            int button = e.getButton();
            int buttonDownMask = InputEvent.getMaskForButton(button);
            if (button == 1 && buttonDownMask == modifiersEx) {
                e.consume();
                return;
            }
            MouseEntryTextField.this.processMouseBinding(new MouseBinding(button, modifiersEx), true);
            e.consume();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.consume();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            e.consume();
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private MyKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            e.consume();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (this.isClearKey(keyCode)) {
                MouseEntryTextField.this.processMouseBinding(null, true);
            }
            e.consume();
        }

        private boolean isClearKey(int keyCode) {
            return keyCode == 8 || keyCode == 10;
        }
    }
}

