/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.Draggable;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;

public class DragSrcAdapter
implements DragSourceListener {
    private static final Cursor COPY_DROP_CURSOR = DragSource.DefaultCopyDrop;
    private static final Cursor COPY_NO_DROP_CURSOR = DragSource.DefaultCopyNoDrop;
    private static final Cursor MOVE_DROP_CURSOR = DragSource.DefaultMoveDrop;
    private static final Cursor MOVE_NO_DROP_CURSOR = DragSource.DefaultMoveNoDrop;
    private static final Cursor LINK_DROP_CURSOR = DragSource.DefaultLinkDrop;
    private static final Cursor LINK_NO_DROP_CURSOR = DragSource.DefaultLinkNoDrop;
    private Cursor currentCursor;
    protected Draggable dragComponent;

    public DragSrcAdapter(Draggable dragComponent) {
        this.dragComponent = dragComponent;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent e) {
        this.dragComponent.dragFinished(!e.getDropSuccess());
    }

    @Override
    public void dragEnter(DragSourceDragEvent e) {
        this.setDragOverFeedback(e);
    }

    @Override
    public void dragOver(DragSourceDragEvent e) {
        this.setDragOverFeedback(e);
    }

    @Override
    public void dragExit(DragSourceEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        context.setCursor(null);
        this.currentCursor = COPY_NO_DROP_CURSOR;
        context.setCursor(this.currentCursor);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent e) {
        this.setDragOverFeedback(e);
    }

    protected void setDragOverFeedback(DragSourceDragEvent e) {
        DragSourceContext context = e.getDragSourceContext();
        int dropOp = e.getDropAction();
        int targetAction = e.getTargetActions();
        int action = dropOp & targetAction;
        Cursor c = null;
        c = action == 0 ? ((dropOp & 0x40000000) == 0x40000000 ? LINK_NO_DROP_CURSOR : ((dropOp & 2) == 2 ? MOVE_NO_DROP_CURSOR : COPY_NO_DROP_CURSOR)) : this.getDropOkCursor(action);
        context.setCursor(null);
        this.currentCursor = c;
        context.setCursor(c);
    }

    protected Cursor getDropOkCursor(int action) {
        if ((action & 0x40000000) == 0x40000000) {
            return LINK_DROP_CURSOR;
        }
        if ((action & 2) == 2) {
            return MOVE_DROP_CURSOR;
        }
        return COPY_DROP_CURSOR;
    }
}

