/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.protocol.BSimQuery;
import ghidra.features.bsim.query.protocol.StagingManager;
import java.util.Iterator;

public class FunctionStaging
extends StagingManager {
    private BSimQuery<?> localQuery;
    private int stagesize;
    private Iterator<FunctionDescription> curiter;
    private DescriptionManager gmanage;
    private DescriptionManager imanage;

    public FunctionStaging(int stagesize) {
        this.stagesize = stagesize;
        this.localQuery = null;
    }

    @Override
    public BSimQuery<?> getQuery() {
        return this.localQuery;
    }

    @Override
    public boolean initialize(BSimQuery<?> q) throws LSHException {
        int count;
        this.globalQuery = q;
        this.gmanage = q.getDescriptionManager();
        if (this.gmanage == null) {
            throw new LSHException("Query cannot be function staged");
        }
        this.totalsize = this.gmanage.numFunctions();
        this.queriesmade = 0;
        this.localQuery = q.getLocalStagingCopy();
        this.imanage = this.localQuery.getDescriptionManager();
        this.curiter = this.gmanage.listAllFunctions();
        this.imanage.clear();
        this.imanage.transferSettings(this.gmanage);
        for (count = 0; count < this.stagesize && this.curiter.hasNext(); ++count) {
            this.imanage.transferFunction(this.curiter.next(), true);
            ++this.queriesmade;
        }
        return count != 0;
    }

    @Override
    public boolean nextStage() throws LSHException {
        int count;
        this.imanage.clear();
        this.imanage.transferSettings(this.gmanage);
        for (count = 0; count < this.stagesize && this.curiter.hasNext(); ++count) {
            this.imanage.transferFunction(this.curiter.next(), true);
            ++this.queriesmade;
        }
        return count != 0;
    }
}

