/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.tracermi;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.rmi.trace.TraceRmi;
import ghidra.util.NumericUtilities;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public interface ValueDecoder {
    public static final ValueDecoder DEFAULT = new ValueDecoder(){};
    public static final ValueDecoder DISPLAY = new ValueDecoder(){
        final Map<String, AddressSpace> spaces = new HashMap<String, AddressSpace>();

        private AddressSpace getSpace(String space) {
            return this.spaces.computeIfAbsent(space, name -> new GenericAddressSpace(name, 64, 1, 0));
        }

        @Override
        public Address toAddress(TraceRmi.Addr addr, boolean required) {
            AddressSpace space = this.getSpace(addr.getSpace());
            return space.getAddress(addr.getOffset());
        }

        @Override
        public AddressRange toRange(TraceRmi.AddrRange range, boolean required) {
            AddressSpace space = this.getSpace(range.getSpace());
            Address min = space.getAddress(range.getOffset());
            Address max = space.getAddress(range.getOffset() + range.getExtend());
            return new AddressRangeImpl(min, max);
        }

        @Override
        public Object getObject(TraceRmi.ObjDesc desc, boolean required) {
            return "<Object id=%d path=%s>".formatted(desc.getId(), desc.getPath().getPath());
        }

        @Override
        public Object getObject(TraceRmi.ObjSpec spec, boolean required) {
            return switch (spec.getKeyCase()) {
                case TraceRmi.ObjSpec.KeyCase.KEY_NOT_SET -> "<ERROR: No key>";
                case TraceRmi.ObjSpec.KeyCase.ID -> "<Object id=%d>".formatted(spec.getId());
                case TraceRmi.ObjSpec.KeyCase.PATH -> "<Object path=%s>".formatted(spec.getPath());
                default -> "<ERROR: default>";
            };
        }

        @Override
        public Object toValue(TraceRmi.Value value) {
            Object obj = ValueDecoder.super.toValue(value);
            if (obj instanceof byte[]) {
                byte[] va = (byte[])obj;
                return NumericUtilities.convertBytesToString((byte[])va, (String)":");
            }
            return obj;
        }
    };

    default public Address toAddress(TraceRmi.Addr addr, boolean required) {
        if (required) {
            throw new IllegalStateException("Address requires a trace for context");
        }
        return null;
    }

    default public AddressRange toRange(TraceRmi.AddrRange range, boolean required) {
        if (required) {
            throw new IllegalStateException("AddressRange requires a trace for context");
        }
        return null;
    }

    default public Object getObject(TraceRmi.ObjSpec spec, boolean required) {
        if (required) {
            throw new IllegalStateException("TraceObject requires a trace for context");
        }
        return null;
    }

    default public Object getObject(TraceRmi.ObjDesc desc, boolean required) {
        if (required) {
            throw new IllegalStateException("TraceObject requires a trace for context");
        }
        return null;
    }

    default public Object toValue(TraceRmi.Value value) {
        return switch (value.getValueCase()) {
            case TraceRmi.Value.ValueCase.NULL_VALUE -> null;
            case TraceRmi.Value.ValueCase.BOOL_VALUE -> value.getBoolValue();
            case TraceRmi.Value.ValueCase.BYTE_VALUE -> (byte)value.getByteValue();
            case TraceRmi.Value.ValueCase.CHAR_VALUE -> Character.valueOf((char)value.getCharValue());
            case TraceRmi.Value.ValueCase.SHORT_VALUE -> (short)value.getShortValue();
            case TraceRmi.Value.ValueCase.INT_VALUE -> value.getIntValue();
            case TraceRmi.Value.ValueCase.LONG_VALUE -> value.getLongValue();
            case TraceRmi.Value.ValueCase.STRING_VALUE -> value.getStringValue();
            case TraceRmi.Value.ValueCase.BOOL_ARR_VALUE -> (Object[])ArrayUtils.toPrimitive((Boolean[])((Boolean[])value.getBoolArrValue().getArrList().stream().toArray(Boolean[]::new)));
            case TraceRmi.Value.ValueCase.BYTES_VALUE -> (Object[])value.getBytesValue().toByteArray();
            case TraceRmi.Value.ValueCase.CHAR_ARR_VALUE -> (Object[])value.getCharArrValue().toCharArray();
            case TraceRmi.Value.ValueCase.SHORT_ARR_VALUE -> (Object[])ArrayUtils.toPrimitive((Short[])((Short[])value.getShortArrValue().getArrList().stream().map(Integer::shortValue).toArray(Short[]::new)));
            case TraceRmi.Value.ValueCase.INT_ARR_VALUE -> (Object[])value.getIntArrValue().getArrList().stream().mapToInt(Integer::intValue).toArray();
            case TraceRmi.Value.ValueCase.LONG_ARR_VALUE -> (Object[])value.getLongArrValue().getArrList().stream().mapToLong(Long::longValue).toArray();
            case TraceRmi.Value.ValueCase.STRING_ARR_VALUE -> (String[])value.getStringArrValue().getArrList().toArray(String[]::new);
            case TraceRmi.Value.ValueCase.ADDRESS_VALUE -> this.toAddress(value.getAddressValue(), true);
            case TraceRmi.Value.ValueCase.RANGE_VALUE -> this.toRange(value.getRangeValue(), true);
            case TraceRmi.Value.ValueCase.CHILD_SPEC -> this.getObject(value.getChildSpec(), true);
            case TraceRmi.Value.ValueCase.CHILD_DESC -> this.getObject(value.getChildDesc(), true);
            default -> throw new AssertionError((Object)("Unrecognized value: " + String.valueOf(value)));
        };
    }
}

