/* Generated By:JavaCC: Do not edit this line. CParser.java */
package ghidra.app.util.cparser.C;

import ghidra.program.model.data.*;
import ghidra.program.model.data.Enum;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.*;

@SuppressWarnings("all")  // ignore warnings from generated code
public class CParser implements CParserConstants {

    private static String DEFAULT_PARSER_OUTPUT_FILENAME = "CParser.out";

    // Map for storing typedef types
    private Map<String, DataType> types = new HashMap<String, DataType>();
    private Map<String, DataType> composites = new HashMap<String, DataType>();
    private Map<String, DataType> functions = new HashMap<String, DataType>();
    private Map<String, DataType> enums = new HashMap<String, DataType>();

    private Map<String, DataType> declarations = new HashMap<String, DataType>();

    private Map<String, DataType> internalTypes = new HashMap<String, DataType>();

    private DataType lastDataType = DefaultDataType.dataType;
    private boolean storeNewDT = true;
    private String possiblyUndefinedType = null;

    DataTypeManager dtMgr = null;
    private DataTypeManager[] subDTMgrs = new DataTypeManager[0];

    private int cnt = 1;
    private int func_cnt = 1;

    private String headerFileName= null;     // Current header file from #line token
    private int headerFileLine = 1;          // Current line number from #line token
    private int headerFileLineOffset= 0;     // offset into parse stream of last #line token
    private String currentCategoryName = ""; // Current category, ROOT category

    private final static String ANONYMOUS_STRUCT_PREFIX = "_struct_";
    private final static String ANONYMOUS_UNION_PREFIX = "_union_";
    private final static String ANONYMOUS_FUNC_PREFIX = "_func_";

    // Stack for determining when the parser is parsing a typdef definition.
    private Stack<Boolean> typedefParsingStack = new Stack<Boolean>();

    // Stack for putting defined data types on
    private Stack<DataType> dataTypeStack = new Stack<DataType>();

    private StringBuilder parseMessages = new StringBuilder();

    // true if parse was successful
    private boolean parseSuccess = false;

    private TaskMonitor monitor = null;

    // packing size for structures
    private int packSize = 0;
    Stack<Integer> packStack = new Stack<Integer>();
    Stack<String> packStackID = new Stack<String>();

    String parseFileName = DEFAULT_PARSER_OUTPUT_FILENAME;

    public void setParseFileName(String fName) {
        parseFileName = fName;
    }

    private CategoryPath getCurrentCategoryPath() {
        return getCategory(currentCategoryName);
    }

    private CategoryPath getCurrentCategoryPath(String subCatName) {
        return getCategory(currentCategoryName).extend(subCatName);
    }

    private CategoryPath getCategory(String catName) {
        CategoryPath rootCat = CategoryPath.ROOT;
        if (catName == null || catName.length() == 0) {
            return rootCat;
        }

        CategoryPath cat= new CategoryPath(rootCat, catName);
        return cat;
    }

    private String getFileName(String path) {
        int slashpos = path.lastIndexOf('/');
        if (slashpos < 0) {
            slashpos = path.lastIndexOf('\u005c\u005c');
        }
        if (slashpos < 0) {
            return path;
        }
        return path.substring(slashpos + 1);
    }

    // Returns true if the given string is a typedef type.
    private boolean isType(String type) {
        // System.out.println("** isType " + type + " = " + (types.get(type)!=null));
        return getType(type) != null;
        // Object obj= types.get(type);
        // return obj instanceof DataType;
    }

    // Add a typedef type to those already defined
    private DataType addTypedef(String type, DataType dt) {

        if (type == null || dt == null) {
            addNearParseMessage("Problem with type " + type + " : " + dt);
            return dt;
        }

        if (type.equals(dt.getName())) {
            // these already get a typedef elsewhere
            if (dt instanceof Composite) {
                return addDef(composites,type,dt);
            }
            if (dt instanceof Enum) {
                return addDef(enums,type,dt);
            }
        }

        // if typedef-ing an anonymous structure, rename structure/union
        if (dt instanceof Composite) {
            if (dt.getName().startsWith(ANONYMOUS_STRUCT_PREFIX) ||
                dt.getName().startsWith(ANONYMOUS_UNION_PREFIX))  {
                try {
                    composites.remove(dt.getName());
                    dt.setName(type);
                    dt = addDef(composites, type, dt);
                    return dt;
                } catch (InvalidNameException e) {
                    // handled below
                } catch (DuplicateNameException e) {
                    // handled below
                }
            }
        }

        // TODO: for builtin-Types, override with the built-in
        //       wchar_t, etc...
        if (type.equals("wchar_t")) {
                dt = WideCharDataType.dataType;
        } else {
                dt = new TypedefDataType(getCurrentCategoryPath(), type, dt, dtMgr);
        }
        dt = addDef(types, type, dt);

        return dt;
    }

    private DataType getType(String type) {
        Object obj;
        obj = composites.get(type);
        if (obj instanceof DataType) {
            return (DataType) obj;
        }
        obj = types.get(type);
        if (obj instanceof DataType) {
            return (DataType) obj;
        }
        obj = enums.get(type);
        if (obj instanceof DataType) {
            return (DataType) obj;
        }

        // only return a function as a type IF we are defining a typedef
        boolean functionsOK = typedefParsingStack.size() > 0;

        if (functionsOK) {
            obj = functions.get(type);
            if (obj instanceof DataType) {
                return (DataType) obj;
            }
        }

        DataType dt = findDataType(type);
        if (dt != null && (functionsOK || !(dt instanceof FunctionDefinition))) {
            return dt;
        }

        // check the BuiltinTypeManager
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        DataType bdt = findDataType(builtInMgr, type);
        if (bdt != null) {
            return bdt;
        }

        possiblyUndefinedType = type;
        return null;
    }

    private DataType findDataType(String dataTypeString) {

        DataType dt = findDataType(dtMgr, dataTypeString);
        if (dt != null) {
            return dt;
        }

        for (int i = 0; i < subDTMgrs.length; i++) {
            DataTypeManager dtm = subDTMgrs[i];
            dt = findDataType(dtm, dataTypeString);
            if (dt != null) {
                return dt;
            }
        }

        return null;
    }

    private DataType findDataType(DataTypeManager dtm, String dataTypeString) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        dtm.findDataTypes(dataTypeString, list);
        if (list.size() > 0) {
            return list.get(0);
        }

        return null;
    }

    private List<DataType> findAllDataTypes(String dataTypeString) {
        List<DataType> list = new ArrayList<DataType>();
        dtMgr.findDataTypes(dataTypeString, list);

        return list;
    }

    // Add a typedef type to those already defined
    private DataType addDef(Map<String, DataType> table, String name, DataType dt) {
        // System.out.println("** addDef " + name + " = " + (dt != null ? dt.getName() : " - no type -") );

                lastDataType = dt;

        DataType existingDT = table.get(name);
        if (existingDT != null && dt.isEquivalent(existingDT)) {
            return existingDT;
        }

        // If the exact data type exists in any open DTMgr, use the open DTmgr type
        // instead
        dt = findEquivalentInOpenDTMgrs(name, dt);

        if (storeNewDT) {
            try {
                dt = dtMgr.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
            } catch (Exception e) {
                addNearParseMessage("Problem adding DataType " + dt.getDisplayName() + "\u005cn" + "    " + e.getMessage());
            }
        } else {
            dt = dt.clone(dtMgr);
        }

        table.put(name, dt);

        lastDataType = dt;

        return dt;
    }

    /**
     * Try to find this named data type in any open data type managers.
     * 
     * @param name name of datatype
     * @param dt datatype to find
     * @return Original dt if none found, dt in other archive if found and equivalent
     */
    private DataType findEquivalentInOpenDTMgrs(String name, DataType dt) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        boolean foundDT = false;
        for (int i = 0; !foundDT && i < subDTMgrs.length; i++) {
            // look for the data type by name
            //    equivalent, return it
            // look for the data type by category
            //    equivalent, return it
            subDTMgrs[i].findDataTypes(name, list);

            Iterator<DataType> iter = list.iterator();
            while (iter.hasNext()) {
                DataType dataType = iter.next();
                if (dataType.isEquivalent(dt)) {
                    return dataType;
                }
            }
        }
        return dt;
    }

    // resolve data types using data type manager so that data organization is considered
    //
    private DataType resolveInternal(DataType datatype) {
        DataType existingDT = internalTypes.get(datatype.getName());
        if (existingDT != null) {
            return existingDT;
        }
        existingDT = datatype.clone(dtMgr);

        internalTypes.put(datatype.getName(), existingDT);

        return existingDT;
    }


    /**
     * Define a forward declared composite
     * 
     * @param name name of composite
     * @param comp composite most likely empty
     * @return composite with a name, possibly already declared
     */
    private Composite defineForwardDeclaredComposite(Token symName, Composite comp) {
        DataType dt = findAnyComposite(symName.image);
        if (dt instanceof Composite) {
            comp = (Composite) dt;
        }
        if (dt == null) {
            String nameStr = symName.image;
            try {
                comp.setName(nameStr);
            } catch (InvalidNameException e) {
                // This should not happen
                e.printStackTrace();
            } catch (DuplicateNameException e) {
                // This should not happen
                e.printStackTrace();
            }
            comp = (Composite) addDef(composites, nameStr, comp);
        }
        return comp;
    }

    /**
     * Define a named composite
     * 
     * @param name name of the composite
     * @param parentName possible parent name
     * @param comp the composite components
     * @return a new composite with the correct name and components
     */
    private Composite defineNamedComposite(Token name, Token parentName, Composite comp) {

            String nameStr = name.image;

            DataType dt = findAnyComposite(nameStr);

            // if existing composite is found
            boolean hasNoComponents = false;
            boolean hasSameSourceArchive = true;
            if (dt != null) {
                    Composite dtComp = (Composite) dt;

                    hasNoComponents = (dtComp.getNumDefinedComponents() == 0 ? true : false);

                    hasSameSourceArchive = Objects.equals(dt.getSourceArchive(), dtMgr.getLocalSourceArchive());
            }

            // make sure comp is a Composite, if existing dt is empty, in same category and archive
            if (comp instanceof Composite && hasNoComponents && hasSameSourceArchive) {
                    // existing composite was an empty placeholder
                    // replace the internals of the exisint datatype with the composite components
                    Composite dtcomp = (Composite) dt;
                    dtcomp.replaceWith(comp);
                    comp = dtcomp;
            } else {

                    // check if a parent name was specified, and if so insert it
                    // only single parent supported currently
                    if (parentName != null) {
                            DataType superDt = findAnyComposite(parentName.image);
                            if (superDt == null) {
                                    addNearParseMessage("Parent structure " + parentName.image + " for " + nameStr + " undefined ");
                            } else {
                                    // surgically add parent to top of structure
                                    comp.insert(0, superDt);
                            }
                    }
                    try {
                        comp.setName(nameStr);
                    } catch (InvalidNameException e) {
                        // This should not happen
                        e.printStackTrace();
                    } catch (DuplicateNameException e) {
                        // This should not happen
                        e.printStackTrace();
                    }
                    comp = (Composite) addDef(composites, nameStr, comp);
            }

            return comp;
    }


    private DataType findAnyComposite(String name) {
        DataType dt = getDef(composites, name);
        if (dt != null) {
            return dt;
        }

        if (!storeNewDT) {

            List<DataType> list = findAllDataTypes(name);
            for (int i = 0; i < list.size(); i++) {
                dt = list.get(i);
                if (dt instanceof Composite) {
                    return dt;
                }
            }
        }

        return null;
    }

    private DataType getEnumDef(String name) {
        DataType dt = getDef(enums, name);
        if (dt != null) {
            return dt;
        }

        if (!storeNewDT) {
            List<DataType> list = findAllDataTypes(name);
            for (int i = 0; i < list.size(); i++) {
                dt = list.get(i);
                if (dt instanceof Enum) {
                    return dt;
                }
            }
        }

        return null;
    }


    private DataType allocateEnumDT(Token t, ArrayList<EnumMember> list) {
        String enumName = (t != null ? t.image : ("enum_" + cnt++));

        // get the normal enum size, which is an int
        // TODO: allow for packing of enum to smallest value with either dataOrganization, or packing flag
        int normalEnumLen = (dtMgr != null ? dtMgr.getDataOrganization().getIntegerSize() : 4);

        // create an initial enum and add all new members
        EnumDataType enumDT= new EnumDataType(getCurrentCategoryPath(), enumName, 8, dtMgr);
        if (list != null) {
            for (EnumMember member : list) {
                try {
                        enumDT.add(member.name, member.value);
                } catch (IllegalArgumentException exc) {
                    addNearParseMessage("duplicate enum value: " + enumName + " : " + member.name + " : " + member.value);
                }
            }
            // get the minimum length to represent the values and resize if too big
            int minLen = enumDT.getMinimumPossibleLength();
            if (minLen > normalEnumLen) {
                enumDT.setLength(minLen);
            } else {
                enumDT.setLength(normalEnumLen);
            }
        } else {
            // length doesn't really matter, forward declaration with no values
            enumDT.setLength(normalEnumLen);
        }

        return addDef(enums, enumDT.getName(), enumDT);
    }

    private DataType getDef(Map<String, DataType> table, String name) {
        return table.get(name);
    }

    // Prints out all the types used in parsing the c source
    @SuppressWarnings("unused")
    private void printTypes() {
        System.out.println("**************   TYPES   ********************");
        printTable(types);
        System.out.println("**************   FUNCTIONS  *****************");
        printTable(functions);
        System.out.println("**************   DECLS      *****************");
        printTable(declarations);
        System.out.println("**************   ENUMS      *****************");
        printTable(enums);
        System.out.println("**************   STRUCTS    *****************");
        printTable(composites);
    }

    private void addNearParseMessage(String message) {
        parseMessages.append(message + "\u005cn");
        parseMessages.append("   In file " + this.headerFileName + "\u005cn");
        parseMessages.append(
            "  Near datatype: " + (lastDataType == null ? "- none -" : lastDataType.getName()) + "\u005cn");

        int endLine = token_source.input_stream.line;
        long subLinenum = ((endLine - headerFileLineOffset) + headerFileLine);

        if (headerFileName != null) {
           parseMessages.append("         in " + headerFileName + " near line " + subLinenum + "\u005cn");
        }
    }

    public String getParseMessages() {
        return parseMessages.toString();
    }

    public boolean didParseSucceed() {
      return parseSuccess;
    }

    public void setMonitor(TaskMonitor monitor) {
      this.monitor = monitor;
    }

    private FunctionDefinitionDataType newAnonymousFunction(FunctionDefinitionDataType currentFuncDT) {
      if (currentFuncDT != null) {
         return currentFuncDT;
      }
      return new FunctionDefinitionDataType(getCurrentCategoryPath("functions"), ANONYMOUS_FUNC_PREFIX+func_cnt++, dtMgr);
    }

    private void checkReturnDataType(DataType retDT) throws ParseException {
        if (retDT == null) {
            return; // treat as void type
        }
        DataType dt = retDT;
        int len = dt.getLength();
        if (len == 0 && dt instanceof TypeDef) {
            dt = ((TypeDef) dt).getBaseDataType();
        }
        if (len <= 0 && !dt.isEquivalent(DataType.VOID)) {
            throw new ParseException("'"+retDT.getName()+"'" + " is not fixed length.  Function return must be fixed length data type or void.");
        }
    }

  /**
   * Add a definition to the correct category for funcDT, and replace any use of funcDT in Declaration
   * 
   * @param dec Declaration data type change to replace any use of funcDT with new addDef
   * @param funcDT function to put in the correct category
   */
    private void defineAndReplaceFunction(Declaration dec, FunctionDefinitionDataType funcDT) {
        DataType newDT = addDef(functions, dec.getName(), funcDT);
        DataType newDecDT = newDT;
        DataType repDT = dec.getDataType();
        DataType origDT = repDT;
        // shove the data type into any pointer definition.
        while (repDT != null) {
                if (repDT instanceof Pointer) {
                        PointerDataType ptDT = (PointerDataType) repDT;
                        if (ptDT.getDataType() instanceof FunctionDefinition) {
                                ptDT.dataTypeReplaced(ptDT.getDataType(), newDT);
                                newDecDT = origDT;
                                break;
                        }
                        repDT = ptDT.getDataType();
                } else if (repDT instanceof Array) {
                        ArrayDataType arrDT = (ArrayDataType) repDT;
                        if (arrDT.getDataType() instanceof FunctionDefinition) {
                                arrDT.dataTypeReplaced(arrDT.getDataType(), newDT);
                                newDecDT = origDT;
                                break;
                        }
                        repDT = arrDT.getDataType();
                } else {
                        break;
                }
        }
        dec.setDataType(newDecDT);
    }

  /**
   * Apply any accumulated function Qualifiers to functionDT from Declaration
   * @param dec Declaration
   * @param funcDT function data type to qualify
   */
    private void applyFunctionQualifiers(Declaration dec, FunctionDefinition funcDT) {
                List<Integer> qualifierList = dec.getQualifiers();
                if (qualifierList.contains(NORETURN)) {
                        funcDT.setNoReturn(true);
                }

                String convention = null;
                for (Integer qualifier : qualifierList) {
                        switch (qualifier) {
                                case CDECL:
                                        convention = CompilerSpec.CALLING_CONVENTION_cdecl;
                                        break;
                                case STDCALL:
                                        convention = CompilerSpec.CALLING_CONVENTION_stdcall;
                                        break;
                                case FASTCALL:
                                        convention = CompilerSpec.CALLING_CONVENTION_fastcall;
                                        break;
                                case VECTORCALL:
                                        convention = CompilerSpec.CALLING_CONVENTION_vectorcall;
                                        break;
                                case RUSTCALL:
                                        convention = CompilerSpec.CALLING_CONVENTION_rustcall;
                                        break;
                                case PASCALCALL:
                                        convention = CompilerSpec.CALLING_CONVENTION_pascal;
                                        break;
                        }
                }
                if (convention != null) {
                        try {
                                funcDT.setCallingConvention(convention);
                        }
                        catch (InvalidInputException e) {
                                // should not happen
                        }
                }
    }

    private Integer getConstantValue (Object obj, int defaultValue) {
        int value = defaultValue;

        if (obj == null) {
            return defaultValue;
        }

        if (obj instanceof Integer) {
            value = ((Integer)obj).intValue();
        }
        else if (obj instanceof Long) {
            value = (int) ((Long) obj).longValue();
        }
        else if (obj instanceof Character) {
            value = ((Character) obj).charValue();
        }
        return value;
    }

        private void pushPack(Token iD, int packingSize) {
        packStack.push(packingSize);
        String name = "";
        if (iD != null) {
            name = iD.image;
        }
        packStackID.push(name);
    }

    private int popPack(Token iD) {
        if (packStack.size() == 0) {
            return packSize;
        }
        String name = "";
        if (iD != null) {
            name = iD.image;
        }

        // keep poping looking for ID, stop when find it
        int popVal = packSize;
        do {
            String ID = packStackID.pop();
            popVal = packStack.pop();
            if (name.equals(ID)) {
                break;
            }
        } while (packStack.size() > 0);
        return popVal;
    }

    private void printTable(Map<String, DataType> table) {

        for (String name : table.keySet()) {
            DataType dt = table.get(name);
            String dataTypeName = "- unknown -";
            String mnemonic = "";
            if (dt != null) {
                dataTypeName = dt.getName();
                mnemonic = dt.getMnemonic(null);
            }
            System.out.println(name + " = " + dataTypeName + " : " + mnemonic);
        }
    }

    Object computeBinaryValue(Object obj1, Token operation, Object obj2) {
        if (!(obj1 instanceof Long && obj2 instanceof Long)) {
            return null;
        }
        Long val1 = (Long) obj1;
        Long val2 = (Long) obj2;

        switch(operation.image) {
          case "<<":
          return val1 << val2;
          case ">>":
          return val1 >> val2;
          case "+":
          return val1 + val2;
          case "-":
          return val1 - val2;
          case "*":
          return val1 * val2;
          case "/":
          return val1 / val2;
          case "%":
          return val1 % val2;
          case "|":
          return val1 | val2;
          case "&":
          return val1 & val2;
          case "^":
          return val1 ^ val2;
          case "==":
          return (val1 == val2 ? 1 : 0);
          case "!=":
          return (val1 != val2 ? 1 : 0);
          case "<":
          return (val1 < val2 ? 1 : 0);
          case ">":
          return (val1 > val2 ? 1 : 0);
          case "<=":
          return (val1 <= val2 ? 1 : 0);
          case ">=":
          return (val1 >= val2 ? 1 : 0);
          case "&&":
          return ((val1 != 0 && val2 != 0) ? 1 : 0);
          case "||":
          return ((val1 != 0 || val2 != 0) ? 1 : 0);
        }
        return null;
    }

    Object computeUnaryValue(Object obj, Token operation) {
        if (!(obj instanceof Long)) {
            return null;
        }
        Long val = (Long) obj;

        switch(operation.image) {
          case "+":
          return val;
          case "-":
          return -val;
          case "~":
          return ~val;
          case "!":
          return (val != 0 ? 0 : 1);
        }
        return null;
    }

    Object computeTernaryValue(Object objTest, Object objTrue, Object objFalse) {
        if (!(objTest instanceof Long)) {
            return null;
        }

        Long testValue = (Long) objTest;
        return (testValue != 0 ? objTrue : objFalse);
    }


    /**
     * Get the data type manager
     * 
     * @return
     */
    public DataTypeManager getDataTypeManager() {
        return dtMgr;
    }

    /**
     * @return the last data type parsed
     */
    public DataType getLastDataType() {
        return lastDataType;
    }

    /**
     * Get Global variable declarations
     * 
     * @return
     */
    public Map<String, DataType> getDeclarations() {
        return declarations;
    }

    /**
     * Get Defined Enumerations
     * 
     * @return Defined enumeration names
     */
    public Map<String, DataType> getEnums() {
        return enums;
    }

    /**
     * Get Function signatures
     * 
     * @return Function signatures
     */
    public Map<String, DataType> getFunctions() {
        return functions;
    }

    /**
     * Get composite definitions
     * 
     * @return Composite (structure/union) definitions
     */
    public Map<String, DataType> getComposites() {
        return composites;
    }

    /**
     * Get Type definitions
     * 
     * @return Type definitions
     */
    public Map<String, DataType> getTypes() {
        return types;
    }

    public DataType parse(String str) throws ParseException {
        InputStream is = new ByteArrayInputStream(str.getBytes());

        parse(is);
        if (lastDataType != null && dtMgr != null) {
            // ensure that data-type sizing is relative to dtMgr's data organization 
            return lastDataType.clone(dtMgr);
        }
        return lastDataType;
    }

    public void parse(InputStream fis) throws ParseException {
        ReInit(fis);
        int transactionID = -1;
        String parseMessage;

        parseSuccess = false;
        try {
            transactionID = dtMgr.startTransaction("Parsing");
            TranslationUnit();
            parseSuccess = true;
        } catch (ParseException e) {
            if (headerFileName == null) {
                throw e;
            }

            long endLine = (e.currentToken != null ? e.currentToken.endLine : 0);
            long subLinenum = ((endLine - headerFileLineOffset) + headerFileLine);

            parseMessage = "C Parser:  Encountered errors during parse.\u005cn";
            if (headerFileName != null) {
                parseMessage += "         in " + headerFileName + " near line " + subLinenum + "\u005cn";
            }
            parseMessage += "Error: " + e.getMessage() + "\u005cn";
            parseMessage += "         near token: " + e.currentToken + "\u005cn";
            parseMessage += "Possibly Undefined : " + possiblyUndefinedType + "\u005cn";
            parseMessage += "         Last Valid Datatype: "
                    + (lastDataType == null ? "- none -" : lastDataType.getDisplayName()) + "\u005cn";
            parseMessage += "         Check around " + parseFileName + " around line: "
                                    + this.jj_input_stream.getBeginLine() + "\u005cn";
            ParseException parseException = new ParseException(parseMessage);
            parseException.currentToken = e.currentToken;
            throw parseException;
        } catch (Error e) {
            if (headerFileName == null) {
                throw e;
            }

            parseMessage = "C Parser:  Problem Parsing.\u005cn";
            if (headerFileName != null) {
                parseMessage += "          in " + headerFileName + " near line " + headerFileLine + "\u005cn";
            }
            parseMessage += "         Last Valid Datatype: "
                    + (lastDataType == null ? "- none -" : lastDataType.getDisplayName()) + "\u005cn";
                            parseMessage += "         Check around " + parseFileName + " around line: "
                                    + this.jj_input_stream.getBeginLine() + "\u005cn";
            Msg.warn(this, e, e);
            ParseException parseException = new ParseException(parseMessage);
            if (token != null) {
                parseException.currentToken = token;
            }
            throw parseException;
        } catch (Exception e) {
            parseMessage = "C Parser:  Problem Parsing.\u005cn";
            if (headerFileName != null) {
                parseMessage += "          in " + headerFileName + " near line " + headerFileLine + "\u005cn";
            }
            parseMessage += "         Last Valid Datatype: "
                    + (lastDataType == null ? "- none -" : lastDataType.getDisplayName()) + "\u005cn";
            parseMessage += "         Check around " + parseFileName + " around line: "
                                    + this.jj_input_stream.getBeginLine() + "\u005cn";
            Msg.warn(this, e, e);
            throw new ParseException(parseMessage);
        } finally {
            dtMgr.endTransaction(transactionID, true);
        }
    }

    public CParser() {
        this(System.in);
        dtMgr= new StandAloneDataTypeManager("parsed");
    }

    public CParser(DataTypeManager dtmgr) {
        this(dtmgr, false, null);
    }

    public CParser(DataTypeManager dtmgr, boolean storeDataType, DataTypeManager subDTMgrs[]) {
        this(System.in);
        this.dtMgr = dtmgr;
        if (subDTMgrs == null) {
            subDTMgrs = new DataTypeManager[0];
        }
        this.subDTMgrs = subDTMgrs;
        this.storeNewDT = storeDataType;
    }

        // Run the parser
    public static void main(String args[]) {
            CParser parser = new CParser();

        try {
            if (args.length == 0) {
                System.out.println("C Parser:  Reading from standard input . . .");
                parser.parse(System.in);
            } else if (args.length == 1) {
                System.out.println("C Parser:  Reading from file " + args[0] + " . . .");
                try {
                        parser.parse(new java.io.FileInputStream(args[0]));
                } catch (java.io.FileNotFoundException e) {
                        System.out.println("C Parser:  File " + args[0] + " not found.");
                        return;
                }
            } else {
                System.out.println("C Parser:  Usage is one of:");
                System.out.println("         java CParser < inputfile");
                System.out.println("OR");
                System.out.println("         java CParser inputfile");
                return;
            }

            System.out.println("C Parser:  Java program parsed successfully.");
        } catch (ParseException e) {
            System.out.println("C Parser:  Encountered errors during parse.");
        }
    }

    private static class EnumMember {
        final String name;
        final long value;
        EnumMember(String name, long value) {
            this.name = name;
            this.value = value;
        }
    }

//jjt SimpleNode TranslationUnit() #TranslationUnit : {}
  final public void TranslationUnit() throws ParseException {
    label_1:
    while (true) {
      ExternalDeclaration();
      if (jj_2_1(1)) {
        ;
      } else {
        break label_1;
      }
    }
    jj_consume_token(0);

  }

  final public void ExternalDeclaration() throws ParseException {
    if (jj_2_3(2147483647)) {
      FunctionDefinition();
      jj_consume_token(146);
      if (jj_2_2(1)) {
        StatementList();
      } else {
        ;
      }
      jj_consume_token(147);
    } else if (jj_2_4(1)) {
      Declaration();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRAGMA:
      case PRAGMA_FUNC:
        PragmaSpec();
        break;
      case STATICASSERT:
        StaticAssert();
        break;
      case LINE:
      case LINEALT:
        LineDef();
        break;
      case 148:
        jj_consume_token(148);
        break;
      default:
        jj_la1[0] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        if (monitor != null && monitor.isCancelled()) {
           {if (true) throw new ParseException("Parsing Canceled");}
        }
        typedefParsingStack.clear();
  }

  final public void LineDef() throws ParseException {
    Token lineTok, fileTok;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LINE:
      jj_consume_token(LINE);
      break;
    case LINEALT:
      jj_consume_token(LINEALT);
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    lineTok = jj_consume_token(LINENUMBER_LITERAL);
    fileTok = jj_consume_token(PATH_LITERAL);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      label_2:
      while (true) {
        jj_consume_token(INTEGER_LITERAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
          ;
          break;
        default:
          jj_la1[2] = jj_gen;
          break label_2;
        }
      }
      break;
    default:
      jj_la1[3] = jj_gen;
      ;
    }
        headerFileName= fileTok.image.substring(1, fileTok.image.length() - 1);
        headerFileLine= Integer.parseInt(lineTok.image);
        headerFileLineOffset= lineTok.beginLine;
        currentCategoryName = getFileName(headerFileName);
  }

  final public DataType ObjcDef() throws ParseException {
    Token nameTok;
    nameTok = jj_consume_token(OBJC_IDENTIFIER);
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OBJC_IGNORE:
      case OBJC_IDENTIFIER:
      case OBJC2_IGNORE:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OBJC_IDENTIFIER:
        jj_consume_token(OBJC_IDENTIFIER);
        break;
      case OBJC_IGNORE:
        jj_consume_token(OBJC_IGNORE);
        break;
      case OBJC2_IGNORE:
        jj_consume_token(OBJC2_IGNORE);
        break;
      default:
        jj_la1[5] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OBJC_SEMI:
      jj_consume_token(OBJC_SEMI);
      break;
    case OBJC2_END:
      jj_consume_token(OBJC2_END);
      break;
    default:
      jj_la1[6] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return addTypedef(nameTok.image, resolveInternal(VoidDataType.dataType));}
    throw new Error("Missing return statement in function");
  }

  final public void FunctionDefinition() throws ParseException {
    Declaration retDT = new Declaration();
    Declaration dec = null;
    if (jj_2_5(2147483647)) {
      retDT = DeclarationSpecifiers(retDT);
    } else {
      ;
    }
     typedefParsingStack.push(Boolean.FALSE);
    dec = Declarator(retDT, null);
    if (jj_2_6(1)) {
      DeclarationList();
    } else {
      ;
    }
                                                        typedefParsingStack.pop();
        if (dec.getDataType() instanceof FunctionDefinition) {
            addDef(functions, dec.getName(), dec.getDataType());
        }
  }

  final public Declaration Declaration() throws ParseException {
    Declaration dec = new Declaration();
    DataType dt = null;
    if (jj_2_7(1)) {
      dec = DeclarationSpecifiers(dec);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLATILE:
      case STATIC:
      case CONST:
      case DECLSPEC:
      case PRAGMA:
      case PRAGMA_FUNC:
      case READABLETO:
      case CDECL:
      case STDCALL:
      case FASTCALL:
      case VECTORCALL:
      case RUSTCALL:
      case PASCALCALL:
      case NORETURN:
      case ALIGNAS:
      case UNALIGNED:
      case PACKED:
      case ATTRIBUTE:
      case EXTENSION:
      case RESTRICT:
      case ASM:
      case INLINE:
      case PTR64:
      case PTR32:
      case W64:
      case NEAR:
      case FAR:
      case IDENTIFIER:
      case 149:
      case 151:
      case 157:
      case 158:
        InitDeclaratorList(dec);
        break;
      default:
        jj_la1[7] = jj_gen;
        ;
      }
      jj_consume_token(148);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PROTOCOL:
      case INTERFACE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PROTOCOL:
          jj_consume_token(PROTOCOL);
          break;
        case INTERFACE:
          jj_consume_token(INTERFACE);
          break;
        default:
          jj_la1[8] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        dt = ObjcDef();
            dec.setDataType(dt);
        break;
      default:
        jj_la1[9] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public void DeclarationList() throws ParseException {
    label_4:
    while (true) {
      Declaration();
      if (jj_2_8(2147483647)) {
        ;
      } else {
        break label_4;
      }
    }
  }

  final public Declaration DeclarationSpecifiers(Declaration specDT) throws ParseException {
    Declaration typeDT= null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case REGISTER:
    case TYPEDEF:
    case EXTERN:
    case STATIC:
    case THREADLOCAL:
    case CONST:
    case AUTO:
      specDT = StorageClassSpecifier(specDT);
      if (jj_2_9(1)) {
        //            LOOKAHEAD(DeclarationSpecifiers(specDT))
                    specDT = DeclarationSpecifiers(specDT);
      } else {
        ;
      }
      break;
    case UNSIGNED:
    case DOUBLE:
    case SIGNED:
    case FLOAT:
    case SHORT:
    case LONG:
    case INT8:
    case INT16:
    case INT32:
    case INT64:
    case BOOL:
    case VOID:
    case CHAR:
    case INT:
      specDT = BuiltInDeclarationSpecifier(specDT);
      if (jj_2_10(2147483647)) {
        specDT = TypeQualifierList(specDT);
      } else {
        ;
      }
      break;
    default:
      jj_la1[10] = jj_gen;
      if (jj_2_13(1)) {
        specDT = TypeSpecifier(specDT);
        if (jj_2_11(2147483647) && (specDT.getDataType() == null)) {
          //            LOOKAHEAD(DeclarationSpecifiers()
          //                     , { (typeDT == null ||
          //                         (!typeDT.getName().equals(getToken(1).image) && !isType(getToken(1).image))) }
           //                     )
                      specDT = DeclarationSpecifiers(specDT);
        } else {
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VOLATILE:
        case STATIC:
        case CONST:
        case DECLSPEC:
        case READABLETO:
        case CDECL:
        case STDCALL:
        case FASTCALL:
        case VECTORCALL:
        case RUSTCALL:
        case PASCALCALL:
        case NORETURN:
        case ALIGNAS:
        case UNALIGNED:
        case PACKED:
        case ATTRIBUTE:
        case EXTENSION:
        case RESTRICT:
        case ASM:
        case INLINE:
        case PTR64:
        case PTR32:
        case W64:
        case NEAR:
        case FAR:
        case 151:
          specDT = TypeQualifier(specDT);
          if (jj_2_12(2147483647)) {
            specDT = DeclarationSpecifiers(specDT);
          } else {
            ;
          }
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    if (jj_2_14(2147483647)) {
      specDT = TypeQualifier(specDT);
    } else {
      ;
    }
        if (specDT == null) {
            specDT = new Declaration(typeDT);
        }
        {if (true) return specDT;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration StorageClassSpecifier(Declaration specDT) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO:
      jj_consume_token(AUTO);
      break;
    case REGISTER:
      jj_consume_token(REGISTER);
      break;
    case STATIC:
      jj_consume_token(STATIC);
      break;
    case CONST:
      jj_consume_token(CONST);
      break;
    case THREADLOCAL:
      jj_consume_token(THREADLOCAL);
      break;
    case EXTERN:
      jj_consume_token(EXTERN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        MultiLineString();
        break;
      default:
        jj_la1[12] = jj_gen;
        ;
      }
      break;
    case TYPEDEF:
      jj_consume_token(TYPEDEF);
            //            System.out.println("TYPEDEF! " + typedefParsingStack.size());
            typedefParsingStack.push(Boolean.TRUE);
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return specDT;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration BuiltInTypeSpecifier(Declaration dec) throws ParseException {
    DataType dt;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
                                 dec.setDataType(resolveInternal(VoidDataType.dataType));
      break;
    case CHAR:
      jj_consume_token(CHAR);
                                   dt = dec.getDataType();
                                if (dt != null) {
                                    if (dt == resolveInternal(UnsignedIntegerDataType.dataType)) {
                                         dt = resolveInternal(UnsignedCharDataType.dataType);
                                    } else if (dt == resolveInternal(IntegerDataType.dataType)) {
                                         dt = resolveInternal(CharDataType.dataType);
                                    } else {
                                         {if (true) throw new ParseException("Bad datatype " + dt + " char");}
                                    }
                                }
                                else {
                                    dt = resolveInternal(CharDataType.dataType);
                                }
                                dec.setDataType(dt);
      break;
    case SHORT:
      jj_consume_token(SHORT);
                              dt = dec.getDataType();
                           if (dt == null) {
                               dt = resolveInternal(ShortDataType.dataType);
                           } else if (dt == resolveInternal(UnsignedIntegerDataType.dataType)) {
                               dt = resolveInternal(UnsignedShortDataType.dataType);
                           } else if (dt == resolveInternal(IntegerDataType.dataType)) {
                               dt = resolveInternal(ShortDataType.dataType);
                           } else {
                              {if (true) throw new ParseException("Bad datatype " + dt + " short");}
                           }
                           dec.setDataType(dt);
      if (jj_2_15(2147483647)) {
        dec = BuiltInDeclarationSpecifier(dec);
      } else {
        ;
      }
      break;
    case INT:
      jj_consume_token(INT);
                                dt = dec.getDataType();
                               if (dt == null ) {
                                 dec.setDataType(resolveInternal(IntegerDataType.dataType));
                               }
      break;
    case LONG:
      jj_consume_token(LONG);
                                 dt = dec.getDataType();
                              if ( dt == null) {
                                  dt = resolveInternal(LongDataType.dataType);
                              } else if ( dt == resolveInternal(UnsignedIntegerDataType.dataType)) {
                                  dt = resolveInternal(UnsignedLongDataType.dataType);
                              } else if (dt == resolveInternal(IntegerDataType.dataType)) {
                                 dt = resolveInternal(LongDataType.dataType);
                              } else if (dt == resolveInternal(LongDataType.dataType)) {
                                 dt = resolveInternal(LongLongDataType.dataType);
                              } else if (dt == resolveInternal(UnsignedLongDataType.dataType)) {
                                 dt = resolveInternal(UnsignedLongLongDataType.dataType);
                              } else {
                                 {if (true) throw new ParseException("Bad datatype " + dt + " long");}
                              }
                               dec.setDataType(dt);
      if (jj_2_16(2147483647)) {
        dec = BuiltInDeclarationSpecifier(dec);
      } else {
        ;
      }
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
                              dt = dec.getDataType();
                          if ( dt == null) {
                              dt = resolveInternal(FloatDataType.dataType);
                          } else if ( dt == resolveInternal(LongDataType.dataType)) {
                              dt = resolveInternal(DoubleDataType.dataType);
                           } else {
                              {if (true) throw new ParseException("Bad datatype " + dt + " long");}
                          }
                          dec.setDataType(dt);
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
                               dec.setDataType(resolveInternal(DoubleDataType.dataType));
      break;
    case SIGNED:
      jj_consume_token(SIGNED);
                              dt = dec.getDataType();
                          if ( dt == null) {
                              dt = resolveInternal(IntegerDataType.dataType);
                          } else {
                              // data type already set, don't do anything?
                             dt = dt;
                          }
                          dec.setDataType(dt);
      if (jj_2_17(2147483647)) {
        dec = BuiltInDeclarationSpecifier(dec);
      } else {
        ;
      }
      break;
    case UNSIGNED:
      jj_consume_token(UNSIGNED);
                                dt = dec.getDataType();
                              if ( dt == null) {
                                  dt = resolveInternal(UnsignedIntegerDataType.dataType);
                              } else if (dt == resolveInternal(ShortDataType.dataType)) {
                                 dt = resolveInternal(UnsignedShortDataType.dataType);
                              } else if (dt == resolveInternal(LongDataType.dataType)) {
                                 dt = resolveInternal(UnsignedLongDataType.dataType);
                              } else if (dt == resolveInternal(LongLongDataType.dataType)) {
                                 dt = resolveInternal(UnsignedLongLongDataType.dataType);
                              } else {
                                 {if (true) throw new ParseException("Bad datatype " + dt + " unsigned");}
                              }
                              dec.setDataType(dt);
      if (jj_2_18(2147483647)) {
        dec = BuiltInDeclarationSpecifier(dec);
      } else {
        ;
      }
      break;
    case INT8:
      jj_consume_token(INT8);
                              dec.setDataType(resolveInternal(SignedByteDataType.dataType));
      break;
    case INT16:
      jj_consume_token(INT16);
                              dec.setDataType(resolveInternal(ShortDataType.dataType));
      break;
    case INT32:
      jj_consume_token(INT32);
                              dec.setDataType(resolveInternal(IntegerDataType.dataType));
      break;
    case INT64:
      jj_consume_token(INT64);
                              dec.setDataType(resolveInternal(LongLongDataType.dataType));
      break;
    case BOOL:
      jj_consume_token(BOOL);
                              dec.setDataType(resolveInternal(BooleanDataType.dataType));
      break;
    default:
      jj_la1[14] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration BuiltInDeclarationSpecifier(Declaration dec) throws ParseException {
    DataType dt= null;
    dec = BuiltInTypeSpecifier(dec);
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration TypeSpecifier(Declaration dec) throws ParseException {
                                               DataType dt = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRUCT:
    case UNION:
      dt = StructOrUnionSpecifier();
      break;
    case ENUM:
      dt = EnumSpecifier();
      break;
    default:
      jj_la1[15] = jj_gen;
      if (isType(getToken(1).image)) {
        dt = TypedefName();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        dec.setDataType(dt);
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration TypeQualifier(Declaration dec) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
      jj_consume_token(CONST);
                 dec.addQualifier(CONST);
      break;
    case VOLATILE:
      jj_consume_token(VOLATILE);
      break;
    case CDECL:
      jj_consume_token(CDECL);
                dec.addQualifier(CDECL);
      break;
    case NEAR:
      jj_consume_token(NEAR);
      break;
    case FAR:
      jj_consume_token(FAR);
      break;
    case STDCALL:
      jj_consume_token(STDCALL);
                  dec.addQualifier(STDCALL);
      break;
    case FASTCALL:
      jj_consume_token(FASTCALL);
                   dec.addQualifier(FASTCALL);
      break;
    case VECTORCALL:
      jj_consume_token(VECTORCALL);
                     dec.addQualifier(VECTORCALL);
      break;
    case RUSTCALL:
      jj_consume_token(RUSTCALL);
                   dec.addQualifier(RUSTCALL);
      break;
    case PASCALCALL:
      jj_consume_token(PASCALCALL);
                     dec.addQualifier(PASCALCALL);
      break;
    case NORETURN:
      jj_consume_token(NORETURN);
                   dec.addQualifier(NORETURN);
      break;
    case W64:
      jj_consume_token(W64);
      break;
    case PTR64:
      jj_consume_token(PTR64);
      break;
    case PTR32:
      jj_consume_token(PTR32);
      break;
    case INLINE:
      jj_consume_token(INLINE);
      break;
    case RESTRICT:
      jj_consume_token(RESTRICT);
      break;
    case EXTENSION:
      jj_consume_token(EXTENSION);
      break;
    case STATIC:
      jj_consume_token(STATIC);
      break;
    case PACKED:
      jj_consume_token(PACKED);
      break;
    case UNALIGNED:
      jj_consume_token(UNALIGNED);
      break;
    case DECLSPEC:
    case READABLETO:
    case ALIGNAS:
    case ATTRIBUTE:
    case ASM:
    case 151:
      DeclSpec(dec);
      break;
    default:
      jj_la1[16] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public void AttributeSpec(Declaration dec) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ATTRIBUTE:
      jj_consume_token(ATTRIBUTE);
      jj_consume_token(149);
      SubIdent(dec);
      jj_consume_token(150);
      break;
    case ASM:
      AsmStatement();
      break;
    case 151:
      jj_consume_token(151);
      jj_consume_token(151);
      AttributeList(dec);
      jj_consume_token(152);
      jj_consume_token(152);
      break;
    case ALIGNAS:
      AlignmentSpecifier();
      break;
    default:
      jj_la1[17] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void AlignmentSpecifier() throws ParseException {
                              Declaration dt = new Declaration();
    jj_consume_token(ALIGNAS);
    jj_consume_token(149);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case 151:
      TypeQualifier(dt);
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case SIZEOF:
    case ALIGNOF:
    case IDENTIFIER:
    case 149:
    case 157:
    case 158:
    case 161:
    case 162:
    case 188:
    case 189:
    case 190:
    case 191:
      AssignmentExpression();
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(150);
  }

  final public void AttributeList(Declaration dec) throws ParseException {
    AttributeToken(dec);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 153:
      label_5:
      while (true) {
        jj_consume_token(153);
        AttributeToken(dec);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 153:
          ;
          break;
        default:
          jj_la1[19] = jj_gen;
          break label_5;
        }
      }
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
  }

  final public void AttributeToken(Declaration dec) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      break;
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case 151:
      TypeQualifier(dec);
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 154:
      jj_consume_token(154);
      jj_consume_token(154);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      case VOLATILE:
      case STATIC:
      case CONST:
      case DECLSPEC:
      case READABLETO:
      case CDECL:
      case STDCALL:
      case FASTCALL:
      case VECTORCALL:
      case RUSTCALL:
      case PASCALCALL:
      case NORETURN:
      case ALIGNAS:
      case UNALIGNED:
      case PACKED:
      case ATTRIBUTE:
      case EXTENSION:
      case RESTRICT:
      case ASM:
      case INLINE:
      case PTR64:
      case PTR32:
      case W64:
      case NEAR:
      case FAR:
      case 151:
        TypeQualifier(dec);
        break;
      default:
        jj_la1[22] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[23] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 149:
      jj_consume_token(149);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
        Constant();
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        label_6:
        while (true) {
          jj_consume_token(153);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDENTIFIER:
            jj_consume_token(IDENTIFIER);
            break;
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case CHARACTER_LITERAL:
          case STRING_LITERAL:
            Constant();
            break;
          default:
            jj_la1[25] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case 153:
            ;
            break;
          default:
            jj_la1[26] = jj_gen;
            break label_6;
          }
        }
        break;
      default:
        jj_la1[27] = jj_gen;
        ;
      }
      jj_consume_token(150);
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
  }

  final public void AttributeSpecList(Declaration dec) throws ParseException {
    label_7:
    while (true) {
      AttributeSpec(dec);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALIGNAS:
      case ATTRIBUTE:
      case ASM:
      case 151:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_7;
      }
    }
  }

  final public void SubIdent(Declaration dec) throws ParseException {
   Token id = null;
   Declaration dt = new Declaration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 149:
      jj_consume_token(149);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case VOLATILE:
      case STATIC:
      case CONST:
      case DECLSPEC:
      case READABLETO:
      case CDECL:
      case STDCALL:
      case FASTCALL:
      case VECTORCALL:
      case RUSTCALL:
      case PASCALCALL:
      case NORETURN:
      case ALIGNAS:
      case UNALIGNED:
      case PACKED:
      case ATTRIBUTE:
      case EXTENSION:
      case RESTRICT:
      case ASM:
      case INLINE:
      case PTR64:
      case PTR32:
      case W64:
      case NEAR:
      case FAR:
      case IDENTIFIER:
      case 149:
      case 151:
        SubIdent(dec);
        break;
      default:
        jj_la1[30] = jj_gen;
        ;
      }
      jj_consume_token(150);
      break;
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case IDENTIFIER:
    case 151:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        id = jj_consume_token(IDENTIFIER);
        break;
      case VOLATILE:
      case STATIC:
      case CONST:
      case DECLSPEC:
      case READABLETO:
      case CDECL:
      case STDCALL:
      case FASTCALL:
      case VECTORCALL:
      case RUSTCALL:
      case PASCALCALL:
      case NORETURN:
      case ALIGNAS:
      case UNALIGNED:
      case PACKED:
      case ATTRIBUTE:
      case EXTENSION:
      case RESTRICT:
      case ASM:
      case INLINE:
      case PTR64:
      case PTR32:
      case W64:
      case NEAR:
      case FAR:
      case 151:
        TypeQualifier(dec);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 149:
      case 155:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 149:
          jj_consume_token(149);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case CHARACTER_LITERAL:
          case STRING_LITERAL:
          case VOLATILE:
          case STATIC:
          case CONST:
          case DECLSPEC:
          case READABLETO:
          case CDECL:
          case STDCALL:
          case FASTCALL:
          case VECTORCALL:
          case RUSTCALL:
          case PASCALCALL:
          case NORETURN:
          case ALIGNAS:
          case UNALIGNED:
          case PACKED:
          case ATTRIBUTE:
          case EXTENSION:
          case RESTRICT:
          case ASM:
          case INLINE:
          case PTR64:
          case PTR32:
          case W64:
          case NEAR:
          case FAR:
          case IDENTIFIER:
          case 149:
          case 151:
            SubIdent(dt);
            break;
          default:
            jj_la1[32] = jj_gen;
            ;
          }
          jj_consume_token(150);
          break;
        case 155:
          jj_consume_token(155);
          SubIdent(dt);
          break;
        default:
          jj_la1[33] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        jj_consume_token(153);
        SubIdent(dt);
        break;
      default:
        jj_la1[35] = jj_gen;
        ;
      }
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      Constant();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        jj_consume_token(153);
        SubIdent(dt);
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        if (id != null && "noreturn".equals(id.image.replace("_", ""))) {
            dec.addQualifier(NORETURN);
            if (dec.getDataType() instanceof FunctionDefinition) {
               applyFunctionQualifiers(dec, (FunctionDefinition) dec.getDataType());
            }
        }
  }

  final public void DeclSpec(Declaration dec) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECLSPEC:
    case READABLETO:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DECLSPEC:
        jj_consume_token(DECLSPEC);
        break;
      case READABLETO:
        jj_consume_token(READABLETO);
        break;
      default:
        jj_la1[38] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(149);
      DeclSpecifier(dec);
      jj_consume_token(150);
      break;
    case ALIGNAS:
    case ATTRIBUTE:
    case ASM:
    case 151:
      AttributeSpecList(dec);
      break;
    default:
      jj_la1[39] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DeclSpecifier(Declaration dec) throws ParseException {
   Token id = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 149:
      jj_consume_token(149);
      DeclSpecifier(dec);
      jj_consume_token(150);
      break;
    case IDENTIFIER:
      label_8:
      while (true) {
        id = jj_consume_token(IDENTIFIER);
                         if (id != null && "noreturn".equals(id.image)) dec.addQualifier(NORETURN);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          ;
          break;
        default:
          jj_la1[40] = jj_gen;
          break label_8;
        }
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 149:
        jj_consume_token(149);
        DeclConstant();
        label_9:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTEGER_LITERAL:
          case STRING_LITERAL:
          case IDENTIFIER:
          case 149:
          case 154:
          case 156:
            ;
            break;
          default:
            jj_la1[41] = jj_gen;
            break label_9;
          }
          DeclConstant();
        }
        jj_consume_token(150);
        break;
      default:
        jj_la1[42] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void DeclConstant() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      jj_consume_token(INTEGER_LITERAL);
      break;
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 154:
        jj_consume_token(154);
        jj_consume_token(INTEGER_LITERAL);
        break;
      default:
        jj_la1[44] = jj_gen;
        ;
      }
      break;
    case STRING_LITERAL:
    case 149:
    case 154:
    case 156:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 156:
        jj_consume_token(156);
        break;
      case 154:
        jj_consume_token(154);
        break;
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      case 149:
        jj_consume_token(149);
        jj_consume_token(150);
        break;
      case STRING_LITERAL:
        MultiLineString();
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Token MultiLineString() throws ParseException {
   Token t = null;
   Token r = null;
    label_10:
    while (true) {
      t = jj_consume_token(STRING_LITERAL);
        if (r == null) {
           r = t;
        } else {
          r.image = r.image.substring(0,r.image.length()) + t.image.substring(1);
        }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STRING_LITERAL:
        ;
        break;
      default:
        jj_la1[47] = jj_gen;
        break label_10;
      }
    }
      {if (true) return r;}
    throw new Error("Missing return statement in function");
  }

  final public void PragmaSpec() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRAGMA:
      jj_consume_token(PRAGMA);
      label_11:
      while (true) {
        PragmaSpecifier();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PIDENTIFIER:
        case POPEN:
          ;
          break;
        default:
          jj_la1[48] = jj_gen;
          break label_11;
        }
      }
      break;
    case PRAGMA_FUNC:
      jj_consume_token(PRAGMA_FUNC);
      PragmaSpecifier();
      break;
    default:
      jj_la1[49] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void PragmaSpecifier() throws ParseException {
   Token id;
   Token ds1=null, ds2=null, ds3 = null;
    if (jj_2_19(3)) {
      jj_consume_token(POPEN);
      PragmaSpecifier();
      jj_consume_token(PCLOSE);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PIDENTIFIER:
        id = jj_consume_token(PIDENTIFIER);
        label_12:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PIDENTIFIER:
          case PCOMMA:
          case PINTEGER_LITERAL:
          case PSTRING_LITERAL:
            ;
            break;
          default:
            jj_la1[50] = jj_gen;
            break label_12;
          }
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PIDENTIFIER:
            jj_consume_token(PIDENTIFIER);
            break;
          case PINTEGER_LITERAL:
            jj_consume_token(PINTEGER_LITERAL);
            break;
          case PSTRING_LITERAL:
            jj_consume_token(PSTRING_LITERAL);
            break;
          case PCOMMA:
            jj_consume_token(PCOMMA);
            break;
          default:
            jj_la1[51] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case POPEN:
          jj_consume_token(POPEN);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PIDENTIFIER:
          case POPEN:
          case PMINUS:
          case PPLUS:
          case PSTAR:
          case PINTEGER_LITERAL:
          case PSTRING_LITERAL:
            label_13:
            while (true) {
              ds1 = PragmaConstant();
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case PIDENTIFIER:
              case POPEN:
              case PMINUS:
              case PPLUS:
              case PSTAR:
              case PINTEGER_LITERAL:
              case PSTRING_LITERAL:
                ;
                break;
              default:
                jj_la1[52] = jj_gen;
                break label_13;
              }
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PCOMMA:
              jj_consume_token(PCOMMA);
              ds2 = PragmaConstant();
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case PCOMMA:
                jj_consume_token(PCOMMA);
                ds3 = PragmaConstant();
                switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                case PCOMMA:
                  label_14:
                  while (true) {
                    jj_consume_token(PCOMMA);
                    PragmaConstant();
                    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
                    case PCOMMA:
                      ;
                      break;
                    default:
                      jj_la1[53] = jj_gen;
                      break label_14;
                    }
                  }
                  break;
                default:
                  jj_la1[54] = jj_gen;
                  ;
                }
                break;
              default:
                jj_la1[55] = jj_gen;
                ;
              }
              break;
            default:
              jj_la1[56] = jj_gen;
              ;
            }
            break;
          default:
            jj_la1[57] = jj_gen;
            ;
          }
          jj_consume_token(PCLOSE);
          break;
        default:
          jj_la1[58] = jj_gen;
          ;
        }
    if (id.image.equals("pack") && ds1 != null) {
        Token newPackVal = ds1;
        Token ID = ds2;
        if (ds1.image.equals("pop")) {
            // pop and set current value
            packSize = popPack(ID);
            newPackVal = null;
        }
        else if (ds1.image.equals("push") && ds2 != null) {
            try {
                // check if second arg is an integer
                int ival = Integer.parseInt(ds2.image);
                // if it is, the ID is default
                newPackVal = ds2;
                ID = null;
            }
            catch (NumberFormatException exc) {
                // if it is not, then second arg is an ID
                // and third arg is potentially a pack value
                newPackVal = ds3;
                ID = ds2;
            }
            pushPack(ID, packSize);
        }
        // set current pack value
        if (newPackVal != null) {
            int ival = packSize;
            try {
                // second arg may be an integer
                ival = Integer.parseInt(newPackVal.image);
            }
            catch (NumberFormatException exc) {
                // bad parse of number, just keep current pack size
            }
            packSize = ival;
        }
    } else if (id.image.equals("pack")) {
       packSize = 0;
    }
        break;
      default:
        jj_la1[59] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public Token PragmaConstant() throws ParseException {
  Token val = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PINTEGER_LITERAL:
      val = jj_consume_token(PINTEGER_LITERAL);
      break;
    case PMINUS:
    case PPLUS:
    case PSTAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PSTAR:
        jj_consume_token(PSTAR);
        break;
      case PPLUS:
        jj_consume_token(PPLUS);
        break;
      case PMINUS:
        jj_consume_token(PMINUS);
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PIDENTIFIER:
        case POPEN:
        case PMINUS:
        case PPLUS:
        case PSTAR:
        case PINTEGER_LITERAL:
        case PSTRING_LITERAL:
          ;
          break;
        default:
          jj_la1[61] = jj_gen;
          break label_15;
        }
        PragmaConstant();
      }
      break;
    case POPEN:
      label_16:
      while (true) {
        jj_consume_token(POPEN);
        label_17:
        while (true) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case PIDENTIFIER:
          case POPEN:
          case PMINUS:
          case PPLUS:
          case PSTAR:
          case PINTEGER_LITERAL:
          case PSTRING_LITERAL:
            ;
            break;
          default:
            jj_la1[62] = jj_gen;
            break label_17;
          }
          PragmaConstant();
        }
        jj_consume_token(PCLOSE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case POPEN:
          ;
          break;
        default:
          jj_la1[63] = jj_gen;
          break label_16;
        }
      }
      break;
    case PIDENTIFIER:
      val = jj_consume_token(PIDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PCOLON:
      case PSTRING_LITERAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PSTRING_LITERAL:
          jj_consume_token(PSTRING_LITERAL);
          break;
        case PCOLON:
          jj_consume_token(PCOLON);
          label_18:
          while (true) {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PINTEGER_LITERAL:
              jj_consume_token(PINTEGER_LITERAL);
              break;
            case PIDENTIFIER:
              jj_consume_token(PIDENTIFIER);
              break;
            default:
              jj_la1[64] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case PIDENTIFIER:
            case PINTEGER_LITERAL:
              ;
              break;
            default:
              jj_la1[65] = jj_gen;
              break label_18;
            }
          }
          break;
        default:
          jj_la1[66] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[67] = jj_gen;
        ;
      }
      break;
    case PSTRING_LITERAL:
      val = jj_consume_token(PSTRING_LITERAL);
      label_19:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PIDENTIFIER:
          ;
          break;
        default:
          jj_la1[68] = jj_gen;
          break label_19;
        }
        jj_consume_token(PIDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case POPEN:
          jj_consume_token(POPEN);
          jj_consume_token(PCLOSE);
          break;
        default:
          jj_la1[69] = jj_gen;
          ;
        }
        jj_consume_token(PSTRING_LITERAL);
      }
      break;
    default:
      jj_la1[70] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
      {if (true) return val;}
    throw new Error("Missing return statement in function");
  }

  final public void StaticAssert() throws ParseException {
  Object expr = null;
  Token t, message=null;
    t = jj_consume_token(STATICASSERT);
    jj_consume_token(149);
    expr = ConstantExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 153:
      jj_consume_token(153);
      label_20:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
          message = jj_consume_token(STRING_LITERAL);
          break;
        case 156:
          jj_consume_token(156);
          jj_consume_token(IDENTIFIER);
          break;
        default:
          jj_la1[71] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRING_LITERAL:
        case 156:
          ;
          break;
        default:
          jj_la1[72] = jj_gen;
          break label_20;
        }
      }
      break;
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    jj_consume_token(150);
        if (expr != null) {
          Integer evalue = getConstantValue(expr,1);
          if (evalue == 0) {
            String smessage = (message == null ? "" : message.image);
              addNearParseMessage("Warning: Static_Assert possibly failed " + " \u005c"" + smessage + "\u005c"");
          }
        }
  }

  final public DataType StructOrUnionSpecifier() throws ParseException {
    Token t;
    Token parent;
    Token sname;
    Composite comp;
    Declaration dec = new Declaration();
        typedefParsingStack.push(Boolean.FALSE);
        t= sname= null;
        parent = null;
    comp = StructOrUnion();
    if (jj_2_21(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 154:
          jj_consume_token(154);
          parent = jj_consume_token(IDENTIFIER);
          break;
        default:
          jj_la1[74] = jj_gen;
          ;
        }
                comp=defineNamedComposite(t, null, comp);
        break;
      default:
        jj_la1[75] = jj_gen;
        ;
      }
      jj_consume_token(146);
      if (jj_2_20(1)) {
        StructDeclarationList(comp);
      } else {
        ;
      }
      jj_consume_token(147);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALIGNAS:
      case ATTRIBUTE:
      case ASM:
      case 151:
        AttributeSpecList(dec);
        break;
      default:
        jj_la1[76] = jj_gen;
        ;
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        sname = jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[77] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        if (t != null) {
            comp = defineNamedComposite(t, parent, comp);
        } else if (sname != null) {
            comp = defineForwardDeclaredComposite(sname, comp);
        }
        typedefParsingStack.pop();
        {if (true) return comp;}
    throw new Error("Missing return statement in function");
  }

  final public Composite StructOrUnion() throws ParseException {
    Composite comp;
    Declaration dec = new Declaration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRUCT:
      jj_consume_token(STRUCT);
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DECLSPEC:
        case PRAGMA:
        case PRAGMA_FUNC:
        case READABLETO:
        case ALIGNAS:
        case ATTRIBUTE:
        case ASM:
        case 151:
          ;
          break;
        default:
          jj_la1[78] = jj_gen;
          break label_21;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DECLSPEC:
        case READABLETO:
        case ALIGNAS:
        case ATTRIBUTE:
        case ASM:
        case 151:
          DeclSpec(dec);
          break;
        case PRAGMA:
        case PRAGMA_FUNC:
          PragmaSpec();
          break;
        default:
          jj_la1[79] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
            comp =  new StructureDataType(getCurrentCategoryPath(), ANONYMOUS_STRUCT_PREFIX + cnt++, 0, dtMgr);

            // Always set the packing, because by default structures should be aligned
            if (packSize > 0) {
                comp.setExplicitPackingValue(packSize);
            }
            else {
                comp.setPackingEnabled(true); // ensure default packing enabled
            }
      break;
    case UNION:
      jj_consume_token(UNION);
      label_22:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DECLSPEC:
        case READABLETO:
        case ALIGNAS:
        case ATTRIBUTE:
        case ASM:
        case 151:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_22;
        }
        DeclSpec(dec);
      }
            comp = new UnionDataType(getCurrentCategoryPath(), ANONYMOUS_UNION_PREFIX  + cnt++, dtMgr);

            // Always set the packing, because by default structures should be aligned
            if (packSize > 0) {
                comp.setExplicitPackingValue(packSize);
            } else {
                comp.setPackingEnabled(true); // ensure default packing enabled
            }
      break;
    default:
      jj_la1[81] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return comp;}
    throw new Error("Missing return statement in function");
  }

  final public void StructDeclarationList(Composite comp) throws ParseException {
    CompositeHandler compositeHandler = new CompositeHandler(comp);
    label_23:
    while (true) {
      StructDeclaration(comp, compositeHandler);
      if (jj_2_22(1)) {
        ;
      } else {
        break label_23;
      }
    }
  }

  final public void InitDeclaratorList(Declaration dt) throws ParseException {
    Declaration initialDT = new Declaration(dt);
    InitDeclarator(dt);
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        ;
        break;
      default:
        jj_la1[82] = jj_gen;
        break label_24;
      }
      jj_consume_token(153);
            dt = new Declaration(initialDT);
      InitDeclarator(dt);
    }
        // Finished with a typedefDeclaration??
        if (!(typedefParsingStack.empty()) && (typedefParsingStack.peek()).booleanValue()) {
            typedefParsingStack.pop();
        }
  }

  final public void InitDeclarator(Declaration dt) throws ParseException {
                                        Declaration dec;
    dec = Declarator(dt, null);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 155:
      jj_consume_token(155);
      Initializer();
      break;
    default:
      jj_la1[83] = jj_gen;
      ;
    }
        if (!(typedefParsingStack.empty()) && (typedefParsingStack.peek()).booleanValue()) {
            addTypedef(dec.getName(), dec.getDataType());
        } else {
            if (dt.getDataType() instanceof FunctionDefinition) {
                addDef(functions, dec.getName(), dec.getDataType());
            }
        }
  }

  final public void StructDeclaration(Composite comp, CompositeHandler compositeHandler) throws ParseException {
    Declaration dt = null;
    Declaration dec = new Declaration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LINE:
    case LINEALT:
      LineDef();
      break;
    case STATICASSERT:
      StaticAssert();
      break;
    case PRAGMA:
    case PRAGMA_FUNC:
      PragmaSpec();
      break;
    default:
      jj_la1[86] = jj_gen;
      if (jj_2_24(1)) {
        if (jj_2_23(1)) {
          dt = SpecifierQualifierList();
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VOLATILE:
        case STATIC:
        case CONST:
        case DECLSPEC:
        case PRAGMA:
        case PRAGMA_FUNC:
        case READABLETO:
        case CDECL:
        case STDCALL:
        case FASTCALL:
        case VECTORCALL:
        case RUSTCALL:
        case PASCALCALL:
        case NORETURN:
        case ALIGNAS:
        case UNALIGNED:
        case PACKED:
        case ATTRIBUTE:
        case EXTENSION:
        case RESTRICT:
        case ASM:
        case INLINE:
        case STATICASSERT:
        case PTR64:
        case PTR32:
        case W64:
        case NEAR:
        case FAR:
        case LINE:
        case LINEALT:
        case IDENTIFIER:
        case 149:
        case 151:
        case 154:
        case 157:
        case 158:
          StructDeclaratorList(dt, comp, compositeHandler);
                                                                   dt= null;
          break;
        default:
          jj_la1[84] = jj_gen;
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ALIGNAS:
        case ATTRIBUTE:
        case ASM:
        case 151:
          AttributeSpecList(dec);
          break;
        default:
          jj_la1[85] = jj_gen;
          ;
        }
        jj_consume_token(148);
        if (dt != null) { // dt was not used up
            if (dt.getDataType().getLength() > 0) {
                comp.add(dt.getDataType(), "", null);
            } else {
                addNearParseMessage("BAD data type struct size  " + dt);
            }
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public Declaration SpecifierQualifierList() throws ParseException {
    Declaration dt = new Declaration();
    Declaration sdt= null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case UNSIGNED:
    case DOUBLE:
    case SIGNED:
    case FLOAT:
    case SHORT:
    case LONG:
    case INT8:
    case INT16:
    case INT32:
    case INT64:
    case BOOL:
    case VOID:
    case CHAR:
    case INT:
      dt = BuiltInDeclarationSpecifier(dt);
      if (jj_2_25(2147483647)) {
        dt = TypeQualifierList(dt);
      } else {
        ;
      }
      break;
    default:
      jj_la1[88] = jj_gen;
      if (jj_2_28(1)) {
        dt = TypeSpecifier(dt);
        if (jj_2_26(2147483647) && (dt == null || dt.getDataType() == null)) {
          sdt = SpecifierQualifierList();
        } else {
          ;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VOLATILE:
        case STATIC:
        case CONST:
        case DECLSPEC:
        case READABLETO:
        case CDECL:
        case STDCALL:
        case FASTCALL:
        case VECTORCALL:
        case RUSTCALL:
        case PASCALCALL:
        case NORETURN:
        case ALIGNAS:
        case UNALIGNED:
        case PACKED:
        case ATTRIBUTE:
        case EXTENSION:
        case RESTRICT:
        case ASM:
        case INLINE:
        case PTR64:
        case PTR32:
        case W64:
        case NEAR:
        case FAR:
        case 151:
          sdt = TypeQualifier(sdt != null ? sdt : dt);
          break;
        default:
          jj_la1[87] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VOLATILE:
        case STATIC:
        case CONST:
        case DECLSPEC:
        case READABLETO:
        case CDECL:
        case STDCALL:
        case FASTCALL:
        case VECTORCALL:
        case RUSTCALL:
        case PASCALCALL:
        case NORETURN:
        case ALIGNAS:
        case UNALIGNED:
        case PACKED:
        case ATTRIBUTE:
        case EXTENSION:
        case RESTRICT:
        case ASM:
        case INLINE:
        case PTR64:
        case PTR32:
        case W64:
        case NEAR:
        case FAR:
        case 151:
          dt = TypeQualifier(dt);
          if (jj_2_27(2147483647)) {
            sdt = SpecifierQualifierList();
          } else {
            ;
          }
          break;
        default:
          jj_la1[89] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
        if (sdt == null) {
            dataTypeStack.push(dt.getDataType());
            {if (true) return dt;}
        }
        {if (true) return sdt;}
    throw new Error("Missing return statement in function");
  }

  final public void StructDeclaratorList(Declaration dt, Composite comp, CompositeHandler compositeHandler) throws ParseException {
    StructDeclarator(dt, comp, compositeHandler);
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        ;
        break;
      default:
        jj_la1[90] = jj_gen;
        break label_25;
      }
      jj_consume_token(153);
      StructDeclarator(dt, comp, compositeHandler);
    }
  }

  final public void StructDeclarator(Declaration dt, Composite comp, CompositeHandler compositeHandler) throws ParseException {
    Declaration dec= null;
    Object bitSizeObj;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LINE:
    case LINEALT:
      LineDef();
      break;
    case STATICASSERT:
      StaticAssert();
      break;
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case PRAGMA:
    case PRAGMA_FUNC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case IDENTIFIER:
    case 149:
    case 151:
    case 154:
    case 157:
    case 158:
      if (jj_2_29(3)) {
        dec = Declarator(dt, comp);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 154:
          jj_consume_token(154);
          bitSizeObj = ConstantExpression();
               Integer bitSize = getConstantValue(bitSizeObj,-1);
               dec.setBitFieldSize(bitSize);
          break;
        default:
          jj_la1[91] = jj_gen;
          ;
        }
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 154:
          jj_consume_token(154);
          bitSizeObj = ConstantExpression();
               Integer bitSize = getConstantValue(bitSizeObj,-1);
               dec = new Declaration(dt);
               dec.setBitFieldSize(bitSize);
          break;
        default:
          jj_la1[92] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
        try {
            compositeHandler.add(dec);
        } catch (IllegalArgumentException e) {
            addNearParseMessage("Bad structure size " + dec.getName() + "  length=" + dec.getDataType().getLength());
        }
      break;
    default:
      jj_la1[93] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public DataType EnumSpecifier() throws ParseException {
    Token t= null;
    DataType dt;
    ArrayList<EnumMember> list;
    Declaration dec = new Declaration();
    jj_consume_token(ENUM);
    if (jj_2_30(3)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ALIGNAS:
      case ATTRIBUTE:
      case ASM:
      case 151:
        AttributeSpecList(dec);
        break;
      default:
        jj_la1[94] = jj_gen;
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
        break;
      default:
        jj_la1[95] = jj_gen;
        ;
      }
      jj_consume_token(146);
      list = EnumeratorList();
      jj_consume_token(147);
            dt = allocateEnumDT(t, list);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        t = jj_consume_token(IDENTIFIER);
            dt= getEnumDef(t.image);
            // not defined yet, define an empty one
            if (dt == null) {
                dt = allocateEnumDT(t, null);
            }
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return dt;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<EnumMember> EnumeratorList() throws ParseException {
    int value= 0;
    ArrayList<EnumMember> list= new ArrayList<EnumMember>();
    label_26:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case PRAGMA:
      case PRAGMA_FUNC:
      case STATICASSERT:
      case LINE:
      case LINEALT:
      case IDENTIFIER:
        ;
        break;
      default:
        jj_la1[97] = jj_gen;
        break label_26;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LINE:
      case LINEALT:
        LineDef();
        break;
      case PRAGMA:
      case PRAGMA_FUNC:
        PragmaSpec();
        break;
      case STATICASSERT:
        StaticAssert();
        break;
      case INTEGER_LITERAL:
      case IDENTIFIER:
        value = Enumerator(list, value);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 153:
          jj_consume_token(153);
          break;
        default:
          jj_la1[98] = jj_gen;
          ;
        }
                                                     value++;
        break;
      default:
        jj_la1[99] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public int Enumerator(ArrayList<EnumMember> list, int value) throws ParseException {
    Token t = null;
    Object obj = null;
    Integer evalue;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 155:
        jj_consume_token(155);
        obj = ConstantExpression();
        break;
      default:
        jj_la1[100] = jj_gen;
        ;
      }
        evalue = getConstantValue(obj,value);
        if (evalue != null) {
            value = evalue;
        }
        list.add(new EnumMember(t.image, value));
        {if (true) return value;}
      break;
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 155:
        jj_consume_token(155);
        obj = ConstantExpression();
        break;
      default:
        jj_la1[101] = jj_gen;
        ;
      }
        evalue = getConstantValue(obj,value);
        if (evalue != null) {
            value = evalue;
        }
        list.add(new EnumMember(t.image, value));
        {if (true) return value;}
      break;
    default:
      jj_la1[102] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Declaration Declarator(Declaration dt, DataType container) throws ParseException {
    Declaration dec= null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case 151:
      dt = TypeQualifierList(dt);
      break;
    default:
      jj_la1[103] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 157:
    case 158:
      dt = Pointer(dt);
      break;
    default:
      jj_la1[104] = jj_gen;
      ;
    }
    dec = DirectDeclarator(dt, container);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ALIGNAS:
    case ATTRIBUTE:
    case ASM:
    case 151:
      AttributeSpecList(dec);
      break;
    default:
      jj_la1[105] = jj_gen;
      ;
    }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration DirectDeclarator(Declaration dt, DataType container) throws ParseException {
    Token t;
    Declaration dec= null;
    Declaration funcDec= null;
    FunctionDefinitionDataType funcDT= null;
    Object obj = null;
    ArrayList list = new ArrayList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRAGMA:
    case PRAGMA_FUNC:
      PragmaSpec();
      break;
    default:
      jj_la1[106] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      t = jj_consume_token(IDENTIFIER);
                                     dec= new Declaration(dt, t.image);
      break;
    case 149:
      jj_consume_token(149);
      dec = Declarator(new Declaration(funcDT=newAnonymousFunction(funcDT)), null);
      jj_consume_token(150);

      break;
    default:
      jj_la1[107] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
          lastDataType = dec.getDataType();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 151:
        ;
        break;
      default:
        jj_la1[108] = jj_gen;
        break label_27;
      }
      jj_consume_token(151);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        obj = ConditionalExpression();
        break;
      default:
        jj_la1[109] = jj_gen;
        ;
      }
      jj_consume_token(152);
                    // make a new array given value on constant expression
                    Integer size = getConstantValue(obj, 0);
                    if (size == null) {
                        System.out.println("BAD ARRAY SIZE! " + obj);
                        size = 0;
                    }
                    list.add(0,size);
    }
            if (list.size() > 0) {
            dec.setDataType(dt.getDataType());
            for (Iterator iterator = list.iterator(); iterator.hasNext();) {
                Integer iSize = (Integer) iterator.next();
                DataType decDt = dec.getDataType();
                dec.setDataType(new ArrayDataType(decDt, iSize, decDt.getLength()));
            }
            //System.out.println("Array expr: for " + dec.getName() + " make an array " + dt.getName() + "["+size+"]");
            }
    label_28:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 149:
        ;
        break;
      default:
        jj_la1[110] = jj_gen;
        break label_28;
      }
      if (jj_2_31(3)) {
        jj_consume_token(149);
        funcDec = ParameterTypeList(funcDT=newAnonymousFunction(funcDT), dt.getDataType());
        jj_consume_token(150);

      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 149:
          jj_consume_token(149);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IDENTIFIER:
            IdentifierList(funcDT=newAnonymousFunction(funcDT), dt.getDataType());
            break;
          default:
            jj_la1[111] = jj_gen;
            ;
          }
          jj_consume_token(150);
                //System.out.println(
                //    "ID List: for " + dec.getName() + " make a function " + dt.getName());
                funcDec= new Declaration(funcDT=newAnonymousFunction(funcDT), "__paramIDList__");
          break;
        default:
          jj_la1[112] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
        if (funcDec != null) {
            try {
              // functions in containers stay anonymous
              if (container == null) {
                funcDT.setName(dec.getName());
              }
                funcDec.setName(dec.getName());
                if (dec.getDataType() != null) {
                    funcDec.setDataType(dec.getDataType());
                }
            } catch (InvalidNameException e) {
                {if (true) throw new ParseException("duplicate name " + dec.getName());}
            }
            DataType retDT = dt.getDataType();
            checkReturnDataType(retDT);
            funcDT.setReturnType(retDT);
            // get qualifiers and apply them
            applyFunctionQualifiers(dt, funcDT);
            dec= funcDec;
            defineAndReplaceFunction(dec, funcDT);
        }

        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration Pointer(Declaration dec) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 157:
      jj_consume_token(157);
      break;
    case 158:
      jj_consume_token(158);
      break;
    default:
      jj_la1[113] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case 151:
      dec = TypeQualifierList(dec);
      break;
    default:
      jj_la1[114] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 157:
    case 158:
      dec = Pointer(dec);
      break;
    default:
      jj_la1[115] = jj_gen;
      ;
    }
        // TODO: is this right?
        dec.setDataType(dtMgr.getPointer(dec.getDataType()));
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration TypeQualifierList(Declaration dec) throws ParseException {
    label_29:
    while (true) {
      dec = TypeQualifier(dec);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VOLATILE:
      case STATIC:
      case CONST:
      case DECLSPEC:
      case READABLETO:
      case CDECL:
      case STDCALL:
      case FASTCALL:
      case VECTORCALL:
      case RUSTCALL:
      case PASCALCALL:
      case NORETURN:
      case ALIGNAS:
      case UNALIGNED:
      case PACKED:
      case ATTRIBUTE:
      case EXTENSION:
      case RESTRICT:
      case ASM:
      case INLINE:
      case PTR64:
      case PTR32:
      case W64:
      case NEAR:
      case FAR:
      case 151:
        ;
        break;
      default:
        jj_la1[116] = jj_gen;
        break label_29;
      }
    }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration ParameterTypeList(FunctionDefinitionDataType funcDT, DataType retDT) throws ParseException {
    ArrayList<Declaration> list;
    Token varargs= null;
    list = ParameterList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 153:
      jj_consume_token(153);
      varargs = jj_consume_token(159);
      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
        checkReturnDataType(retDT);
        if (funcDT == null) {
            funcDT= new FunctionDefinitionDataType(getCurrentCategoryPath("functions"), ANONYMOUS_FUNC_PREFIX, dtMgr);
        }
        funcDT.setVarArgs(varargs!=null);
        Declaration firstDeclaration = null;
        ParameterDefinition[] variables= new ParameterDefinition[list.size()];
        if (variables.length == 1) {
            firstDeclaration = list.get(0);
        }
        for (int i= 0; i < variables.length; i++) {
            Declaration dec= list.get(i);
            DataType varDT = dec.getDataType();

            // if this is a single void parameter, empty the parameter variable list
            //
            if (variables.length == 1 && varDT instanceof VoidDataType) {
                variables = new ParameterDefinition[0];
                break;
            }
            variables[i] = new ParameterDefinitionImpl(dec.getName(), dec.getDataType(), null);
        }
        funcDT.setReturnType(retDT);
        funcDT.setArguments(variables);
        Declaration dec = new Declaration(funcDT);
        if (firstDeclaration != null) {
            dec.addQualifiers(firstDeclaration);
        }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public ArrayList<Declaration> ParameterList() throws ParseException {
    ArrayList<Declaration> list= new ArrayList<Declaration>();
    ParameterDeclaration(list);
    label_30:
    while (true) {
      if (jj_2_32(2)) {
        ;
      } else {
        break label_30;
      }
      jj_consume_token(153);
      ParameterDeclaration(list);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public void ParameterDeclaration(ArrayList<Declaration> list) throws ParseException {
    Declaration dt = new Declaration();
    Declaration dec= new Declaration();
    dt = DeclarationSpecifiers(dec);
    if (jj_2_33(2147483647)) {
      dec = Declarator(dt, null);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 149:
      case 151:
      case 157:
      case 158:
        dec = AbstractDeclarator(dt);
        break;
      default:
        jj_la1[118] = jj_gen;
        ;
      }
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 155:
      jj_consume_token(155);
      jj_consume_token(INTEGER_LITERAL);
      break;
    default:
      jj_la1[119] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRAGMA:
    case PRAGMA_FUNC:
      PragmaSpec();
      break;
    default:
      jj_la1[120] = jj_gen;
      ;
    }
        if (dec == null) {
            dec = new Declaration(dt);
        }
        DataType decDT = dec.getDataType();
        if (decDT != null) {
            if (decDT.getLength() < 0  && !((decDT instanceof FunctionDefinition) || (decDT instanceof TypeDef && (((TypeDef) decDT).getDataType() instanceof FunctionDefinition)))) {
            // if (decDT.getLength() < 0  && !(decDT instanceof FunctionDefinitionDataType)) {
               {if (true) throw new ParseException("'"+decDT.getName()+"'" + " is not fixed length.  Function parameters must use fixed length data type.");}
            } else {
               list.add(dec);
            }
        }
  }

  final public void IdentifierList(FunctionDefinitionDataType funcDT, DataType retDT) throws ParseException {
    Token t;
        ArrayList<String> list= new ArrayList<String>();
    t = jj_consume_token(IDENTIFIER);
                                      list.add(t.image);
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        ;
        break;
      default:
        jj_la1[121] = jj_gen;
        break label_31;
      }
      jj_consume_token(153);
      t = jj_consume_token(IDENTIFIER);
                                          list.add(t.image);
    }
        checkReturnDataType(retDT);
        ParameterDefinition[] variables= new ParameterDefinition[list.size()];
        for (int i= 0; i < variables.length; i++) {
            // TODO need a data type
            variables[i] = new ParameterDefinitionImpl(list.get(i), null, null);
        }
        funcDT.setReturnType(retDT);
        funcDT.setArguments(variables);
  }

  final public void Initializer() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case SIZEOF:
    case ALIGNOF:
    case IDENTIFIER:
    case 149:
    case 157:
    case 158:
    case 161:
    case 162:
    case 188:
    case 189:
    case 190:
    case 191:
      AssignmentExpression();
      break;
    case 146:
      jj_consume_token(146);
      InitializerList();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        jj_consume_token(153);
        break;
      default:
        jj_la1[122] = jj_gen;
        ;
      }
      jj_consume_token(147);
      break;
    default:
      jj_la1[123] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void InitializerList() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 151:
    case 160:
      Designation();
      break;
    default:
      jj_la1[124] = jj_gen;
      ;
    }
    Initializer();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 153:
      jj_consume_token(153);
      InitializerList();
      break;
    default:
      jj_la1[125] = jj_gen;
      ;
    }
  }

  final public void Designation() throws ParseException {
    DesignatorList();
    jj_consume_token(155);
  }

  final public void DesignatorList() throws ParseException {
    Designator();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 151:
    case 160:
      DesignatorList();
      break;
    default:
      jj_la1[126] = jj_gen;
      ;
    }
  }

  final public void Designator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 151:
      jj_consume_token(151);
      ConstantExpression();
      jj_consume_token(152);
      break;
    case 160:
      jj_consume_token(160);
      jj_consume_token(IDENTIFIER);
      break;
    default:
      jj_la1[127] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Declaration TypeName() throws ParseException {
    Declaration dec = null;
    dec = SpecifierQualifierList();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 149:
    case 151:
    case 157:
    case 158:
      dec = AbstractDeclarator(new Declaration(dec));
      break;
    default:
      jj_la1[128] = jj_gen;
      ;
    }
       {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public Declaration AbstractDeclarator(Declaration dt) throws ParseException {
    Declaration dec= null;
    if (jj_2_34(3)) {
      dec = DirectAbstractDeclarator(dt);
                                             {if (true) return dec;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 157:
      case 158:
        dt = Pointer(dt);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 149:
        case 151:
          dec = DirectAbstractDeclarator(dt);
                                                              {if (true) return dec;}
          break;
        default:
          jj_la1[129] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[130] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
      {if (true) return new Declaration(dt);}
    throw new Error("Missing return statement in function");
  }

  final public Declaration DirectAbstractDeclarator(Declaration dt) throws ParseException {
    Declaration dec= dt;
    Declaration paramDec= null;
    FunctionDefinitionDataType funcDT = null;
    Object constObj = null;
    ArrayList list = new ArrayList();
    if (jj_2_36(2)) {
      jj_consume_token(149);
              funcDT = newAnonymousFunction(null); dec = new Declaration(funcDT);
      dec = AbstractDeclarator(dec);
      jj_consume_token(150);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 151:
        jj_consume_token(151);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INTEGER_LITERAL:
        case FLOATING_POINT_LITERAL:
        case CHARACTER_LITERAL:
        case STRING_LITERAL:
        case SIZEOF:
        case ALIGNOF:
        case IDENTIFIER:
        case 149:
        case 157:
        case 158:
        case 161:
        case 162:
        case 188:
        case 189:
        case 190:
        case 191:
          constObj = ConstantExpression();
          break;
        default:
          jj_la1[131] = jj_gen;
          ;
        }
        jj_consume_token(152);
           // TODO: create an array
           Integer size = getConstantValue(constObj, 0);
           list.add(0,size);
        break;
      case 149:
        jj_consume_token(149);
        if (jj_2_35(1)) {
                funcDT = newAnonymousFunction(null);
          dec = ParameterTypeList(funcDT, dt.getDataType());
        } else {
          ;
        }
        jj_consume_token(150);
          funcDT = (FunctionDefinitionDataType) dec.getDataType();
          dec.setDataType(dtMgr.getPointer(funcDT));
        break;
      default:
        jj_la1[132] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 151:
        ;
        break;
      default:
        jj_la1[133] = jj_gen;
        break label_32;
      }
      jj_consume_token(151);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        constObj = ConstantExpression();
        break;
      default:
        jj_la1[134] = jj_gen;
        ;
      }
      jj_consume_token(152);
              // TODO: create an array
               Integer size = getConstantValue(constObj, 0);
               list.add(0,size);
    }
        if (list.size() > 0) {
            for (Iterator iterator = list.iterator(); iterator.hasNext();) {
                Integer iSize = (Integer) iterator.next();
                DataType decDt = dec.getDataType();
                dec.setDataType(new ArrayDataType(decDt, iSize, decDt.getLength()));
            }
        }
    label_33:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 149:
        ;
        break;
      default:
        jj_la1[135] = jj_gen;
        break label_33;
      }
      jj_consume_token(149);
      if (jj_2_37(1)) {
        paramDec = ParameterTypeList(funcDT, dt.getDataType());
      } else {
        ;
      }
      jj_consume_token(150);
           dec = (funcDT != null ? dec : paramDec);
    }
        if (funcDT != null) {
            // get qualifiers and apply them
            List<Integer> dtQualifiers = dt.getQualifiers();
            if (dtQualifiers == null || dtQualifiers.isEmpty()) {
                dt = dec;
            }
            applyFunctionQualifiers(dt, funcDT);
            defineAndReplaceFunction(dec, funcDT);
        }
        {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

  final public DataType TypedefName() throws ParseException {
    Token t;
    t = jj_consume_token(IDENTIFIER);
        {if (true) return getType(t.image);}
    throw new Error("Missing return statement in function");
  }

  final public void Statement() throws ParseException {
    if (jj_2_38(2)) {
      AsmStatement();
    } else if (jj_2_39(3)) {
      DeclarationList();
    } else if (jj_2_40(2)) {
      LabeledStatement();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 148:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        ExpressionStatement();
        break;
      case 146:
        CompoundStatement();
        break;
      case SWITCH:
      case IF:
        SelectionStatement();
        break;
      case WHILE:
      case FOR:
      case DO:
        IterationStatement();
        break;
      case CONTINUE:
      case RETURN:
      case BREAK:
      case GOTO:
        JumpStatement();
        break;
      case ASM:
        AsmStatement();
        break;
      case PRAGMA:
      case PRAGMA_FUNC:
        PragmaSpec();
        break;
      case STATICASSERT:
        StaticAssert();
        break;
      default:
        jj_la1[136] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void LabeledStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      jj_consume_token(IDENTIFIER);
      jj_consume_token(154);
      Statement();
      break;
    case CASE:
      jj_consume_token(CASE);
      ConstantExpression();
      jj_consume_token(154);
      Statement();
      break;
    case DFLT:
      jj_consume_token(DFLT);
      jj_consume_token(154);
      Statement();
      break;
    default:
      jj_la1[137] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void ExpressionStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
    case SIZEOF:
    case ALIGNOF:
    case IDENTIFIER:
    case 149:
    case 157:
    case 158:
    case 161:
    case 162:
    case 188:
    case 189:
    case 190:
    case 191:
      Expression();
      break;
    default:
      jj_la1[138] = jj_gen;
      ;
    }
    jj_consume_token(148);
  }

  final public void CompoundStatement() throws ParseException {
    jj_consume_token(146);
    if (jj_2_41(1)) {
      StatementList();
    } else {
      ;
    }
    jj_consume_token(147);
  }

  final public void StatementList() throws ParseException {
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LINE:
      case LINEALT:
        LineDef();
        break;
      default:
        jj_la1[139] = jj_gen;
        if (jj_2_42(1)) {
          Statement();
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_43(1)) {
        ;
      } else {
        break label_34;
      }
    }
  }

  final public void AsmStatement() throws ParseException {
   Declaration dec = new Declaration();
    jj_consume_token(ASM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOLATILE:
    case STATIC:
    case CONST:
    case DECLSPEC:
    case READABLETO:
    case CDECL:
    case STDCALL:
    case FASTCALL:
    case VECTORCALL:
    case RUSTCALL:
    case PASCALCALL:
    case NORETURN:
    case ALIGNAS:
    case UNALIGNED:
    case PACKED:
    case ATTRIBUTE:
    case EXTENSION:
    case RESTRICT:
    case ASM:
    case INLINE:
    case PTR64:
    case PTR32:
    case W64:
    case NEAR:
    case FAR:
    case 151:
      TypeQualifier(dec);
      break;
    default:
      jj_la1[140] = jj_gen;
      ;
    }
    AsmLine();
  }

  final public void AsmLine() throws ParseException {
    Declaration dec = new Declaration();
    label_35:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IDENTIFIER:
        jj_consume_token(IDENTIFIER);
        break;
      case STRING_LITERAL:
        jj_consume_token(STRING_LITERAL);
        break;
      case INTEGER_LITERAL:
        jj_consume_token(INTEGER_LITERAL);
        break;
      case ATTRIBUTE:
        jj_consume_token(ATTRIBUTE);
        break;
      case UNSIGNED:
      case DOUBLE:
      case SIGNED:
      case FLOAT:
      case SHORT:
      case LONG:
      case INT8:
      case INT16:
      case INT32:
      case INT64:
      case BOOL:
      case VOID:
      case CHAR:
      case INT:
        BuiltInTypeSpecifier(dec);
        break;
      case 156:
        jj_consume_token(156);
        break;
      case 161:
        jj_consume_token(161);
        break;
      case 162:
        jj_consume_token(162);
        break;
      case 153:
        jj_consume_token(153);
        break;
      case 154:
        jj_consume_token(154);
        break;
      case 157:
        jj_consume_token(157);
        break;
      case 151:
        jj_consume_token(151);
        AsmLine();
        jj_consume_token(152);
        break;
      case 149:
        jj_consume_token(149);
        AsmLine();
        jj_consume_token(150);
        break;
      case 146:
        jj_consume_token(146);
        AsmLine();
        jj_consume_token(147);
        break;
      default:
        jj_la1[141] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case STRING_LITERAL:
      case UNSIGNED:
      case DOUBLE:
      case SIGNED:
      case ATTRIBUTE:
      case FLOAT:
      case SHORT:
      case LONG:
      case INT8:
      case INT16:
      case INT32:
      case INT64:
      case BOOL:
      case VOID:
      case CHAR:
      case INT:
      case IDENTIFIER:
      case 146:
      case 149:
      case 151:
      case 153:
      case 154:
      case 156:
      case 157:
      case 161:
      case 162:
        ;
        break;
      default:
        jj_la1[142] = jj_gen;
        break label_35;
      }
    }
  }

  final public void SelectionStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(149);
      Expression();
      jj_consume_token(150);
      Statement();
      if (jj_2_44(2)) {
        jj_consume_token(ELSE);
        Statement();
      } else {
        ;
      }
      break;
    case SWITCH:
      jj_consume_token(SWITCH);
      jj_consume_token(149);
      Expression();
      jj_consume_token(150);
      Statement();
      break;
    default:
      jj_la1[143] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void IterationStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHILE:
      jj_consume_token(WHILE);
      jj_consume_token(149);
      Expression();
      jj_consume_token(150);
      Statement();
      break;
    case DO:
      jj_consume_token(DO);
      Statement();
      jj_consume_token(WHILE);
      jj_consume_token(149);
      Expression();
      jj_consume_token(150);
      jj_consume_token(148);
      break;
    case FOR:
      jj_consume_token(FOR);
      jj_consume_token(149);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        Expression();
        break;
      default:
        jj_la1[144] = jj_gen;
        ;
      }
      jj_consume_token(148);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        Expression();
        break;
      default:
        jj_la1[145] = jj_gen;
        ;
      }
      jj_consume_token(148);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        Expression();
        break;
      default:
        jj_la1[146] = jj_gen;
        ;
      }
      jj_consume_token(150);
      Statement();
      break;
    default:
      jj_la1[147] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void JumpStatement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GOTO:
      jj_consume_token(GOTO);
      jj_consume_token(IDENTIFIER);
      jj_consume_token(148);
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
      jj_consume_token(148);
      break;
    case BREAK:
      jj_consume_token(BREAK);
      jj_consume_token(148);
      break;
    case RETURN:
      jj_consume_token(RETURN);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        Expression();
        break;
      default:
        jj_la1[148] = jj_gen;
        ;
      }
      jj_consume_token(148);
      break;
    default:
      jj_la1[149] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Object Expression() throws ParseException {
   Object obj = null;
    obj = AssignmentExpression();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        ;
        break;
      default:
        jj_la1[150] = jj_gen;
        break label_36;
      }
      jj_consume_token(153);
      obj = AssignmentExpression();
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object AssignmentExpression() throws ParseException {
   Object obj = null;
    if (jj_2_45(2147483647)) {
      UnaryExpression();
      AssignmentOperator();
      obj = AssignmentExpression();
    } else if (jj_2_46(3)) {
      obj = ConditionalExpression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRAGMA:
    case PRAGMA_FUNC:
      PragmaSpec();
      break;
    default:
      jj_la1[151] = jj_gen;
      ;
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public void AssignmentOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 155:
      jj_consume_token(155);
      break;
    case 163:
      jj_consume_token(163);
      break;
    case 164:
      jj_consume_token(164);
      break;
    case 165:
      jj_consume_token(165);
      break;
    case 166:
      jj_consume_token(166);
      break;
    case 167:
      jj_consume_token(167);
      break;
    case 168:
      jj_consume_token(168);
      break;
    case 169:
      jj_consume_token(169);
      break;
    case 170:
      jj_consume_token(170);
      break;
    case 171:
      jj_consume_token(171);
      break;
    case 172:
      jj_consume_token(172);
      break;
    default:
      jj_la1[152] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Object ConditionalExpression() throws ParseException {
    Object obj = null;
    Object objTrue = null, objFalse = null;
    obj = LogicalORExpression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 173:
      jj_consume_token(173);
      objTrue = Expression();
      jj_consume_token(154);
      objFalse = ConditionalExpression();
                                                                                                  obj = computeTernaryValue(obj, objTrue, objFalse);
      break;
    default:
      jj_la1[153] = jj_gen;
      ;
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object ConstantExpression() throws ParseException {
    Object obj = null;
    obj = ConditionalExpression();
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object LogicalORExpression() throws ParseException {
   Object obj = null, obj2 = null; Token op=null;
    obj = LogicalANDExpression();
    label_37:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 174:
        ;
        break;
      default:
        jj_la1[154] = jj_gen;
        break label_37;
      }
      op = jj_consume_token(174);
      obj2 = LogicalANDExpression();
                                                                           obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object LogicalANDExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = InclusiveORExpression();
    label_38:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 175:
        ;
        break;
      default:
        jj_la1[155] = jj_gen;
        break label_38;
      }
      op = jj_consume_token(175);
      obj2 = InclusiveORExpression();
                                                                           obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object InclusiveORExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = ExclusiveORExpression();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 176:
        ;
        break;
      default:
        jj_la1[156] = jj_gen;
        break label_39;
      }
      op = jj_consume_token(176);
      obj2 = ExclusiveORExpression();
                                                                          obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object ExclusiveORExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = ANDExpression();
    label_40:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 177:
        ;
        break;
      default:
        jj_la1[157] = jj_gen;
        break label_40;
      }
      op = jj_consume_token(177);
      obj2 = ANDExpression();
                                                          obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object ANDExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = EqualityExpression();
    label_41:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 158:
        ;
        break;
      default:
        jj_la1[158] = jj_gen;
        break label_41;
      }
      op = jj_consume_token(158);
      obj2 = EqualityExpression();
                                                                    obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object EqualityExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = RelationalExpression();
    label_42:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 178:
      case 179:
        ;
        break;
      default:
        jj_la1[159] = jj_gen;
        break label_42;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 178:
        op = jj_consume_token(178);
        break;
      case 179:
        op = jj_consume_token(179);
        break;
      default:
        jj_la1[160] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = RelationalExpression();
                                                           obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object RelationalExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = ShiftExpression();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 180:
      case 181:
      case 182:
      case 183:
        ;
        break;
      default:
        jj_la1[161] = jj_gen;
        break label_43;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 180:
        op = jj_consume_token(180);
        break;
      case 181:
        op = jj_consume_token(181);
        break;
      case 182:
        op = jj_consume_token(182);
        break;
      case 183:
        op = jj_consume_token(183);
        break;
      default:
        jj_la1[162] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = ShiftExpression();
                                                                     obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object ShiftExpression() throws ParseException {
   Object obj = null, obj2 = null; Token op=null;
    obj = AdditiveExpression();
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 184:
      case 185:
        ;
        break;
      default:
        jj_la1[163] = jj_gen;
        break label_44;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 184:
        op = jj_consume_token(184);
        break;
      case 185:
        op = jj_consume_token(185);
        break;
      default:
        jj_la1[164] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = AdditiveExpression();
         obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object AdditiveExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = MultiplicativeExpression();
    label_45:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 161:
      case 162:
        ;
        break;
      default:
        jj_la1[165] = jj_gen;
        break label_45;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 161:
        op = jj_consume_token(161);
        break;
      case 162:
        op = jj_consume_token(162);
        break;
      default:
        jj_la1[166] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = MultiplicativeExpression();
        obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object MultiplicativeExpression() throws ParseException {
    Object obj = null, obj2 = null; Token op=null;
    obj = CastExpression();
    label_46:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 157:
      case 186:
      case 187:
        ;
        break;
      default:
        jj_la1[167] = jj_gen;
        break label_46;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 157:
        op = jj_consume_token(157);
        break;
      case 186:
        op = jj_consume_token(186);
        break;
      case 187:
        op = jj_consume_token(187);
        break;
      default:
        jj_la1[168] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      obj2 = CastExpression();
        obj = computeBinaryValue(obj, op, obj2);
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object CastExpression() throws ParseException {
    Object obj = null;
    if (jj_2_47(2147483647)) {
      jj_consume_token(149);
      TypeName();
      jj_consume_token(150);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        obj = CastExpression();
        break;
      case 146:
        jj_consume_token(146);
        InitializerList();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 153:
          jj_consume_token(153);
          break;
        default:
          jj_la1[169] = jj_gen;
          ;
        }
        jj_consume_token(147);
        break;
      default:
        jj_la1[170] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case INTEGER_LITERAL:
      case FLOATING_POINT_LITERAL:
      case CHARACTER_LITERAL:
      case STRING_LITERAL:
      case SIZEOF:
      case ALIGNOF:
      case IDENTIFIER:
      case 149:
      case 157:
      case 158:
      case 161:
      case 162:
      case 188:
      case 189:
      case 190:
      case 191:
        obj = UnaryExpression();
        break;
      default:
        jj_la1[171] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object UnaryExpression() throws ParseException {
     Object obj = null;
     Token op = null;
     Declaration dec = null;
    if (jj_2_49(3)) {
      obj = PostfixExpression();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 157:
      case 158:
        UnaryOperator();
        CastExpression();
        break;
      case 188:
        jj_consume_token(188);
        UnaryExpression();
        break;
      case 189:
        jj_consume_token(189);
        UnaryExpression();
        break;
      case 161:
        jj_consume_token(161);
        obj = CastExpression();
        break;
      case 162:
        op = jj_consume_token(162);
        obj = CastExpression();
                                      obj = computeUnaryValue(obj, op);
        break;
      case 190:
        op = jj_consume_token(190);
        obj = CastExpression();
                                      obj = computeUnaryValue(obj, op);
        break;
      case 191:
        op = jj_consume_token(191);
        obj = CastExpression();
                                      obj = computeUnaryValue(obj, op);
        break;
      case SIZEOF:
        jj_consume_token(SIZEOF);
        jj_consume_token(149);
        if (jj_2_48(1)) {
          dec = TypeName();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case INTEGER_LITERAL:
          case FLOATING_POINT_LITERAL:
          case CHARACTER_LITERAL:
          case STRING_LITERAL:
          case SIZEOF:
          case ALIGNOF:
          case IDENTIFIER:
          case 149:
          case 157:
          case 158:
          case 161:
          case 162:
          case 188:
          case 189:
          case 190:
          case 191:
            obj = UnaryExpression();
            break;
          default:
            jj_la1[172] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        jj_consume_token(150);
                if (obj != null && obj instanceof String) {
                    obj = Long.valueOf(((String) obj).length() - 1); // will include "" plus \0
                }
                else if (dec != null) {
                    obj = Long.valueOf(dec.getDataType().clone(dtMgr).getLength());
                }
                else if (obj != null) {
                   // TODO: try to look up the type of the identifier
                   // TODO: Throw error if identifier is not defined
                   //       may need to actually track declarations!
                }
        break;
      case ALIGNOF:
        jj_consume_token(ALIGNOF);
        jj_consume_token(149);
        dec = TypeName();
        jj_consume_token(150);

        break;
      default:
        jj_la1[173] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public void UnaryOperator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case 158:
      jj_consume_token(158);
      break;
    case 157:
      jj_consume_token(157);
      break;
    default:
      jj_la1[174] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public Object PostfixExpression() throws ParseException {
     Object obj = null;
    obj = PrimaryExpression();
    label_47:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 149:
      case 151:
      case 160:
      case 188:
      case 189:
      case 192:
        ;
        break;
      default:
        jj_la1[175] = jj_gen;
        break label_47;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 151:
        jj_consume_token(151);
        Expression();
        jj_consume_token(152);
        break;
      case 149:
        jj_consume_token(149);
        if (jj_2_50(2147483647)) {
          ArgumentExpressionList();
        } else {
          ;
        }
        jj_consume_token(150);
        break;
      case 160:
        jj_consume_token(160);
        jj_consume_token(IDENTIFIER);
        break;
      case 192:
        jj_consume_token(192);
        jj_consume_token(IDENTIFIER);
        break;
      case 188:
        jj_consume_token(188);
        break;
      case 189:
        jj_consume_token(189);
        break;
      default:
        jj_la1[176] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public Object PrimaryExpression() throws ParseException {
    Object obj = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IDENTIFIER:
      obj = jj_consume_token(IDENTIFIER);
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case CHARACTER_LITERAL:
    case STRING_LITERAL:
      obj = Constant();
      break;
    case 149:
      jj_consume_token(149);
      obj = Expression();
      jj_consume_token(150);
      break;
    default:
      jj_la1[177] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  final public void ArgumentExpressionList() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRAGMA:
    case PRAGMA_FUNC:
      PragmaSpec();
      break;
    default:
      jj_la1[178] = jj_gen;
      ;
    }
    AssignmentExpression();
    label_48:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 153:
        ;
        break;
      default:
        jj_la1[179] = jj_gen;
        break label_48;
      }
      jj_consume_token(153);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRAGMA:
      case PRAGMA_FUNC:
        PragmaSpec();
        break;
      default:
        jj_la1[180] = jj_gen;
        ;
      }
      AssignmentExpression();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRAGMA:
    case PRAGMA_FUNC:
      PragmaSpec();
      break;
    default:
      jj_la1[181] = jj_gen;
      ;
    }
  }

  final public Object Constant() throws ParseException {
    Token t;
    Object obj= null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
      t = jj_consume_token(INTEGER_LITERAL);
            String sval = t.image;
            if (sval.endsWith("i8") || sval.endsWith("I8")) {
                sval = sval.substring(0,sval.length()-2);
            }
            else if (sval.endsWith("i16") || sval.endsWith("I16")) {
                sval = sval.substring(0,sval.length()-3);
            }
            else if (sval.endsWith("i32") || sval.endsWith("I32")) {
                sval = sval.substring(0,sval.length()-3);
            }
            else if (sval.endsWith("i64") || sval.endsWith("I64")) {
                sval = sval.substring(0,sval.length()-3);
            }

            if (sval.endsWith("ull") || sval.endsWith("ULL")) {
                sval = sval.substring(0,sval.length()-3);
            }
            else if (sval.endsWith("ll") || sval.endsWith("LL")) {
                sval = sval.substring(0,sval.length()-2);
            }
            else if (sval.endsWith("ul") || sval.endsWith("UL")) {
                sval = sval.substring(0,sval.length()-2);
            }
            else if (sval.endsWith("l") || sval.endsWith("L")) {
                sval = sval.substring(0,sval.length()-1);
            }
            else if (sval.endsWith("u") || sval.endsWith("U")) {
                sval = sval.substring(0,sval.length()-1);
            }
            if (sval.startsWith("0x") || sval.startsWith("0X")) {
                BigInteger bigConst = new BigInteger(sval.substring(2), 16);
                obj = Long.valueOf(bigConst.longValue());
            }
            else {
                BigInteger bigConst = new BigInteger(sval);
                obj = Long.valueOf(bigConst.longValue());
            }
      break;
    case FLOATING_POINT_LITERAL:
      t = jj_consume_token(FLOATING_POINT_LITERAL);
            obj = new Double(t.image);
      break;
    case CHARACTER_LITERAL:
      t = jj_consume_token(CHARACTER_LITERAL);
            if (t.image.length() == 1) {
              obj = new Character(t.image.charAt(0));
            } else if (t.image.length() == 4) {
              long cval = ((long)t.image.charAt(0) << 24) + ((long)t.image.charAt(1) << 16) + ((long)t.image.charAt(2) << 8) + ((long) t.image.charAt(3));
              obj = Long.valueOf(cval);
            }
      break;
    case STRING_LITERAL:
      t = MultiLineString();
            obj = t.image;
      break;
    default:
      jj_la1[182] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return obj;}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_9(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(8, xla); }
  }

  private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_10(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(9, xla); }
  }

  private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_11(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(10, xla); }
  }

  private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_12(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(11, xla); }
  }

  private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_13(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(12, xla); }
  }

  private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_14(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(13, xla); }
  }

  private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_15(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(14, xla); }
  }

  private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_16(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(15, xla); }
  }

  private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_17(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(16, xla); }
  }

  private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_18(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(17, xla); }
  }

  private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_19(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(18, xla); }
  }

  private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_20(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(19, xla); }
  }

  private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_21(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(20, xla); }
  }

  private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_22(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(21, xla); }
  }

  private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_23(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(22, xla); }
  }

  private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_24(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(23, xla); }
  }

  private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_25(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(24, xla); }
  }

  private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_26(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(25, xla); }
  }

  private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_27(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(26, xla); }
  }

  private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_28(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(27, xla); }
  }

  private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_29(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(28, xla); }
  }

  private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_30(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(29, xla); }
  }

  private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_31(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(30, xla); }
  }

  private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_32(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(31, xla); }
  }

  private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_33(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(32, xla); }
  }

  private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_34(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(33, xla); }
  }

  private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_35(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(34, xla); }
  }

  private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_36(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(35, xla); }
  }

  private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_37(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(36, xla); }
  }

  private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_38(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(37, xla); }
  }

  private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_39(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(38, xla); }
  }

  private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_40(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(39, xla); }
  }

  private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_41(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(40, xla); }
  }

  private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_42(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(41, xla); }
  }

  private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_43(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(42, xla); }
  }

  private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_44(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(43, xla); }
  }

  private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_45(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(44, xla); }
  }

  private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_46(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(45, xla); }
  }

  private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_47(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(46, xla); }
  }

  private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_48(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(47, xla); }
  }

  private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_49(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(48, xla); }
  }

  private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_50(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(49, xla); }
  }

  private boolean jj_3R_205() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_144() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(85)) {
    jj_scanpos = xsp;
    if (jj_scan_token(86)) return true;
    }
    if (jj_scan_token(LINENUMBER_LITERAL)) return true;
    if (jj_scan_token(PATH_LITERAL)) return true;
    xsp = jj_scanpos;
    if (jj_3R_376()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_204() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_157() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_124() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_203() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_50() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_70() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_124()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_225() {
    if (jj_scan_token(192)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_88() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_3R_51()) return true;
    if (jj_scan_token(146)) return true;
    return false;
  }

  private boolean jj_3R_224() {
    if (jj_scan_token(160)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_87() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_272() {
    if (jj_3R_84()) return true;
    return false;
  }

  private boolean jj_3R_86() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_223() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_300() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_158() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) {
    jj_scanpos = xsp;
    if (jj_3R_224()) {
    jj_scanpos = xsp;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_scan_token(188)) {
    jj_scanpos = xsp;
    if (jj_scan_token(189)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_222() {
    if (jj_scan_token(151)) return true;
    if (jj_3R_219()) return true;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_85() {
    if (jj_3R_51()) return true;
    return false;
  }

  private boolean jj_3R_69() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_336() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_192()) return true;
    return false;
  }

  private boolean jj_3_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) jj_scanpos = xsp;
    if (jj_scan_token(146)) return true;
    if (jj_3R_70()) return true;
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) {
    jj_scanpos = xsp;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_86()) {
    jj_scanpos = xsp;
    if (jj_3R_87()) {
    jj_scanpos = xsp;
    if (jj_3R_88()) {
    jj_scanpos = xsp;
    if (jj_scan_token(148)) return true;
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_68() {
    if (jj_scan_token(154)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_83() {
    if (jj_3R_157()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_158()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_172() {
    if (jj_scan_token(ENUM)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) {
    jj_scanpos = xsp;
    if (jj_3R_300()) return true;
    }
    return false;
  }

  private boolean jj_3_1() {
    if (jj_3R_49()) return true;
    return false;
  }

  private boolean jj_3R_216() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_214() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(158)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) return true;
    }
    return false;
  }

  private boolean jj_3R_153() {
    if (jj_scan_token(ALIGNOF)) return true;
    if (jj_scan_token(149)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_283() {
    if (jj_scan_token(154)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3_48() {
    if (jj_3R_82()) return true;
    return false;
  }

  private boolean jj_3_29() {
    if (jj_3R_67()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_68()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_245() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_29()) {
    jj_scanpos = xsp;
    if (jj_3R_283()) return true;
    }
    return false;
  }

  private boolean jj_3R_244() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_192() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_243()) {
    jj_scanpos = xsp;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_243() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_27() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_152() {
    if (jj_scan_token(SIZEOF)) return true;
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_48()) {
    jj_scanpos = xsp;
    if (jj_3R_216()) return true;
    }
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_151() {
    if (jj_scan_token(191)) return true;
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_150() {
    if (jj_scan_token(190)) return true;
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_118() {
    if (jj_3R_192()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_336()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_149() {
    if (jj_scan_token(162)) return true;
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_148() {
    if (jj_scan_token(161)) return true;
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_196() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_147() {
    if (jj_scan_token(189)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_289() {
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3_26() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_146() {
    if (jj_scan_token(188)) return true;
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3R_145() {
    if (jj_3R_214()) return true;
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_195() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3_49() {
    if (jj_3R_83()) return true;
    return false;
  }

  private boolean jj_3_25() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_117() {
    if (jj_3R_57()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_196()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_194() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_79() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) {
    jj_scanpos = xsp;
    if (jj_3R_146()) {
    jj_scanpos = xsp;
    if (jj_3R_147()) {
    jj_scanpos = xsp;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_290() {
    if (jj_scan_token(146)) return true;
    if (jj_3R_311()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(153)) jj_scanpos = xsp;
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3_47() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_193() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_268() {
    if (jj_3R_79()) return true;
    return false;
  }

  private boolean jj_3_28() {
    if (jj_3R_56()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_194()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_195()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_267() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_82()) return true;
    if (jj_scan_token(150)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_289()) {
    jj_scanpos = xsp;
    if (jj_3R_290()) return true;
    }
    return false;
  }

  private boolean jj_3R_116() {
    if (jj_3R_58()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_193()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_215() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) {
    jj_scanpos = xsp;
    if (jj_3R_268()) return true;
    }
    return false;
  }

  private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3_28()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_391() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(186)) {
    jj_scanpos = xsp;
    if (jj_scan_token(187)) return true;
    }
    }
    if (jj_3R_215()) return true;
    return false;
  }

  private boolean jj_3R_382() {
    if (jj_3R_215()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_391()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_65() {
    if (jj_3R_118()) return true;
    return false;
  }

  private boolean jj_3R_66() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_301() {
    if (jj_scan_token(155)) return true;
    if (jj_3R_315()) return true;
    return false;
  }

  private boolean jj_3_23() {
    if (jj_3R_64()) return true;
    return false;
  }

  private boolean jj_3R_383() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) return true;
    }
    if (jj_3R_382()) return true;
    return false;
  }

  private boolean jj_3R_372() {
    if (jj_3R_382()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_383()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_256() {
    if (jj_scan_token(146)) return true;
    if (jj_3R_132()) return true;
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3_24() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_66()) jj_scanpos = xsp;
    if (jj_scan_token(148)) return true;
    return false;
  }

  private boolean jj_3R_115() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_114() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_113() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3R_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_113()) {
    jj_scanpos = xsp;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3_24()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_373() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(184)) {
    jj_scanpos = xsp;
    if (jj_scan_token(185)) return true;
    }
    if (jj_3R_372()) return true;
    return false;
  }

  private boolean jj_3R_358() {
    if (jj_3R_372()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_373()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_328() {
    if (jj_scan_token(158)) return true;
    if (jj_3R_327()) return true;
    return false;
  }

  private boolean jj_3R_274() {
    if (jj_3R_67()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_301()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_359() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(180)) {
    jj_scanpos = xsp;
    if (jj_scan_token(181)) {
    jj_scanpos = xsp;
    if (jj_scan_token(182)) {
    jj_scanpos = xsp;
    if (jj_scan_token(183)) return true;
    }
    }
    }
    if (jj_3R_358()) return true;
    return false;
  }

  private boolean jj_3R_255() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_132()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_343() {
    if (jj_3R_358()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_359()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_275() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_274()) return true;
    return false;
  }

  private boolean jj_3R_233() {
    if (jj_3R_274()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_275()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_344() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(178)) {
    jj_scanpos = xsp;
    if (jj_scan_token(179)) return true;
    }
    if (jj_3R_343()) return true;
    return false;
  }

  private boolean jj_3R_313() {
    if (jj_scan_token(177)) return true;
    if (jj_3R_312()) return true;
    return false;
  }

  private boolean jj_3R_292() {
    if (jj_scan_token(176)) return true;
    if (jj_3R_291()) return true;
    return false;
  }

  private boolean jj_3_22() {
    if (jj_3R_63()) return true;
    return false;
  }

  private boolean jj_3R_327() {
    if (jj_3R_343()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_344()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_60() {
    Token xsp;
    if (jj_3_22()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_22()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_397() {
    if (jj_scan_token(156)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_347() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_331() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_254() {
    if (jj_scan_token(151)) return true;
    if (jj_3R_132()) return true;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_270() {
    if (jj_scan_token(175)) return true;
    if (jj_3R_269()) return true;
    return false;
  }

  private boolean jj_3R_312() {
    if (jj_3R_327()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_328()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_62() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_277() {
    if (jj_scan_token(UNION)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_331()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_218() {
    if (jj_scan_token(174)) return true;
    if (jj_3R_217()) return true;
    return false;
  }

  private boolean jj_3R_346() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_330() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) return true;
    }
    return false;
  }

  private boolean jj_3R_291() {
    if (jj_3R_312()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_313()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_389() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_3R_397()) return true;
    }
    return false;
  }

  private boolean jj_3R_269() {
    if (jj_3R_291()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_292()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_276() {
    if (jj_scan_token(STRUCT)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_330()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_111() {
    if (jj_scan_token(154)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_377() {
    if (jj_scan_token(153)) return true;
    Token xsp;
    if (jj_3R_389()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_389()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_235() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) {
    jj_scanpos = xsp;
    if (jj_3R_277()) return true;
    }
    return false;
  }

  private boolean jj_3R_155() {
    if (jj_scan_token(173)) return true;
    if (jj_3R_219()) return true;
    if (jj_scan_token(154)) return true;
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_217() {
    if (jj_3R_269()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_270()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_396() {
    if (jj_scan_token(PCOMMA)) return true;
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_388() {
    Token xsp;
    if (jj_3R_396()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_396()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_20() {
    if (jj_3R_60()) return true;
    return false;
  }

  private boolean jj_3R_401() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(109)) return true;
    }
    return false;
  }

  private boolean jj_3R_266() {
    if (jj_scan_token(RETURN)) return true;
    return false;
  }

  private boolean jj_3R_154() {
    if (jj_3R_217()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_218()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_61() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_111()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_61()) jj_scanpos = xsp;
    if (jj_scan_token(146)) return true;
    xsp = jj_scanpos;
    if (jj_3_20()) jj_scanpos = xsp;
    if (jj_scan_token(147)) return true;
    xsp = jj_scanpos;
    if (jj_3R_62()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_400() {
    if (jj_scan_token(POPEN)) return true;
    if (jj_scan_token(PCLOSE)) return true;
    return false;
  }

  private boolean jj_3R_399() {
    if (jj_scan_token(PCOLON)) return true;
    Token xsp;
    if (jj_3R_401()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_401()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_123() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_265() {
    if (jj_scan_token(BREAK)) return true;
    return false;
  }

  private boolean jj_3R_171() {
    if (jj_3R_235()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_21()) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) return true;
    }
    return false;
  }

  private boolean jj_3R_297() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_81() {
    if (jj_3R_154()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_155()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_253() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_395() {
    if (jj_scan_token(PIDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_400()) jj_scanpos = xsp;
    if (jj_scan_token(PSTRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_392() {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_80() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(155)) {
    jj_scanpos = xsp;
    if (jj_scan_token(163)) {
    jj_scanpos = xsp;
    if (jj_scan_token(164)) {
    jj_scanpos = xsp;
    if (jj_scan_token(165)) {
    jj_scanpos = xsp;
    if (jj_scan_token(166)) {
    jj_scanpos = xsp;
    if (jj_scan_token(167)) {
    jj_scanpos = xsp;
    if (jj_scan_token(168)) {
    jj_scanpos = xsp;
    if (jj_scan_token(169)) {
    jj_scanpos = xsp;
    if (jj_scan_token(170)) {
    jj_scanpos = xsp;
    if (jj_scan_token(171)) {
    jj_scanpos = xsp;
    if (jj_scan_token(172)) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_45() {
    if (jj_3R_79()) return true;
    if (jj_3R_80()) return true;
    return false;
  }

  private boolean jj_3R_394() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_3R_399()) return true;
    }
    return false;
  }

  private boolean jj_3R_375() {
    if (jj_scan_token(PCOMMA)) return true;
    if (jj_3R_374()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_388()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_264() {
    if (jj_scan_token(CONTINUE)) return true;
    return false;
  }

  private boolean jj_3R_227() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3_46() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3R_164() {
    if (jj_scan_token(STATICASSERT)) return true;
    if (jj_scan_token(149)) return true;
    if (jj_3R_123()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_377()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_226() {
    if (jj_3R_79()) return true;
    if (jj_3R_80()) return true;
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_160() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_226()) {
    jj_scanpos = xsp;
    if (jj_3_46()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_227()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_390() {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_398() {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_387() {
    if (jj_scan_token(PSTRING_LITERAL)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_395()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_219() {
    if (jj_3R_160()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_297()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_135() {
    if (jj_scan_token(DFLT)) return true;
    if (jj_scan_token(154)) return true;
    return false;
  }

  private boolean jj_3R_393() {
    if (jj_scan_token(POPEN)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_398()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(PCLOSE)) return true;
    return false;
  }

  private boolean jj_3R_386() {
    if (jj_scan_token(PIDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_394()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_263() {
    if (jj_scan_token(GOTO)) return true;
    return false;
  }

  private boolean jj_3R_385() {
    Token xsp;
    if (jj_3R_393()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_393()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_213() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) {
    jj_scanpos = xsp;
    if (jj_3R_266()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_384() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(116)) {
    jj_scanpos = xsp;
    if (jj_scan_token(115)) {
    jj_scanpos = xsp;
    if (jj_scan_token(114)) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_392()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_262() {
    if (jj_scan_token(FOR)) return true;
    return false;
  }

  private boolean jj_3R_261() {
    if (jj_scan_token(DO)) return true;
    return false;
  }

  private boolean jj_3R_374() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_3R_384()) {
    jj_scanpos = xsp;
    if (jj_3R_385()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_260() {
    if (jj_scan_token(WHILE)) return true;
    return false;
  }

  private boolean jj_3R_361() {
    if (jj_scan_token(PCOMMA)) return true;
    if (jj_3R_374()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_375()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_379() {
    if (jj_scan_token(153)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_390()) return true;
    }
    return false;
  }

  private boolean jj_3R_369() {
    Token xsp;
    if (jj_3R_379()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_379()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_212() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_44() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_259() {
    if (jj_scan_token(SWITCH)) return true;
    return false;
  }

  private boolean jj_3R_258() {
    if (jj_scan_token(IF)) return true;
    return false;
  }

  private boolean jj_3R_211() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_258()) {
    jj_scanpos = xsp;
    if (jj_3R_259()) return true;
    }
    return false;
  }

  private boolean jj_3R_368() {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_scan_token(17)) {
    jj_scanpos = xsp;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_scan_token(53)) {
    jj_scanpos = xsp;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(161)) {
    jj_scanpos = xsp;
    if (jj_scan_token(162)) {
    jj_scanpos = xsp;
    if (jj_scan_token(153)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_3R_254()) {
    jj_scanpos = xsp;
    if (jj_3R_255()) {
    jj_scanpos = xsp;
    if (jj_3R_256()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_132() {
    Token xsp;
    if (jj_3R_208()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_208()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_360() {
    if (jj_3R_374()) return true;
    return false;
  }

  private boolean jj_3R_345() {
    Token xsp;
    if (jj_3R_360()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_360()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_361()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_189() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(109)) {
    jj_scanpos = xsp;
    if (jj_scan_token(119)) {
    jj_scanpos = xsp;
    if (jj_scan_token(123)) {
    jj_scanpos = xsp;
    if (jj_scan_token(118)) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_131() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_134() {
    if (jj_scan_token(CASE)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_190() {
    if (jj_scan_token(POPEN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_345()) jj_scanpos = xsp;
    if (jj_scan_token(PCLOSE)) return true;
    return false;
  }

  private boolean jj_3R_75() {
    if (jj_scan_token(ASM)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_131()) jj_scanpos = xsp;
    if (jj_3R_132()) return true;
    return false;
  }

  private boolean jj_3R_355() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_368()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_369()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3_42() {
    if (jj_3R_77()) return true;
    return false;
  }

  private boolean jj_3R_364() {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_78() {
    if (jj_3R_144()) return true;
    return false;
  }

  private boolean jj_3_43() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_78()) {
    jj_scanpos = xsp;
    if (jj_3_42()) return true;
    }
    return false;
  }

  private boolean jj_3R_110() {
    if (jj_scan_token(PIDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_189()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_190()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_50() {
    Token xsp;
    if (jj_3_43()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_43()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_41() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_366() {
    if (jj_scan_token(155)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3_19() {
    if (jj_scan_token(POPEN)) return true;
    if (jj_3R_59()) return true;
    if (jj_scan_token(PCLOSE)) return true;
    return false;
  }

  private boolean jj_3R_59() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_19()) {
    jj_scanpos = xsp;
    if (jj_3R_110()) return true;
    }
    return false;
  }

  private boolean jj_3R_298() {
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_363() {
    if (jj_scan_token(149)) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_335() {
    if (jj_3R_334()) return true;
    return false;
  }

  private boolean jj_3R_210() {
    if (jj_scan_token(146)) return true;
    return false;
  }

  private boolean jj_3R_257() {
    if (jj_3R_219()) return true;
    return false;
  }

  private boolean jj_3R_230() {
    if (jj_scan_token(PRAGMA_FUNC)) return true;
    if (jj_3R_59()) return true;
    return false;
  }

  private boolean jj_3R_209() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_257()) jj_scanpos = xsp;
    if (jj_scan_token(148)) return true;
    return false;
  }

  private boolean jj_3R_163() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_229()) {
    jj_scanpos = xsp;
    if (jj_3R_230()) return true;
    }
    return false;
  }

  private boolean jj_3R_229() {
    if (jj_scan_token(PRAGMA)) return true;
    Token xsp;
    if (jj_3R_298()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_298()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_133() {
    if (jj_scan_token(IDENTIFIER)) return true;
    if (jj_scan_token(154)) return true;
    return false;
  }

  private boolean jj_3R_76() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_133()) {
    jj_scanpos = xsp;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_367() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_143() {
    if (jj_3R_164()) return true;
    return false;
  }

  private boolean jj_3R_362() {
    if (jj_scan_token(154)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_142() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_378() {
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_141() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_140() {
    if (jj_3R_213()) return true;
    return false;
  }

  private boolean jj_3R_314() {
    if (jj_scan_token(STRING_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_317() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_334()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_335()) { jj_scanpos = xsp; break; }
    }
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_299() {
    Token xsp;
    if (jj_3R_314()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_314()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_139() {
    if (jj_3R_212()) return true;
    return false;
  }

  private boolean jj_3R_138() {
    if (jj_3R_211()) return true;
    return false;
  }

  private boolean jj_3R_365() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_378()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_351() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) return true;
    }
    return false;
  }

  private boolean jj_3R_137() {
    if (jj_3R_210()) return true;
    return false;
  }

  private boolean jj_3R_136() {
    if (jj_3R_209()) return true;
    return false;
  }

  private boolean jj_3R_349() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(156)) {
    jj_scanpos = xsp;
    if (jj_scan_token(154)) {
    jj_scanpos = xsp;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_363()) {
    jj_scanpos = xsp;
    if (jj_3R_364()) return true;
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_348() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_362()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_40() {
    if (jj_3R_76()) return true;
    return false;
  }

  private boolean jj_3R_334() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(10)) {
    jj_scanpos = xsp;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) return true;
    }
    }
    return false;
  }

  private boolean jj_3_39() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_316() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_303() {
    Token xsp;
    if (jj_3R_316()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_316()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_317()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_38() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_354() {
    if (jj_scan_token(154)) return true;
    if (jj_scan_token(154)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_367()) return true;
    }
    return false;
  }

  private boolean jj_3R_302() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_278()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_278() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_302()) {
    jj_scanpos = xsp;
    if (jj_3R_303()) return true;
    }
    return false;
  }

  private boolean jj_3R_77() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) {
    jj_scanpos = xsp;
    if (jj_3R_140()) {
    jj_scanpos = xsp;
    if (jj_3R_141()) {
    jj_scanpos = xsp;
    if (jj_3R_142()) {
    jj_scanpos = xsp;
    if (jj_3R_143()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_337() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_237() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_353() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_174() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) return true;
    }
    return false;
  }

  private boolean jj_3R_236() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(38)) {
    jj_scanpos = xsp;
    if (jj_scan_token(41)) return true;
    }
    if (jj_scan_token(149)) return true;
    if (jj_3R_278()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_352() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_173() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_323() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_350() {
    if (jj_3R_306()) return true;
    return false;
  }

  private boolean jj_3R_320() {
    if (jj_3R_271()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_353()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_338() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_356() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_321()) return true;
    return false;
  }

  private boolean jj_3R_341() {
    Token xsp;
    if (jj_3R_356()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_356()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_37() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_319() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_337()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_351()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_352()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_318() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_350()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_306() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_318()) {
    jj_scanpos = xsp;
    if (jj_3R_319()) {
    jj_scanpos = xsp;
    if (jj_3R_320()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_129() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_37()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_322() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_191() {
    if (jj_3R_242()) return true;
    return false;
  }

  private boolean jj_3R_329() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_112() {
    Token xsp;
    if (jj_3R_191()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_191()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_321() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(87)) {
    jj_scanpos = xsp;
    if (jj_3R_338()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_354()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_355()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_128() {
    if (jj_scan_token(151)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_329()) jj_scanpos = xsp;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_307() {
    if (jj_3R_321()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_341()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_35() {
    if (jj_3R_71()) return true;
    return false;
  }

  private boolean jj_3R_304() {
    if (jj_scan_token(ALIGNAS)) return true;
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) return true;
    }
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_282() {
    if (jj_3R_304()) return true;
    return false;
  }

  private boolean jj_3R_127() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_281() {
    if (jj_scan_token(151)) return true;
    if (jj_scan_token(151)) return true;
    if (jj_3R_307()) return true;
    if (jj_scan_token(152)) return true;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_207() {
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_280() {
    if (jj_3R_75()) return true;
    return false;
  }

  private boolean jj_3R_242() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) {
    jj_scanpos = xsp;
    if (jj_3R_281()) {
    jj_scanpos = xsp;
    if (jj_3R_282()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_279() {
    if (jj_scan_token(ATTRIBUTE)) return true;
    if (jj_scan_token(149)) return true;
    if (jj_3R_306()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_288() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_126() {
    if (jj_scan_token(151)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_207()) jj_scanpos = xsp;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_156() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_36() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_74()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_108() {
    if (jj_3R_174()) return true;
    return false;
  }

  private boolean jj_3R_73() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_36()) {
    jj_scanpos = xsp;
    if (jj_3R_126()) {
    jj_scanpos = xsp;
    if (jj_3R_127()) return true;
    }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_128()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_129()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_107() {
    if (jj_scan_token(NORETURN)) return true;
    return false;
  }

  private boolean jj_3R_106() {
    if (jj_scan_token(PASCALCALL)) return true;
    return false;
  }

  private boolean jj_3R_105() {
    if (jj_scan_token(RUSTCALL)) return true;
    return false;
  }

  private boolean jj_3R_130() {
    if (jj_3R_197()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_104() {
    if (jj_scan_token(VECTORCALL)) return true;
    return false;
  }

  private boolean jj_3R_103() {
    if (jj_scan_token(FASTCALL)) return true;
    return false;
  }

  private boolean jj_3_34() {
    if (jj_3R_73()) return true;
    return false;
  }

  private boolean jj_3R_102() {
    if (jj_scan_token(STDCALL)) return true;
    return false;
  }

  private boolean jj_3R_326() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_311()) return true;
    return false;
  }

  private boolean jj_3R_101() {
    if (jj_scan_token(CDECL)) return true;
    return false;
  }

  private boolean jj_3R_74() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_34()) {
    jj_scanpos = xsp;
    if (jj_3R_130()) return true;
    }
    return false;
  }

  private boolean jj_3R_100() {
    if (jj_scan_token(CONST)) return true;
    return false;
  }

  private boolean jj_3R_57() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_100()) {
    jj_scanpos = xsp;
    if (jj_scan_token(19)) {
    jj_scanpos = xsp;
    if (jj_3R_101()) {
    jj_scanpos = xsp;
    if (jj_scan_token(77)) {
    jj_scanpos = xsp;
    if (jj_scan_token(78)) {
    jj_scanpos = xsp;
    if (jj_3R_102()) {
    jj_scanpos = xsp;
    if (jj_3R_103()) {
    jj_scanpos = xsp;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) {
    jj_scanpos = xsp;
    if (jj_3R_107()) {
    jj_scanpos = xsp;
    if (jj_scan_token(71)) {
    jj_scanpos = xsp;
    if (jj_scan_token(68)) {
    jj_scanpos = xsp;
    if (jj_scan_token(69)) {
    jj_scanpos = xsp;
    if (jj_scan_token(57)) {
    jj_scanpos = xsp;
    if (jj_scan_token(55)) {
    jj_scanpos = xsp;
    if (jj_scan_token(54)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(52)) {
    jj_scanpos = xsp;
    if (jj_scan_token(51)) {
    jj_scanpos = xsp;
    if (jj_3R_108()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_371() {
    if (jj_3R_357()) return true;
    return false;
  }

  private boolean jj_3R_82() {
    if (jj_3R_64()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_156()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_333() {
    if (jj_scan_token(146)) return true;
    if (jj_3R_311()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(153)) jj_scanpos = xsp;
    if (jj_scan_token(147)) return true;
    return false;
  }

  private boolean jj_3R_99() {
    if (jj_3R_173()) return true;
    return false;
  }

  private boolean jj_3R_98() {
    if (jj_3R_172()) return true;
    return false;
  }

  private boolean jj_3R_97() {
    if (jj_3R_171()) return true;
    return false;
  }

  private boolean jj_3R_381() {
    if (jj_scan_token(160)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_380() {
    if (jj_scan_token(151)) return true;
    if (jj_3R_123()) return true;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_370() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) return true;
    }
    return false;
  }

  private boolean jj_3R_56() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) {
    jj_scanpos = xsp;
    if (jj_3R_98()) {
    jj_scanpos = xsp;
    jj_lookingAhead = true;
    jj_semLA = isType(getToken(1).image);
    jj_lookingAhead = false;
    if (!jj_semLA || jj_3R_99()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_357() {
    if (jj_3R_370()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_371()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_58() {
    if (jj_3R_109()) return true;
    return false;
  }

  private boolean jj_3R_342() {
    if (jj_3R_357()) return true;
    if (jj_scan_token(155)) return true;
    return false;
  }

  private boolean jj_3_18() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_325() {
    if (jj_3R_342()) return true;
    return false;
  }

  private boolean jj_3R_311() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_325()) jj_scanpos = xsp;
    if (jj_3R_315()) return true;
    xsp = jj_scanpos;
    if (jj_3R_326()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_332() {
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_188() {
    if (jj_scan_token(BOOL)) return true;
    return false;
  }

  private boolean jj_3R_315() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) return true;
    }
    return false;
  }

  private boolean jj_3R_187() {
    if (jj_scan_token(INT64)) return true;
    return false;
  }

  private boolean jj_3R_186() {
    if (jj_scan_token(INT32)) return true;
    return false;
  }

  private boolean jj_3R_241() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_185() {
    if (jj_scan_token(INT16)) return true;
    return false;
  }

  private boolean jj_3R_184() {
    if (jj_scan_token(INT8)) return true;
    return false;
  }

  private boolean jj_3R_340() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3_17() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_324() {
    if (jj_scan_token(153)) return true;
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_305() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_324()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_240() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_183() {
    if (jj_scan_token(UNSIGNED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_241()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_33() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_339() {
    if (jj_scan_token(155)) return true;
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_287() {
    if (jj_3R_74()) return true;
    return false;
  }

  private boolean jj_3_16() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_252() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_287()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_182() {
    if (jj_scan_token(SIGNED)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_240()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_181() {
    if (jj_scan_token(DOUBLE)) return true;
    return false;
  }

  private boolean jj_3R_251() {
    if (jj_3R_67()) return true;
    return false;
  }

  private boolean jj_3R_72() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_339()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_340()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_239() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_180() {
    if (jj_scan_token(FLOAT)) return true;
    return false;
  }

  private boolean jj_3_32() {
    if (jj_scan_token(153)) return true;
    if (jj_3R_72()) return true;
    return false;
  }

  private boolean jj_3R_125() {
    if (jj_3R_72()) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_32()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3_15() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_179() {
    if (jj_scan_token(LONG)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_238() {
    if (jj_3R_58()) return true;
    return false;
  }

  private boolean jj_3R_247() {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_310() {
    if (jj_scan_token(153)) return true;
    if (jj_scan_token(159)) return true;
    return false;
  }

  private boolean jj_3R_178() {
    if (jj_scan_token(INT)) return true;
    return false;
  }

  private boolean jj_3R_177() {
    if (jj_scan_token(SHORT)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_238()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_71() {
    if (jj_3R_125()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_310()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_246() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_96() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_176() {
    if (jj_scan_token(CHAR)) return true;
    return false;
  }

  private boolean jj_3R_55() {
    Token xsp;
    if (jj_3R_96()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_96()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_175() {
    if (jj_scan_token(VOID)) return true;
    return false;
  }

  private boolean jj_3R_109() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) {
    jj_scanpos = xsp;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_273() {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3R_197() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(157)) {
    jj_scanpos = xsp;
    if (jj_scan_token(158)) return true;
    }
    xsp = jj_scanpos;
    if (jj_3R_246()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_122() {
    if (jj_3R_112()) return true;
    return false;
  }

  private boolean jj_3R_232() {
    if (jj_scan_token(TYPEDEF)) return true;
    return false;
  }

  private boolean jj_3R_231() {
    if (jj_scan_token(EXTERN)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_284() {
    if (jj_3R_305()) return true;
    return false;
  }

  private boolean jj_3_12() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_165() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(73)) {
    jj_scanpos = xsp;
    if (jj_scan_token(20)) {
    jj_scanpos = xsp;
    if (jj_scan_token(31)) {
    jj_scanpos = xsp;
    if (jj_scan_token(37)) {
    jj_scanpos = xsp;
    if (jj_scan_token(32)) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) return true;
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3_14() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_249() {
    if (jj_scan_token(149)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_284()) jj_scanpos = xsp;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_162() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3_11() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_168() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3_31() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_71()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_202() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_31()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) return true;
    }
    return false;
  }

  private boolean jj_3R_94() {
    if (jj_3R_57()) return true;
    return false;
  }

  private boolean jj_3R_93() {
    if (jj_3R_57()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_10() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_167() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_376() {
    Token xsp;
    if (jj_scan_token(10)) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_scan_token(10)) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_248() {
    if (jj_3R_81()) return true;
    return false;
  }

  private boolean jj_3_13() {
    if (jj_3R_56()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_167()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_166() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_169() {
    if (jj_3R_233()) return true;
    return false;
  }

  private boolean jj_3R_296() {
    if (jj_3R_299()) return true;
    return false;
  }

  private boolean jj_3_9() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_201() {
    if (jj_scan_token(151)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_248()) jj_scanpos = xsp;
    if (jj_scan_token(152)) return true;
    return false;
  }

  private boolean jj_3R_92() {
    if (jj_3R_58()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_166()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_120() {
    if (jj_3R_197()) return true;
    return false;
  }

  private boolean jj_3R_91() {
    if (jj_3R_165()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_9()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3R_295() {
    if (jj_scan_token(CHARACTER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_91()) {
    jj_scanpos = xsp;
    if (jj_3R_92()) {
    jj_scanpos = xsp;
    if (jj_3_13()) {
    jj_scanpos = xsp;
    if (jj_3R_93()) return true;
    }
    }
    }
    xsp = jj_scanpos;
    if (jj_3R_94()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_200() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_67()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_294() {
    if (jj_scan_token(FLOATING_POINT_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_199() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  private boolean jj_3R_95() {
    if (jj_3R_52()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_3R_54()) return true;
    return false;
  }

  private boolean jj_3R_228() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_54() {
    Token xsp;
    if (jj_3R_95()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_95()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_198() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_121() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_198()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) return true;
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_201()) { jj_scanpos = xsp; break; }
    }
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_202()) { jj_scanpos = xsp; break; }
    }
    return false;
  }

  private boolean jj_3R_161() {
    if (jj_scan_token(153)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_228()) jj_scanpos = xsp;
    if (jj_3R_160()) return true;
    return false;
  }

  private boolean jj_3R_90() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(83)) {
    jj_scanpos = xsp;
    if (jj_scan_token(84)) return true;
    }
    if (jj_3R_170()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_3R_53()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_169()) jj_scanpos = xsp;
    if (jj_scan_token(148)) return true;
    return false;
  }

  private boolean jj_3R_309() {
    if (jj_scan_token(155)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_234() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(130)) {
    jj_scanpos = xsp;
    if (jj_scan_token(129)) {
    jj_scanpos = xsp;
    if (jj_scan_token(144)) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_119() {
    if (jj_3R_55()) return true;
    return false;
  }

  private boolean jj_3R_52() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_90()) return true;
    }
    return false;
  }

  private boolean jj_3_5() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_119()) jj_scanpos = xsp;
    xsp = jj_scanpos;
    if (jj_3R_120()) jj_scanpos = xsp;
    if (jj_3R_121()) return true;
    xsp = jj_scanpos;
    if (jj_3R_122()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_308() {
    if (jj_scan_token(155)) return true;
    if (jj_3R_123()) return true;
    return false;
  }

  private boolean jj_3R_89() {
    if (jj_3R_53()) return true;
    return false;
  }

  private boolean jj_3R_51() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_89()) jj_scanpos = xsp;
    if (jj_3R_67()) return true;
    xsp = jj_scanpos;
    if (jj_3_6()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_293() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_286() {
    if (jj_scan_token(INTEGER_LITERAL)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_309()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_271() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_293()) {
    jj_scanpos = xsp;
    if (jj_3R_294()) {
    jj_scanpos = xsp;
    if (jj_3R_295()) {
    jj_scanpos = xsp;
    if (jj_3R_296()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_170() {
    if (jj_scan_token(OBJC_IDENTIFIER)) return true;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_234()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_scan_token(133)) {
    jj_scanpos = xsp;
    if (jj_scan_token(145)) return true;
    }
    return false;
  }

  private boolean jj_3R_159() {
    if (jj_3R_163()) return true;
    return false;
  }

  private boolean jj_3R_285() {
    if (jj_scan_token(IDENTIFIER)) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_308()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3R_250() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) return true;
    }
    return false;
  }

  private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) jj_scanpos = xsp;
    if (jj_3R_160()) return true;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_161()) { jj_scanpos = xsp; break; }
    }
    xsp = jj_scanpos;
    if (jj_3R_162()) jj_scanpos = xsp;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_3R_50()) return true;
    return false;
  }

  private boolean jj_3R_221() {
    if (jj_scan_token(149)) return true;
    if (jj_3R_219()) return true;
    if (jj_scan_token(150)) return true;
    return false;
  }

  private boolean jj_3R_220() {
    if (jj_3R_271()) return true;
    return false;
  }

  private boolean jj_3R_206() {
    if (jj_3R_250()) return true;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_scan_token(153)) jj_scanpos = xsp;
    return false;
  }

  /** Generated Token Manager. */
  public CParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  /** Whether we are looking ahead. */
  private boolean jj_lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[183];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static private int[] jj_la1_5;
  static private int[] jj_la1_6;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
      jj_la1_init_3();
      jj_la1_init_4();
      jj_la1_init_5();
      jj_la1_init_6();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x400,0x400,0x0,0x0,0x0,0x80080000,0x0,0x0,0x91700000,0x80080000,0x20000,0x90500000,0x1200000,0x40000000,0x80080000,0x0,0x820b4400,0x0,0x0,0x80080000,0x80080000,0x0,0x34400,0x34400,0x0,0x0,0x0,0x0,0x800b4400,0x80080000,0x800b4400,0x0,0x0,0x0,0x0,0x800b4400,0x0,0x0,0x0,0x20400,0x0,0x0,0x0,0x20000,0x20400,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000,0x20000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x80080000,0x0,0x0,0x80080000,0x1200000,0x80080000,0x0,0x0,0x0,0x80080000,0x0,0x0,0x0,0x400,0x0,0x400,0x0,0x0,0x400,0x80080000,0x0,0x0,0x0,0x0,0x0,0x2034400,0x0,0x0,0x0,0x0,0x80080000,0x0,0x80080000,0x0,0x0,0x0,0x0,0x0,0x0,0x2034400,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2034400,0x0,0x0,0x2034400,0x0,0xe074400,0x800000,0x2034400,0x0,0x80080000,0x1220400,0x1220400,0x4000000,0x2034400,0x2034400,0x2034400,0x0,0x2034400,0x8040000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2034400,0x2034400,0x2034400,0x2000000,0x0,0x0,0x0,0x34400,0x0,0x0,0x0,0x0,0x34400,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x4000180,0x0,0x0,0x0,0x0,0x0,0x0,0x3fbffe0,0x0,0x0,0x98000023,0x3fbfe60,0x0,0x21,0x98000002,0x10,0x3fbfe60,0x1220000,0x3fffe60,0x0,0x0,0x3fbfe60,0x3fbfe60,0x0,0x0,0x0,0x0,0x0,0x0,0x1220000,0x3fbfe60,0x3fbfe60,0x3fbfe60,0x0,0x0,0x0,0x0,0x3fbfe60,0x240,0x1220240,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1220000,0x0,0x12203c0,0x12203c0,0x1220240,0x10,0x0,0x0,0x7fbffe0,0x1220000,0x4000180,0x3fbfe60,0x98000002,0x3fbfe60,0x0,0x0,0x0,0x7fbffe0,0x1220000,0x0,0x0,0x4000180,0x0,0x4000180,0x0,0x0,0x0,0x3fbfe60,0x0,0x1220000,0x180,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x3fbfe60,0x0,0x3fbfe60,0x0,0x0,0x0,0x180,0x0,0x0,0x40000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x0,0x0,0x40000,0x0,0x504018c,0x40000000,0x40000,0x0,0x3fbfe60,0x98200002,0x98200002,0x0,0x40000,0x40000,0x40000,0x4,0x40000,0x8,0x0,0x180,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000,0x40000,0x40000,0x40000,0x0,0x0,0x0,0x0,0x180,0x0,0x180,0x180,0x0,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x600000,0x600000,0x0,0x0,0x0,0x0,0x0,0x8060b0,0x180000,0x180000,0x10e4f,0x60b0,0x0,0x200,0x10c4f,0x100,0x60b0,0x0,0x8060b0,0x0,0x0,0x8060b0,0x8060b0,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x8060b0,0x8060b0,0x8060b0,0x0,0x0,0x0,0x0,0x8060b0,0x0,0x0,0x800000,0x800000,0x0,0x800000,0x0,0x800000,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0xe060b0,0x0,0x600000,0x60b0,0x10c4f,0x60b0,0x0,0x0,0x0,0xe060b0,0x0,0x800000,0x800000,0xe00000,0x0,0xe00000,0x0,0x0,0x800000,0x60b0,0x0,0x0,0x0,0x800000,0x0,0x800000,0x0,0x800000,0x0,0x0,0x60b0,0x0,0x60b0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x800000,0x0,0x869000,0x800000,0x800000,0x600000,0x60b0,0x810c4f,0x810c4f,0x20000,0x800000,0x800000,0x800000,0x48000,0x800000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x800000,0x800000,0x0,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_3() {
      jj_la1_3 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x12000,0x0,0x8c02000,0x8c02000,0x89d2000,0x400000,0x400000,0x400000,0x400000,0x89d2000,0x10000,0x2000,0x1c0000,0x89d2000,0x89d2000,0x10000,0x802000,0x802000,0x8200000,0x8200000,0x2000,0x10000,0x89d2000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_4() {
      jj_la1_4 = new int[] {0x100000,0x0,0x0,0x0,0x10006,0x10006,0x20020,0x60a00000,0x0,0x0,0x0,0x800000,0x0,0x0,0x0,0x0,0x800000,0x800000,0x60a00000,0x2000000,0x2000000,0x800000,0x800000,0x4000000,0x0,0x0,0x2000000,0x2000000,0x200000,0x800000,0xa00000,0x800000,0xa00000,0x8200000,0x8200000,0x2000000,0x2000000,0xa00000,0x0,0x800000,0x0,0x14200000,0x200000,0x200000,0x4000000,0x14200000,0x14200000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x2000000,0x4000000,0x0,0x800000,0x0,0x800000,0x800000,0x800000,0x0,0x2000000,0x8000000,0x64a00000,0x800000,0x0,0x800000,0x0,0x800000,0x2000000,0x4000000,0x4000000,0x64a00000,0x800000,0x0,0x0,0x0,0x2000000,0x0,0x8000000,0x8000000,0x0,0x800000,0x60000000,0x800000,0x0,0x200000,0x800000,0x60200000,0x200000,0x0,0x200000,0x60000000,0x800000,0x60000000,0x800000,0x2000000,0x60a00000,0x8000000,0x0,0x2000000,0x2000000,0x60240000,0x800000,0x2000000,0x800000,0x800000,0x60a00000,0xa00000,0x60000000,0x60200000,0xa00000,0x800000,0x60200000,0x200000,0x60340000,0x0,0x60200000,0x0,0x800000,0x36a40000,0x36a40000,0x0,0x60200000,0x60200000,0x60200000,0x0,0x60200000,0x0,0x2000000,0x0,0x8000000,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20000000,0x20000000,0x2000000,0x60240000,0x60200000,0x60200000,0x60000000,0x60000000,0xa00000,0xa00000,0x200000,0x0,0x2000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_5() {
      jj_la1_5 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000006,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000006,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf0000006,0x1,0x0,0x1,0x1,0x0,0x0,0x0,0xf0000006,0x0,0x0,0xf0000006,0x0,0xf0000006,0x0,0xf0000006,0x0,0x0,0x6,0x6,0x0,0xf0000006,0xf0000006,0xf0000006,0x0,0xf0000006,0x0,0x0,0x0,0x1ff8,0x2000,0x4000,0x8000,0x10000,0x20000,0x0,0xc0000,0xc0000,0xf00000,0xf00000,0x3000000,0x3000000,0x6,0x6,0xc000000,0xc000000,0x0,0xf0000006,0xf0000006,0xf0000006,0xf0000006,0x0,0x30000001,0x30000001,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
   private static void jj_la1_init_6() {
      jj_la1_6 = new int[] {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x1,0x0,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[50];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public CParser(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public CParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new CParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public CParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public CParser(CParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(CParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 183; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = jj_lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[193];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 183; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
          if ((jj_la1_5[i] & (1<<j)) != 0) {
            la1tokens[160+j] = true;
          }
          if ((jj_la1_6[i] & (1<<j)) != 0) {
            la1tokens[192+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 193; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 50; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
