/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.text.VersionComparatorUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.kotlin.idea.inspections.ReplaceStringInDocumentFix;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.idea.maven.PomFileKt;
import org.jetbrains.kotlin.idea.versions.DeprecatedLibInfo;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/DeprecatedMavenDependencyInspection;", "Lcom/intellij/util/xml/highlighting/DomElementsInspection;", "Lorg/jetbrains/idea/maven/dom/model/MavenDomProjectModel;", "Lcom/intellij/codeInspection/CleanupLocalInspectionTool;", "<init>", "()V", "checkFileElement", "", "domFileElement", "Lcom/intellij/util/xml/DomFileElement;", "holder", "Lcom/intellij/util/xml/highlighting/DomElementAnnotationHolder;", "intellij.kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nDeprecatedMavenDependencyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecatedMavenDependencyInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/DeprecatedMavenDependencyInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n774#2:62\n865#2:63\n1563#2:64\n1634#2,3:65\n866#2:68\n774#2:69\n865#2,2:70\n*S KotlinDebug\n*F\n+ 1 DeprecatedMavenDependencyInspection.kt\norg/jetbrains/kotlin/idea/maven/inspections/DeprecatedMavenDependencyInspection\n*L\n34#1:62\n34#1:63\n36#1:64\n36#1:65,3\n34#1:68\n40#1:69\n40#1:70,2\n*E\n"})
public final class DeprecatedMavenDependencyInspection
extends DomElementsInspection<MavenDomProjectModel>
implements CleanupLocalInspectionTool {
    public DeprecatedMavenDependencyInspection() {
        super(MavenDomProjectModel.class, new Class[0]);
    }

    /*
     * WARNING - void declaration
     */
    public void checkFileElement(@NotNull DomFileElement<MavenDomProjectModel> domFileElement, @NotNull DomElementAnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter(domFileElement, (String)"domFileElement");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        XmlFile xmlFile = domFileElement.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)xmlFile, (String)"getFile(...)");
        XmlFile file = xmlFile;
        Module module = domFileElement.getModule();
        if (module == null) {
            return;
        }
        Module module2 = module;
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance((Project)module2.getProject());
        if (mavenProjectsManager == null) {
            return;
        }
        MavenProjectsManager manager = mavenProjectsManager;
        MavenProject mavenProject = manager.findProject(module2);
        if (mavenProject == null) {
            return;
        }
        MavenProject mavenProject2 = mavenProject;
        PomFile pomFile = PomFile.Companion.forFileOrNull(file);
        if (pomFile == null) {
            return;
        }
        PomFile pomFile2 = pomFile;
        for (DeprecatedLibInfo libInfo : KotlinRuntimeLibraryUtilKt.getDEPRECATED_LIBRARIES_INFORMATION()) {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            void $this$filter$iv;
            MavenId libMavenId = new MavenId(libInfo.getOld().getGroupId(), libInfo.getOld().getName(), null);
            Iterable iterable = PomFile.findDependencies$default(pomFile2, libMavenId, null, 2, null);
            boolean $i$f$filter = false;
            void var14_15 = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                void $this$mapTo$iv$iv;
                MavenDomDependency it = (MavenDomDependency)element$iv$iv;
                boolean bl = false;
                Iterable $this$map$iv = mavenProject2.findDependencies(libInfo.getOld().getGroupId(), libInfo.getOld().getName());
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    MavenArtifact mavenArtifact = (MavenArtifact)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    collection.add(it2.getVersion());
                }
                String libVersion = (String)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
                if (!(libVersion != null && VersionComparatorUtil.COMPARATOR.compare(libVersion, libInfo.getOutdatedAfterVersion()) >= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List moduleDependencies = (List)destination$iv$iv;
            MavenDomDependencies mavenDomDependencies = pomFile2.getDomModel().getDependencyManagement().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)mavenDomDependencies, (String)"getDependencies(...)");
            Iterable $this$filter$iv2 = PomFileKt.findDependencies$default(mavenDomDependencies, libMavenId, null, 2, null);
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                MavenDomDependency it = (MavenDomDependency)element$iv$iv;
                boolean bl = false;
                GenericDomValue genericDomValue = it.getVersion();
                String version = genericDomValue != null ? genericDomValue.getStringValue() : null;
                if (!(version != null && VersionComparatorUtil.COMPARATOR.compare(version, libInfo.getOutdatedAfterVersion()) >= 0)) continue;
                destination$iv$iv3.add(element$iv$iv);
            }
            List dependencyManagementDependencies = (List)destination$iv$iv3;
            for (MavenDomDependency dependency : CollectionsKt.plus((Collection)moduleDependencies, (Iterable)dependencyManagementDependencies)) {
                XmlElement xmlElement = dependency.getArtifactId().getXmlElement();
                if (xmlElement == null) continue;
                ReplaceStringInDocumentFix fix3 = new ReplaceStringInDocumentFix((PsiElement)xmlElement, libInfo.getOld().getName(), libInfo.getNew().getName());
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix3};
                holder2.createProblem((DomElement)dependency.getArtifactId(), ProblemHighlightType.LIKE_DEPRECATED, libInfo.getMessage(), null, localQuickFixArray);
            }
        }
    }
}

