/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.ru;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.PhraseCommaChange;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.ru.Case;
import ai.grazie.rules.ru.InflectedForm;
import ai.grazie.rules.ru.PunctuationRules;
import ai.grazie.rules.ru.RussianTreePatterns;
import ai.grazie.rules.ru.RussianValences;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeCorrector;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.NodePointer;
import ai.grazie.rules.tree.ReportingKind;
import ai.grazie.rules.tree.TextRange;
import ai.grazie.rules.tree.Tree;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;

class ParticleSeparation {
    static final NodePattern interrogativePronoun = NodePattern.N.lemma("\u043a\u0442\u043e|\u0447\u0442\u043e|\u043a\u0430\u043a\u043e\u0439|\u043a\u0430\u043a|\u0441\u043a\u043e\u043b\u044c\u043a\u043e|\u0447\u0435\u0439|\u0433\u0434\u0435|\u043a\u0443\u0434\u0430|\u043e\u0442\u043a\u0443\u0434\u0430|\u0437\u0430\u0447\u0435\u043c|\u043f\u043e\u0447\u0435\u043c\u0443|\u043e\u0442\u0447\u0435\u0433\u043e|\u043a\u043e\u0433\u0434\u0430");
    private static final NodePattern noHyphenParticle = NodePattern.N.form("\u0431\u044b?|\u0436\u0435?|\u043b\u0438|\u043b\u044c|\u0432\u0435\u0434\u044c|\u0432\u043e\u0442|\u043c\u043e\u043b|\u0434\u0430\u0436\u0435|\u0434\u0435\u0441\u043a\u0430\u0442\u044c|\u0432\u043e\u043d|\u0431\u0443\u0434\u0442\u043e");
    private static final NodePattern requiringHyphenTaki = NodePattern.N.pos("VB.*|ADV|PARTICLE").andNot(noHyphenParticle).andNot(NodePattern.N.lemma("\u0432\u0435\u0441\u044c|\u0447\u0442\u043e|\u0442\u043e").noForm("\u0432\u0441[\u0435\u0451]")).andNot(NodePattern.N.directlyAfter(CommonPatterns.HYPHEN_NODE));
    private static final NodePattern russianWord = NodePattern.N.anyPos().andNot(CommonPatterns.capitalizedMiddle);
    private static final NodePattern transitive = NodePattern.N.pos(".*:TRANS:.*");
    private static final NodePattern addHyphenAfter = NodePattern.custom((node, match) -> match.withCorrector(NodeCorrector.rawReplace(node.endOffset(), Objects.requireNonNull(node.nextNode()).startOffset(), "-"))).and(CommonPatterns.reportWithNext);
    private static final NodePattern poDativeAdj = NodePattern.or(NodePattern.N.pos("ADJ:Posit:Masc:D"), NodePattern.N.form("\u0434\u0440\u0443\u0433\u043e\u043c\u0443|\u0432\u0441\u044f\u043a\u043e\u043c\u0443"));
    private static final NodePattern concatWithPrev = NodePattern.N.correct(NodeCorrector.concatenate(-1));
    static final NodePattern koe = NodePattern.N.form("\u043a\u043e\u0435|\u043a\u043e\u0439");
    static final NodePattern to = NodePattern.N.form("\u0442\u043e|\u043b\u0438\u0431\u043e|\u043d\u0438\u0431\u0443\u0434\u044c");
    static final NodePattern ka = NodePattern.N.form("\u0442?\u043a\u0430|\u0442\u043a\u043e|\u0434\u0435");
    static final NodePattern taki = NodePattern.N.form("\u0442\u0430\u043a\u0438");
    private static final NodePattern tomuSemu = NodePattern.N.form("\u044d?\u0442\u043e\u043c\u0443|\u0441\u0435\u043c\u0443");
    private static final NodePattern beforeGenitive = NodePattern.N.markAs("Anchor").directlyBefore(NodePattern.N.inPhrase(Case.R.posPattern.noDependents("case").withHeadRelation("det|nmod").after("Anchor").markAs("Gen")));

    ParticleSeparation() {
    }

    static NodePattern pattern() {
        NodePattern headClause = NodePattern.N.withHead(RussianTreePatterns.clause);
        return NodePattern.or(noHyphenParticle.includeIntoReport().andNot(NodePattern.N.inFormSequence(2, "\u0432\u043e\u0442", "-", "\u0432\u043e\u0442")).directlyAfter(NodePattern.N.inFormSequence(1, "[\u0430-\u044f\u04510-9]+", "-").noSpaceAfter().reportEverythingTouched().andOr(NodePattern.N.directlyAfter(NodePattern.N.form("\u0447\u0442\u043e").markAs("\u0427\u0442\u043e").withHead(transitive.withDependent("obj", NodePattern.N.after("\u0427\u0442\u043e")))), NodePattern.N.correct(NodeCorrector.replace(" ")))).and((particle, match) -> {
            Node hyphen = Objects.requireNonNull(particle.prevNode());
            Node prev = Objects.requireNonNull(hyphen.prevNode());
            String concat = prev.form() + particle.form();
            if (prev.tree().treeSupport().tagToken(concat).hasPos(".*")) {
                match = match.withCorrector(NodeCorrector.replaceNodes(prev, particle, concat));
            }
            return match.withMessage("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab" + particle.lowForm() + "\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0431\u0435\u0437 \u0434\u0435\u0444\u0438\u0441\u0430");
        }), NodePattern.N.form("\u0431\u044b").directlyAfter(NodePattern.N.form("\u0447\u0442\u043e").withHeadRelation("mark")).withHeadRelation("goeswith").message("\u0415\u0441\u043b\u0438 \u0432\u044b \u043e\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0435 \u0446\u0435\u043b\u044c, \u0442\u043e \u00ab\u0447\u0442\u043e\u0431\u044b\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), to.includeIntoReport().directlyAfter(interrogativePronoun.includeIntoReport()).noHeadRelation("obj|cc").andNot(NodePattern.N.withHeadRelation("det").beforeHead()).andNot(NodePattern.N.form("\u0442\u043e").withHead("goeswith", NodePattern.N.withHead("nsubj", NodePattern.N.withDependent("obj"))).directlyBefore(NodePattern.N.pos(".*:Neut:.*"))).andOr(NodePattern.N.noDependents("acl.*"), NodePattern.N.directlyAfter(NodePattern.N.form("\u0447\u0442\u043e").withHeadRelation("nsubj.*|i?obj|obl"))).and((node, match) -> {
            int prevEnd = Objects.requireNonNull(node.prevNode()).endOffset();
            String form = node.form();
            if (node.hasForm("\u0442\u043e|\u043b\u0438\u0431\u043e") && ((StreamEx)node.forward().skip(1L)).anyMatch(n -> n.form().equals(form))) {
                match = match.withCorrector(NodeCorrector.rawReplace(prevEnd, node.startOffset(), ": "));
            }
            return match;
        }).and(NodePattern.N.directlyAfter(addHyphenAfter)).message("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab$_\u00bb \u0432 \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u0445 \u043c\u0435\u0441\u0442\u043e\u0438\u043c\u0435\u043d\u0438\u044f\u0445 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0438\u0441"), ParticleSeparation.koe.includeIntoReport().andOr(NodePattern.N.directlyBefore(interrogativePronoun.includeIntoReport()).and(addHyphenAfter).message("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab$_\u00bb \u0432 \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0451\u043d\u043d\u044b\u0445 \u043c\u0435\u0441\u0442\u043e\u0438\u043c\u0435\u043d\u0438\u044f\u0445 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0438\u0441"), NodePattern.N.inFormSequence(0, ".*", "-", ".*", "-", ".*").and((koe, match) -> {
            List nodes = ((StreamEx)koe.forward().limit(5L)).toList();
            if (!((Node)nodes.get(2)).hasPos("PREP") || !interrogativePronoun.matches((Node)nodes.get(4))) {
                return null;
            }
            return match.withReportedNodes(nodes).withCorrector(NodeCorrector.replace((Node)nodes.get(1), " ").join(NodeCorrector.replace((Node)nodes.get(3), " "))).withMessage("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab" + koe.lowForm() + "\u00bb \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0433\u043e\u043c \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e");
        })), NodePattern.N.inFormSequence(1, "\u0442\u0430\u043a", "\u043a\u0430").correct(NodeCorrector.replace("\u043a\u0430\u043a")).message("\u041e\u043f\u0435\u0447\u0430\u0442\u043a\u0430 \u0432 \u00ab\u0442\u0430\u043a \u043a\u0430\u043a\u00bb?"), ka.includeIntoReport().directlyAfter(russianWord.andNot(NodePattern.PUNCT).andNot(noHyphenParticle).includeIntoReport().and(addHyphenAfter)).directlyBefore(NodePattern.or(russianWord, NodePattern.PUNCT.andNot(CommonPatterns.HYPHEN_NODE.noSpaceBefore()))).message("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab$_\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0438\u0441"), taki.includeIntoReport().andOr(NodePattern.N.directlyAfter(requiringHyphenTaki.and(addHyphenAfter)).message("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab\u0442\u0430\u043a\u0438\u00bb \u043f\u043e\u0441\u043b\u0435 \u0433\u043b\u0430\u0433\u043e\u043b\u043e\u0432, \u043d\u0430\u0440\u0435\u0447\u0438\u0439 \u0438\u043b\u0438 \u0447\u0430\u0441\u0442\u0438\u0446 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0438\u0441").and((node, match) -> {
            int prevEnd = Objects.requireNonNull(node.prevNode()).endOffset();
            return match.withReportedRange(new TextRange(prevEnd, node.endOffset()), node.tree());
        }), NodePattern.N.directlyAfter(NodePattern.N.form("-").includeIntoReport().directlyAfter(NodePattern.not(requiringHyphenTaki).includeIntoReport()).correct(NodeCorrector.replace(" "))).message("\u0427\u0430\u0441\u0442\u0438\u0446\u0430 \u00ab\u0442\u0430\u043a\u0438\u00bb \u043d\u0435 \u043f\u043e\u0441\u043b\u0435 \u0433\u043b\u0430\u0433\u043e\u043b\u043e\u0432, \u043d\u0430\u0440\u0435\u0447\u0438\u0439 \u0438\u043b\u0438 \u0447\u0430\u0441\u0442\u0438\u0446 \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e")), ParticleSeparation.takjeConfusion(), NodePattern.N.form("\u043f\u043e").includeIntoReport().andOr(NodePattern.or(NodePattern.N.directlyBefore(poDativeAdj.includeIntoReport().markAs("Dative").andOr(headClause, NodePattern.N.withHead("obl", headClause))).withHead("case", NodePattern.N.noDependents(NodePattern.N.afterHead()).andOr(NodePattern.N.alreadyMarkedAs("Dative").noPos("NN.*").andNot(CommonPatterns.capitalizedMiddle), NodePattern.N.pos("ADV").directlyAfter("Dative"))), NodePattern.N.withHeadRelation("advmod").directlyBefore(poDativeAdj.markAs("Dative"))).message("\u041d\u0430\u0440\u0435\u0447\u0438\u0435 \u00ab\u043f\u043e-$Dative\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0438\u0441").and(addHyphenAfter), NodePattern.N.withNeighbor(1, NodePattern.N.form("-").includeIntoReport().correct(NodeCorrector.replace(" "))).withNeighbor(2, NodePattern.N.pos("ADJ:.*:D").includeIntoReport().markAs("Dative")).andOr(NodePattern.N.withHead("case", NodePattern.N.markAs("Noun").onlyPos("NN.*").and(Case.D.posPattern).after("Dative")), NodePattern.N.withNeighbor(3, NodePattern.N.markAs("Noun").onlyPos("NN.*").and(Case.D.posPattern))).and((__, match) -> {
            List<InflectedForm> nounForms;
            List<InflectedForm> adjForms = InflectedForm.fromPosTags(match.getMarkedNode("Dative"));
            return ParticleSeparation.agreeByGenderInDative(adjForms, nounForms = InflectedForm.fromNPHead(match.getMarkedNode("Noun"))) ? match : null;
        }).message("\u00ab\u043f\u043e $Dative $Noun\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e"), CommonPatterns.beforeSkipping(CommonPatterns.HYPHEN_NODE, tomuSemu.markAs("Tomu").noHeadRelation("det").andNot(NodePattern.N.directlyBefore(CommonPatterns.comma)).andNot(NodePattern.N.withHead(NodePattern.N.lemma("\u0441\u0443\u0434\u0438\u0442\u044c")))).message("\u0412\u044b \u0438\u043c\u0435\u043b\u0438 \u0432 \u0432\u0438\u0434\u0443 \u00ab\u043f\u043e$Tomu\u00bb?").and((po, match) -> {
            Node tomu = match.getMarkedNode("Tomu");
            return match.withCorrector(NodeCorrector.replaceNodes(po, tomu, "\u043f\u043e" + tomu.form()));
        })), NodePattern.N.inFormSequence(1, "\u043f\u043e\u043b", "\u0433\u043e\u0434\u0430|\u0433\u043e\u0434\u0438\u043a\u0430").reportEverythingTouched().message("\u00ab\u043f\u043e\u043b$_\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.N.form("\u043f\u043e\u043b[\u043b\u0430\u0435\u0451\u0438\u043e\u0443\u044d\u044e\u044f].+").noPos().andNot(CommonPatterns.capitalizedMiddle).and((node, match) -> {
            String low = node.lowForm();
            if (low.startsWith("\u043f\u043e\u043b\u0443") && node.tree().treeSupport().tagToken(low.substring(4)).hasPos("ADJ.*")) {
                return null;
            }
            String whole = low.substring(3);
            Tree.Token taggedWhole = node.tree().treeSupport().tagToken(whole);
            if (taggedWhole.hasPos(".*") && !taggedWhole.hasPos("NN:(Name|Fam).*")) {
                String msg = "\u00ab\u043f\u043e\u043b\u00bb \u0441\u043e \u0441\u043b\u043e\u0432\u0430\u043c\u0438 \u043d\u0430 " + (whole.startsWith("\u043b") ? "\u00ab\u043b\u00bb" : "\u0433\u043b\u0430\u0441\u043d\u0443\u044e \u0431\u0443\u043a\u0432\u0443") + " \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0447\u0435\u0440\u0435\u0437 \u0434\u0435\u0444\u0438\u0441";
                return match.withMessage(msg).withCorrector(NodeCorrector.replace(node, "\u043f\u043e\u043b-" + whole));
            }
            return null;
        }), NodePattern.N.inFormSequence(1, "\u043d\u0438", "\u0436\u0435").reportEverythingTouched().message("\u041f\u0440\u0438\u043b\u0430\u0433\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u00ab\u043d\u0438\u0436\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.N.form("\u043d\u0438\u0436\u0435|\u0432\u044b\u0448\u0435").directlyBeforeHead().directlyBefore(NodePattern.N.pos("PT:.*").noHeadRelation("amod").markAs("PT").and(concatWithPrev)).message("\u041f\u0440\u0438\u0447\u0430\u0441\u0442\u0438\u0435 \u00ab$_$PT\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e"), NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u0441\u0447[\u0435\u0451]\u0442").reportEverythingTouched().directlyBefore(NodePattern.N.form("\u0442\u043e\u0433\u043e").withDependent("acl|advcl")).message("\u041f\u0440\u0435\u0434\u043b\u043e\u0433 \u00ab\u043d\u0430\u0441\u0447\u0451\u0442\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.or(NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u043a\u0430\u043d\u0443\u043d\u0435|\u043f\u0440\u043e\u0442\u0438\u0432"), NodePattern.N.inFormSequence(1, "\u0441|\u043f\u043e", "\u0432\u0435\u0440\u0445|\u0432\u044b\u0448\u0435"), NodePattern.N.inFormSequence(1, "\u0441\u043e", "\u0433\u043b\u0430\u0441\u043d\u043e"), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u043c\u0438\u043c\u043e|\u0434\u043e"), NodePattern.N.inFormSequence(1, "\u0432", "\u0434\u043e\u043b\u044c|\u0433\u043b\u0443\u0431\u044c|\u0437\u0430\u043c\u0435\u043d")).andNot(CommonPatterns.capitalizedMiddle).reportEverythingTouched().directlyAfter(NodePattern.N.markAs("Prep")).message("\u00ab$Prep$_\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.N.inFormSequence(1, "\u0432", "\u0432\u0438\u0434\u0443").reportEverythingTouched().withHead("fixed", NodePattern.N.withHead(NodePattern.N.pos(".*:R"))).message("\u041f\u0440\u0435\u0434\u043b\u043e\u0433 \u00ab\u0432\u0432\u0438\u0434\u0443\u00bb (\u0447\u0435\u0433\u043e-\u043b\u0438\u0431\u043e) \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.N.inFormSequence(1, "\u0432", "\u043f\u0440\u0430\u0432\u0435").reportEverythingTouched().markAs("\u041f\u0440\u0430\u0432\u0435").directlyBefore(NodePattern.N.after("\u041f\u0440\u0430\u0432\u0435").inPhrase(NodePattern.or(RussianTreePatterns.infinitive, RussianTreePatterns.clause.withDependent("aux.*", RussianTreePatterns.infinitive)))).message("\u041d\u0430\u0440\u0435\u0447\u0438\u0435 \u00ab\u0432\u043f\u0440\u0430\u0432\u0435\u00bb (\u0447\u0442\u043e-\u043b\u0438\u0431\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c) \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.N.inFormSequence(1, "\u0432", "\u043f\u043e\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438[\u0435\u0438]").reportEverythingTouched().message("\u041d\u0430\u0440\u0435\u0447\u0438\u0435 \u00ab\u0432\u043f\u043e\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0438\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").directlyAfter(NodePattern.N.markAs("Prep")).correct(NodeCorrector.replaceNodes(NodePointer.marked("Prep"), NodePointer.anchor(), "\u0432\u043f\u043e\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0438")), NodePattern.N.form("\u0432\u0432\u0438\u0434\u0443").withHead("advmod", NodePattern.N.lemma("\u0438\u043c\u0435\u0442\u044c")).message("\u00ab\u0438\u043c\u0435\u0442\u044c \u0432 \u0432\u0438\u0434\u0443\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e").correct(NodeCorrector.replace("\u0432 \u0432\u0438\u0434\u0443")), ParticleSeparation.voVremya(), ParticleSeparation.naUdachu(), ParticleSeparation.naVstrechu(), ParticleSeparation.napodobie(), ParticleSeparation.vsledstvie(), NodePattern.or(NodePattern.N.inFormSequence(1, "\u043d\u0430|\u0441|\u0432|\u043a|\u0434\u043e|\u043f\u043e", "\u0432\u0435\u0440\u0445\u0443"), NodePattern.N.inFormSequence(1, "\u0441|\u0432|\u043a|\u0434\u043e|\u043f\u043e", "\u043d\u0438\u0437\u0443"), NodePattern.N.inFormSequence(1, "\u0441", "\u0434\u0443\u0440\u0443"), NodePattern.N.form("\u0440\u0430\u043d\u0435\u0435").markAs("\u0420\u0430\u043d\u0435\u0435").directlyAfter(NodePattern.N.form("\u0437\u0430").withHead("case", NodePattern.N.alreadyMarkedAs("\u0420\u0430\u043d\u0435\u0435"))), NodePattern.N.inFormSequence(1, "\u043f\u043e", "\u0441\u0435\u0440\u0435\u0434\u0438\u043d\u0435")).reportEverythingTouched().noDependents("nmod").directlyAfter(NodePattern.N.markAs("Prep")).message("\u041d\u0430\u0440\u0435\u0447\u0438\u0435 \u00ab$Prep$_\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev));
    }

    private static boolean agreeByGenderInDative(List<InflectedForm> forms1, List<InflectedForm> forms2) {
        return forms1.stream().anyMatch(af -> af.caze == Case.D && forms2.stream().anyMatch(nf -> ParticleSeparation.agreeByGender(af, nf)));
    }

    private static boolean agreeByGender(InflectedForm f1, InflectedForm f2) {
        InflectedForm unified = f1.unify(f2);
        return unified != null && (unified.gender != null || unified.number == InflectedForm.Number.PL);
    }

    private static NodePattern naUdachu() {
        return NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u0443\u0434\u0430\u0447\u0443").reportEverythingTouched().withHead("obl", RussianValences.withoutArg("\u043d\u0430\u0412")).message("\u041d\u0430\u0440\u0435\u0447\u0438\u0435 \u00ab\u043d\u0430\u0443\u0434\u0430\u0447\u0443\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev);
    }

    private static NodePattern voVremya() {
        return NodePattern.or(NodePattern.N.inFormSequence(1, "\u0432\u043e", "\u0432\u0440\u0435\u043c\u044f").reportEverythingTouched().markAs("Vremya").andOr(NodePattern.N.directlyAfterHead().withHead("fixed", NodePattern.N.withHead(NodePattern.N).noDependents(NodePattern.N.after("Vremya"))), NodePattern.N.withDependent("case", NodePattern.N.directlyBeforeHead()).noDependents(NodePattern.N.afterHead())).andNot(NodePattern.N.directlyBefore(NodePattern.N.form("\u043e\u043d\u043e").afterHead())).andNot(NodePattern.N.directlyBefore(NodePattern.N.inPhrase(Case.R.posPattern.after("Vremya")))).andNot(NodePattern.N.directlyAfter(NodePattern.N.withHead("case", NodePattern.N.after("Vremya")))).andNot(NodePattern.N.directlyBefore(NodePattern.or(RussianTreePatterns.anyQuotation, RussianTreePatterns.foreignWord))).message("\u041d\u0430\u0440\u0435\u0447\u0438\u0435 \u00ab\u0432\u043e\u0432\u0440\u0435\u043c\u044f\u00bb (\u0441\u0432\u043e\u0435\u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e) \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev), NodePattern.N.form("\u0432\u043e\u0432\u0440\u0435\u043c\u044f").directlyBefore(Case.R.posPattern).message("\u0412\u044b\u0440\u0430\u0436\u0435\u043d\u0438\u0435 \u00ab\u0432\u043e \u0432\u0440\u0435\u043c\u044f\u00bb (\u0447\u0435\u0433\u043e-\u043b\u0438\u0431\u043e) \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e").correct(NodeCorrector.replace("\u0432\u043e \u0432\u0440\u0435\u043c\u044f")));
    }

    private static NodePattern napodobie() {
        return NodePattern.N.form("\u043f\u043e\u0434\u043e\u0431\u0438.").directlyAfter(NodePattern.N.form("\u043d\u0430").markAs("Na")).and(beforeGenitive).andOr(NodePattern.N.form("\u043f\u043e\u0434\u043e\u0431\u0438\u0435").withHead("nmod|obl", RussianValences.withoutArgAround("\u043d\u0430\u0412")), NodePattern.N.form("\u043f\u043e\u0434\u043e\u0431\u0438\u0438").withHead("nmod|obl", RussianValences.withoutArgAround("\u043d\u0430\u041f"))).message("\u041f\u0440\u0435\u0434\u043b\u043e\u0433 \u00ab\u043d\u0430\u043f\u043e\u0434\u043e\u0431\u0438\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").correct(NodeCorrector.replaceNodes(NodePointer.marked("Na"), NodePointer.anchor(), "\u043d\u0430\u043f\u043e\u0434\u043e\u0431\u0438\u0435"));
    }

    private static NodePattern vsledstvie() {
        return NodePattern.N.form("\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438.").directlyAfter(NodePattern.N.form("\u0432").markAs("V")).and(beforeGenitive).andOr(NodePattern.N.form("\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0435").withHead("nmod|obl", RussianValences.withoutArgAround("\u0432\u0412")), NodePattern.N.form("\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0438").withHead("nmod|obl", RussianValences.withoutArgAround("\u0432\u041f")).andNot(NodePattern.markedNodeMatches("Gen", NodePattern.N.lemma("\u0442\u0435\u043e\u0440\u0435\u043c\u0430|\u0433\u0438\u043f\u043e\u0442\u0435\u0437\u0430|\u043b\u0435\u043c\u043c\u0430")))).message("\u041f\u0440\u0435\u0434\u043b\u043e\u0433 \u00ab\u0432\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").correct(NodeCorrector.replaceNodes(NodePointer.marked("V"), NodePointer.anchor(), "\u0432\u0441\u043b\u0435\u0434\u0441\u0442\u0432\u0438\u0435"));
    }

    private static NodePattern naVstrechu() {
        NodePattern arg = NodePattern.or(Case.D.posPattern, NodePattern.N.inFormSequence(0, "\u0434\u0440\u0443\u0433", "\u0434\u0440\u0443\u0433\u0443"));
        return NodePattern.N.inFormSequence(1, "\u043d\u0430", "\u0432\u0441\u0442\u0440\u0435\u0447\u0443").reportEverythingTouched().andOr(NodePattern.N.withDependent("iobj", arg), NodePattern.N.withHead("obl", NodePattern.N.withDependent("iobj", arg.noLemma("\u043e\u0434\u0438\u043d")))).message("\u041f\u0440\u0435\u0434\u043b\u043e\u0433 \u00ab\u043d\u0430\u0432\u0441\u0442\u0440\u0435\u0447\u0443\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev);
    }

    private static NodePattern takjeConfusion() {
        NodePattern takjeTogether = NodePattern.N.includeIntoReport().form("\u0442\u0430\u043a\u0436\u0435").markAs("Takje").andOr(CommonPatterns.phraseEndsWithComma.withNextSibling(NodePattern.N.withHeadRelation("obl").withPhraseEnd(CommonPatterns.comma.markAs("Comma2")).and((p, match) -> {
            PhraseCommaChange change = PhraseCommaChange.removeSurroundingCommas(p.phraseStart(), p.phraseEnd(), PunctuationRules.unmandatedComma);
            return change == null ? null : match.withCorrector(change.correct());
        })).reportRangeTo("Comma2", ReportingKind.Hover).message("\u00ab\u0442\u0430\u043a\u0436\u0435\u00bb \u043d\u0435 \u0432\u0432\u043e\u0434\u043d\u043e\u0435 \u0441\u043b\u043e\u0432\u043e, \u0437\u0430\u043f\u044f\u0442\u044b\u043c\u0438 \u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u044f\u0435\u0442\u0441\u044f"), NodePattern.or(NodePattern.N.directlyBefore(NodePattern.or(NodePattern.N.form("[.?!]"), NodePattern.N.form("\u043a\u0430\u043a").andNot(NodePattern.N.withHead("advmod", NodePattern.N.withHead("conj", NodePattern.N.withDependent("advmod", NodePattern.N.form("\u043a\u0430\u043a"))))).andNot(NodePattern.N.directlyBefore(CommonPatterns.noSpaceHyphen)), NodePattern.N.inFormSequence(0, ",", "\u0442\u043e\u043b\u044c\u043a\u043e"))).andNot(NodePattern.N.directlyAfter(NodePattern.or(NodePattern.N.form("\u0430"), NodePattern.N.inFormSequence(1, "\u043d\u043e", "\u0438")))), NodePattern.N.withHead("advmod", NodePattern.or(NodePattern.N.withDependent("obl|advcl", NodePattern.N.withDependent("mark|case", NodePattern.N.inFormSequence(1, ",", "\u043a\u0430\u043a").after("Takje"))), NodePattern.custom((node, match) -> {
            List<Valence> valences = RussianValences.get(node);
            Node takje = match.getMarkedNode("Takje");
            if (valences.stream().noneMatch(as -> ParticleSeparation.matches(node, takje, as, valences)) && valences.stream().anyMatch(as -> as.arguments.contains(RussianValences.HOW))) {
                return match;
            }
            return null;
        })))).message("\u0415\u0441\u043b\u0438 \u0432\u044b \u043e\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u0442\u0435 \u00ab\u043a\u0430\u043a\u00bb, \u0442\u043e \u00ab\u0442\u0430\u043a \u0436\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e")).correct(NodeCorrector.replace("\u0442\u0430\u043a \u0436\u0435"));
        NodePattern takJeSeparate = NodePattern.N.inFormSequence(2, "\u0430", "\u0442\u0430\u043a", "\u0436\u0435").message("\u0415\u0441\u043b\u0438 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u0432 \u0432\u0438\u0434\u0443 \u00ab\u0435\u0449\u0451\u00bb, \u0442\u043e \u00ab\u0442\u0430\u043a\u0436\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0441\u043b\u0438\u0442\u043d\u043e").and(concatWithPrev);
        NodePattern toJeTogether = NodePattern.N.form("\u0442\u043e\u0436\u0435").andOr(NodePattern.N.directlyAfter(NodePattern.N.pos("PREP").withHeadRelation("case|discourse")), NodePattern.N.directlyAfterHead().withHead("fixed|det", NodePattern.N.pos("PREP")), NodePattern.N.directlyBefore(CommonPatterns.comma.directlyBefore(NodePattern.N.form("\u0447\u0442\u043e").withHeadRelation("nsubj.*"))), NodePattern.N.inFormSequence(0, "\u0442\u043e\u0436\u0435", ",", "\u0447\u0442\u043e", "\u0438").andNot(NodePattern.N.withHead("advmod", NodePattern.N.withDependent(".*", RussianTreePatterns.clause)))).message("\u0415\u0441\u043b\u0438 \u0438\u043c\u0435\u0435\u0442\u0441\u044f \u0432 \u0432\u0438\u0434\u0443 \u00ab\u0442\u0430\u043a\u043e\u0435 \u0436\u0435\u00bb, \u00ab\u0442\u043e \u0436\u0435\u00bb \u043f\u0438\u0448\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0434\u0435\u043b\u044c\u043d\u043e").correct(NodeCorrector.replace("\u0442\u043e \u0436\u0435"));
        return NodePattern.or(takjeTogether, takJeSeparate, toJeTogether);
    }

    private static boolean matches(Node head, Node arg, Valence structure, List<Valence> all) {
        return structure.arguments.stream().filter(a -> !all.stream().allMatch(as -> as.arguments.contains(a))).map(a -> a.findOn(head)).anyMatch(existing -> existing != arg && existing != null);
    }
}

