/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.dictionary;

import com.jetbrains.fus.reporting.FileHandle;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/internal/statistic/eventLog/dictionary/InMemoryFileHandle;", "Lcom/jetbrains/fus/reporting/FileHandle;", "bytes", "", "([B)V", "close", "", "exists", "", "length", "", "read", "", "index", "", "dstBuffer", "readAll", "write", "", "ap-validation"})
public final class InMemoryFileHandle
implements FileHandle {
    @NotNull
    private final byte[] bytes;

    public InMemoryFileHandle(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.bytes = bytes;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    @NotNull
    public byte[] readAll() {
        return this.bytes;
    }

    @Override
    @NotNull
    public byte[] read(int index, @NotNull byte[] dstBuffer) {
        Intrinsics.checkNotNullParameter((Object)dstBuffer, (String)"dstBuffer");
        throw new UnsupportedOperationException();
    }

    @Override
    public byte read(int index) {
        return ByteBuffer.wrap(this.bytes).get(index);
    }

    @NotNull
    public Void write(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

