/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.push.ui;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.push.PrePushHandler;
import com.intellij.dvcs.push.PushController;
import com.intellij.dvcs.push.PushDialogActionsProvider;
import com.intellij.dvcs.push.PushDialogCustomizer;
import com.intellij.dvcs.push.PushInfo;
import com.intellij.dvcs.push.PushSource;
import com.intellij.dvcs.push.PushSupport;
import com.intellij.dvcs.push.PushTarget;
import com.intellij.dvcs.push.VcsPushOptionValue;
import com.intellij.dvcs.push.VcsPushOptionsPanel;
import com.intellij.dvcs.push.ui.PushActionBase;
import com.intellij.dvcs.push.ui.PushLog;
import com.intellij.dvcs.push.ui.SimplePushAction;
import com.intellij.dvcs.push.ui.VcsPushUi;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OptionAction;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.ui.components.JBOptionButton;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class VcsPushDialog
extends DialogWrapper
implements VcsPushUi,
UiDataProvider {
    @NonNls
    private static final String DIMENSION_KEY = "Vcs.Push.Dialog.v2";
    @NonNls
    private static final String HELP_ID = "Vcs.Push.Dialog";
    private static final Logger LOG = Logger.getInstance(VcsPushDialog.class);
    private static final ExtensionPointName<PushDialogCustomizer> PUSH_DIALOG_CUSTOMIZER_EP = ExtensionPointName.create((String)"com.intellij.pushDialogCustomizer");
    private static final ExtensionPointName<PushDialogActionsProvider> PUSH_DIALOG_ACTIONS_PROVIDER_EP = ExtensionPointName.create((String)"com.intellij.pushDialogActionsProvider");
    private static final int CENTER_PANEL_HEIGHT = 450;
    private static final int CENTER_PANEL_WIDTH = 800;
    protected final Project myProject;
    protected final PushController myController;
    private final Map<PushSupport<?, ?, ?>, VcsPushOptionsPanel> myAdditionalPanels;
    private final @Unmodifiable Map<String, VcsPushOptionsPanel> myCustomPanels;
    private final PushLog myListPanel;
    private final JComponent myTopPanel;
    private final ComplexPushAction myMainAction;
    @NotNull
    private final List<ActionWrapper> myPushActions;

    public VcsPushDialog(@NotNull Project project, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo) {
        if (project == null) {
            VcsPushDialog.$$$reportNull$$$0(0);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(1);
        }
        this(project, VcsRepositoryManager.getInstance(project).getRepositories(), selectedRepositories, currentRepo, null);
    }

    public VcsPushDialog(@NotNull Project project, @NotNull Collection<? extends Repository> allRepos, @NotNull List<? extends Repository> selectedRepositories, @Nullable Repository currentRepo, @Nullable PushSource pushSource) {
        if (project == null) {
            VcsPushDialog.$$$reportNull$$$0(2);
        }
        if (allRepos == null) {
            VcsPushDialog.$$$reportNull$$$0(3);
        }
        if (selectedRepositories == null) {
            VcsPushDialog.$$$reportNull$$$0(4);
        }
        super(project, true, DialogWrapper.IdeModalityType.IDE);
        this.myProject = project;
        this.myController = new PushController(project, this, allRepos, selectedRepositories, currentRepo, pushSource);
        this.myAdditionalPanels = this.myController.createAdditionalPanels();
        this.myCustomPanels = this.myController.createCustomPanels(allRepos);
        this.myListPanel = this.myController.getPushPanelLog();
        this.myTopPanel = this.myController.createTopPanel();
        this.myPushActions = this.collectPushActions();
        this.myMainAction = new ComplexPushAction(this.myPushActions.subList(0, this.myPushActions.size()));
        this.myMainAction.putValue("DefaultAction", Boolean.TRUE);
        this.myController.startLoadingCommits();
        this.init();
        this.updateOkActions();
        this.setOKButtonText(DvcsBundle.message((String)"action.push", (Object[])new Object[0]));
        String title = allRepos.size() == 1 ? DvcsBundle.message((String)"push.dialog.push.commits.to.title", (Object[])new Object[]{DvcsUtil.getShortRepositoryName((Repository)ContainerUtil.getFirstItem(allRepos))}) : DvcsBundle.message((String)"push.dialog.push.commits.title", (Object[])new Object[0]);
        this.setTitle(title);
    }

    @NotNull
    private List<ActionWrapper> collectPushActions() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup group = (DefaultActionGroup)actionManager.getAction("Vcs.Push.Actions");
        ArrayList<PushActionBase> pushActions = new ArrayList<PushActionBase>(ContainerUtil.findAll((Object[])group.getChildren(actionManager), PushActionBase.class));
        VcsPushDialog.customizeDialog(this, (SimplePushAction)((Object)ContainerUtil.findInstance(pushActions, SimplePushAction.class)));
        List actionProviders = PUSH_DIALOG_ACTIONS_PROVIDER_EP.getExtensionList();
        for (PushDialogActionsProvider actionProvider : ContainerUtil.reverse((List)actionProviders)) {
            pushActions.addAll(0, actionProvider.getCustomActionsAboveDefault(this.myProject));
        }
        int firstEnabledActionPosition = ContainerUtil.indexOf(pushActions, it -> it.isEnabled(this));
        if (firstEnabledActionPosition >= 0) {
            PushActionBase firstEnabledAction = (PushActionBase)((Object)pushActions.remove(firstEnabledActionPosition));
            pushActions.add(0, firstEnabledAction);
        }
        List list = ContainerUtil.map(pushActions, action -> new ActionWrapper(this.myProject, this, (PushActionBase)((Object)action)));
        if (list == null) {
            VcsPushDialog.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static void customizeDialog(@NotNull VcsPushDialog dialog, @NotNull SimplePushAction simplePushAction) {
        List customizers;
        if (dialog == null) {
            VcsPushDialog.$$$reportNull$$$0(6);
        }
        if (simplePushAction == null) {
            VcsPushDialog.$$$reportNull$$$0(7);
        }
        if (!(customizers = PUSH_DIALOG_CUSTOMIZER_EP.getExtensionList()).isEmpty()) {
            if (customizers.size() == 1) {
                PushDialogCustomizer customizer = (PushDialogCustomizer)customizers.get(0);
                VcsPushDialog.customizeDialog(dialog, customizer, simplePushAction);
            } else {
                LOG.warn("There can be only one push actions customizer, found: " + String.valueOf(customizers));
            }
        }
    }

    private static void customizeDialog(@NotNull VcsPushDialog dialog, @NotNull PushDialogCustomizer customizer, @NotNull SimplePushAction simplePushAction) {
        if (dialog == null) {
            VcsPushDialog.$$$reportNull$$$0(8);
        }
        if (customizer == null) {
            VcsPushDialog.$$$reportNull$$$0(9);
        }
        if (simplePushAction == null) {
            VcsPushDialog.$$$reportNull$$$0(10);
        }
        simplePushAction.getTemplatePresentation().setText(customizer.getNameForSimplePushAction(dialog));
        simplePushAction.setCondition(customizer.getCondition());
    }

    @Nullable
    protected Border createContentPaneBorder() {
        return null;
    }

    @Nullable
    protected JPanel createSouthAdditionalPanel() {
        return this.createSouthOptionsPanel();
    }

    protected JComponent createSouthPanel() {
        JComponent southPanel = super.createSouthPanel();
        southPanel.setBorder((Border)JBUI.Borders.empty((int)8, (int)12));
        return southPanel;
    }

    protected JComponent createCenterPanel() {
        BorderLayoutPanel panel = JBUI.Panels.simplePanel().addToTop((Component)this.myTopPanel).addToCenter((Component)this.myListPanel).addToBottom((Component)this.createOptionsPanel());
        this.myListPanel.setPreferredSize((Dimension)new JBDimension(800, 450));
        return panel;
    }

    @NotNull
    protected JPanel createOptionsPanel() {
        OptionsPanel optionsPanel = new OptionsPanel();
        optionsPanel.setBorder((Border)JBUI.Borders.emptyTop((int)2));
        ArrayList<VcsPushOptionsPanel> panels = new ArrayList<VcsPushOptionsPanel>(this.myAdditionalPanels.values());
        panels.addAll(this.myCustomPanels.values());
        for (VcsPushOptionsPanel panel : panels) {
            if (panel.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.DEFAULT) continue;
            ((Container)optionsPanel).add((Component)panel);
        }
        OptionsPanel optionsPanel2 = optionsPanel;
        if (optionsPanel2 == null) {
            VcsPushDialog.$$$reportNull$$$0(11);
        }
        return optionsPanel2;
    }

    @NotNull
    private JPanel createSouthOptionsPanel() {
        JPanel optionsPanel = new JPanel((LayoutManager)new MigLayout("ins 0 20 0 0, flowx, gapx 16"));
        ArrayList<VcsPushOptionsPanel> panels = new ArrayList<VcsPushOptionsPanel>(this.myAdditionalPanels.values());
        panels.addAll(this.myCustomPanels.values());
        for (VcsPushOptionsPanel panel : panels) {
            if (panel.getPosition() != VcsPushOptionsPanel.OptionsPanelPosition.SOUTH) continue;
            optionsPanel.add((Component)panel);
        }
        JPanel jPanel = optionsPanel;
        if (jPanel == null) {
            VcsPushDialog.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    protected String getDimensionServiceKey() {
        return DIMENSION_KEY;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.updateOkActions();
        return null;
    }

    protected boolean postponeValidation() {
        return false;
    }

    protected void doOKAction() {
        this.push(false);
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.myMainAction);
        actions.add(this.getCancelAction());
        actions.add(this.getHelpAction());
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            VcsPushDialog.$$$reportNull$$$0(13);
        }
        return actionArray;
    }

    @Override
    public boolean canPush() {
        return this.myController.isPushAllowed();
    }

    @Override
    public boolean hasWarnings() {
        return this.myController.hasCommitWarnings();
    }

    @Override
    @NotNull
    public Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> getSelectedPushSpecs() {
        Map<PushSupport<Repository, PushSource, PushTarget>, Collection<PushInfo>> map = this.myController.getSelectedPushSpecs();
        if (map == null) {
            VcsPushDialog.$$$reportNull$$$0(14);
        }
        return map;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myListPanel.getPreferredFocusedComponent();
    }

    @NotNull
    protected Action getOKAction() {
        ComplexPushAction complexPushAction = this.myMainAction;
        if (complexPushAction == null) {
            VcsPushDialog.$$$reportNull$$$0(15);
        }
        return complexPushAction;
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    @Override
    @RequiresEdt
    public void push(final boolean forcePush) {
        this.executeAfterRunningPrePushHandlers(new Task.Backgroundable(this.myProject, DvcsBundle.message((String)"push.process.pushing", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                VcsPushDialog.this.myController.push(forcePush);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dvcs/push/ui/VcsPushDialog$1", "run"));
            }
        });
    }

    @Override
    @RequiresEdt
    public void executeAfterRunningPrePushHandlers(@NotNull Task.Backgroundable activity) {
        PrePushHandler.Result result;
        if (activity == null) {
            VcsPushDialog.$$$reportNull$$$0(16);
        }
        if ((result = this.runPrePushHandlersInModalTask()) == PrePushHandler.Result.OK) {
            activity.queue();
            this.close(0);
        } else if (result == PrePushHandler.Result.ABORT_AND_CLOSE) {
            this.doCancelAction();
        } else if (result == PrePushHandler.Result.ABORT) {
            // empty if block
        }
    }

    @RequiresEdt
    public PrePushHandler.Result runPrePushHandlersInModalTask() {
        FileDocumentManager.getInstance().saveAllDocuments();
        final AtomicReference<PrePushHandler.Result> result = new AtomicReference<PrePushHandler.Result>(PrePushHandler.Result.OK);
        new Task.Modal(this.myController.getProject(), DvcsBundle.message((String)"push.process.checking.commits", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                result.set(VcsPushDialog.this.myController.executeHandlers(indicator));
            }

            public void onThrowable(@NotNull Throwable error) {
                if (error == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (error instanceof PushController.HandlerException) {
                    String suggestionMessageProblem;
                    PushController.HandlerException handlerException = (PushController.HandlerException)error;
                    Throwable cause = handlerException.getCause();
                    String failedHandler = handlerException.getFailedHandlerName();
                    List<String> skippedHandlers = handlerException.getSkippedHandlers();
                    if (cause instanceof ProcessCanceledException) {
                        suggestionMessageProblem = DvcsBundle.message((String)"push.dialog.push.cancelled.message", (Object[])new Object[]{failedHandler});
                    } else {
                        super.onThrowable(cause);
                        suggestionMessageProblem = DvcsBundle.message((String)"push.dialog.push.failed.message", (Object[])new Object[]{failedHandler});
                    }
                    @Nls String suggestionMessageQuestion = skippedHandlers.isEmpty() ? DvcsBundle.message((String)"push.dialog.push.anyway.confirmation", (Object[])new Object[0]) : DvcsBundle.message((String)"push.dialog.skip.all.remaining.steps.confirmation", (Object[])new Object[0]);
                    this.suggestToSkipOrPush(suggestionMessageProblem + "\n" + suggestionMessageQuestion);
                } else {
                    super.onThrowable(error);
                }
            }

            public void onCancel() {
                super.onCancel();
                this.suggestToSkipOrPush(DvcsBundle.message((String)"push.dialog.skip.all.steps.confirmation", (Object[])new Object[0]));
            }

            private void suggestToSkipOrPush(@Nls @NotNull String message) {
                if (message == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)DvcsBundle.message((String)"action.push", (Object[])new Object[0]), (String)DvcsBundle.message((String)"action.push.anyway", (Object[])new Object[0]), (String)IdeBundle.message((String)"button.cancel", (Object[])new Object[0]), (Icon)UIUtil.getWarningIcon()) == 0) {
                    result.set(PrePushHandler.Result.OK);
                } else {
                    result.set(PrePushHandler.Result.ABORT);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "indicator";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "error";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "run";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onThrowable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "suggestToSkipOrPush";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.queue();
        return result.get();
    }

    public void updateOkActions() {
        for (ActionWrapper wrapper : this.myPushActions) {
            wrapper.update();
        }
        this.myMainAction.update();
        JButton jButton = this.getButton(this.myMainAction);
        if (jButton instanceof JBOptionButton) {
            JBOptionButton o = (JBOptionButton)jButton;
            if (!Arrays.equals(this.myMainAction.getOptions(), o.getOptions())) {
                o.setOptions(this.myMainAction.getOptions());
            }
        }
    }

    public void enableOkActions(boolean value) {
        this.myMainAction.setEnabled(value);
    }

    @Override
    @Nullable
    public VcsPushOptionValue getAdditionalOptionValue(@NotNull PushSupport support) {
        VcsPushOptionsPanel panel;
        if (support == null) {
            VcsPushDialog.$$$reportNull$$$0(17);
        }
        return (panel = this.myAdditionalPanels.get(support)) == null ? null : panel.getValue();
    }

    @ApiStatus.Experimental
    @Nullable
    public VcsPushOptionsPanel getCustomPanel(@NotNull String id) {
        if (id == null) {
            VcsPushDialog.$$$reportNull$$$0(18);
        }
        return this.myCustomPanels.get(id);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            VcsPushDialog.$$$reportNull$$$0(19);
        }
        sink.set(VCS_PUSH_DIALOG, (Object)this);
    }

    @ApiStatus.Experimental
    @NotNull
    public Map<String, VcsPushOptionValue> getCustomParams() {
        HashMap<String, VcsPushOptionValue> ret = new HashMap<String, VcsPushOptionValue>();
        this.myCustomPanels.forEach((id, panel) -> {
            VcsPushOptionValue value = panel.getValue();
            if (value != null) {
                ret.put((String)id, value);
            }
        });
        HashMap<String, VcsPushOptionValue> hashMap = ret;
        if (hashMap == null) {
            VcsPushDialog.$$$reportNull$$$0(20);
        }
        return hashMap;
    }

    private static Presentation buildActionPresentation(@NotNull AnAction action, @NotNull Project project, @NotNull VcsPushDialog dialog) {
        if (action == null) {
            VcsPushDialog.$$$reportNull$$$0(21);
        }
        if (project == null) {
            VcsPushDialog.$$$reportNull$$$0(22);
        }
        if (dialog == null) {
            VcsPushDialog.$$$reportNull$$$0(23);
        }
        DataContext dataContext = dataId -> {
            if (VCS_PUSH_DIALOG.is(dataId)) {
                return dialog;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return project;
            }
            return null;
        };
        Presentation presentation = new Presentation();
        if (action instanceof SimplePushAction) {
            SimplePushAction simplePushAction = (SimplePushAction)action;
            VcsPushDialog.customizeDialog(dialog, simplePushAction);
        }
        action.update(AnActionEvent.createEvent((DataContext)dataContext, (Presentation)presentation, (String)"VcsPushDialog", (ActionUiKind)ActionUiKind.NONE, null));
        return presentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 11, 12, 13, 14, 15, 20 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRepositories";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepos";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 6: 
            case 8: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simplePushAction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activity";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPushActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSouthOptionsPanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedPushSpecs";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getOKAction";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizeDialog";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "executeAfterRunningPrePushHandlers";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalOptionValue";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getCustomPanel";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "buildActionPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 11, 12, 13, 14, 15, 20 -> new IllegalStateException(string);
        };
    }

    private static final class ComplexPushAction
    extends AbstractAction
    implements OptionAction {
        private final List<ActionWrapper> myActions;
        private ActionWrapper myDefaultAction;
        private List<ActionWrapper> myOptions;

        private ComplexPushAction(@NotNull List<ActionWrapper> actions) {
            if (actions == null) {
                ComplexPushAction.$$$reportNull$$$0(0);
            }
            super(actions.getFirst().getName());
            this.myActions = actions;
            this.myDefaultAction = actions.getFirst();
            this.myOptions = actions.subList(1, actions.size());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myDefaultAction.actionPerformed(e);
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            for (Action action : this.myActions) {
                action.setEnabled(isEnabled);
            }
        }

        public void update() {
            int firstEnabled = ContainerUtil.indexOf(this.myActions, it -> it.isEnabled());
            if (firstEnabled >= 0) {
                this.myDefaultAction = this.myActions.get(firstEnabled);
                this.myOptions = new ArrayList<ActionWrapper>();
                this.myOptions.addAll(this.myActions.subList(0, firstEnabled));
                this.myOptions.addAll(this.myActions.subList(firstEnabled + 1, this.myActions.size()));
            }
            this.setEnabled(this.myDefaultAction.myDialog.canPush());
            Presentation presentation = VcsPushDialog.buildActionPresentation((AnAction)this.myDefaultAction.myRealAction, this.myDefaultAction.myProject, this.myDefaultAction.myDialog);
            TextWithMnemonic textWithMnemonic = (TextWithMnemonic)presentation.getTextWithPossibleMnemonic().get();
            this.putValue("Name", textWithMnemonic.getText());
            this.putValue("MnemonicKey", textWithMnemonic.getMnemonicCode());
            this.putValue("SwingDisplayedMnemonicIndexKey", textWithMnemonic.getMnemonicIndex());
            this.putValue("ShortDescription", presentation.getDescription());
        }

        public Action @NotNull [] getOptions() {
            Action[] actionArray = this.myOptions.toArray(new ActionWrapper[0]);
            if (actionArray == null) {
                ComplexPushAction.$$$reportNull$$$0(1);
            }
            return actionArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ComplexPushAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class OptionsPanel
    extends JPanel {
        OptionsPanel() {
            super((LayoutManager)new MigLayout("ins 0 0, flowy, gap 0"));
        }

        @Override
        public Component add(Component comp) {
            BorderLayoutPanel wrapperPanel = new BorderLayoutPanel().addToCenter(comp);
            wrapperPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)15, (int)0, (int)0));
            return super.add((Component)wrapperPanel);
        }
    }

    private static class ActionWrapper
    extends AbstractAction {
        @NotNull
        private final Project myProject;
        @NotNull
        private final VcsPushDialog myDialog;
        @NotNull
        private final PushActionBase myRealAction;

        ActionWrapper(@NotNull Project project, @NotNull VcsPushDialog dialog, @NotNull PushActionBase realAction) {
            if (project == null) {
                ActionWrapper.$$$reportNull$$$0(0);
            }
            if (dialog == null) {
                ActionWrapper.$$$reportNull$$$0(1);
            }
            if (realAction == null) {
                ActionWrapper.$$$reportNull$$$0(2);
            }
            this.myProject = project;
            this.myDialog = dialog;
            this.myRealAction = realAction;
            this.putValue("Name", this.myRealAction.getText(this.myDialog, true));
            this.putValue("AnAction", (Object)realAction);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myRealAction.actionPerformed(this.myProject, this.myDialog);
        }

        public void update() {
            Presentation presentation = VcsPushDialog.buildActionPresentation((AnAction)this.myRealAction, this.myProject, this.myDialog);
            this.setEnabled(presentation.isEnabled());
            TextWithMnemonic textWithMnemonic = (TextWithMnemonic)presentation.getTextWithPossibleMnemonic().get();
            this.putValue("Name", textWithMnemonic.getText());
            this.putValue("MnemonicKey", textWithMnemonic.getMnemonicCode());
            this.putValue("SwingDisplayedMnemonicIndexKey", textWithMnemonic.getMnemonicIndex());
            this.putValue("ShortDescription", presentation.getDescription());
        }

        @Nls
        @NotNull
        public String getName() {
            String string = Objects.requireNonNull(this.myRealAction.getTemplatePresentation().getTextWithMnemonic());
            if (string == null) {
                ActionWrapper.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dialog";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "realAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/push/ui/VcsPushDialog$ActionWrapper";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

