/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import git4idea.GitProtectedBranchesKt;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSingleCommitEditingAction;
import git4idea.rebase.log.GitCommitEditingActionBase;
import git4idea.rebase.log.GitNewCommitMessageActionDialogKt;
import git4idea.repo.GitRepository;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B+\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0001\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0014\u001a\u00020\u0011H\u0002J)\u0010\u0015\u001a\u00020\u00112!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00110\u0010J!\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0004\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0014J\r\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0016J\b\u0010 \u001a\u00020\u0006H\u0014J\b\u0010!\u001a\u00020\u000eH\u0002J\n\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010#\u001a\u00020\u0011H\u0014J\b\u0010$\u001a\u00020\u0011H\u0014J\b\u0010%\u001a\u00020&H\u0002R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lgit4idea/rebase/log/GitNewCommitMessageActionDialog;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lcom/intellij/openapi/ui/DialogWrapper;", "commitEditingData", "originMessage", "", "title", "dialogLabel", "<init>", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "originalHEAD", "commitEditor", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "onOk", "Lkotlin/Function1;", "", "repositoryValidationResult", "Lcom/intellij/openapi/ui/ValidationInfo;", "updateOkButtonState", "show", "Lkotlin/ParameterName;", "name", "newMessage", "validate", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;)Lcom/intellij/openapi/ui/ValidationInfo;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "Lcom/intellij/ui/EditorTextField;", "Lorg/jetbrains/annotations/NotNull;", "getDimensionServiceKey", "createCommitEditor", "doValidate", "doOKAction", "dispose", "shouldUpdateCommitHistory", "", "intellij.vcs.git"})
public final class GitNewCommitMessageActionDialog<T extends GitCommitEditingActionBase.MultipleCommitEditingData>
extends DialogWrapper {
    @NotNull
    private final T commitEditingData;
    @NotNull
    private final String originMessage;
    @NotNull
    private final String dialogLabel;
    @Nullable
    private final String originalHEAD;
    @NotNull
    private final CommitMessage commitEditor;
    @NotNull
    private Function1<? super String, Unit> onOk;
    @Nullable
    private ValidationInfo repositoryValidationResult;

    public GitNewCommitMessageActionDialog(@NotNull T commitEditingData, @NotNull String originMessage, @Nls @NotNull String title, @Nls @NotNull String dialogLabel) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)originMessage, (String)"originMessage");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)dialogLabel, (String)"dialogLabel");
        super(((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getProject(), true);
        this.commitEditingData = commitEditingData;
        this.originMessage = originMessage;
        this.dialogLabel = dialogLabel;
        this.originalHEAD = ((GitCommitEditingActionBase.MultipleCommitEditingData)this.commitEditingData).getRepository().getInfo().getCurrentRevision();
        this.commitEditor = this.createCommitEditor();
        this.onOk = GitNewCommitMessageActionDialog::onOk$lambda$0;
        Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)this.commitEditor));
        this.init();
        this.setModal(false);
        this.setTitle(title);
        this.commitEditor.getEditorField().addDocumentListener(new DocumentListener(){

            public void documentChanged(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.updateOkButtonState();
            }
        });
        this.updateOkButtonState();
    }

    private final void updateOkButtonState() {
        if (this.repositoryValidationResult != null) {
            return;
        }
        String string = this.commitEditor.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComment(...)");
        boolean isMessageEmpty = StringsKt.isBlank((CharSequence)string);
        this.setOKActionEnabled(!isMessageEmpty);
    }

    public final void show(@NotNull Function1<? super String, Unit> onOk) {
        Intrinsics.checkNotNullParameter(onOk, (String)"onOk");
        this.onOk = onOk;
        this.show();
    }

    private final ValidationInfo validate(T commitEditingData, String originalHEAD) {
        VcsLogData logData = ((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getLogData();
        GitRepository repository2 = ((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getRepository();
        List commits = ((GitCommitEditingActionBase.MultipleCommitEditingData)commitEditingData).getSelection().getCommits();
        if (!Intrinsics.areEqual((Object)repository2.getInfo().getCurrentRevision(), (Object)originalHEAD) || logData.isDisposed()) {
            Object[] objectArray = new Object[]{commits.size()};
            return new ValidationInfo(GitBundle.message("rebase.log.reword.dialog.failed.repository.changed.message", objectArray));
        }
        Hash hash = ((CommitId)CollectionsKt.last((List)commits)).getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
        Hash lastCommitHash = hash;
        VirtualFile virtualFile = repository2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        List<String> branches = GitCommitEditingActionBase.Companion.findContainingBranches(logData, virtualFile, lastCommitHash);
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository2, (Collection<String>)branches);
        if (protectedBranch != null) {
            Object[] objectArray = new Object[]{commits.size(), lastCommitHash, protectedBranch};
            return new ValidationInfo(GitBundle.message("rebase.log.reword.dialog.failed.pushed.to.protected.message", objectArray));
        }
        return null;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel dialogPanel;
        DialogPanel it = dialogPanel = BuilderKt.panel(arg_0 -> GitNewCommitMessageActionDialog.createCenterPanel$lambda$0(this, arg_0));
        boolean bl = false;
        it.setMinimumSize((Dimension)JBUI.size((int)400, (int)120));
        return (JComponent)dialogPanel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.commitEditor.getEditorField();
        Intrinsics.checkNotNullExpressionValue((Object)editorTextField, (String)"getEditorField(...)");
        return editorTextField;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "Git.Rebase.Log.Action.NewCommitMessage.Dialog";
    }

    private final CommitMessage createCommitEditor() {
        Project project = ((GitCommitEditingActionBase.MultipleCommitEditingData)this.commitEditingData).getProject();
        CommitMessage editor2 = new CommitMessage(this, project){
            final /* synthetic */ GitNewCommitMessageActionDialog<T> this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false, false, true);
            }

            public void uiDataSnapshot(DataSink sink) {
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                super.uiDataSnapshot(sink);
                DataKey dataKey = VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"VCS_LOG_COMMIT_SELECTION");
                sink.set(dataKey, (Object)GitNewCommitMessageActionDialog.access$getCommitEditingData$p(this.this$0).getSelection());
                DataKey dataKey2 = VcsLogInternalDataKeys.LOG_DATA;
                Intrinsics.checkNotNullExpressionValue((Object)dataKey2, (String)"LOG_DATA");
                sink.set(dataKey2, (Object)GitNewCommitMessageActionDialog.access$getCommitEditingData$p(this.this$0).getLogData());
            }
        };
        if (this.commitEditingData instanceof GitSingleCommitEditingAction.SingleCommitEditingData && !((Collection)((GitSingleCommitEditingAction.SingleCommitEditingData)this.commitEditingData).getSelectedChanges()).isEmpty()) {
            editor2.setChangesSupplier(() -> GitNewCommitMessageActionDialog.createCommitEditor$lambda$0(this));
        }
        editor2.setText(this.originMessage);
        editor2.getEditorField().setCaretPosition(0);
        return editor2;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        this.repositoryValidationResult = this.validate(this.commitEditingData, this.originalHEAD);
        return this.repositoryValidationResult;
    }

    protected void doOKAction() {
        super.doOKAction();
        String string = this.commitEditor.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getComment(...)");
        this.onOk.invoke((Object)string);
    }

    protected void dispose() {
        if (this.shouldUpdateCommitHistory()) {
            VcsConfiguration.getInstance((Project)((GitCommitEditingActionBase.MultipleCommitEditingData)this.commitEditingData).getProject()).saveCommitMessage(this.commitEditor.getComment());
        }
        super.dispose();
    }

    private final boolean shouldUpdateCommitHistory() {
        return !Intrinsics.areEqual((Object)this.commitEditor.getComment(), (Object)this.originMessage);
    }

    private static final Unit onOk$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0(GitNewCommitMessageActionDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        GitNewCommitMessageActionDialogKt.commitMessageWithLabelAndToolbar($this$panel, this$0.commitEditor, this$0.dialogLabel);
        return Unit.INSTANCE;
    }

    private static final Iterable createCommitEditor$lambda$0(GitNewCommitMessageActionDialog this$0) {
        return ((GitSingleCommitEditingAction.SingleCommitEditingData)this$0.commitEditingData).getSelectedChanges();
    }

    public static final /* synthetic */ GitCommitEditingActionBase.MultipleCommitEditingData access$getCommitEditingData$p(GitNewCommitMessageActionDialog $this) {
        return $this.commitEditingData;
    }
}

