/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.digest;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.digest.BubbleBabble;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

@JRubyModule(name={"Digest"})
public class RubyDigest {
    private static final Map<String, MessageDigest> CLONEABLE_DIGESTS = new HashMap<String, MessageDigest>(8, 1.0f);
    private static final String PROVIDER = "org.bouncycastle.jce.provider.BouncyCastleProvider";
    private static Provider provider;
    private static final byte[] digits;

    private static Logger logger() {
        return LoggerFactory.getLogger(RubyDigest.class);
    }

    public static void createDigest(Ruby ruby) {
        try {
            provider = (Provider)Class.forName(PROVIDER).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        RubyModule rubyModule = ruby.defineModule("Digest");
        rubyModule.defineAnnotatedMethods(RubyDigest.class);
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("Instance");
        rubyModule2.defineAnnotatedMethods(DigestInstance.class);
        RubyClass rubyClass = rubyModule.defineClassUnder("Class", ruby.getObject(), DigestClass::new);
        rubyClass.defineAnnotatedMethods(DigestClass.class);
        rubyClass.includeModule((IRubyObject)rubyModule2);
        RubyClass rubyClass2 = rubyModule.defineClassUnder("Base", rubyClass, DigestBase::new);
        rubyClass2.defineAnnotatedMethods(DigestBase.class);
    }

    private static MessageDigest createMessageDigest(String string) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = CLONEABLE_DIGESTS.get(string);
        if (messageDigest != null) {
            try {
                return (MessageDigest)messageDigest.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        if (provider != null) {
            try {
                return MessageDigest.getInstance(string, provider);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return MessageDigest.getInstance(string);
    }

    private static ByteList toHex(byte[] byArray) {
        ByteList byteList = new ByteList(byArray.length * 2);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] & 0xFF;
            byteList.append(digits[n2 >> 4]);
            byteList.append(digits[n2 & 0xF]);
        }
        return byteList;
    }

    private static RubyString toHexString(Ruby ruby, byte[] byArray) {
        return RubyString.newStringNoCopy((Ruby)ruby, (ByteList)new ByteList(ByteList.plain((CharSequence)RubyDigest.toHex(byArray)), (Encoding)USASCIIEncoding.INSTANCE));
    }

    @JRubyMethod(name={"hexencode"}, required=1, meta=true)
    public static RubyString hexencode(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return RubyDigest.toHexString(iRubyObject.getRuntime(), iRubyObject2.convertToString().getBytes());
    }

    @JRubyMethod(name={"bubblebabble"}, required=1, meta=true)
    public static RubyString bubblebabble(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = iRubyObject2.convertToString().getByteList();
        return RubyString.newString((Ruby)iRubyObject.getRuntime(), (ByteList)BubbleBabble.bubblebabble(byteList.unsafeBytes(), byteList.begin(), byteList.length()));
    }

    public static void createDigestMD5(Ruby ruby) {
        ruby.getLoadService().require("digest");
        RubyModule rubyModule = ruby.getModule("Digest");
        RubyClass rubyClass = rubyModule.getClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("MD5", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalVariable("metadata", (Object)new Metadata("MD5", 64));
    }

    public static void createDigestRMD160(Ruby ruby) {
        ruby.getLoadService().require("digest");
        if (provider == null) {
            throw ruby.newLoadError("RMD160 not supported without BouncyCastle");
        }
        RubyModule rubyModule = ruby.getModule("Digest");
        RubyClass rubyClass = rubyModule.getClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("RMD160", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalVariable("metadata", (Object)new Metadata("RIPEMD160", 64));
    }

    public static void createDigestSHA1(Ruby ruby) {
        ruby.getLoadService().require("digest");
        RubyModule rubyModule = ruby.getModule("Digest");
        RubyClass rubyClass = rubyModule.getClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("SHA1", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalVariable("metadata", (Object)new Metadata("SHA1", 64));
    }

    public static void createDigestSHA2(Ruby ruby) {
        ruby.getLoadService().require("digest");
        try {
            RubyDigest.createMessageDigest("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            RaiseException raiseException = ruby.newLoadError("SHA2 not supported");
            raiseException.initCause((Throwable)noSuchAlgorithmException);
            throw raiseException;
        }
        RubyModule rubyModule = ruby.getModule("Digest");
        RubyClass rubyClass = rubyModule.getClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("SHA256", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalVariable("metadata", (Object)new Metadata("SHA-256", 64));
        RubyClass rubyClass3 = rubyModule.defineClassUnder("SHA384", rubyClass, rubyClass.getAllocator());
        rubyClass3.setInternalVariable("metadata", (Object)new Metadata("SHA-384", 128));
        RubyClass rubyClass4 = rubyModule.defineClassUnder("SHA512", rubyClass, rubyClass.getAllocator());
        rubyClass4.setInternalVariable("metadata", (Object)new Metadata("SHA-512", 128));
    }

    public static void createDigestBubbleBabble(Ruby ruby) {
        ruby.getLoadService().require("digest");
        RubyModule rubyModule = ruby.getModule("Digest");
        RubyClass rubyClass = rubyModule.getClass("Base");
        RubyClass rubyClass2 = rubyModule.defineClassUnder("BubbleBabble", rubyClass, rubyClass.getAllocator());
        rubyClass2.setInternalVariable("metadata", (Object)new Metadata("BubbleBabble", 64));
    }

    static {
        for (String string : new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"}) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance(string);
                messageDigest.clone();
                CLONEABLE_DIGESTS.put(string, messageDigest);
            }
            catch (Exception exception) {
                RubyDigest.logger().debug(string + " not clonable", (Throwable)exception);
            }
        }
        provider = null;
        digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    }

    @JRubyModule(name={"Digest::Instance"})
    public static class DigestInstance {
        private static IRubyObject throwUnimplError(IRubyObject iRubyObject, String string) {
            throw iRubyObject.getRuntime().newRuntimeError(String.format("%s does not implement %s()", iRubyObject.getMetaClass().getRealClass().getName(), string));
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public static IRubyObject update(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return DigestInstance.throwUnimplError(iRubyObject, "update");
        }

        @JRubyMethod
        public static IRubyObject finish(ThreadContext threadContext, IRubyObject iRubyObject) {
            return DigestInstance.throwUnimplError(iRubyObject, "finish");
        }

        @JRubyMethod
        public static IRubyObject reset(ThreadContext threadContext, IRubyObject iRubyObject) {
            return DigestInstance.throwUnimplError(iRubyObject, "reset");
        }

        @JRubyMethod
        public static IRubyObject digest_length(ThreadContext threadContext, IRubyObject iRubyObject) {
            return DigestInstance.digest(threadContext, iRubyObject, null).convertToString().bytesize();
        }

        @JRubyMethod
        public static IRubyObject block_length(ThreadContext threadContext, IRubyObject iRubyObject) {
            return DigestInstance.throwUnimplError(iRubyObject, "block_length");
        }

        @JRubyMethod(name={"=="}, required=1)
        public static IRubyObject op_equal(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            RubyString rubyString;
            RubyString rubyString2;
            if (iRubyObject2.isNil()) {
                return threadContext.fals;
            }
            RubyModule rubyModule = (RubyModule)threadContext.runtime.getModule("Digest").getConstantAt("Instance");
            if (iRubyObject2.getMetaClass().getRealClass().hasModuleInHierarchy(rubyModule)) {
                rubyString2 = DigestInstance.digest(threadContext, iRubyObject, null).convertToString();
                rubyString = DigestInstance.digest(threadContext, iRubyObject2, null).convertToString();
            } else {
                rubyString2 = DigestInstance.to_s(threadContext, iRubyObject).convertToString();
                rubyString = iRubyObject2.convertToString();
            }
            boolean bl = rubyString2.bytesize().eql((IRubyObject)rubyString.bytesize()) && rubyString2.eql((IRubyObject)rubyString);
            return bl ? threadContext.tru : threadContext.fals;
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext threadContext, IRubyObject iRubyObject) {
            return RubyString.newStringNoCopy((Ruby)iRubyObject.getRuntime(), (byte[])ByteList.plain((CharSequence)("#<" + iRubyObject.getMetaClass().getRealClass().getName() + ": " + DigestInstance.hexdigest(threadContext, iRubyObject, null) + ">")));
        }

        @JRubyMethod(name={"new"})
        public static IRubyObject newObject(ThreadContext threadContext, IRubyObject iRubyObject) {
            return iRubyObject.rbClone().callMethod(threadContext, "reset");
        }

        @JRubyMethod(optional=1)
        public static IRubyObject digest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            IRubyObject iRubyObject2;
            if (iRubyObjectArray != null && iRubyObjectArray.length > 0) {
                iRubyObject.callMethod(threadContext, "reset");
                iRubyObject.callMethod(threadContext, "update", iRubyObjectArray[0]);
                iRubyObject2 = iRubyObject.callMethod(threadContext, "finish");
                iRubyObject.callMethod(threadContext, "reset");
            } else {
                IRubyObject iRubyObject3 = iRubyObject.rbClone();
                iRubyObject2 = iRubyObject3.callMethod(threadContext, "finish");
                iRubyObject3.callMethod(threadContext, "reset");
            }
            return iRubyObject2;
        }

        @JRubyMethod(name={"digest!"})
        public static IRubyObject digest_bang(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "finish");
            iRubyObject.callMethod(threadContext, "reset");
            return iRubyObject2;
        }

        @JRubyMethod(optional=1)
        public static IRubyObject hexdigest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return RubyDigest.toHexString(threadContext.runtime, DigestInstance.digest(threadContext, iRubyObject, iRubyObjectArray).convertToString().getBytes());
        }

        @JRubyMethod(name={"hexdigest!"})
        public static IRubyObject hexdigest_bang(ThreadContext threadContext, IRubyObject iRubyObject) {
            return RubyDigest.toHexString(threadContext.runtime, DigestInstance.digest_bang(threadContext, iRubyObject).convertToString().getBytes());
        }

        @JRubyMethod(name={"bubblebabble"}, required=1, optional=1, meta=true)
        public static IRubyObject bubblebabble(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            byte[] byArray = iRubyObject.callMethod(threadContext, "digest", iRubyObjectArray, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyString.newString((Ruby)iRubyObject.getRuntime(), (ByteList)BubbleBabble.bubblebabble(byArray, 0, byArray.length));
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext threadContext, IRubyObject iRubyObject) {
            return iRubyObject.callMethod(threadContext, "hexdigest");
        }

        @JRubyMethod(name={"length", "size"})
        public static IRubyObject length(ThreadContext threadContext, IRubyObject iRubyObject) {
            return iRubyObject.callMethod(threadContext, "digest_length");
        }
    }

    @JRubyClass(name={"Digest::Class"})
    public static class DigestClass
    extends RubyObject {
        public DigestClass(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod(name={"digest"}, required=1, rest=true, meta=true)
        public static IRubyObject s_digest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Ruby ruby = threadContext.runtime;
            if (iRubyObjectArray.length < 1) {
                throw ruby.newArgumentError("no data given");
            }
            RubyString rubyString = iRubyObjectArray[0].convertToString();
            iRubyObjectArray = ArraySupport.newCopy((IRubyObject[])iRubyObjectArray, (int)1, (int)(iRubyObjectArray.length - 1));
            IRubyObject iRubyObject2 = ((RubyClass)iRubyObject).newInstance(threadContext, iRubyObjectArray, Block.NULL_BLOCK);
            return iRubyObject2.callMethod(threadContext, "digest", (IRubyObject)rubyString);
        }

        @JRubyMethod(name={"hexdigest"}, required=1, optional=1, meta=true)
        public static IRubyObject s_hexdigest(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray, Block block) {
            Ruby ruby = iRubyObject.getRuntime();
            byte[] byArray = iRubyObject.callMethod(threadContext, "digest", iRubyObjectArray, Block.NULL_BLOCK).convertToString().getBytes();
            return RubyDigest.toHexString(ruby, byArray);
        }

        @JRubyMethod(name={"bubblebabble"}, required=1, meta=true)
        public static RubyString bubblebabble(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            byte[] byArray = iRubyObject.callMethod(iRubyObject.getRuntime().getCurrentContext(), "digest", iRubyObject2).convertToString().getBytes();
            return RubyString.newString((Ruby)iRubyObject.getRuntime(), (ByteList)BubbleBabble.bubblebabble(byArray, 0, byArray.length));
        }
    }

    @JRubyClass(name={"Digest::Base"})
    public static class DigestBase
    extends RubyObject {
        private MessageDigest algo;
        private int blockLength = 0;

        public DigestBase(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
            if (rubyClass == ruby.getModule("Digest").getClass("Base")) {
                throw ruby.newNotImplementedError("Digest::Base is an abstract class");
            }
            Metadata metadata = this.getMetadata((RubyModule)rubyClass);
            if (metadata == null) {
                throw ruby.newNotImplementedError("the " + rubyClass + "() function is unimplemented on this machine");
            }
            try {
                this.setAlgorithm(metadata);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw ruby.newNotImplementedError("the " + rubyClass + "() function is unimplemented on this machine");
            }
        }

        private Metadata getMetadata(RubyModule rubyModule) {
            for (RubyModule rubyModule2 = rubyModule; rubyModule2 != null; rubyModule2 = rubyModule2.getSuperClass()) {
                Metadata metadata = (Metadata)rubyModule2.getInternalVariable("metadata");
                if (metadata == null) continue;
                return metadata;
            }
            return null;
        }

        @JRubyMethod(required=1, visibility=Visibility.PRIVATE)
        public IRubyObject initialize_copy(IRubyObject iRubyObject) {
            if (this == iRubyObject) {
                return this;
            }
            DigestBase digestBase = (DigestBase)iRubyObject;
            digestBase.checkFrozen();
            try {
                this.algo = (MessageDigest)digestBase.algo.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                String string = digestBase.algo.getAlgorithm();
                throw this.getRuntime().newTypeError("Could not initialize copy of digest (" + string + ")");
            }
            return this;
        }

        @JRubyMethod(name={"update", "<<"}, required=1)
        public IRubyObject update(IRubyObject iRubyObject) {
            ByteList byteList = iRubyObject.convertToString().getByteList();
            this.algo.update(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            return this;
        }

        @JRubyMethod
        public IRubyObject finish() {
            RubyString rubyString = RubyString.newStringNoCopy((Ruby)this.getRuntime(), (byte[])this.algo.digest());
            this.algo.reset();
            return rubyString;
        }

        @JRubyMethod
        public IRubyObject digest_length() {
            return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (int)this.algo.getDigestLength());
        }

        @JRubyMethod
        public IRubyObject block_length() {
            if (this.blockLength == 0) {
                throw this.getRuntime().newRuntimeError(this.getMetaClass() + " doesn't implement block_length()");
            }
            return RubyFixnum.newFixnum((Ruby)this.getRuntime(), (int)this.blockLength);
        }

        @JRubyMethod
        public IRubyObject reset() {
            this.algo.reset();
            return this;
        }

        @JRubyMethod
        public IRubyObject bubblebabble(ThreadContext threadContext) {
            byte[] byArray = this.algo.digest();
            return RubyString.newString((Ruby)threadContext.runtime, (ByteList)BubbleBabble.bubblebabble(byArray, 0, byArray.length));
        }

        private void setAlgorithm(Metadata metadata) throws NoSuchAlgorithmException {
            this.algo = RubyDigest.createMessageDigest(metadata.getName());
            this.blockLength = metadata.getBlockLength();
        }
    }

    private static class Metadata {
        private final String name;
        private final int blockLength;

        Metadata(String string, int n) {
            this.name = string;
            this.blockLength = n;
        }

        String getName() {
            return this.name;
        }

        int getBlockLength() {
            return this.blockLength;
        }
    }

    @JRubyClass(name={"Digest::SHA512"}, parent="Digest::Base")
    public static class SHA512 {
    }

    @JRubyClass(name={"Digest::SHA384"}, parent="Digest::Base")
    public static class SHA384 {
    }

    @JRubyClass(name={"Digest::SHA256"}, parent="Digest::Base")
    public static class SHA256 {
    }

    @JRubyClass(name={"Digest::SHA1"}, parent="Digest::Base")
    public static class SHA1 {
    }

    @JRubyClass(name={"Digest::RMD160"}, parent="Digest::Base")
    public static class RMD160 {
    }

    @JRubyClass(name={"Digest::MD5"}, parent="Digest::Base")
    public static class MD5 {
    }
}

