/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import org.hibernate.metamodel.MappingMetamodel;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.internal.MappingModelHelper;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.persister.entity.EntityPersister;

public class DomainModelHelper {
    static boolean isCompatible(PersistentAttribute<?, ?> attribute1, PersistentAttribute<?, ?> attribute2, MappingMetamodel mappingMetamodel) {
        if (attribute1 == attribute2) {
            return true;
        }
        ModelPart modelPart1 = DomainModelHelper.getEntityAttributeModelPart(attribute1, attribute1.getDeclaringType(), mappingMetamodel);
        ModelPart modelPart2 = DomainModelHelper.getEntityAttributeModelPart(attribute2, attribute2.getDeclaringType(), mappingMetamodel);
        return modelPart1 != null && modelPart2 != null && MappingModelHelper.isCompatibleModelPart(modelPart1, modelPart2);
    }

    static ModelPart getEntityAttributeModelPart(PersistentAttribute<?, ?> attribute, ManagedDomainType<?> domainType, MappingMetamodel mappingMetamodel) {
        if (domainType instanceof EntityDomainType) {
            EntityPersister entity = mappingMetamodel.getEntityDescriptor(domainType.getTypeName());
            return entity.findSubPart(attribute.getName());
        }
        ModelPart candidate = null;
        for (ManagedDomainType<?> subType : domainType.getSubTypes()) {
            ModelPart modelPart = DomainModelHelper.getEntityAttributeModelPart(attribute, subType, mappingMetamodel);
            if (modelPart == null) continue;
            if (candidate != null && !MappingModelHelper.isCompatibleModelPart(candidate, modelPart)) {
                return null;
            }
            candidate = modelPart;
        }
        return candidate;
    }
}

