/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.DomainParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class AsymmetricDHKey
implements AsymmetricKey {
    private final boolean approvedModeOnly = CryptoServicesRegistrar.isInApprovedOnlyMode();
    private Algorithm algorithm;
    private DHDomainParameters domainParameters;

    AsymmetricDHKey(Algorithm algorithm, DHDomainParameters dHDomainParameters) {
        this.algorithm = algorithm;
        this.domainParameters = dHDomainParameters;
    }

    AsymmetricDHKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier) {
        this.algorithm = algorithm;
        this.domainParameters = AsymmetricDHKey.decodeDomainParameters(algorithmIdentifier);
    }

    private static DHDomainParameters decodeDomainParameters(AlgorithmIdentifier algorithmIdentifier) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
        ASN1Encodable aSN1Encodable = algorithmIdentifier.getParameters();
        if (aSN1Encodable == null) {
            throw new NullPointerException("AlgorithmIdentifier parameters cannot be empty");
        }
        if (aSN1ObjectIdentifier.equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter elGamalParameter = ElGamalParameter.getInstance(aSN1Encodable);
            return new DHDomainParameters(elGamalParameter.getP(), elGamalParameter.getG());
        }
        if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.dhKeyAgreement) || KeyUtils.isDHPKCSParam(aSN1Encodable)) {
            DHParameter dHParameter = DHParameter.getInstance(aSN1Encodable);
            if (dHParameter.getL() != null) {
                return new DHDomainParameters(dHParameter.getP(), null, dHParameter.getG(), dHParameter.getL().intValue());
            }
            return new DHDomainParameters(dHParameter.getP(), dHParameter.getG());
        }
        if (aSN1ObjectIdentifier.equals(X9ObjectIdentifiers.dhpublicnumber)) {
            DomainParameters domainParameters = DomainParameters.getInstance(aSN1Encodable);
            if (domainParameters.getValidationParams() != null) {
                return new DHDomainParameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), new DHValidationParameters(domainParameters.getValidationParams().getSeed(), domainParameters.getValidationParams().getPgenCounter().intValue()));
            }
            return new DHDomainParameters(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), null);
        }
        throw new IllegalArgumentException("Unknown algorithm type: " + aSN1ObjectIdentifier);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public DHDomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected final boolean isThreadCorrectMode() {
        return this.approvedModeOnly == CryptoServicesRegistrar.isInApprovedOnlyMode();
    }

    protected final void checkApprovedOnlyModeStatus() {
        if (!this.isThreadCorrectMode()) {
            throw new FipsUnapprovedOperationError("No access to key in current thread.");
        }
    }

    protected void zeroize() {
        this.algorithm = null;
        this.domainParameters = null;
    }
}

