/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.lucene;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.search.knn.KnnCollectorManager;
import org.apache.lucene.search.knn.KnnSearchStrategy;

public class OptimisticKnnCollectorManager
implements KnnCollectorManager {
    private static final int LAMBDA = 16;
    private final int k;
    private final KnnCollectorManager delegate;

    public OptimisticKnnCollectorManager(int k, KnnCollectorManager delegate) {
        this.k = k;
        this.delegate = delegate;
    }

    public KnnCollector newCollector(int visitedLimit, KnnSearchStrategy searchStrategy, LeafReaderContext context) throws IOException {
        if (this.delegate.isOptimistic()) {
            float leafProportion = (float)context.reader().maxDoc() / (float)context.parent.reader().maxDoc();
            int perLeafTopK = OptimisticKnnCollectorManager.perLeafTopKCalculation(this.k, leafProportion);
            assert (perLeafTopK > 0);
            return this.delegate.newOptimisticCollector(visitedLimit, searchStrategy, context, perLeafTopK);
        }
        return this.delegate.newCollector(visitedLimit, searchStrategy, context);
    }

    private static int perLeafTopKCalculation(int k, float leafProportion) {
        return (int)Math.max(1.0, (double)((float)k * leafProportion) + 16.0 * Math.sqrt((float)k * leafProportion * (1.0f - leafProportion)));
    }
}

