// Copyright (C) 2017 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only
// Qt-Security score:significant reason:default

import QtQuick
import QtQuick.Controls.impl
import QtQuick.Templates as T

T.RoundButton {
    id: control

    implicitWidth: Math.max(implicitBackgroundWidth + leftInset + rightInset,
                            implicitContentWidth + leftPadding + rightPadding)
    implicitHeight: Math.max(implicitBackgroundHeight + topInset + bottomInset,
                             implicitContentHeight + topPadding + bottomPadding)

    padding: 6
    spacing: 6

    icon.width: 24
    icon.height: 24

    contentItem: IconLabel {
        spacing: control.spacing
        mirrored: control.mirrored
        display: control.display

        icon: control.icon
        defaultIconColor: control.checked || control.highlighted ? control.palette.brightText
            : control.flat && !control.down ? (control.visualFocus ? control.palette.highlight
            : control.palette.windowText) : control.palette.buttonText
        text: control.text
        font: control.font
        color: defaultIconColor
    }

    background: Rectangle {
        implicitWidth: 40
        implicitHeight: 40
        radius: control.radius
        opacity: enabled ? 1 : 0.3
        visible: !control.flat || control.down || control.checked || control.highlighted
        color: Color.blend(control.checked || control.highlighted ? control.palette.dark : control.palette.button,
                                                                    control.palette.mid, control.down ? 0.5 : 0.0)
        border.color: {
            if (control.visualFocus)
                return control.palette.highlight
            else if (Qt.styleHints.accessibility.contrastPreference === Qt.HighContrast)
                return Color.blend(control.palette.text, control.palette.dark,
                                   control.enabled ? 0.0 : 0.3)
            else
                return control.palette.windowText
        }
        border.width: control.visualFocus ? 2 :
                      (Qt.styleHints.accessibility.contrastPreference == Qt.HighContrast) ? 1 : 0
    }
}
