/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.object.ImmutableMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Objects;

final class StrongKeyWeakValueEntry<K, V>
extends WeakReference<V>
implements Map.Entry<K, V> {
    private final K key;

    StrongKeyWeakValueEntry(K key, V value) {
        super(value);
        this.key = Objects.requireNonNull(key);
    }

    StrongKeyWeakValueEntry(K key, V value, ReferenceQueue<? super V> queue) {
        super(value, queue);
        this.key = Objects.requireNonNull(key);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return (V)this.get();
    }

    @Override
    public V setValue(V value) {
        throw ImmutableMap.unmodifiableException();
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StrongKeyWeakValueEntry)) {
            return false;
        }
        StrongKeyWeakValueEntry other = (StrongKeyWeakValueEntry)obj;
        return this.key.equals(other.getKey()) && Objects.equals(this.getValue(), other.getValue());
    }

    public String toString() {
        return String.valueOf(this.getKey()) + "=" + String.valueOf(this.getValue());
    }
}

