/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  4 13:49:14 EST 2014 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 25 -dit -name hf2_25 -include hf.h */

/*
 * This function contains 440 FP additions, 434 FP multiplications,
 * (or, 84 additions, 78 multiplications, 356 fused multiply/add),
 * 215 stack variables, 47 constants, and 100 memory accesses
 */
#include "hf.h"

static void hf2_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP949179823, +0.949179823508441261575555465843363271711583843);
     DK(KP860541664, +0.860541664367944677098261680920518816412804187);
     DK(KP621716863, +0.621716863012209892444754556304102309693593202);
     DK(KP614372930, +0.614372930789563808870829930444362096004872855);
     DK(KP557913902, +0.557913902031834264187699648465567037992437152);
     DK(KP249506682, +0.249506682107067890488084201715862638334226305);
     DK(KP560319534, +0.560319534973832390111614715371676131169633784);
     DK(KP681693190, +0.681693190061530575150324149145440022633095390);
     DK(KP906616052, +0.906616052148196230441134447086066874408359177);
     DK(KP968479752, +0.968479752739016373193524836781420152702090879);
     DK(KP845997307, +0.845997307939530944175097360758058292389769300);
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP994076283, +0.994076283785401014123185814696322018529298887);
     DK(KP734762448, +0.734762448793050413546343770063151342619912334);
     DK(KP772036680, +0.772036680810363904029489473607579825330539880);
     DK(KP062914667, +0.062914667253649757225485955897349402364686947);
     DK(KP921177326, +0.921177326965143320250447435415066029359282231);
     DK(KP833417178, +0.833417178328688677408962550243238843138996060);
     DK(KP541454447, +0.541454447536312777046285590082819509052033189);
     DK(KP803003575, +0.803003575438660414833440593570376004635464850);
     DK(KP943557151, +0.943557151597354104399655195398983005179443399);
     DK(KP242145790, +0.242145790282157779872542093866183953459003101);
     DK(KP554608978, +0.554608978404018097464974850792216217022558774);
     DK(KP559154169, +0.559154169276087864842202529084232643714075927);
     DK(KP683113946, +0.683113946453479238701949862233725244439656928);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP248028675, +0.248028675328619457762448260696444630363259177);
     DK(KP904730450, +0.904730450839922351881287709692877908104763647);
     DK(KP831864738, +0.831864738706457140726048799369896829771167132);
     DK(KP525970792, +0.525970792408939708442463226536226366643874659);
     DK(KP726211448, +0.726211448929902658173535992263577167607493062);
     DK(KP549754652, +0.549754652192770074288023275540779861653779767);
     DK(KP871714437, +0.871714437527667770979999223229522602943903653);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP939062505, +0.939062505817492352556001843133229685779824606);
     DK(KP851038619, +0.851038619207379630836264138867114231259902550);
     DK(KP256756360, +0.256756360367726783319498520922669048172391148);
     DK(KP912575812, +0.912575812670962425556968549836277086778922727);
     DK(KP634619297, +0.634619297544148100711287640319130485732531031);
     DK(KP912018591, +0.912018591466481957908415381764119056233607330);
     DK(KP470564281, +0.470564281212251493087595091036643380879947982);
     DK(KP827271945, +0.827271945972475634034355757144307982555673741);
     DK(KP126329378, +0.126329378446108174786050455341811215027378105);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E T7M, T6S, T6Q, T7S, T7Q, T7L, T6R, T6J, T7N, T7R;
	       {
		    E T2, T8, T3, T6, Tk, Tv, TS, T4, Ta, TD, T2L, T10, Tm, T5, Tc;
		    T2 = W[0];
		    T8 = W[4];
		    T3 = W[2];
		    T6 = W[3];
		    Tk = W[6];
		    Tv = T2 * T8;
		    TS = T3 * T8;
		    T4 = T2 * T3;
		    Ta = T2 * T6;
		    TD = T8 * Tk;
		    T2L = T2 * Tk;
		    T10 = T3 * Tk;
		    Tm = W[7];
		    T5 = W[1];
		    Tc = W[5];
		    {
			 E T7u, T7U, T4s, T6a, T4g, TN, T4f, T7q, T8j, T7p, T4G, T6k, T3a, T4z, T6n;
			 E T6m, T4w, T4a, T4D, T6j, T6C, T54, T6z, T5b, T1v, T3t, T6y, T58, T6B, T51;
			 E T6v, T5j, T6s, T5q, T21, T3H, T6r, T5n, T6u, T5g, T26, T3K, T4N, T2A, T3U;
			 E T4U, T2c, T3M, T2k, T3O;
			 {
			      E T11, T1b, Tb, T19, T7, T2m, TT, T15, T2Q, TX, T2p, T1g, T2a, T2e, T2i;
			      E T27, T1c, T1O, T1K, T1q, T1m, T2x, T2t, T1W, T1S, T2G, T3Y, T2N, T4F, T38;
			      E T48, T4y, T2K, T40, T2S, T41;
			      {
				   E T2M, T1j, T1l, T2X, T2U, T35, T31, T7l, T7n, T7m, T2O, T2R;
				   {
					E T1, Tj, T4j, TK, T4q, TC, T4o, Tt, T4l;
					{
					     E TE, Tw, TI, TA, Th, Tr, Tn, Td, Te, Ti, T14, T2P, TH, Tx, TB;
					     T1 = cr[0];
					     T11 = FMA(T6, Tm, T10);
					     T14 = T3 * Tm;
					     T2P = T2 * Tm;
					     TH = T8 * Tm;
					     T2M = FMA(T5, Tm, T2L);
					     T1b = FNMS(T5, T3, Ta);
					     Tb = FMA(T5, T3, Ta);
					     T19 = FMA(T5, T6, T4);
					     T7 = FNMS(T5, T6, T4);
					     T2m = FNMS(T6, Tc, TS);
					     TT = FMA(T6, Tc, TS);
					     TE = FMA(Tc, Tm, TD);
					     T1j = FMA(T5, Tc, Tv);
					     Tw = FNMS(T5, Tc, Tv);
					     {
						  E TW, Tz, T1f, T2d;
						  TW = T3 * Tc;
						  Tz = T2 * Tc;
						  T15 = FNMS(T6, Tk, T14);
						  T2Q = FNMS(T5, Tk, T2P);
						  TI = FNMS(Tc, Tk, TH);
						  T1f = T19 * Tc;
						  T2d = T19 * Tk;
						  {
						       E T2h, T1a, Tg, Tq;
						       T2h = T19 * Tm;
						       T1a = T19 * T8;
						       Tg = T7 * Tc;
						       Tq = T7 * Tm;
						       {
							    E Tl, T9, T1p, T1k;
							    Tl = T7 * Tk;
							    T9 = T7 * T8;
							    T1p = T1j * Tm;
							    T1k = T1j * Tk;
							    {
								 E T34, T30, T1N, T1J;
								 T34 = TT * Tm;
								 T30 = TT * Tk;
								 T1N = Tw * Tm;
								 T1J = Tw * Tk;
								 TX = FNMS(T6, T8, TW);
								 T2p = FMA(T6, T8, TW);
								 TA = FMA(T5, T8, Tz);
								 T1l = FNMS(T5, T8, Tz);
								 T1g = FMA(T1b, T8, T1f);
								 T2a = FNMS(T1b, T8, T1f);
								 T2e = FMA(T1b, Tm, T2d);
								 T2i = FNMS(T1b, Tk, T2h);
								 T27 = FMA(T1b, Tc, T1a);
								 T1c = FNMS(T1b, Tc, T1a);
								 T2X = FMA(Tb, T8, Tg);
								 Th = FNMS(Tb, T8, Tg);
								 Tr = FNMS(Tb, Tk, Tq);
								 Tn = FMA(Tb, Tm, Tl);
								 Td = FMA(Tb, Tc, T9);
								 T2U = FNMS(Tb, Tc, T9);
								 T35 = FNMS(TX, Tk, T34);
								 T31 = FMA(TX, Tm, T30);
								 T1O = FNMS(TA, Tk, T1N);
								 T1K = FMA(TA, Tm, T1J);
								 T1q = FNMS(T1l, Tk, T1p);
								 T1m = FMA(T1l, Tm, T1k);
								 {
								      E T2w, T2s, T1V, T1R;
								      T2w = T27 * Tm;
								      T2s = T27 * Tk;
								      T1V = Td * Tm;
								      T1R = Td * Tk;
								      T2x = FNMS(T2a, Tk, T2w);
								      T2t = FMA(T2a, Tm, T2s);
								      T1W = FNMS(Th, Tk, T1V);
								      T1S = FMA(Th, Tm, T1R);
								      T7l = ci[0];
								      Te = cr[WS(rs, 5)];
								      Ti = ci[WS(rs, 5)];
								 }
							    }
						       }
						  }
					     }
					     {
						  E TF, TJ, Tf, T4i, TG, T4p;
						  TF = cr[WS(rs, 15)];
						  TJ = ci[WS(rs, 15)];
						  Tf = Td * Te;
						  T4i = Td * Ti;
						  TG = TE * TF;
						  T4p = TE * TJ;
						  Tj = FMA(Th, Ti, Tf);
						  T4j = FNMS(Th, Te, T4i);
						  TK = FMA(TI, TJ, TG);
						  T4q = FNMS(TI, TF, T4p);
					     }
					     Tx = cr[WS(rs, 10)];
					     TB = ci[WS(rs, 10)];
					     {
						  E To, Ts, Ty, T4n, Tp, T4k;
						  To = cr[WS(rs, 20)];
						  Ts = ci[WS(rs, 20)];
						  Ty = Tw * Tx;
						  T4n = Tw * TB;
						  Tp = Tn * To;
						  T4k = Tn * Ts;
						  TC = FMA(TA, TB, Ty);
						  T4o = FNMS(TA, Tx, T4n);
						  Tt = FMA(Tr, Ts, Tp);
						  T4l = FNMS(Tr, To, T4k);
					     }
					}
					{
					     E TL, T7s, T4r, Tu, T7t, T4m, TM;
					     TL = TC + TK;
					     T7s = TC - TK;
					     T4r = T4o - T4q;
					     T7n = T4o + T4q;
					     Tu = Tj + Tt;
					     T7t = Tj - Tt;
					     T4m = T4j - T4l;
					     T7m = T4j + T4l;
					     T7u = FNMS(KP618033988, T7t, T7s);
					     T7U = FMA(KP618033988, T7s, T7t);
					     T4s = FMA(KP618033988, T4r, T4m);
					     T6a = FNMS(KP618033988, T4m, T4r);
					     T4g = Tu - TL;
					     TM = Tu + TL;
					     TN = T1 + TM;
					     T4f = FNMS(KP250000000, TM, T1);
					}
				   }
				   {
					E T2D, T2F, T7o, T2E, T3X;
					T2D = cr[WS(rs, 3)];
					T2F = ci[WS(rs, 3)];
					T7q = T7m - T7n;
					T7o = T7m + T7n;
					T2E = T3 * T2D;
					T3X = T3 * T2F;
					{
					     E T2V, T2W, T2Y, T32, T36;
					     T2V = cr[WS(rs, 13)];
					     T8j = T7o + T7l;
					     T7p = FNMS(KP250000000, T7o, T7l);
					     T2G = FMA(T6, T2F, T2E);
					     T3Y = FNMS(T6, T2D, T3X);
					     T2W = T2U * T2V;
					     T2Y = ci[WS(rs, 13)];
					     T32 = cr[WS(rs, 18)];
					     T36 = ci[WS(rs, 18)];
					     {
						  E T2H, T2I, T2J, T3Z;
						  {
						       E T2Z, T45, T37, T47, T44, T33, T46;
						       T2H = cr[WS(rs, 8)];
						       T2Z = FMA(T2X, T2Y, T2W);
						       T44 = T2U * T2Y;
						       T33 = T31 * T32;
						       T46 = T31 * T36;
						       T2I = T1j * T2H;
						       T45 = FNMS(T2X, T2V, T44);
						       T37 = FMA(T35, T36, T33);
						       T47 = FNMS(T35, T32, T46);
						       T2J = ci[WS(rs, 8)];
						       T2N = cr[WS(rs, 23)];
						       T4F = T2Z - T37;
						       T38 = T2Z + T37;
						       T48 = T45 + T47;
						       T4y = T47 - T45;
						       T3Z = T1j * T2J;
						       T2O = T2M * T2N;
						       T2R = ci[WS(rs, 23)];
						  }
						  T2K = FMA(T1l, T2J, T2I);
						  T40 = FNMS(T1l, T2H, T3Z);
					     }
					}
				   }
				   T2S = FMA(T2Q, T2R, T2O);
				   T41 = T2M * T2R;
			      }
			      {
				   E TR, T3h, T1t, T53, T3r, T5a, TZ, T3j, T17, T3l;
				   {
					E T12, T16, T13, T3k;
					{
					     E TO, TP, T4C, T4B, TQ;
					     {
						  E T2T, T4E, T42, T4v, T39;
						  TO = cr[WS(rs, 1)];
						  T2T = T2K + T2S;
						  T4E = T2K - T2S;
						  T42 = FNMS(T2Q, T2N, T41);
						  TP = T2 * TO;
						  T4G = FMA(KP618033988, T4F, T4E);
						  T6k = FNMS(KP618033988, T4E, T4F);
						  T4v = T38 - T2T;
						  T39 = T2T + T38;
						  {
						       E T43, T4x, T4u, T49;
						       T43 = T40 + T42;
						       T4x = T42 - T40;
						       T4u = FNMS(KP250000000, T39, T2G);
						       T3a = T2G + T39;
						       T4z = FMA(KP618033988, T4y, T4x);
						       T6n = FNMS(KP618033988, T4x, T4y);
						       T4C = T48 - T43;
						       T49 = T43 + T48;
						       T6m = FMA(KP559016994, T4v, T4u);
						       T4w = FNMS(KP559016994, T4v, T4u);
						       T4B = FNMS(KP250000000, T49, T3Y);
						       T4a = T3Y + T49;
						       TQ = ci[WS(rs, 1)];
						  }
					     }
					     {
						  E T1n, T1r, T1i, T1o, T3o, T3p;
						  {
						       E T1d, T1h, T1e, T3n, T3g;
						       T1d = cr[WS(rs, 11)];
						       T1h = ci[WS(rs, 11)];
						       T4D = FNMS(KP559016994, T4C, T4B);
						       T6j = FMA(KP559016994, T4C, T4B);
						       TR = FMA(T5, TQ, TP);
						       T3g = T2 * TQ;
						       T1e = T1c * T1d;
						       T3n = T1c * T1h;
						       T1n = cr[WS(rs, 16)];
						       T3h = FNMS(T5, TO, T3g);
						       T1r = ci[WS(rs, 16)];
						       T1i = FMA(T1g, T1h, T1e);
						       T1o = T1m * T1n;
						       T3o = FNMS(T1g, T1d, T3n);
						       T3p = T1m * T1r;
						  }
						  {
						       E TU, TY, TV, T3i, T3q, T1s;
						       TU = cr[WS(rs, 6)];
						       T1s = FMA(T1q, T1r, T1o);
						       TY = ci[WS(rs, 6)];
						       T3q = FNMS(T1q, T1n, T3p);
						       TV = TT * TU;
						       T1t = T1i + T1s;
						       T53 = T1s - T1i;
						       T3i = TT * TY;
						       T3r = T3o + T3q;
						       T5a = T3q - T3o;
						       T12 = cr[WS(rs, 21)];
						       T16 = ci[WS(rs, 21)];
						       TZ = FMA(TX, TY, TV);
						       T3j = FNMS(TX, TU, T3i);
						       T13 = T11 * T12;
						       T3k = T11 * T16;
						  }
					     }
					}
					T17 = FMA(T15, T16, T13);
					T3l = FNMS(T15, T12, T3k);
				   }
				   {
					E T1z, T3v, T5i, T1Z, T3F, T5p, T1D, T3x, T1H, T3z;
					{
					     E T1E, T1G, T1F, T3y;
					     {
						  E T1w, T1y, T1x, T57, T50, T56, T4Z, T3u, T18, T52;
						  T1w = cr[WS(rs, 4)];
						  T1y = ci[WS(rs, 4)];
						  T18 = TZ + T17;
						  T52 = T17 - TZ;
						  {
						       E T3m, T59, T1u, T3s;
						       T3m = T3j + T3l;
						       T59 = T3j - T3l;
						       T1x = T7 * T1w;
						       T6C = FNMS(KP618033988, T52, T53);
						       T54 = FMA(KP618033988, T53, T52);
						       T1u = T18 + T1t;
						       T57 = T18 - T1t;
						       T6z = FMA(KP618033988, T59, T5a);
						       T5b = FNMS(KP618033988, T5a, T59);
						       T3s = T3m + T3r;
						       T50 = T3m - T3r;
						       T1v = TR + T1u;
						       T56 = FNMS(KP250000000, T1u, TR);
						       T3t = T3h + T3s;
						       T4Z = FNMS(KP250000000, T3s, T3h);
						       T3u = T7 * T1y;
						  }
						  T6y = FNMS(KP559016994, T57, T56);
						  T58 = FMA(KP559016994, T57, T56);
						  T6B = FNMS(KP559016994, T50, T4Z);
						  T51 = FMA(KP559016994, T50, T4Z);
						  T1z = FMA(Tb, T1y, T1x);
						  T3v = FNMS(Tb, T1w, T3u);
					     }
					     {
						  E T1Q, T3C, T1Y, T3E;
						  {
						       E T1L, T1P, T1T, T1X, T1M, T3B, T1U, T3D;
						       T1L = cr[WS(rs, 14)];
						       T1P = ci[WS(rs, 14)];
						       T1T = cr[WS(rs, 19)];
						       T1X = ci[WS(rs, 19)];
						       T1M = T1K * T1L;
						       T3B = T1K * T1P;
						       T1U = T1S * T1T;
						       T3D = T1S * T1X;
						       T1Q = FMA(T1O, T1P, T1M);
						       T3C = FNMS(T1O, T1L, T3B);
						       T1Y = FMA(T1W, T1X, T1U);
						       T3E = FNMS(T1W, T1T, T3D);
						  }
						  {
						       E T1A, T1C, T1B, T3w;
						       T1A = cr[WS(rs, 9)];
						       T1C = ci[WS(rs, 9)];
						       T5i = T1Y - T1Q;
						       T1Z = T1Q + T1Y;
						       T3F = T3C + T3E;
						       T5p = T3E - T3C;
						       T1B = T8 * T1A;
						       T3w = T8 * T1C;
						       T1E = cr[WS(rs, 24)];
						       T1G = ci[WS(rs, 24)];
						       T1D = FMA(Tc, T1C, T1B);
						       T3x = FNMS(Tc, T1A, T3w);
						       T1F = Tk * T1E;
						       T3y = Tk * T1G;
						  }
					     }
					     T1H = FMA(Tm, T1G, T1F);
					     T3z = FNMS(Tm, T1E, T3y);
					}
					{
					     E T2f, T2j, T2g, T3N;
					     {
						  E T23, T25, T24, T5m, T5f, T5l, T5e, T3J, T1I, T5h;
						  T23 = cr[WS(rs, 2)];
						  T25 = ci[WS(rs, 2)];
						  T1I = T1D + T1H;
						  T5h = T1H - T1D;
						  {
						       E T3A, T5o, T20, T3G;
						       T3A = T3x + T3z;
						       T5o = T3z - T3x;
						       T24 = T19 * T23;
						       T6v = FNMS(KP618033988, T5h, T5i);
						       T5j = FMA(KP618033988, T5i, T5h);
						       T20 = T1I + T1Z;
						       T5m = T1I - T1Z;
						       T6s = FNMS(KP618033988, T5o, T5p);
						       T5q = FMA(KP618033988, T5p, T5o);
						       T3G = T3A + T3F;
						       T5f = T3F - T3A;
						       T21 = T1z + T20;
						       T5l = FNMS(KP250000000, T20, T1z);
						       T3H = T3v + T3G;
						       T5e = FNMS(KP250000000, T3G, T3v);
						       T3J = T19 * T25;
						  }
						  T6r = FNMS(KP559016994, T5m, T5l);
						  T5n = FMA(KP559016994, T5m, T5l);
						  T6u = FMA(KP559016994, T5f, T5e);
						  T5g = FNMS(KP559016994, T5f, T5e);
						  T26 = FMA(T1b, T25, T24);
						  T3K = FNMS(T1b, T23, T3J);
					     }
					     {
						  E T2r, T3R, T2z, T3T;
						  {
						       E T2n, T2q, T2u, T2y, T2o, T3Q, T2v, T3S;
						       T2n = cr[WS(rs, 12)];
						       T2q = ci[WS(rs, 12)];
						       T2u = cr[WS(rs, 17)];
						       T2y = ci[WS(rs, 17)];
						       T2o = T2m * T2n;
						       T3Q = T2m * T2q;
						       T2v = T2t * T2u;
						       T3S = T2t * T2y;
						       T2r = FMA(T2p, T2q, T2o);
						       T3R = FNMS(T2p, T2n, T3Q);
						       T2z = FMA(T2x, T2y, T2v);
						       T3T = FNMS(T2x, T2u, T3S);
						  }
						  {
						       E T28, T2b, T29, T3L;
						       T28 = cr[WS(rs, 7)];
						       T2b = ci[WS(rs, 7)];
						       T4N = T2z - T2r;
						       T2A = T2r + T2z;
						       T3U = T3R + T3T;
						       T4U = T3R - T3T;
						       T29 = T27 * T28;
						       T3L = T27 * T2b;
						       T2f = cr[WS(rs, 22)];
						       T2j = ci[WS(rs, 22)];
						       T2c = FMA(T2a, T2b, T29);
						       T3M = FNMS(T2a, T28, T3L);
						       T2g = T2e * T2f;
						       T3N = T2e * T2j;
						  }
					     }
					     T2k = FMA(T2i, T2j, T2g);
					     T3O = FNMS(T2i, T2f, T3N);
					}
				   }
			      }
			 }
			 {
			      E T8k, T6d, T6g, T8r, T6f, T8l, T6c, T8q, T69, T7r, T5Y, T8g, T8i, T66, T68;
			      E T5X, T8d, T8h;
			      {
				   E T4O, T4V, T22, T4S, T4L, T3b, T4e, T4c, T3I;
				   T8k = T3t + T3H;
				   T3I = T3t - T3H;
				   {
					E T2l, T4M, T3P, T4T;
					T2l = T2c + T2k;
					T4M = T2k - T2c;
					T3P = T3M + T3O;
					T4T = T3O - T3M;
					T4O = FMA(KP618033988, T4N, T4M);
					T6d = FNMS(KP618033988, T4M, T4N);
					{
					     E T4R, T2B, T4K, T3V;
					     T4R = T2A - T2l;
					     T2B = T2l + T2A;
					     T4V = FNMS(KP618033988, T4U, T4T);
					     T6g = FMA(KP618033988, T4T, T4U);
					     T4K = T3U - T3P;
					     T3V = T3P + T3U;
					     {
						  E T4Q, T2C, T4J, T3W, T4b;
						  T4Q = FNMS(KP250000000, T2B, T26);
						  T2C = T26 + T2B;
						  T4J = FNMS(KP250000000, T3V, T3K);
						  T3W = T3K + T3V;
						  T8r = T21 - T1v;
						  T22 = T1v + T21;
						  T4S = FNMS(KP559016994, T4R, T4Q);
						  T6f = FMA(KP559016994, T4R, T4Q);
						  T4b = T3W - T4a;
						  T8l = T3W + T4a;
						  T6c = FMA(KP559016994, T4K, T4J);
						  T4L = FNMS(KP559016994, T4K, T4J);
						  T8q = T2C - T3a;
						  T3b = T2C + T3a;
						  T4e = FNMS(KP618033988, T3I, T4b);
						  T4c = FMA(KP618033988, T4b, T3I);
					     }
					}
				   }
				   {
					E T5H, T4t, T7V, T87, T5Q, T5P, T5D, T8e, T5A, T8f, T5K, T60, T8c, T8a, T5u;
					E T5w, T5U, T64, T5N, T61;
					{
					     E T3e, T3d, T4h, T3c, T7T;
					     T4h = FMA(KP559016994, T4g, T4f);
					     T69 = FNMS(KP559016994, T4g, T4f);
					     T3c = T22 + T3b;
					     T3e = T22 - T3b;
					     T7r = FNMS(KP559016994, T7q, T7p);
					     T7T = FMA(KP559016994, T7q, T7p);
					     T5H = FMA(KP951056516, T4s, T4h);
					     T4t = FNMS(KP951056516, T4s, T4h);
					     cr[0] = TN + T3c;
					     T3d = FNMS(KP250000000, T3c, TN);
					     T7V = FNMS(KP951056516, T7U, T7T);
					     T87 = FMA(KP951056516, T7U, T7T);
					     {
						  E T5S, T5T, T5L, T4I, T5B, T5M, T55, T5J, T5s, T5z, T4X, T5C, T5I, T5c;
						  {
						       E T5k, T5r, T4P, T4W;
						       {
							    E T4A, T4d, T3f, T4H;
							    T4A = FMA(KP951056516, T4z, T4w);
							    T5S = FNMS(KP951056516, T4z, T4w);
							    T4d = FNMS(KP559016994, T3e, T3d);
							    T3f = FMA(KP559016994, T3e, T3d);
							    T5T = FNMS(KP951056516, T4G, T4D);
							    T4H = FMA(KP951056516, T4G, T4D);
							    T5k = FNMS(KP951056516, T5j, T5g);
							    T5L = FMA(KP951056516, T5j, T5g);
							    cr[WS(rs, 5)] = FMA(KP951056516, T4c, T3f);
							    ci[WS(rs, 4)] = FNMS(KP951056516, T4c, T3f);
							    ci[WS(rs, 9)] = FMA(KP951056516, T4e, T4d);
							    cr[WS(rs, 10)] = FNMS(KP951056516, T4e, T4d);
							    T4I = FNMS(KP126329378, T4H, T4A);
							    T5B = FMA(KP126329378, T4A, T4H);
							    T5M = FNMS(KP951056516, T5q, T5n);
							    T5r = FMA(KP951056516, T5q, T5n);
						       }
						       T4P = FNMS(KP951056516, T4O, T4L);
						       T5Q = FMA(KP951056516, T4O, T4L);
						       T5P = FNMS(KP951056516, T4V, T4S);
						       T4W = FMA(KP951056516, T4V, T4S);
						       T55 = FNMS(KP951056516, T54, T51);
						       T5J = FMA(KP951056516, T54, T51);
						       T5s = FMA(KP827271945, T5r, T5k);
						       T5z = FNMS(KP827271945, T5k, T5r);
						       T4X = FNMS(KP470564281, T4W, T4P);
						       T5C = FMA(KP470564281, T4P, T4W);
						       T5I = FMA(KP951056516, T5b, T58);
						       T5c = FNMS(KP951056516, T5b, T58);
						  }
						  {
						       E T88, T4Y, T5d, T5y, T89, T5t;
						       T5D = FNMS(KP912018591, T5C, T5B);
						       T88 = FMA(KP912018591, T5C, T5B);
						       T8e = FMA(KP912018591, T4X, T4I);
						       T4Y = FNMS(KP912018591, T4X, T4I);
						       T5d = FMA(KP634619297, T5c, T55);
						       T5y = FNMS(KP634619297, T55, T5c);
						       T5A = FMA(KP912575812, T5z, T5y);
						       T89 = FNMS(KP912575812, T5z, T5y);
						       T8f = FMA(KP912575812, T5s, T5d);
						       T5t = FNMS(KP912575812, T5s, T5d);
						       T5K = FMA(KP256756360, T5J, T5I);
						       T60 = FNMS(KP256756360, T5I, T5J);
						       T8c = FNMS(KP851038619, T89, T88);
						       T8a = FMA(KP851038619, T89, T88);
						       T5u = FNMS(KP851038619, T5t, T4Y);
						       T5w = FMA(KP851038619, T5t, T4Y);
						  }
						  T5U = FMA(KP939062505, T5T, T5S);
						  T64 = FNMS(KP939062505, T5S, T5T);
						  T5N = FMA(KP634619297, T5M, T5L);
						  T61 = FNMS(KP634619297, T5L, T5M);
					     }
					}
					{
					     E T62, T7W, T83, T5O, T5R, T63;
					     cr[WS(rs, 4)] = FNMS(KP992114701, T5u, T4t);
					     T62 = FMA(KP871714437, T61, T60);
					     T7W = FNMS(KP871714437, T61, T60);
					     T83 = FNMS(KP871714437, T5N, T5K);
					     T5O = FMA(KP871714437, T5N, T5K);
					     T5R = FMA(KP549754652, T5Q, T5P);
					     T63 = FNMS(KP549754652, T5P, T5Q);
					     ci[WS(rs, 20)] = FNMS(KP992114701, T8a, T87);
					     {
						  E T65, T5W, T84, T86, T81, T85, T8b;
						  {
						       E T5E, T5G, T82, T80, T7Y, T5v, T7X, T5V, T5F, T5x, T7Z;
						       T5E = FNMS(KP726211448, T5D, T5A);
						       T5G = FMA(KP525970792, T5A, T5D);
						       T65 = FNMS(KP831864738, T64, T63);
						       T7X = FMA(KP831864738, T64, T63);
						       T82 = FNMS(KP831864738, T5U, T5R);
						       T5V = FMA(KP831864738, T5U, T5R);
						       T80 = FNMS(KP904730450, T7X, T7W);
						       T7Y = FMA(KP904730450, T7X, T7W);
						       T5Y = FNMS(KP904730450, T5V, T5O);
						       T5W = FMA(KP904730450, T5V, T5O);
						       T5v = FMA(KP248028675, T5u, T4t);
						       ci[WS(rs, 23)] = FMA(KP968583161, T7Y, T7V);
						       cr[WS(rs, 1)] = FMA(KP968583161, T5W, T5H);
						       T84 = FNMS(KP683113946, T83, T82);
						       T86 = FMA(KP559154169, T82, T83);
						       T5F = FNMS(KP554608978, T5w, T5v);
						       T5x = FMA(KP554608978, T5w, T5v);
						       T7Z = FNMS(KP242145790, T7Y, T7V);
						       ci[WS(rs, 10)] = FNMS(KP943557151, T5G, T5F);
						       ci[WS(rs, 5)] = FMA(KP943557151, T5G, T5F);
						       ci[0] = FMA(KP803003575, T5E, T5x);
						       cr[WS(rs, 9)] = FNMS(KP803003575, T5E, T5x);
						       T81 = FNMS(KP541454447, T80, T7Z);
						       T85 = FMA(KP541454447, T80, T7Z);
						  }
						  T8g = FNMS(KP525970792, T8f, T8e);
						  T8i = FMA(KP726211448, T8e, T8f);
						  ci[WS(rs, 13)] = FMA(KP833417178, T84, T81);
						  cr[WS(rs, 16)] = FMS(KP833417178, T84, T81);
						  cr[WS(rs, 21)] = -(FMA(KP921177326, T86, T85));
						  ci[WS(rs, 18)] = FNMS(KP921177326, T86, T85);
						  T8b = FMA(KP248028675, T8a, T87);
						  T66 = FMA(KP559154169, T65, T62);
						  T68 = FNMS(KP683113946, T62, T65);
						  T5X = FNMS(KP242145790, T5W, T5H);
						  T8d = FNMS(KP554608978, T8c, T8b);
						  T8h = FMA(KP554608978, T8c, T8b);
					     }
					}
				   }
			      }
			      {
				   E T8s, T8u, T5Z, T67;
				   cr[WS(rs, 24)] = -(FMA(KP803003575, T8i, T8h));
				   ci[WS(rs, 15)] = FNMS(KP803003575, T8i, T8h);
				   cr[WS(rs, 19)] = FMS(KP943557151, T8g, T8d);
				   cr[WS(rs, 14)] = -(FMA(KP943557151, T8g, T8d));
				   T5Z = FMA(KP541454447, T5Y, T5X);
				   T67 = FNMS(KP541454447, T5Y, T5X);
				   cr[WS(rs, 11)] = FNMS(KP833417178, T68, T67);
				   ci[WS(rs, 8)] = FMA(KP833417178, T68, T67);
				   cr[WS(rs, 6)] = FMA(KP921177326, T66, T5Z);
				   ci[WS(rs, 3)] = FNMS(KP921177326, T66, T5Z);
				   T8s = FMA(KP618033988, T8r, T8q);
				   T8u = FNMS(KP618033988, T8q, T8r);
				   {
					E T6X, T6T, T6b, T7H, T7v, T6Y, T72, T71, T6P, T7O, T6M, T7P, T7K, T6G, T6I;
					E T6W, T7f, T7d, T76;
					{
					     E T74, T75, T6i, T6N, T6L, T6E, T6U, T6l, T6o, T6V, T6t, T6w;
					     {
						  E T6e, T8o, T8n, T6h, T8m;
						  T6X = FNMS(KP951056516, T6d, T6c);
						  T6e = FMA(KP951056516, T6d, T6c);
						  T8o = T8k - T8l;
						  T8m = T8k + T8l;
						  T6T = FNMS(KP951056516, T6a, T69);
						  T6b = FMA(KP951056516, T6a, T69);
						  T7H = FNMS(KP951056516, T7u, T7r);
						  T7v = FMA(KP951056516, T7u, T7r);
						  ci[WS(rs, 24)] = T8m + T8j;
						  T8n = FNMS(KP250000000, T8m, T8j);
						  T6h = FMA(KP951056516, T6g, T6f);
						  T6Y = FNMS(KP951056516, T6g, T6f);
						  {
						       E T6A, T6D, T8t, T8p;
						       T74 = FMA(KP951056516, T6z, T6y);
						       T6A = FNMS(KP951056516, T6z, T6y);
						       T6D = FMA(KP951056516, T6C, T6B);
						       T75 = FNMS(KP951056516, T6C, T6B);
						       T8t = FMA(KP559016994, T8o, T8n);
						       T8p = FNMS(KP559016994, T8o, T8n);
						       T6i = FMA(KP062914667, T6h, T6e);
						       T6N = FNMS(KP062914667, T6e, T6h);
						       ci[WS(rs, 14)] = FMA(KP951056516, T8s, T8p);
						       cr[WS(rs, 15)] = FMS(KP951056516, T8s, T8p);
						       ci[WS(rs, 19)] = FMA(KP951056516, T8u, T8t);
						       cr[WS(rs, 20)] = FMS(KP951056516, T8u, T8t);
						       T6L = FNMS(KP939062505, T6A, T6D);
						       T6E = FMA(KP939062505, T6D, T6A);
						  }
					     }
					     T6U = FMA(KP951056516, T6k, T6j);
					     T6l = FNMS(KP951056516, T6k, T6j);
					     T6o = FNMS(KP951056516, T6n, T6m);
					     T6V = FMA(KP951056516, T6n, T6m);
					     T72 = FMA(KP951056516, T6s, T6r);
					     T6t = FNMS(KP951056516, T6s, T6r);
					     T6w = FMA(KP951056516, T6v, T6u);
					     T71 = FNMS(KP951056516, T6v, T6u);
					     {
						  E T6q, T6F, T6O, T6p;
						  T6O = FMA(KP827271945, T6l, T6o);
						  T6p = FNMS(KP827271945, T6o, T6l);
						  {
						       E T6K, T6x, T7I, T7J;
						       T6K = FMA(KP126329378, T6t, T6w);
						       T6x = FNMS(KP126329378, T6w, T6t);
						       T7I = FMA(KP772036680, T6O, T6N);
						       T6P = FNMS(KP772036680, T6O, T6N);
						       T6q = FMA(KP772036680, T6p, T6i);
						       T7O = FNMS(KP772036680, T6p, T6i);
						       T7J = FNMS(KP734762448, T6L, T6K);
						       T6M = FMA(KP734762448, T6L, T6K);
						       T6F = FNMS(KP734762448, T6E, T6x);
						       T7P = FMA(KP734762448, T6E, T6x);
						       T7K = FMA(KP994076283, T7J, T7I);
						       T7M = FNMS(KP994076283, T7J, T7I);
						  }
						  T6G = FNMS(KP994076283, T6F, T6q);
						  T6I = FMA(KP994076283, T6F, T6q);
					     }
					     T6W = FMA(KP062914667, T6V, T6U);
					     T7f = FNMS(KP062914667, T6U, T6V);
					     T7d = FNMS(KP549754652, T74, T75);
					     T76 = FMA(KP549754652, T75, T74);
					}
					{
					     E T7h, T7C, T7e, T7D, T7y, T7A, T78, T7a;
					     {
						  E T70, T77, T7g, T6Z;
						  cr[WS(rs, 3)] = FMA(KP998026728, T6G, T6b);
						  T7g = FNMS(KP634619297, T6X, T6Y);
						  T6Z = FMA(KP634619297, T6Y, T6X);
						  {
						       E T7c, T73, T7w, T7x;
						       T7c = FMA(KP470564281, T71, T72);
						       T73 = FNMS(KP470564281, T72, T71);
						       T7w = FMA(KP845997307, T7g, T7f);
						       T7h = FNMS(KP845997307, T7g, T7f);
						       T70 = FMA(KP845997307, T6Z, T6W);
						       T7C = FNMS(KP845997307, T6Z, T6W);
						       T7x = FNMS(KP968479752, T7d, T7c);
						       T7e = FMA(KP968479752, T7d, T7c);
						       T77 = FMA(KP968479752, T76, T73);
						       T7D = FNMS(KP968479752, T76, T73);
						       T7y = FMA(KP906616052, T7x, T7w);
						       T7A = FNMS(KP906616052, T7x, T7w);
						  }
						  ci[WS(rs, 21)] = FNMS(KP998026728, T7K, T7H);
						  T78 = FMA(KP906616052, T77, T70);
						  T7a = FNMS(KP906616052, T77, T70);
					     }
					     {
						  E T7G, T7E, T7k, T7i, T79, T7F, T7B, T7z, T6H, T7j, T7b;
						  T7G = FMA(KP681693190, T7C, T7D);
						  T7E = FNMS(KP560319534, T7D, T7C);
						  ci[WS(rs, 22)] = FNMS(KP998026728, T7y, T7v);
						  cr[WS(rs, 2)] = FMA(KP998026728, T78, T6T);
						  T7z = FMA(KP249506682, T7y, T7v);
						  T7k = FNMS(KP560319534, T7e, T7h);
						  T7i = FMA(KP681693190, T7h, T7e);
						  T79 = FNMS(KP249506682, T78, T6T);
						  T7F = FMA(KP557913902, T7A, T7z);
						  T7B = FNMS(KP557913902, T7A, T7z);
						  T6S = FMA(KP614372930, T6M, T6P);
						  T6Q = FNMS(KP621716863, T6P, T6M);
						  cr[WS(rs, 22)] = FMS(KP860541664, T7G, T7F);
						  ci[WS(rs, 17)] = FMA(KP860541664, T7G, T7F);
						  ci[WS(rs, 12)] = FNMS(KP949179823, T7E, T7B);
						  cr[WS(rs, 17)] = -(FMA(KP949179823, T7E, T7B));
						  T7j = FMA(KP557913902, T7a, T79);
						  T7b = FNMS(KP557913902, T7a, T79);
						  T6H = FNMS(KP249506682, T6G, T6b);
						  ci[WS(rs, 7)] = FMA(KP949179823, T7k, T7j);
						  cr[WS(rs, 12)] = FNMS(KP949179823, T7k, T7j);
						  cr[WS(rs, 7)] = FMA(KP860541664, T7i, T7b);
						  ci[WS(rs, 2)] = FNMS(KP860541664, T7i, T7b);
						  T7S = FMA(KP621716863, T7O, T7P);
						  T7Q = FNMS(KP614372930, T7P, T7O);
						  T7L = FMA(KP249506682, T7K, T7H);
						  T6R = FMA(KP557913902, T6I, T6H);
						  T6J = FNMS(KP557913902, T6I, T6H);
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       ci[WS(rs, 6)] = FNMS(KP949179823, T6S, T6R);
	       ci[WS(rs, 11)] = FMA(KP949179823, T6S, T6R);
	       cr[WS(rs, 8)] = FMA(KP943557151, T6Q, T6J);
	       ci[WS(rs, 1)] = FNMS(KP943557151, T6Q, T6J);
	       T7N = FNMS(KP557913902, T7M, T7L);
	       T7R = FMA(KP557913902, T7M, T7L);
	       cr[WS(rs, 23)] = -(FMA(KP943557151, T7S, T7R));
	       ci[WS(rs, 16)] = FNMS(KP943557151, T7S, T7R);
	       cr[WS(rs, 18)] = FMS(KP949179823, T7Q, T7N);
	       cr[WS(rs, 13)] = -(FMA(KP949179823, T7Q, T7N));
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 24},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 25, "hf2_25", twinstr, &GENUS, {84, 78, 356, 0} };

void X(codelet_hf2_25) (planner *p) {
     X(khc2hc_register) (p, hf2_25, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -twiddle-log3 -precompute-twiddles -n 25 -dit -name hf2_25 -include hf.h */

/*
 * This function contains 440 FP additions, 340 FP multiplications,
 * (or, 280 additions, 180 multiplications, 160 fused multiply/add),
 * 149 stack variables, 20 constants, and 100 memory accesses
 */
#include "hf.h"

static void hf2_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP062790519, +0.062790519529313376076178224565631133122484832);
     DK(KP684547105, +0.684547105928688673732283357621209269889519233);
     DK(KP728968627, +0.728968627421411523146730319055259111372571664);
     DK(KP481753674, +0.481753674101715274987191502872129653528542010);
     DK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DK(KP248689887, +0.248689887164854788242283746006447968417567406);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP125333233, +0.125333233564304245373118759816508793942918247);
     DK(KP425779291, +0.425779291565072648862502445744251703979973042);
     DK(KP904827052, +0.904827052466019527713668647932697593970413911);
     DK(KP637423989, +0.637423989748689710176712811676016195434917298);
     DK(KP770513242, +0.770513242775789230803009636396177847271667672);
     DK(KP844327925, +0.844327925502015078548558063966681505381659241);
     DK(KP535826794, +0.535826794978996618271308767867639978063575346);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 8); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 8, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E T2, T5, T3, T6, T8, Td, T16, T14, Te, T9, T21, T23, Tx, TR, T1g;
	       E TB, T1f, TV, T1Q, Tg, T1S, Tk, T18, T2s, T1c, T2q, Tn, To, Tp, Tr;
	       E T28, T2x, TY, T2k, T2m, T2v, TG, TE, T10, T1h, T1E, T26, T1B, T1G, T1V;
	       E T1X, T1z, T1j;
	       {
		    E Tw, TT, Tz, TQ, Tv, TU, TA, TP;
		    {
			 E T4, Tc, T7, Tb;
			 T2 = W[0];
			 T5 = W[1];
			 T3 = W[2];
			 T6 = W[3];
			 T4 = T2 * T3;
			 Tc = T5 * T3;
			 T7 = T5 * T6;
			 Tb = T2 * T6;
			 T8 = T4 - T7;
			 Td = Tb + Tc;
			 T16 = Tb - Tc;
			 T14 = T4 + T7;
			 Te = W[5];
			 Tw = T5 * Te;
			 TT = T3 * Te;
			 Tz = T2 * Te;
			 TQ = T6 * Te;
			 T9 = W[4];
			 Tv = T2 * T9;
			 TU = T6 * T9;
			 TA = T5 * T9;
			 TP = T3 * T9;
		    }
		    T21 = TP - TQ;
		    T23 = TT + TU;
		    {
			 E T15, T17, Ta, Tf, T1a, T1b, Ti, Tj;
			 Tx = Tv - Tw;
			 TR = TP + TQ;
			 T1g = Tz - TA;
			 TB = Tz + TA;
			 T1f = Tv + Tw;
			 TV = TT - TU;
			 T15 = T14 * T9;
			 T17 = T16 * Te;
			 T1Q = T15 + T17;
			 Ta = T8 * T9;
			 Tf = Td * Te;
			 Tg = Ta + Tf;
			 T1a = T14 * Te;
			 T1b = T16 * T9;
			 T1S = T1a - T1b;
			 Ti = T8 * Te;
			 Tj = Td * T9;
			 Tk = Ti - Tj;
			 T18 = T15 - T17;
			 T2s = Ti + Tj;
			 T1c = T1a + T1b;
			 T2q = Ta - Tf;
			 Tn = W[6];
			 To = W[7];
			 Tp = FMA(T8, Tn, Td * To);
			 Tr = FNMS(Td, Tn, T8 * To);
			 T28 = FNMS(T1S, Tn, T1Q * To);
			 T2x = FNMS(TV, Tn, TR * To);
			 TY = FMA(T3, Tn, T6 * To);
			 T2k = FMA(T2, Tn, T5 * To);
			 T2m = FNMS(T5, Tn, T2 * To);
			 T2v = FMA(TR, Tn, TV * To);
			 TG = FNMS(Te, Tn, T9 * To);
			 TE = FMA(T9, Tn, Te * To);
			 T10 = FNMS(T6, Tn, T3 * To);
			 T1h = FMA(T1f, Tn, T1g * To);
			 T1E = FMA(Tg, Tn, Tk * To);
			 T26 = FMA(T1Q, Tn, T1S * To);
			 T1B = FNMS(TB, Tn, Tx * To);
			 T1G = FNMS(Tk, Tn, Tg * To);
			 T1V = FMA(T14, Tn, T16 * To);
			 T1X = FNMS(T16, Tn, T14 * To);
			 T1z = FMA(Tx, Tn, TB * To);
			 T1j = FNMS(T1g, Tn, T1f * To);
		    }
	       }
	       {
		    E T1, T6v, T2F, T6A, TK, T2G, T6y, T6z, T6u, T71, T2O, T52, T2C, T6k, T4c;
		    E T5X, T4L, T5s, T4j, T5W, T4K, T5v, T1o, T6g, T30, T5M, T4A, T56, T3b, T5N;
		    E T4B, T59, T1L, T6h, T3r, T5P, T4E, T5d, T3y, T5Q, T4D, T5g, T2d, T6j, T3P;
		    E T5U, T4I, T5o, T3W, T5T, T4H, T5l;
		    {
			 E Tm, T2I, Tt, T2J, Tu, T6w, TD, T2L, TI, T2M, TJ, T6x;
			 T1 = cr[0];
			 T6v = ci[0];
			 {
			      E Th, Tl, Tq, Ts;
			      Th = cr[WS(rs, 5)];
			      Tl = ci[WS(rs, 5)];
			      Tm = FMA(Tg, Th, Tk * Tl);
			      T2I = FNMS(Tk, Th, Tg * Tl);
			      Tq = cr[WS(rs, 20)];
			      Ts = ci[WS(rs, 20)];
			      Tt = FMA(Tp, Tq, Tr * Ts);
			      T2J = FNMS(Tr, Tq, Tp * Ts);
			 }
			 Tu = Tm + Tt;
			 T6w = T2I + T2J;
			 {
			      E Ty, TC, TF, TH;
			      Ty = cr[WS(rs, 10)];
			      TC = ci[WS(rs, 10)];
			      TD = FMA(Tx, Ty, TB * TC);
			      T2L = FNMS(TB, Ty, Tx * TC);
			      TF = cr[WS(rs, 15)];
			      TH = ci[WS(rs, 15)];
			      TI = FMA(TE, TF, TG * TH);
			      T2M = FNMS(TG, TF, TE * TH);
			 }
			 TJ = TD + TI;
			 T6x = T2L + T2M;
			 T2F = KP559016994 * (Tu - TJ);
			 T6A = KP559016994 * (T6w - T6x);
			 TK = Tu + TJ;
			 T2G = FNMS(KP250000000, TK, T1);
			 T6y = T6w + T6x;
			 T6z = FNMS(KP250000000, T6y, T6v);
			 {
			      E T6s, T6t, T2K, T2N;
			      T6s = TD - TI;
			      T6t = Tm - Tt;
			      T6u = FNMS(KP587785252, T6t, KP951056516 * T6s);
			      T71 = FMA(KP951056516, T6t, KP587785252 * T6s);
			      T2K = T2I - T2J;
			      T2N = T2L - T2M;
			      T2O = FMA(KP951056516, T2K, KP587785252 * T2N);
			      T52 = FNMS(KP587785252, T2K, KP951056516 * T2N);
			 }
		    }
		    {
			 E T2g, T48, T3Y, T3Z, T4h, T4g, T43, T46, T49, T2p, T2A, T2B, T2e, T2f;
			 T2e = cr[WS(rs, 3)];
			 T2f = ci[WS(rs, 3)];
			 T2g = FMA(T3, T2e, T6 * T2f);
			 T48 = FNMS(T6, T2e, T3 * T2f);
			 {
			      E T2j, T41, T2z, T45, T2o, T42, T2u, T44;
			      {
				   E T2h, T2i, T2w, T2y;
				   T2h = cr[WS(rs, 8)];
				   T2i = ci[WS(rs, 8)];
				   T2j = FMA(T1f, T2h, T1g * T2i);
				   T41 = FNMS(T1g, T2h, T1f * T2i);
				   T2w = cr[WS(rs, 18)];
				   T2y = ci[WS(rs, 18)];
				   T2z = FMA(T2v, T2w, T2x * T2y);
				   T45 = FNMS(T2x, T2w, T2v * T2y);
			      }
			      {
				   E T2l, T2n, T2r, T2t;
				   T2l = cr[WS(rs, 23)];
				   T2n = ci[WS(rs, 23)];
				   T2o = FMA(T2k, T2l, T2m * T2n);
				   T42 = FNMS(T2m, T2l, T2k * T2n);
				   T2r = cr[WS(rs, 13)];
				   T2t = ci[WS(rs, 13)];
				   T2u = FMA(T2q, T2r, T2s * T2t);
				   T44 = FNMS(T2s, T2r, T2q * T2t);
			      }
			      T3Y = T2j - T2o;
			      T3Z = T2u - T2z;
			      T4h = T44 - T45;
			      T4g = T41 - T42;
			      T43 = T41 + T42;
			      T46 = T44 + T45;
			      T49 = T43 + T46;
			      T2p = T2j + T2o;
			      T2A = T2u + T2z;
			      T2B = T2p + T2A;
			 }
			 T2C = T2g + T2B;
			 T6k = T48 + T49;
			 {
			      E T40, T5r, T4b, T5q, T47, T4a;
			      T40 = FMA(KP951056516, T3Y, KP587785252 * T3Z);
			      T5r = FNMS(KP587785252, T3Y, KP951056516 * T3Z);
			      T47 = KP559016994 * (T43 - T46);
			      T4a = FNMS(KP250000000, T49, T48);
			      T4b = T47 + T4a;
			      T5q = T4a - T47;
			      T4c = T40 + T4b;
			      T5X = T5r + T5q;
			      T4L = T4b - T40;
			      T5s = T5q - T5r;
			 }
			 {
			      E T4i, T5u, T4f, T5t, T4d, T4e;
			      T4i = FMA(KP951056516, T4g, KP587785252 * T4h);
			      T5u = FNMS(KP587785252, T4g, KP951056516 * T4h);
			      T4d = KP559016994 * (T2p - T2A);
			      T4e = FNMS(KP250000000, T2B, T2g);
			      T4f = T4d + T4e;
			      T5t = T4e - T4d;
			      T4j = T4f - T4i;
			      T5W = T5t - T5u;
			      T4K = T4f + T4i;
			      T5v = T5t + T5u;
			 }
		    }
		    {
			 E TO, T37, T2V, T2Y, T32, T31, T34, T35, T38, T13, T1m, T1n, TM, TN;
			 TM = cr[WS(rs, 1)];
			 TN = ci[WS(rs, 1)];
			 TO = FMA(T2, TM, T5 * TN);
			 T37 = FNMS(T5, TM, T2 * TN);
			 {
			      E TX, T2T, T1l, T2X, T12, T2U, T1e, T2W;
			      {
				   E TS, TW, T1i, T1k;
				   TS = cr[WS(rs, 6)];
				   TW = ci[WS(rs, 6)];
				   TX = FMA(TR, TS, TV * TW);
				   T2T = FNMS(TV, TS, TR * TW);
				   T1i = cr[WS(rs, 16)];
				   T1k = ci[WS(rs, 16)];
				   T1l = FMA(T1h, T1i, T1j * T1k);
				   T2X = FNMS(T1j, T1i, T1h * T1k);
			      }
			      {
				   E TZ, T11, T19, T1d;
				   TZ = cr[WS(rs, 21)];
				   T11 = ci[WS(rs, 21)];
				   T12 = FMA(TY, TZ, T10 * T11);
				   T2U = FNMS(T10, TZ, TY * T11);
				   T19 = cr[WS(rs, 11)];
				   T1d = ci[WS(rs, 11)];
				   T1e = FMA(T18, T19, T1c * T1d);
				   T2W = FNMS(T1c, T19, T18 * T1d);
			      }
			      T2V = T2T - T2U;
			      T2Y = T2W - T2X;
			      T32 = T1e - T1l;
			      T31 = TX - T12;
			      T34 = T2T + T2U;
			      T35 = T2W + T2X;
			      T38 = T34 + T35;
			      T13 = TX + T12;
			      T1m = T1e + T1l;
			      T1n = T13 + T1m;
			 }
			 T1o = TO + T1n;
			 T6g = T37 + T38;
			 {
			      E T2Z, T55, T2S, T54, T2Q, T2R;
			      T2Z = FMA(KP951056516, T2V, KP587785252 * T2Y);
			      T55 = FNMS(KP587785252, T2V, KP951056516 * T2Y);
			      T2Q = KP559016994 * (T13 - T1m);
			      T2R = FNMS(KP250000000, T1n, TO);
			      T2S = T2Q + T2R;
			      T54 = T2R - T2Q;
			      T30 = T2S - T2Z;
			      T5M = T54 - T55;
			      T4A = T2S + T2Z;
			      T56 = T54 + T55;
			 }
			 {
			      E T33, T58, T3a, T57, T36, T39;
			      T33 = FMA(KP951056516, T31, KP587785252 * T32);
			      T58 = FNMS(KP587785252, T31, KP951056516 * T32);
			      T36 = KP559016994 * (T34 - T35);
			      T39 = FNMS(KP250000000, T38, T37);
			      T3a = T36 + T39;
			      T57 = T39 - T36;
			      T3b = T33 + T3a;
			      T5N = T58 + T57;
			      T4B = T3a - T33;
			      T59 = T57 - T58;
			 }
		    }
		    {
			 E T1r, T3n, T3d, T3e, T3w, T3v, T3i, T3l, T3o, T1y, T1J, T1K, T1p, T1q;
			 T1p = cr[WS(rs, 4)];
			 T1q = ci[WS(rs, 4)];
			 T1r = FMA(T8, T1p, Td * T1q);
			 T3n = FNMS(Td, T1p, T8 * T1q);
			 {
			      E T1u, T3g, T1I, T3k, T1x, T3h, T1D, T3j;
			      {
				   E T1s, T1t, T1F, T1H;
				   T1s = cr[WS(rs, 9)];
				   T1t = ci[WS(rs, 9)];
				   T1u = FMA(T9, T1s, Te * T1t);
				   T3g = FNMS(Te, T1s, T9 * T1t);
				   T1F = cr[WS(rs, 19)];
				   T1H = ci[WS(rs, 19)];
				   T1I = FMA(T1E, T1F, T1G * T1H);
				   T3k = FNMS(T1G, T1F, T1E * T1H);
			      }
			      {
				   E T1v, T1w, T1A, T1C;
				   T1v = cr[WS(rs, 24)];
				   T1w = ci[WS(rs, 24)];
				   T1x = FMA(Tn, T1v, To * T1w);
				   T3h = FNMS(To, T1v, Tn * T1w);
				   T1A = cr[WS(rs, 14)];
				   T1C = ci[WS(rs, 14)];
				   T1D = FMA(T1z, T1A, T1B * T1C);
				   T3j = FNMS(T1B, T1A, T1z * T1C);
			      }
			      T3d = T1x - T1u;
			      T3e = T1D - T1I;
			      T3w = T3j - T3k;
			      T3v = T3g - T3h;
			      T3i = T3g + T3h;
			      T3l = T3j + T3k;
			      T3o = T3i + T3l;
			      T1y = T1u + T1x;
			      T1J = T1D + T1I;
			      T1K = T1y + T1J;
			 }
			 T1L = T1r + T1K;
			 T6h = T3n + T3o;
			 {
			      E T3f, T5c, T3q, T5b, T3m, T3p;
			      T3f = FNMS(KP587785252, T3e, KP951056516 * T3d);
			      T5c = FMA(KP587785252, T3d, KP951056516 * T3e);
			      T3m = KP559016994 * (T3i - T3l);
			      T3p = FNMS(KP250000000, T3o, T3n);
			      T3q = T3m + T3p;
			      T5b = T3p - T3m;
			      T3r = T3f - T3q;
			      T5P = T5c + T5b;
			      T4E = T3f + T3q;
			      T5d = T5b - T5c;
			 }
			 {
			      E T3x, T5f, T3u, T5e, T3s, T3t;
			      T3x = FMA(KP951056516, T3v, KP587785252 * T3w);
			      T5f = FNMS(KP587785252, T3v, KP951056516 * T3w);
			      T3s = KP559016994 * (T1y - T1J);
			      T3t = FNMS(KP250000000, T1K, T1r);
			      T3u = T3s + T3t;
			      T5e = T3t - T3s;
			      T3y = T3u - T3x;
			      T5Q = T5e - T5f;
			      T4D = T3u + T3x;
			      T5g = T5e + T5f;
			 }
		    }
		    {
			 E T1P, T3L, T3B, T3C, T3U, T3T, T3G, T3J, T3M, T20, T2b, T2c, T1N, T1O;
			 T1N = cr[WS(rs, 2)];
			 T1O = ci[WS(rs, 2)];
			 T1P = FMA(T14, T1N, T16 * T1O);
			 T3L = FNMS(T16, T1N, T14 * T1O);
			 {
			      E T1U, T3E, T2a, T3I, T1Z, T3F, T25, T3H;
			      {
				   E T1R, T1T, T27, T29;
				   T1R = cr[WS(rs, 7)];
				   T1T = ci[WS(rs, 7)];
				   T1U = FMA(T1Q, T1R, T1S * T1T);
				   T3E = FNMS(T1S, T1R, T1Q * T1T);
				   T27 = cr[WS(rs, 17)];
				   T29 = ci[WS(rs, 17)];
				   T2a = FMA(T26, T27, T28 * T29);
				   T3I = FNMS(T28, T27, T26 * T29);
			      }
			      {
				   E T1W, T1Y, T22, T24;
				   T1W = cr[WS(rs, 22)];
				   T1Y = ci[WS(rs, 22)];
				   T1Z = FMA(T1V, T1W, T1X * T1Y);
				   T3F = FNMS(T1X, T1W, T1V * T1Y);
				   T22 = cr[WS(rs, 12)];
				   T24 = ci[WS(rs, 12)];
				   T25 = FMA(T21, T22, T23 * T24);
				   T3H = FNMS(T23, T22, T21 * T24);
			      }
			      T3B = T1U - T1Z;
			      T3C = T25 - T2a;
			      T3U = T3H - T3I;
			      T3T = T3E - T3F;
			      T3G = T3E + T3F;
			      T3J = T3H + T3I;
			      T3M = T3G + T3J;
			      T20 = T1U + T1Z;
			      T2b = T25 + T2a;
			      T2c = T20 + T2b;
			 }
			 T2d = T1P + T2c;
			 T6j = T3L + T3M;
			 {
			      E T3D, T5n, T3O, T5m, T3K, T3N;
			      T3D = FMA(KP951056516, T3B, KP587785252 * T3C);
			      T5n = FNMS(KP587785252, T3B, KP951056516 * T3C);
			      T3K = KP559016994 * (T3G - T3J);
			      T3N = FNMS(KP250000000, T3M, T3L);
			      T3O = T3K + T3N;
			      T5m = T3N - T3K;
			      T3P = T3D + T3O;
			      T5U = T5n + T5m;
			      T4I = T3O - T3D;
			      T5o = T5m - T5n;
			 }
			 {
			      E T3V, T5k, T3S, T5j, T3Q, T3R;
			      T3V = FMA(KP951056516, T3T, KP587785252 * T3U);
			      T5k = FNMS(KP587785252, T3T, KP951056516 * T3U);
			      T3Q = KP559016994 * (T20 - T2b);
			      T3R = FNMS(KP250000000, T2c, T1P);
			      T3S = T3Q + T3R;
			      T5j = T3R - T3Q;
			      T3W = T3S - T3V;
			      T5T = T5j - T5k;
			      T4H = T3S + T3V;
			      T5l = T5j + T5k;
			 }
		    }
		    {
			 E T6m, T6o, TL, T2E, T6d, T6e, T6n, T6f;
			 {
			      E T6i, T6l, T1M, T2D;
			      T6i = T6g - T6h;
			      T6l = T6j - T6k;
			      T6m = FMA(KP951056516, T6i, KP587785252 * T6l);
			      T6o = FNMS(KP587785252, T6i, KP951056516 * T6l);
			      TL = T1 + TK;
			      T1M = T1o + T1L;
			      T2D = T2d + T2C;
			      T2E = T1M + T2D;
			      T6d = KP559016994 * (T1M - T2D);
			      T6e = FNMS(KP250000000, T2E, TL);
			 }
			 cr[0] = TL + T2E;
			 T6n = T6e - T6d;
			 cr[WS(rs, 10)] = T6n - T6o;
			 ci[WS(rs, 9)] = T6n + T6o;
			 T6f = T6d + T6e;
			 ci[WS(rs, 4)] = T6f - T6m;
			 cr[WS(rs, 5)] = T6f + T6m;
		    }
		    {
			 E T2P, T4z, T72, T7e, T4m, T7j, T4n, T7i, T4U, T77, T4X, T75, T4O, T6Y, T4P;
			 E T6X, T4s, T7f, T4v, T7d, T2H, T70;
			 T2H = T2F + T2G;
			 T2P = T2H - T2O;
			 T4z = T2H + T2O;
			 T70 = T6A + T6z;
			 T72 = T70 - T71;
			 T7e = T71 + T70;
			 {
			      E T3c, T3z, T3A, T3X, T4k, T4l;
			      T3c = FMA(KP535826794, T30, KP844327925 * T3b);
			      T3z = FNMS(KP637423989, T3y, KP770513242 * T3r);
			      T3A = T3c + T3z;
			      T3X = FNMS(KP425779291, T3W, KP904827052 * T3P);
			      T4k = FNMS(KP992114701, T4j, KP125333233 * T4c);
			      T4l = T3X + T4k;
			      T4m = T3A + T4l;
			      T7j = T3X - T4k;
			      T4n = KP559016994 * (T3A - T4l);
			      T7i = T3z - T3c;
			 }
			 {
			      E T4S, T4T, T73, T4V, T4W, T74;
			      T4S = FNMS(KP248689887, T4A, KP968583161 * T4B);
			      T4T = FNMS(KP844327925, T4D, KP535826794 * T4E);
			      T73 = T4S + T4T;
			      T4V = FNMS(KP481753674, T4H, KP876306680 * T4I);
			      T4W = FNMS(KP684547105, T4K, KP728968627 * T4L);
			      T74 = T4V + T4W;
			      T4U = T4S - T4T;
			      T77 = KP559016994 * (T73 - T74);
			      T4X = T4V - T4W;
			      T75 = T73 + T74;
			 }
			 {
			      E T4C, T4F, T4G, T4J, T4M, T4N;
			      T4C = FMA(KP968583161, T4A, KP248689887 * T4B);
			      T4F = FMA(KP535826794, T4D, KP844327925 * T4E);
			      T4G = T4C + T4F;
			      T4J = FMA(KP876306680, T4H, KP481753674 * T4I);
			      T4M = FMA(KP728968627, T4K, KP684547105 * T4L);
			      T4N = T4J + T4M;
			      T4O = T4G + T4N;
			      T6Y = T4J - T4M;
			      T4P = KP559016994 * (T4G - T4N);
			      T6X = T4F - T4C;
			 }
			 {
			      E T4q, T4r, T7b, T4t, T4u, T7c;
			      T4q = FNMS(KP844327925, T30, KP535826794 * T3b);
			      T4r = FMA(KP770513242, T3y, KP637423989 * T3r);
			      T7b = T4q + T4r;
			      T4t = FMA(KP125333233, T4j, KP992114701 * T4c);
			      T4u = FMA(KP904827052, T3W, KP425779291 * T3P);
			      T7c = T4u + T4t;
			      T4s = T4q - T4r;
			      T7f = T7b - T7c;
			      T4v = T4t - T4u;
			      T7d = KP559016994 * (T7b + T7c);
			 }
			 cr[WS(rs, 4)] = T2P + T4m;
			 ci[WS(rs, 23)] = T75 + T72;
			 ci[WS(rs, 20)] = T7f + T7e;
			 cr[WS(rs, 1)] = T4z + T4O;
			 {
			      E T4w, T4y, T4p, T4x, T4o;
			      T4w = FMA(KP951056516, T4s, KP587785252 * T4v);
			      T4y = FNMS(KP587785252, T4s, KP951056516 * T4v);
			      T4o = FNMS(KP250000000, T4m, T2P);
			      T4p = T4n + T4o;
			      T4x = T4o - T4n;
			      ci[0] = T4p - T4w;
			      ci[WS(rs, 5)] = T4x + T4y;
			      cr[WS(rs, 9)] = T4p + T4w;
			      ci[WS(rs, 10)] = T4x - T4y;
			 }
			 {
			      E T6Z, T79, T78, T7a, T76;
			      T6Z = FMA(KP587785252, T6X, KP951056516 * T6Y);
			      T79 = FNMS(KP587785252, T6Y, KP951056516 * T6X);
			      T76 = FNMS(KP250000000, T75, T72);
			      T78 = T76 - T77;
			      T7a = T77 + T76;
			      cr[WS(rs, 16)] = T6Z - T78;
			      ci[WS(rs, 18)] = T79 + T7a;
			      ci[WS(rs, 13)] = T6Z + T78;
			      cr[WS(rs, 21)] = T79 - T7a;
			 }
			 {
			      E T7k, T7l, T7h, T7m, T7g;
			      T7k = FMA(KP587785252, T7i, KP951056516 * T7j);
			      T7l = FNMS(KP587785252, T7j, KP951056516 * T7i);
			      T7g = FNMS(KP250000000, T7f, T7e);
			      T7h = T7d - T7g;
			      T7m = T7d + T7g;
			      cr[WS(rs, 14)] = T7h - T7k;
			      ci[WS(rs, 15)] = T7l + T7m;
			      cr[WS(rs, 19)] = T7k + T7h;
			      cr[WS(rs, 24)] = T7l - T7m;
			 }
			 {
			      E T4Y, T50, T4R, T4Z, T4Q;
			      T4Y = FMA(KP951056516, T4U, KP587785252 * T4X);
			      T50 = FNMS(KP587785252, T4U, KP951056516 * T4X);
			      T4Q = FNMS(KP250000000, T4O, T4z);
			      T4R = T4P + T4Q;
			      T4Z = T4Q - T4P;
			      ci[WS(rs, 3)] = T4R - T4Y;
			      ci[WS(rs, 8)] = T4Z + T50;
			      cr[WS(rs, 6)] = T4R + T4Y;
			      cr[WS(rs, 11)] = T4Z - T50;
			 }
		    }
		    {
			 E T7p, T7x, T7q, T7t, T7u, T7v, T7y, T7w;
			 {
			      E T7n, T7o, T7r, T7s;
			      T7n = T1L - T1o;
			      T7o = T2d - T2C;
			      T7p = FMA(KP587785252, T7n, KP951056516 * T7o);
			      T7x = FNMS(KP587785252, T7o, KP951056516 * T7n);
			      T7q = T6y + T6v;
			      T7r = T6g + T6h;
			      T7s = T6j + T6k;
			      T7t = T7r + T7s;
			      T7u = FNMS(KP250000000, T7t, T7q);
			      T7v = KP559016994 * (T7r - T7s);
			 }
			 ci[WS(rs, 24)] = T7t + T7q;
			 T7y = T7v + T7u;
			 cr[WS(rs, 20)] = T7x - T7y;
			 ci[WS(rs, 19)] = T7x + T7y;
			 T7w = T7u - T7v;
			 cr[WS(rs, 15)] = T7p - T7w;
			 ci[WS(rs, 14)] = T7p + T7w;
		    }
		    {
			 E T53, T5L, T6C, T6O, T5y, T6T, T5z, T6S, T66, T6H, T69, T6F, T60, T6q, T61;
			 E T6p, T5E, T6P, T5H, T6N, T51, T6B;
			 T51 = T2G - T2F;
			 T53 = T51 + T52;
			 T5L = T51 - T52;
			 T6B = T6z - T6A;
			 T6C = T6u + T6B;
			 T6O = T6B - T6u;
			 {
			      E T5a, T5h, T5i, T5p, T5w, T5x;
			      T5a = FMA(KP728968627, T56, KP684547105 * T59);
			      T5h = FNMS(KP992114701, T5g, KP125333233 * T5d);
			      T5i = T5a + T5h;
			      T5p = FMA(KP062790519, T5l, KP998026728 * T5o);
			      T5w = FNMS(KP637423989, T5v, KP770513242 * T5s);
			      T5x = T5p + T5w;
			      T5y = T5i + T5x;
			      T6T = T5p - T5w;
			      T5z = KP559016994 * (T5i - T5x);
			      T6S = T5h - T5a;
			 }
			 {
			      E T64, T65, T6D, T67, T68, T6E;
			      T64 = FNMS(KP481753674, T5M, KP876306680 * T5N);
			      T65 = FMA(KP904827052, T5Q, KP425779291 * T5P);
			      T6D = T64 - T65;
			      T67 = FNMS(KP844327925, T5T, KP535826794 * T5U);
			      T68 = FNMS(KP998026728, T5W, KP062790519 * T5X);
			      T6E = T67 + T68;
			      T66 = T64 + T65;
			      T6H = KP559016994 * (T6D - T6E);
			      T69 = T67 - T68;
			      T6F = T6D + T6E;
			 }
			 {
			      E T5O, T5R, T5S, T5V, T5Y, T5Z;
			      T5O = FMA(KP876306680, T5M, KP481753674 * T5N);
			      T5R = FNMS(KP425779291, T5Q, KP904827052 * T5P);
			      T5S = T5O + T5R;
			      T5V = FMA(KP535826794, T5T, KP844327925 * T5U);
			      T5Y = FMA(KP062790519, T5W, KP998026728 * T5X);
			      T5Z = T5V + T5Y;
			      T60 = T5S + T5Z;
			      T6q = T5V - T5Y;
			      T61 = KP559016994 * (T5S - T5Z);
			      T6p = T5R - T5O;
			 }
			 {
			      E T5C, T5D, T6L, T5F, T5G, T6M;
			      T5C = FNMS(KP684547105, T56, KP728968627 * T59);
			      T5D = FMA(KP125333233, T5g, KP992114701 * T5d);
			      T6L = T5C - T5D;
			      T5F = FNMS(KP998026728, T5l, KP062790519 * T5o);
			      T5G = FMA(KP770513242, T5v, KP637423989 * T5s);
			      T6M = T5F - T5G;
			      T5E = T5C + T5D;
			      T6P = T6L + T6M;
			      T5H = T5F + T5G;
			      T6N = KP559016994 * (T6L - T6M);
			 }
			 cr[WS(rs, 3)] = T53 + T5y;
			 ci[WS(rs, 22)] = T6F + T6C;
			 ci[WS(rs, 21)] = T6P + T6O;
			 cr[WS(rs, 2)] = T5L + T60;
			 {
			      E T6r, T6J, T6I, T6K, T6G;
			      T6r = FMA(KP587785252, T6p, KP951056516 * T6q);
			      T6J = FNMS(KP587785252, T6q, KP951056516 * T6p);
			      T6G = FNMS(KP250000000, T6F, T6C);
			      T6I = T6G - T6H;
			      T6K = T6H + T6G;
			      cr[WS(rs, 17)] = T6r - T6I;
			      ci[WS(rs, 17)] = T6J + T6K;
			      ci[WS(rs, 12)] = T6r + T6I;
			      cr[WS(rs, 22)] = T6J - T6K;
			 }
			 {
			      E T6a, T6c, T63, T6b, T62;
			      T6a = FMA(KP951056516, T66, KP587785252 * T69);
			      T6c = FNMS(KP587785252, T66, KP951056516 * T69);
			      T62 = FNMS(KP250000000, T60, T5L);
			      T63 = T61 + T62;
			      T6b = T62 - T61;
			      ci[WS(rs, 2)] = T63 - T6a;
			      ci[WS(rs, 7)] = T6b + T6c;
			      cr[WS(rs, 7)] = T63 + T6a;
			      cr[WS(rs, 12)] = T6b - T6c;
			 }
			 {
			      E T5I, T5K, T5B, T5J, T5A;
			      T5I = FMA(KP951056516, T5E, KP587785252 * T5H);
			      T5K = FNMS(KP587785252, T5E, KP951056516 * T5H);
			      T5A = FNMS(KP250000000, T5y, T53);
			      T5B = T5z + T5A;
			      T5J = T5A - T5z;
			      ci[WS(rs, 1)] = T5B - T5I;
			      ci[WS(rs, 6)] = T5J + T5K;
			      cr[WS(rs, 8)] = T5B + T5I;
			      ci[WS(rs, 11)] = T5J - T5K;
			 }
			 {
			      E T6U, T6V, T6R, T6W, T6Q;
			      T6U = FMA(KP587785252, T6S, KP951056516 * T6T);
			      T6V = FNMS(KP587785252, T6T, KP951056516 * T6S);
			      T6Q = FNMS(KP250000000, T6P, T6O);
			      T6R = T6N - T6Q;
			      T6W = T6N + T6Q;
			      cr[WS(rs, 13)] = T6R - T6U;
			      ci[WS(rs, 16)] = T6V + T6W;
			      cr[WS(rs, 18)] = T6U + T6R;
			      cr[WS(rs, 23)] = T6V - T6W;
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_CEXP, 1, 1},
     {TW_CEXP, 1, 3},
     {TW_CEXP, 1, 9},
     {TW_CEXP, 1, 24},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 25, "hf2_25", twinstr, &GENUS, {280, 180, 160, 0} };

void X(codelet_hf2_25) (planner *p) {
     X(khc2hc_register) (p, hf2_25, &desc);
}
#endif				/* HAVE_FMA */
