// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Classes:
//   GKPoissonStencil
//-----------------------------------------------------------------------------

#ifndef POOMA_EXAMPLES_GKPOISSON_GKPOISSONSTENCIL_H
#define POOMA_EXAMPLES_GKPOISSON_GKPOISSONSTENCIL_H

// include files

#include "Pooma/Arrays.h"

//-----------------------------------------------------------------------------
// Stencil GKPoissonStencil
//-----------------------------------------------------------------------------

class GKPoissonStencil
{
public:

  GKPoissonStencil(double gamma0) 
    : gamma0_m(gamma0), ijfact_m(0.25-gamma0)
  { }

  template <class A>
  inline
  typename A::Element_t
  operator()(const A& x, int i, int j) const
  {
    return ( ijfact_m * x(i,j) +

             0.125  * ( x(i+1,j+1) + x(i+1,j-1) + 
			x(i-1,j+1) + x(i-1,j-1) ) +

	     0.0625 * ( x(i  ,j+2) + x(i  ,j-2) +
			x(i+2,j  ) + x(i-2,j  ) ) );
  }

  inline int lowerExtent(int) const { return 2; }
  inline int upperExtent(int) const { return 2; }  

private:

  double gamma0_m, ijfact_m;
};

#endif // POOMA_EXAMPLES_GKPOISSON_GKPOISSONSTENCIL_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: GKPoissonStencil.h,v $   $Author: sa_smith $
// $Revision: 1.11 $   $Date: 2000/07/04 05:06:47 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
