##################################################################
# ACL:license
#  ----------------------------------------------------------------------
#  This software and ancillary information (herein called "SOFTWARE")
#  called POOMA (Parallel Object-Oriented Methods and Applications) is
#  made available under the terms described here.  The SOFTWARE has been
#  approved for release with associated LA-CC Number LA-CC-98-65.
#  
#  Unless otherwise indicated, this SOFTWARE has been authored by an
#  employee or employees of the University of California, operator of the
#  Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
#  the U.S. Department of Energy.  The U.S. Government has rights to use,
#  reproduce, and distribute this SOFTWARE. The public may copy, distribute,
#  prepare derivative works and publicly display this SOFTWARE without 
#  charge, provided that this Notice and any statement of authorship are 
#  reproduced on all copies.  Neither the Government nor the University 
#  makes any warranty, express or implied, or assumes any liability or 
#  responsibility for the use of this SOFTWARE.
#  
#  If SOFTWARE is modified to produce derivative works, such modified
#  SOFTWARE should be clearly marked, so as not to confuse it with the
#  version available from LANL.
#  
#  For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
#  or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
#  ----------------------------------------------------------------------
# ACL:license

# simple user-application Makefile using the version of POOMA
# installed in the 'POOMADIR' directory.
##################################################################

### include the POOMA makefile stub, to get compiler flags and libraries

include $(POOMADIR)/$(POOMAARCH)/lib/Makefile.pooma


### the name of the example code to compile

EXAMPLE = GKPoisson


### the main target for this makefile

$(EXAMPLE): $(EXAMPLE).inst.cpp
	$(POOMA_CXX) $(POOMA_CXX_DBG_ARGS) -o $(EXAMPLE) $(EXAMPLE).inst.cpp $(POOMA_INCLUDES) $(POOMA_DEFINES) $(POOMA_LIBS)

# To build the instrumented example 
$(EXAMPLE).inst.cpp : $(EXAMPLE).pdb
	$(TAUINSTR) $(EXAMPLE).pdb $(EXAMPLE).cpp -o $(EXAMPLE).inst.cpp

# To build the .pdb file 
$(EXAMPLE).pdb : $(EXAMPLE).cpp 
	$(TAUPARSE) $(EXAMPLE).cpp $(POOMA_INCLUDES) 

### clean things up a bit

clean:
	rm -rf $(EXAMPLE) $(EXAMPLE).o $(EXAMPLE).inst.cpp $(EXAMPLE).pdb $(EXAMPLE).ii ii_files ti_files 


# ACL:rcsinfo
#  ----------------------------------------------------------------------
#  $RCSfile: Makefile.profile,v $   $Author: swhaney $
#  $Revision: 1.3 $   $Date: 2000/03/07 13:15:19 $
#  ----------------------------------------------------------------------
# ACL:rcsinfo
