// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Array test 12: where()
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"
#include "Array/ArrayOperators.h"

#include <math.h>


int main(int argc, char* argv[])
{
  // Initialize Pooma.
  
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc, argv);

  int n = 20;
  double pi = 3.1415926535897932;
  Array<1> a(n), b(n), c(n), d(n);
  int i;
  for (i = 0; i < n; ++i) 
  {
    a(i) = sin(0.1 * pi * i);
    b(i) = cos(0.1 * pi * i);
    c(i) = i * 1.0;
  }

  d = c;
  d = where( GT(a, b), where( LT(c, 6.5), 1.0, 0.0), d + 2.0);

  double compare[20] =
  {
    2.0,3.0,4.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,
    0.0,0.0,0.0,15.0,16.0,17.0,18.0,19.0,20.0,21.0
  };
  double d2 = 0;
  double diff;
  
  Pooma::blockAndEvaluate();

  tester.out() << "Created arrays:" << std::endl;
  tester.out() << "  a = " << a << std::endl;
  tester.out() << "  b = " << b << std::endl;
  tester.out() << "  c = " << c << std::endl;
  tester.out() << "  d = " << d << std::endl;

  for (i = 0; i < n; ++i)
  {
    diff = d(i) - compare[i];
    d2 += diff * diff;
  }

  tester.out() << "Computed difference^2 from expected result = " << d2;
  tester.out() << std::endl;
  tester.check("d2 < 0.000001", d2 < 0.000001);

  d /= where( GT(d, 2.5), d );

  Pooma::blockAndEvaluate();

  for (i = 0; i < n; ++i)
  {
    if (compare[i] > 2.5)
    {
      diff = d(i) - 1.0;
    }
    else
    {
      diff = d(i) - compare[i];
    }

    d2 += diff * diff;
  }

  tester.out() << "Computed difference^2 from expected result = " << d2;
  tester.out() << std::endl;
  tester.check("d2 < 0.000001", d2 < 0.000001);

  int ret = tester.results("array_test12");
  Pooma::finalize();
  return ret;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test12.cpp,v $   $Author: julianc $
// $Revision: 1.13 $   $Date: 2000/03/10 18:10:45 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
