// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Miscellaneous tests of combinations of engines.
//-----------------------------------------------------------------------------

// include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Engine/BrickEngine.h"
#include "Engine/ConstantFunctionEngine.h"
#include "Array/Array.h"
#include "Tiny/Vector.h"

template<class Array>
bool isSmall(const Array &a)
{
  double epsilon = 0.000001;
  int i;
  int first = a.domain()[0].first();
  int last  = a.domain()[0].last();
  double sum = 0.0;
  for (i = first; i <= last; ++i)
  {
    sum += a.read(i)*a.read(i);
  }
  return (sum < epsilon);
}

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc, argv);

  int from = 1;
  int to = 5;

  Interval<1> dom(from,to);

  ModelElement<Vector<3,double> > v(Vector<3,double>(1,2,3));

  Array<1,Vector<3,double>,ConstantFunction> a(dom,v);
  Array<1,Vector<3,double>,Brick> b(dom);
  Array<1,double,Brick> c(dom);

  b = 2*a;
  c = 2*a.comp(2);

  tester.out() 
    << b << '\n'
    << b.comp(2) << '\n'
    << c << std::endl;

  tester.check(isSmall(b.comp(2)-c));

  int ret = tester.results("array_test16");
  Pooma::finalize();
  return ret;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test16.cpp,v $   $Author: swhaney $
// $Revision: 1.6 $   $Date: 2000/07/20 15:36:25 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
