// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Array test 22: miscellaneous bugs that were reported.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Layout/DomainLayout.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"
#include "Tiny/Vector.h"
#include "Tiny/Tensor.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  Interval<1> dom(1,20);
  DomainLayout<1> layout(dom);

  Array<1,double,Brick> a(dom), c(layout);
  typedef Array<1, Vector<2, double>, Brick> Array_t;
  typedef ComponentView<Loc<1>, Array_t>::Type_t CView_t; 
  Array_t b(dom);
  CView_t d(b.comp(1));

  a = 2.0;
  //  b = Vector<2,double>(2.0,3.0);
  b = Vector<2,double>(2.0, 1.0);
  d = 3.0;

  c = (a+2*b).comp(1);

  Pooma::blockAndEvaluate();

  tester.out() << "Created arrays:" << std::endl;
  tester.out() << "  a = " << a << std::endl;
  tester.out() << "  b = " << b << std::endl;
  tester.out() << "  c = " << c << std::endl;

  // Make sure that a particular element from c is OK

  tester.check("c(2) == 8", c(2) == 8.0);

  // check that assignment of a scalar to a vector field
  // compiles.

  b = 1.0;
  Pooma::blockAndEvaluate();

  tester.check("assigning scalar", b(2) == Vector<2,double>(1.0,1.0));

  typedef Array<1, Tensor<2, double, Antisymmetric>,
    Brick> Array2_t;
  typedef ComponentView<Loc<2>, Array2_t>::Type_t CView2_t; 
  Array2_t aa(dom);
  CView2_t bb(aa.comp(0, 1));

  //  aa.comp(0, 1) = 2.0;
  bb = 2.0;

  tester.out() << aa << std::endl;

  tester.check("antisymmetry", aa(3)(1, 0) == -2.0);
  
  int ret = tester.results("array_test22");
  Pooma::finalize();
  return ret;
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test22.cpp,v $   $Author: julianc $
// $Revision: 1.11 $   $Date: 2000/03/10 18:10:46 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
