// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Array test 6: global reductions.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/AllDomain.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"
#include "Array/Reductions.h"


int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  Array<2, int> a(2, 2);
  Array<2, int> b(2, 2);
  bool OK = true;

  b = 0;
  
  Pooma::blockAndEvaluate();
  a(0, 0) = 1; a(0,1) = 2; a(1, 0) = 3; a(1, 1) = 4;
  b(1,0) = 1;
  
  OK = (OK && sum(a) == 10);
  OK = (OK && min(a(AllDomain<1>(), 1)) == 2);
  OK = (OK && max(3.0 * a) == 12);
  OK = (OK && prod(a + b) == 32);
  OK = (OK && all(b) == false);
  OK = (OK && any(b) == true);
  OK = (OK && bitOr(a) == 7);
  OK = (OK && bitAnd(a) == 0);

  tester.check(OK);

  int ret = tester.results( "array_test6" );
  Pooma::finalize();
  return ret; 
}
// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test6.cpp,v $   $Author: julianc $
// $Revision: 1.10 $   $Date: 2000/03/10 18:10:46 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
