// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Pooma Extras for the Portable Expression Template Engine
//-----------------------------------------------------------------------------

#ifndef POOMA_POOMA_PETE_EXTRAS_H
#define POOMA_POOMA_PETE_EXTRAS_H

template<int D,class T,class E> class Vector;
template<int DR, int DC, class T, class E> class TinyMatrix;
template<int D, class T, class E> class Tensor;

//-----------------------------------------------------------------------------
// Includes
//-----------------------------------------------------------------------------

#include "PETE/PETE.h"
#include "Pooma/PoomaOperatorTags.h"

#include <algorithm>

//-----------------------------------------------------------------------------
// Complex support
//-----------------------------------------------------------------------------

// Attempt to set up macros that tell how to refer to complex numbers. We
// handle templated complex classes in or out of the std::namespace.

#if !POOMA_NO_TEMPLATED_COMPLEX

#if !POOMA_NO_STD_COMPLEX

namespace std {

template<class T> class complex;

}

using std::complex;

#define POOMA_COMPLEX complex<T>
#define POOMA_COMPLEX_CLASS complex

#else

template<class T> class complex;

#define POOMA_COMPLEX complex<T>
#define POOMA_COMPLEX_CLASS complex

#endif

#else

#error "You need to edit Pooma/PETEExtras.h to configure complex numbers."

#endif

//-----------------------------------------------------------------------------
// Complex unary operators
//-----------------------------------------------------------------------------

// The real, imag, abs, arg, and, norm functions need to be defined 
// specially since they don't return complex numbers.

template<class T>
struct UnaryReturn< POOMA_COMPLEX, FnConj >
{
  typedef POOMA_COMPLEX Type_t;
};

template<class T>
struct UnaryReturn<POOMA_COMPLEX, FnReal>
{
  typedef T Type_t;
};

template<class T>
struct UnaryReturn<POOMA_COMPLEX, FnImag>
{
  typedef T Type_t;
};

template<class T>
struct UnaryReturn<POOMA_COMPLEX, FnArg>
{
  typedef T Type_t;
};

template<class T>
struct UnaryReturn<POOMA_COMPLEX, FnNorm>
{
  typedef T Type_t;
};

template<class T>
struct UnaryReturn<T, FnAbs>
{
  typedef T Type_t;
};

template<class T>
struct UnaryReturn<POOMA_COMPLEX, FnAbs>
{
  typedef T Type_t;
};


//-----------------------------------------------------------------------------
// Complex binary operators
//-----------------------------------------------------------------------------

// Define promotions for complex.

// Astoundingly, the binary operators in the standard do not support mixed
// mode arithmetic. 

template<class T>
struct Promote<POOMA_COMPLEX, POOMA_COMPLEX >
{
  typedef POOMA_COMPLEX Type_t;
};

template<class T>
struct Promote<POOMA_COMPLEX, T>
{
  typedef POOMA_COMPLEX Type_t;
};

template<class T>
struct Promote<T, POOMA_COMPLEX>
{
  typedef POOMA_COMPLEX Type_t;
};

// This version is so pow(complex, int) will work correctly.

template<class T>
struct BinaryReturn<POOMA_COMPLEX, int, FnPow>
{
  typedef POOMA_COMPLEX Type_t;
};


//-----------------------------------------------------------------------------
// Special POOMA functions
//-----------------------------------------------------------------------------

template<class T>
struct UnaryReturn<T, FnPow2>
{
  typedef typename BinaryReturn<T, T, OpMultiply>::Type_t Type_t;
};

template<class T>
struct UnaryReturn<T, FnPow3>
{
  typedef typename BinaryReturn<T, T, OpMultiply>::Type_t Type_t;
};

template<class T>
struct UnaryReturn<T, FnPow4>
{
  typedef typename BinaryReturn<T, T, OpMultiply>::Type_t Type_t;
};


#endif // POOMA_POOMA_PETE_EXTRAS_H

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: PETEExtras.h,v $   $Author: swhaney $
// $Revision: 1.19 $   $Date: 2000/03/07 13:18:03 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
