// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
//
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without
// charge, provided that this Notice and any statement of authorship are
// reproduced on all copies.  Neither the Government nor the University
// makes any warranty, express or implied, or assumes any liability or
// responsibility for the use of this SOFTWARE.
//
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
//
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Test of Grid Serialize specialization and JAC's intro to sending
// messages with MatchingHandler 8-)
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Grid.h"
#include "Domain/Range.h"

#if POOMA_CHEETAH
#include "Cheetah/Cheetah.h"
#endif

#define BARRIER

#ifndef BARRIER
# if POOMA_CHEETAH
#  define BARRIER Pooma::controller()->barrier()
# else
#  define BARRIER
# endif
#endif

bool gotIt = false;

typedef Grid<1> Send_t;

void receiveGrid(Send_t *lg, Send_t &rg)
{
  *lg = rg;
  gotIt = true;
}
 
int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

#if POOMA_CHEETAH

  typedef Cheetah::MatchingHandler Handler_t;
  
  const int numContexts = Pooma::contexts();
  const int myContext   = Pooma::context();

  Handler_t *handler = new Cheetah::MatchingHandler(*Pooma::controller());

  tester.out() << "Testing Grid messages . . .\n";
  tester.out() << "Running with " << numContexts << " contexts." << std::endl;

  int start = myContext * 10;
  int end   = (myContext + 1) * 10;

  Range<1> r(start, end, 2);

  Grid<1> foo(r);

  tester.out() << "Here are our Grids..." << std::endl;

  BARRIER;

  tester.out().setOutputContext(-1);
  tester.out() << foo << std::endl;

  // Here's the message pattern - we're just sending in a ring:

  int toContext   = (myContext + 1)               % numContexts;
  int fromContext = (myContext + numContexts - 1) % numContexts;

  BARRIER;

  tester.out() << "Node "             << myContext 
	       << ";   Sending to "     << toContext 
	       << ";   Receiving from " << fromContext << std::endl;

  int msgtag = 0;

  handler->send(toContext, msgtag, foo);

  Send_t bar;

  handler->request(fromContext, msgtag, receiveGrid, &bar);

  while (!gotIt) Pooma::pollMessages();

  BARRIER;

  tester.out().setOutputContext(0);
  tester.out() << "Here are the Grids we received:" << std::endl;

  BARRIER;

  tester.out().setOutputContext(-1);
  tester.out() << bar << std::endl;

  start = fromContext * 10;
  end   = (fromContext + 1) * 10;

  Range<1> ans(start, end, 2);

  BARRIER;

  tester.check(bar == ans);

  delete handler;

#else

  tester.out() << "This test requires Cheetah" << std::endl;

#endif

  int ret = tester.results("GridMessage Test");
  Pooma::finalize();

  return ret;
}

