// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Big Expression Test Code
//-----------------------------------------------------------------------------

// include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Domain/AllDomain.h"
#include "Engine/BrickEngine.h"
#include "Engine/CompressibleBrick.h"
#include "Engine/IndirectionEngine.h"
#include "Tiny/Vector.h"
#include "Array/Array.h"
#include "Array/tests/ExpressionTest.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc, argv);

  int from = 1;
  int to = 20;
  int fromInterior = 2;
  int toInterior = 19;

  Interval<1> dom(from,to);
  Interval<1> I(fromInterior,toInterior);
  int loc1 = 4;
  int loc2 = 12;

  Array<1,double,Brick>
    a1(dom),a2(dom),a3(dom),a4(dom), initial(dom);

  initial = 0.0;

  Pooma::blockAndEvaluate();

  initial(loc1) = 2.0;
  initial(loc2) = 3.0;

  test1(tester, 1, a1, a2, a3, a4, initial, I);
  test2(tester, 2, a1, a2, a3, a4, initial, I);
  test3(tester, 3, a1, a2, a3, a4, initial, I);
  test4(tester, 4, a1, a2, a3, a4, initial, I);

  Array<1,Vector<2,double>,Brick>
    av1(dom),av2(dom),av3(dom),av4(dom), initialv(dom);

  initialv = Vector<2,double>(0.0,0.0);

  Pooma::blockAndEvaluate();

  initialv(4) = Vector<2,double>(2.0,3.0);
  initialv(12) = Vector<2,double>(3.0,-1.0);

  test5(tester,5,av1,av2,av3,av4, initialv,I);

  Array<1,double,CompressibleBrick>
    ac1(dom),ac2(dom),ac3(dom),ac4(dom);

  test1(tester, 6, ac1, ac2, ac3, ac4, initial, I);
  test2(tester, 7, ac1, ac2, ac3, ac4, initial, I);
  test4(tester, 9, ac1, ac2, ac3, ac4, initial, I);

  Array<1,Vector<2,double>,CompressibleBrick>
    avc1(dom),avc2(dom),avc3(dom),avc4(dom);

  test5(tester, 10, avc1, avc2, avc3, avc4, initialv, I);
  test6(tester, 11, avc1, avc2, avc3, avc4, initialv, I);

  //---------------------------------------------------------------------
  // simple indirection test - rotate some values

  test7(tester, 12, a1, a2, a3, a4, initial, dom);

  //---------------------------------------------------------------------
  // slices  

  Interval<2> dom2(dom,dom);

  Array<2,double,Brick>
    a21(dom2),a22(dom2),a23(dom2),a24(dom2);

  AllDomain<1> all;

  test1(tester,13,a21(all,3),a22(all,3),a23(all,3),a24(all,3), initial,I);
  test2(tester,14,a21(all,3),a22(all,3),a23(all,3),a24(all,3), initial,I);
  test3(tester,15,a21(all,3),a22(all,3),a23(all,3),a24(all,3), initial,I);
  test4(tester,16,a21(all,3),a22(all,3),a23(all,3),a24(all,3), initial,I);

  int ret = tester.results("array_test15");
  Pooma::finalize();
  return ret;
}


// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test15.cpp,v $   $Author: sa_smith $
// $Revision: 1.25 $   $Date: 2000/07/06 16:25:26 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
