// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license
//-----------------------------------------------------------------------------
// Array test 2: indexing.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"

int main(int argc, char *argv[])
{
  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);
  
  Array<3, int> a(6, 6, 6);
  
  // Block since we're starting scalar code.
    
  Pooma::blockAndEvaluate();
  
  for (int i2 = 0; i2 < 6; i2++)
    for (int i1 = 0; i1 < 6; i1++)
      for (int i0 = 0; i0 < 6; i0++)
	a(i0,i1,i2) = i2+10*(i1+10*i0);

  tester.check("a(int,int,int)", a(1, 2, 3), 123);
  tester.check("a.read(int,int,int)", a.read(1, 2, 3), 123);
  tester.check("a(int,long,int)", a(1, 2L, 3), 123);
  tester.check("a.read(int,long,int)", a.read(1, 2L, 3), 123);
  tester.check("a(int,int,unsigned)", a(1, 2, 3U), 123);
  tester.check("a.read(int,int,unsigned)", a.read(1, 2, 3U), 123);
  tester.check("a(unsigned long,int,unsigned)", a(1UL, 2, 3U), 123);
  tester.check("a.read(unsigned long,int,unsigned)", a.read(1UL, 2, 3U), 123);

  int ret = tester.results( "array_test2" );
  Pooma::finalize();
  return ret; 
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test2.cpp,v $   $Author: julianc $
// $Revision: 1.16 $   $Date: 2000/03/10 18:10:45 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
