// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Array test 25: initialize function.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Domain/Interval.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"

int main(int argc, char *argv[])
{
  // Initialize POOMA and output stream, using Tester class

  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  Array<2> a(4, 4), b;
  
  a = 3.0;
  b.initialize(a);

  Pooma::blockAndEvaluate();

  b(2, 2) = -1.0;
  
  tester.out() << a << std::endl;
  tester.out() << b << std::endl;
  
  tester.check("simple", a(2,2), -1.0);

  Interval<1> x(0,5),y(0,5);
  Interval<2> dom(x,y);
  Array<2> xy(dom);
  xy = 0;

  Pooma::blockAndEvaluate();
  
  xy(3,3) = 303;

  b.initialize(xy.engine());

  tester.check("engine-init", b.domain(), xy.domain());

  Interval<1> x1(47,57);
  Interval<1> y1(5);
  Interval<1> z1(10);
  Interval<3> xyz(x1,y1,z1);
  Array<3,double> foo3;
  foo3.initialize(x1,y1,z1);

  tester.check("domain-init", foo3.domain(), xyz);

  int retval = tester.results("array_test25");

  Pooma::finalize();

  return retval;  
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test25.cpp,v $   $Author: swhaney $
// $Revision: 1.5 $   $Date: 2000/07/20 15:36:25 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
