// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// Array test 26: 2-argument min/max functions.
//-----------------------------------------------------------------------------

// Include files

#include "Pooma/Pooma.h"
#include "Utilities/Tester.h"
#include "Engine/BrickEngine.h"
#include "Array/Array.h"
#include "Array/Reductions.h"


int main(int argc, char *argv[])
{
  // Initialize POOMA and output stream, using Tester class

  Pooma::initialize(argc, argv);
  Pooma::Tester tester(argc, argv);

  int i, j;
  Array<2, int> a(4, 4), b(4, 4), c(4, 4);

  Pooma::blockAndEvaluate();

  for (j = 0; j < 4; j++)
    for (i = 0; i < 4; i++)
      {
	a(i, j) = -2 + i + j;
	b(i, j) = 4 - i - j;
      }

  tester.out() << a << '\n' << std::endl;
  tester.out() << b << '\n' << std::endl;

  tester.out() << min(a, b) << '\n' << std::endl;
  tester.out() << max(a, b) << std::endl;

  c = min(a, b);

  Pooma::blockAndEvaluate();

  for (j = 0; j < 4; j++)
    for (i = 0; i < 4; i++)
      tester.check(c(i, j) == (a(i, j) < b(i, j) ? a(i, j) : b(i, j)));

  c = max(a, b);

  Pooma::blockAndEvaluate();

  for (j = 0; j < 4; j++)
    for (i = 0; i < 4; i++)
      tester.check(c(i, j) == (a(i, j) > b(i, j) ? a(i, j) : b(i, j)));

  int retval = tester.results("array_test26");

  Pooma::finalize();

  return retval;  
}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: array_test26.cpp,v $   $Author: julianc $
// $Revision: 1.3 $   $Date: 2000/03/10 18:10:46 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
