// -*- C++ -*-
// ACL:license
// ----------------------------------------------------------------------
// This software and ancillary information (herein called "SOFTWARE")
// called POOMA (Parallel Object-Oriented Methods and Applications) is
// made available under the terms described here.  The SOFTWARE has been
// approved for release with associated LA-CC Number LA-CC-98-65.
// 
// Unless otherwise indicated, this SOFTWARE has been authored by an
// employee or employees of the University of California, operator of the
// Los Alamos National Laboratory under Contract No. W-7405-ENG-36 with
// the U.S. Department of Energy.  The U.S. Government has rights to use,
// reproduce, and distribute this SOFTWARE. The public may copy, distribute,
// prepare derivative works and publicly display this SOFTWARE without 
// charge, provided that this Notice and any statement of authorship are 
// reproduced on all copies.  Neither the Government nor the University 
// makes any warranty, express or implied, or assumes any liability or 
// responsibility for the use of this SOFTWARE.
// 
// If SOFTWARE is modified to produce derivative works, such modified
// SOFTWARE should be clearly marked, so as not to confuse it with the
// version available from LANL.
// 
// For more information about POOMA, send e-mail to pooma@acl.lanl.gov,
// or visit the POOMA web page at http://www.acl.lanl.gov/pooma/.
// ----------------------------------------------------------------------
// ACL:license

//-----------------------------------------------------------------------------
// evaluation of compressible brick test #1
// (this test is really simple and only checks that the results are compressed
// when they should be)
//-----------------------------------------------------------------------------

// include files

#include "Pooma/Pooma.h"
#include "Array/Array.h"
#include "Engine/BrickEngine.h"
#include "Evaluator/CompressibleEval.h"
#include "Utilities/Tester.h"
#include <iostream>
#include <math.h>


const char* compressed(const Array<1,double,CompressibleBrick>& array)
{
  return (array.engine().compressed() ?
	  "compressed" : "uncompressed" );
}

int main(int argc, char* argv[])
{
  // initialize Pooma
  Pooma::initialize(argc,argv);
  Pooma::Tester tester(argc,argv);

  int return_status = 0;

  int n = 20;
  double pi = 3.1415926535897932;
  Array<1> a(n),b(n),c(n),d(n);
  Array<1,double,CompressibleBrick> aa(n),bb(n),cc(n),dd(n);
  int i;
  for (i=0;i<n;++i)
  {
    a(i) = sin(0.1*pi*i);
    b(i) = cos(0.1*pi*i);
    c(i) = 1.0;
    d(i) = 2.0;
  }

  tester.out() << "Testing Compressile Bricks." << std::endl;

  aa = a;
  bb = b;
  cc = c;
  dd = d;

  Pooma::blockAndEvaluate();

  tester.out() << "  i    aa    bb   cc   dd " << std::endl;
  for (i=0; i<n; ++i)
  {
    tester.out() << i << " " << aa.read(i) << " " << bb.read(i) << " "
		 << cc.read(i) << " " << dd.read(i) << std::endl;
  }

  tester.out() << "aa: " << compressed(aa) << std::endl;
  tester.out() << "bb: " << compressed(bb) << std::endl;
  tester.out() << "cc: " << compressed(cc) << std::endl;
  tester.out() << "dd: " << compressed(dd) << std::endl;

  tester.check(!aa.engine().compressed());
  tester.check(!bb.engine().compressed());
  tester.check(cc.engine().compressed());
  tester.check(dd.engine().compressed());

  aa = aa*aa+bb*bb;
  bb = cc*dd+2.0*cc;
  bb += cc*dd+2.0*cc;
  cc = dd*c+d;

  Pooma::blockAndEvaluate();

  tester.out() << "  i    aa    bb   cc   dd " << std::endl;
  for (i=0; i<n; ++i)
  {
    tester.out() << i << " " << aa.read(i) << " " << bb.read(i) << " "
		 << cc.read(i) << " " << dd.read(i) << std::endl;
  }

  tester.out() << "aa: " << compressed(aa) << std::endl;
  tester.out() << "bb: " << compressed(bb) << std::endl;
  tester.out() << "cc: " << compressed(cc) << std::endl;
  tester.out() << "dd: " << compressed(dd) << std::endl;

  tester.check(!aa.engine().compressed());
  tester.check(bb.engine().compressed());
  tester.check(cc.engine().compressed());
  tester.check(dd.engine().compressed());

  a = b+dd*cc;

  Pooma::blockAndEvaluate();

  tester.out() << "a: ";
  for (i=0; i<n; ++i) {
    tester.out() << "(" << i << ")=" << a.read(i) << ",";
  }
  tester.out() << std::endl;

  tester.out() << "------------------------------------------------" << std::endl;
 
  int retval = tester.results("compressibleTest1");

  Pooma::finalize();  
  return return_status;

}

// ACL:rcsinfo
// ----------------------------------------------------------------------
// $RCSfile: compressibleTest1.cpp,v $   $Author: swhaney $
// $Revision: 1.15 $   $Date: 2000/03/07 13:17:05 $
// ----------------------------------------------------------------------
// ACL:rcsinfo
